/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeFactory;
import biz.k11i.xgboost.util.ModelReader;
import hex.genmodel.algos.xgboost.XGBoostJavaMojoModel;
import hex.tree.xgboost.predict.XGBoostRegTree;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;

public class PredictorFactory {
    public static Predictor makePredictor(byte[] boosterBytes) {
        return PredictorFactory.makePredictor(boosterBytes, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Predictor makePredictor(byte[] boosterBytes, byte[] auxNodeWeightBytes, boolean scoringOnly) {
        PredictorConfiguration.Builder bldr = PredictorConfiguration.builder();
        if (scoringOnly && PredictorFactory.unsafeTreesSupported()) {
            bldr.regTreeFactory(UnsafeRegTreeFactory.INSTANCE);
        }
        PredictorConfiguration cfg = bldr.build();
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Predictor p2 = new Predictor(is, cfg);
            if (!scoringOnly && auxNodeWeightBytes != null) {
                XGBoostJavaMojoModel.updateNodeWeights(p2, auxNodeWeightBytes);
            }
            Predictor predictor = p2;
            return predictor;
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    private static boolean unsafeTreesSupported() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    private static class UnsafeRegTreeFactory
    implements RegTreeFactory {
        private static final UnsafeRegTreeFactory INSTANCE = new UnsafeRegTreeFactory();

        private UnsafeRegTreeFactory() {
        }

        @Override
        public RegTree loadTree(ModelReader reader) throws IOException {
            return new XGBoostRegTree(reader);
        }
    }
}

