/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import ai.h2o.xgboost4j.java.util.BigDenseMatrix;
import hex.tree.xgboost.matrix.DenseMatrixFactory;
import hex.tree.xgboost.matrix.MatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrix;
import hex.tree.xgboost.matrix.SparseMatrixDimensions;
import hex.tree.xgboost.matrix.SparseMatrixFactory;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import java.util.HashMap;
import java.util.Map;
import water.Key;

public class RemoteMatrixLoader
extends MatrixLoader {
    private static final Map<String, RemoteMatrix> REGISTRY = new HashMap<String, RemoteMatrix>();
    private final Key modelKey;

    public static void initSparse(String key, SparseMatrixDimensions dims) {
        RemoteSparseMatrix m4 = new RemoteSparseMatrix(dims);
        REGISTRY.put(key, m4);
    }

    public static void sparseChunk(String key, XGBoostUploadMatrixTask.SparseMatrixChunk chunk) {
        int i2;
        RemoteSparseMatrix m4 = (RemoteSparseMatrix)REGISTRY.get(key);
        long nonZeroCount = m4.dims._precedingNonZeroElementsCounts[chunk.id];
        int rwRow = m4.dims._precedingRowCounts[chunk.id];
        SparseMatrixFactory.NestedArrayPointer rowHeaderPointer = new SparseMatrixFactory.NestedArrayPointer(rwRow);
        SparseMatrixFactory.NestedArrayPointer dataPointer = new SparseMatrixFactory.NestedArrayPointer(nonZeroCount);
        for (i2 = 0; i2 < chunk.rowHeader.length; ++i2) {
            rowHeaderPointer.setAndIncrement(m4.matrix._rowHeaders, chunk.rowHeader[i2]);
        }
        for (i2 = 0; i2 < chunk.data.length; ++i2) {
            dataPointer.set(m4.matrix._sparseData, chunk.data[i2]);
            dataPointer.set(m4.matrix._colIndices, chunk.colIndices[i2]);
            dataPointer.increment();
        }
    }

    public static void initDense(String key, XGBoostUploadMatrixTask.DenseMatrixDimensions dims) {
        RemoteDenseMatrix m4 = new RemoteDenseMatrix(dims);
        REGISTRY.put(key, m4);
    }

    public static void denseChunk(String key, XGBoostUploadMatrixTask.DenseMatrixChunk chunk) {
        RemoteDenseMatrix m4 = (RemoteDenseMatrix)REGISTRY.get(key);
        for (long i2 = 0L; i2 < (long)chunk.data.length; ++i2) {
            m4.matrix.set(i2 + (long)(m4.dims.rowOffsets[chunk.id] * m4.dims.cols), chunk.data[(int)i2]);
        }
    }

    public static void matrixData(String key, XGBoostUploadMatrixTask.MatrixData data) {
        RemoteMatrixLoader.REGISTRY.get((Object)key).data = data;
    }

    public static void cleanup(String key) {
        REGISTRY.remove(key);
    }

    public RemoteMatrixLoader(Key modelKey) {
        this.modelKey = modelKey;
    }

    @Override
    public MatrixLoader.DMatrixProvider makeLocalMatrix() {
        return REGISTRY.remove(this.modelKey.toString()).make();
    }

    static class RemoteDenseMatrix
    extends RemoteMatrix {
        final XGBoostUploadMatrixTask.DenseMatrixDimensions dims;
        final BigDenseMatrix matrix;

        RemoteDenseMatrix(XGBoostUploadMatrixTask.DenseMatrixDimensions dims) {
            this.dims = dims;
            this.matrix = new BigDenseMatrix(dims.rows, dims.cols);
        }

        @Override
        MatrixLoader.DMatrixProvider make() {
            return new DenseMatrixFactory.DenseDMatrixProvider(this.data.actualRows, this.data.resp, this.data.weights, this.data.offsets, this.matrix);
        }
    }

    static class RemoteSparseMatrix
    extends RemoteMatrix {
        final SparseMatrixDimensions dims;
        final SparseMatrix matrix;

        RemoteSparseMatrix(SparseMatrixDimensions dims) {
            this.dims = dims;
            this.matrix = SparseMatrixFactory.allocateCSRMatrix(dims);
        }

        @Override
        MatrixLoader.DMatrixProvider make() {
            return SparseMatrixFactory.toDMatrix(this.matrix, this.dims, this.data.actualRows, this.data.shape, this.data.resp, this.data.weights, this.data.offsets);
        }
    }

    static abstract class RemoteMatrix {
        XGBoostUploadMatrixTask.MatrixData data;

        RemoteMatrix() {
        }

        abstract MatrixLoader.DMatrixProvider make();
    }
}

