/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.SharedTreeModel;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestMojoWriter;
import hex.tree.isofor.MetricBuilderAnomalySupervised;
import hex.tree.isofor.ModelMetricsAnomaly;
import water.Key;
import water.fvec.Frame;
import water.util.TwoDimTable;

public class IsolationForestModel
extends SharedTreeModel<IsolationForestModel, IsolationForestParameters, IsolationForestOutput> {
    public IsolationForestModel(Key<IsolationForestModel> selfKey, IsolationForestParameters parms, IsolationForestOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public void initActualParamValues() {
        super.initActualParamValues();
        if (((IsolationForestParameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.AUTO) {
            ((IsolationForestParameters)this._parms)._stopping_metric = ((IsolationForestParameters)this._parms)._stopping_rounds == 0 ? null : ScoreKeeper.StoppingMetric.anomaly_score;
        }
        if (((IsolationForestParameters)this._parms)._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.AUTO) {
            ((IsolationForestParameters)this._parms)._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.Enum;
        }
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (domain != null && ((IsolationForestOutput)this._output).hasResponse()) {
            return new MetricBuilderAnomalySupervised(domain);
        }
        return new ModelMetricsAnomaly.MetricBuilderAnomaly("Isolation Forest Metrics", this.outputAnomalyFlag());
    }

    @Override
    protected String[] makeScoringNames() {
        if (this.outputAnomalyFlag()) {
            return new String[]{"predict", "score", "mean_length"};
        }
        return new String[]{"predict", "mean_length"};
    }

    @Override
    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        assert (!this.outputAnomalyFlag() ? names.length == 2 : names.length == 3);
        String[][] domains = new String[names.length][];
        if (this.outputAnomalyFlag()) {
            String[] stringArray;
            if (((IsolationForestOutput)this._output)._response_domain != null) {
                stringArray = ((IsolationForestOutput)this._output)._response_domain;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "0";
                stringArray = stringArray2;
                stringArray2[1] = "1";
            }
            domains[0] = stringArray;
        }
        return domains;
    }

    @Override
    protected double[] score0(double[] data, double[] preds, double offset, int ntrees) {
        int off;
        super.score0(data, preds, offset, ntrees);
        boolean outputAnomalyFlag = this.outputAnomalyFlag();
        int n2 = off = outputAnomalyFlag ? 1 : 0;
        if (ntrees >= 1) {
            preds[off + 1] = preds[0] / (double)ntrees;
        }
        preds[off] = this.normalizePathLength(preds[0]);
        if (outputAnomalyFlag) {
            preds[0] = preds[1] >= ((IsolationForestOutput)this._output)._defaultThreshold ? 1.0 : 0.0;
        }
        return preds;
    }

    final double normalizePathLength(double pathLength) {
        return IsolationForestModel.normalizePathLength(pathLength, ((IsolationForestOutput)this._output)._min_path_length, ((IsolationForestOutput)this._output)._max_path_length);
    }

    static double normalizePathLength(double pathLength, int minPathLength, int maxPathLength) {
        if (maxPathLength > minPathLength) {
            return ((double)maxPathLength - pathLength) / (double)(maxPathLength - minPathLength);
        }
        return 1.0;
    }

    @Override
    public IsolationForestMojoWriter getMojo() {
        return new IsolationForestMojoWriter(this);
    }

    @Override
    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        if (!computeMetrics || ((IsolationForestOutput)this._output)._response_column == null) {
            return super.adaptTestForTrain(test, expensive, computeMetrics);
        }
        return IsolationForestModel.adaptTestForTrain(test, ((IsolationForestOutput)this._output)._origNames, ((IsolationForestOutput)this._output)._origDomains, ArrayUtils.append(((IsolationForestOutput)this._output)._names, ((IsolationForestOutput)this._output)._response_column), ArrayUtils.append(((IsolationForestOutput)this._output)._domains, new String[][]{((IsolationForestOutput)this._output)._response_domain}), this._parms, expensive, true, ((IsolationForestOutput)this._output).interactionBuilder(), this.getToEigenVec(), this._toDelete, false);
    }

    final boolean outputAnomalyFlag() {
        return ((IsolationForestOutput)this._output)._defaultThreshold >= 0.0;
    }

    public static class IsolationForestOutput
    extends SharedTreeModel.SharedTreeOutput {
        public int _max_path_length;
        public int _min_path_length;
        public String _response_column;
        public String[] _response_domain;
        public IsolationForest.VarSplits _var_splits;
        public TwoDimTable _variable_splits;

        public IsolationForestOutput(IsolationForest b2) {
            super(b2);
            if (b2.vresponse() != null) {
                this._response_column = ((IsolationForestParameters)b2._parms)._response_column;
                this._response_domain = b2.vresponse().domain();
            }
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.AnomalyDetection;
        }

        @Override
        public double defaultThreshold() {
            return this._defaultThreshold;
        }

        @Override
        public String responseName() {
            return this._response_column;
        }

        @Override
        public boolean hasResponse() {
            return this._response_column != null;
        }

        @Override
        public int responseIdx() {
            return this._names.length;
        }
    }

    public static class IsolationForestParameters
    extends SharedTreeModel.SharedTreeParameters {
        public int _mtries = -1;
        public long _sample_size = 256L;
        public double _contamination;

        @Override
        public String algoName() {
            return "IsolationForest";
        }

        @Override
        public String fullName() {
            return "Isolation Forest";
        }

        @Override
        public String javaName() {
            return IsolationForestModel.class.getName();
        }

        public IsolationForestParameters() {
            this._max_depth = 8;
            this._sample_rate = -1.0;
            this._min_rows = 1.0;
            this._min_split_improvement = 0.0;
            this._nbins = 2;
            this._nbins_cats = 2;
            this._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
            this._distribution = DistributionFamily.gaussian;
            this._contamination = -1.0;
        }

        @Override
        protected double defaultStoppingTolerance() {
            return 0.01;
        }
    }
}

