/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.KeyValue;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.tree.SharedTreeModel;
import java.util.HashSet;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class TreeUtils {
    public static void checkMonotoneConstraints(ModelBuilder<?, ?, ?> mb, Frame train, KeyValue[] constraints) {
        HashSet<String> constrained = new HashSet<String>();
        for (KeyValue constraint : constraints) {
            if (constrained.contains(constraint.getKey())) {
                mb.error("_monotone_constraints", "Feature '" + constraint.getKey() + "' has multiple constraints.");
                continue;
            }
            constrained.add(constraint.getKey());
            Vec v2 = train.vec(constraint.getKey());
            if (v2 == null) {
                mb.error("_monotone_constraints", "Invalid constraint - there is no column '" + constraint.getKey() + "' in the training frame.");
                continue;
            }
            if (v2.get_type() == 3) continue;
            mb.error("_monotone_constraints", "Invalid constraint - column '" + constraint.getKey() + "' has type " + v2.get_type_str() + ". Only numeric columns can have monotonic constraints.");
        }
    }

    public static void checkInteractionConstraints(ModelBuilder<?, ?, ?> mb, Frame train, String[][] constraints) {
        String[][] stringArray = constraints;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] constraintsSet;
            for (String constraint : constraintsSet = stringArray[i2]) {
                if (((Model.Parameters)mb._parms)._ignored_columns != null && ArrayUtils.find(((Model.Parameters)mb._parms)._ignored_columns, constraint) != -1) {
                    mb.error("_interaction_constraints", "Column with the name '" + constraint + "' is set in ignored columns and cannot be used in interaction.");
                } else {
                    Vec v2 = train.vec(constraint);
                    if (v2 == null) {
                        mb.error("_interaction_constraints", "Invalid interaction constraint - there is no column '" + constraint + "' in the training frame.");
                    }
                }
                if (constraint.equals(((Model.Parameters)mb._parms)._response_column)) {
                    mb.error("'_interaction_constraints'", "Column with the name '" + constraint + "' is used as response column and cannot be used in interaction.");
                }
                if (constraint.equals(((Model.Parameters)mb._parms)._weights_column)) {
                    mb.error("'_interaction_constraints'", "Column with the name '" + constraint + "' is used as weights column and cannot be used in interaction.");
                }
                if (!constraint.equals(((Model.Parameters)mb._parms)._fold_column)) continue;
                mb.error("_interaction_constraints", "Column with the name '" + constraint + "' is used as fold column and cannot be used in interaction.");
            }
        }
    }

    public static int getResponseLevelIndex(String categorical, SharedTreeModel.SharedTreeOutput sharedTreeOutput) {
        String trimmedCategorical;
        String string = trimmedCategorical = categorical != null ? categorical.trim() : "";
        if (!sharedTreeOutput.isClassifier()) {
            if (!trimmedCategorical.isEmpty()) {
                throw new IllegalArgumentException("There are no tree classes for " + (Object)((Object)sharedTreeOutput.getModelCategory()) + ".");
            }
            return 0;
        }
        String[] responseColumnDomain = sharedTreeOutput._domains[sharedTreeOutput.responseIdx()];
        if (sharedTreeOutput.getModelCategory() == ModelCategory.Binomial) {
            if (!trimmedCategorical.isEmpty() && !trimmedCategorical.equals(responseColumnDomain[0])) {
                throw new IllegalArgumentException("For binomial, only one tree class has been built per each iteration: " + responseColumnDomain[0]);
            }
            return 0;
        }
        for (int i2 = 0; i2 < responseColumnDomain.length; ++i2) {
            if (!trimmedCategorical.equals(responseColumnDomain[i2])) continue;
            return i2;
        }
        throw new IllegalArgumentException("There is no such tree class. Given categorical level does not exist in response column: " + trimmedCategorical);
    }
}

