/*
 * Decompiled with CFR 0.152.
 */
package hex.steam;

import hex.steam.SteamMessageExchange;
import java.io.IOException;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.WebsocketConnection;
import water.webserver.iface.WebsocketHandler;

public class SteamWebsocketServlet
implements H2OWebsocketServlet {
    private static final Object CONNECTION_LOCK = new Object();
    private WebsocketConnection currentConnection;
    private final SteamMessageExchange exchange = new SteamMessageExchange(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebsocketHandler onConnect(WebsocketConnection conn) {
        Object object = CONNECTION_LOCK;
        synchronized (object) {
            this.currentConnection = conn;
            this.exchange.onConnected();
        }
        return new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) throws IOException {
        WebsocketConnection conn;
        Object object = CONNECTION_LOCK;
        synchronized (object) {
            conn = this.currentConnection;
        }
        if (conn == null) {
            throw new IOException("Connection currently not available");
        }
        conn.sendMessage(message);
    }

    private class Handler
    implements WebsocketHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(WebsocketConnection connection) {
            Object object = CONNECTION_LOCK;
            synchronized (object) {
                if (SteamWebsocketServlet.this.currentConnection == connection) {
                    SteamWebsocketServlet.this.currentConnection = null;
                    SteamWebsocketServlet.this.exchange.onConnectionClosed();
                }
            }
        }

        @Override
        public void onMessage(String message) {
            SteamWebsocketServlet.this.exchange.distributeMessage(message);
        }
    }
}

