/*
 * Decompiled with CFR 0.152.
 */
package hex.steam;

import hex.steam.SteamMessageSender;
import hex.steam.SteamMessenger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import water.H2O;

public class SteamHelloMessenger
implements SteamMessenger {
    Logger LOG = Logger.getLogger(SteamHelloMessenger.class);
    private SteamMessageSender sender;

    @Override
    public void onConnectionStateChange(SteamMessageSender sender) {
        this.sender = sender;
    }

    @Override
    public void onMessage(Map<String, String> message) {
        if ("hello".equals(message.get("_type"))) {
            assert (this.sender != null) : "Received message but sender is null";
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("_type", "hello_response");
            response.put("_id", message.get("_id") + "_response");
            response.put("version", H2O.ABV.projectVersion());
            response.put("branch", H2O.ABV.branchName());
            response.put("hash", H2O.ABV.lastCommitHash());
            response.put("cloud_size", String.valueOf(H2O.CLOUD.size()));
            try {
                this.sender.sendMessage(response);
            }
            catch (IOException e2) {
                this.LOG.error((Object)"Failed to send response to hello.", (Throwable)e2);
            }
        }
    }
}

