/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.psvm.BulkSupportVectorScorer;
import org.apache.commons.math3.util.FastMath;
import water.fvec.Chunk;

class GaussianScorerParsed
implements BulkSupportVectorScorer {
    private final double _gamma;
    private final double[] _alphas;
    private final double[][] _nums;
    private final int[][] _cats;

    GaussianScorerParsed(KernelParameters parms, byte[] svs, int svsCount) {
        this(parms._gamma, svs, svsCount);
    }

    private GaussianScorerParsed(double gamma, byte[] svs, int svsCount) {
        this._gamma = gamma;
        this._alphas = new double[svsCount];
        this._nums = new double[svsCount][];
        this._cats = new int[svsCount][];
        ByteBufferWrapper bb = new ByteBufferWrapper(svs);
        for (int i2 = 0; i2 < svsCount; ++i2) {
            int j2;
            this._alphas[i2] = bb.get8d();
            this._cats[i2] = new int[bb.get4()];
            for (j2 = 0; j2 < this._cats[i2].length; ++j2) {
                this._cats[i2][j2] = bb.get4();
            }
            this._nums[i2] = new double[bb.get4()];
            for (j2 = 0; j2 < this._nums[i2].length; ++j2) {
                this._nums[i2][j2] = bb.get8d();
            }
        }
    }

    @Override
    public double[] bulkScore0(Chunk[] cs) {
        double[] result = new double[cs[0]._len];
        double[] norms = new double[cs[0]._len];
        for (int s2 = 0; s2 < this._alphas.length; ++s2) {
            int i2;
            for (i2 = 0; i2 < this._cats[s2].length; ++i2) {
                int svCat = this._cats[s2][i2];
                for (int j2 = 0; j2 < norms.length; ++j2) {
                    int n2 = j2;
                    norms[n2] = norms[n2] + ((int)cs[i2].at8(j2) == svCat ? 0.0 : 2.0);
                }
            }
            for (i2 = 0; i2 < this._nums[s2].length; ++i2) {
                double svNum = this._nums[s2][i2];
                int j3 = 0;
                while (j3 < norms.length) {
                    double v2 = cs[i2 + this._cats[s2].length].atd(j3) - svNum;
                    int n3 = j3++;
                    norms[n3] = norms[n3] + v2 * v2;
                }
            }
            for (int j4 = 0; j4 < result.length; ++j4) {
                int n4 = j4;
                result[n4] = result[n4] + this._alphas[s2] * FastMath.exp((double)(-this._gamma * norms[j4]));
                norms[j4] = 0.0;
            }
        }
        return result;
    }
}

