/*
 * Decompiled with CFR 0.152.
 */
package hex.pca.mtj;

import hex.pca.PCAInterface;
import hex.util.LinearAlgebraUtils;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;

public class PCA_MTJ_SVD_DenseMatrix
implements PCAInterface {
    private DenseMatrix gramMatrix;
    private SVD svd;
    private double[][] rightEigenvectors;

    public PCA_MTJ_SVD_DenseMatrix(double[][] gramMatrix) {
        this.gramMatrix = new DenseMatrix(gramMatrix);
        this.runSVD();
    }

    @Override
    public double[] getVariances() {
        return this.svd.getS();
    }

    @Override
    public double[][] getPrincipalComponents() {
        return this.rightEigenvectors;
    }

    private void runSVD() {
        int gramDimension = this.gramMatrix.numRows();
        try {
            this.svd = new SVD(gramDimension, gramDimension).factor(this.gramMatrix);
        }
        catch (NotConvergedException e2) {
            throw new RuntimeException(e2);
        }
        double[] Vt_1D = this.svd.getVt().getData();
        this.rightEigenvectors = LinearAlgebraUtils.reshape1DArray(Vt_1D, gramDimension, gramDimension);
    }
}

