/*
 * Decompiled with CFR 0.152.
 */
package hex.pca.mtj;

import hex.pca.PCAInterface;
import hex.util.EigenPair;
import hex.util.LinearAlgebraUtils;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.NotConvergedException;
import water.util.ArrayUtils;

public class PCA_MTJ_EVD_DenseMatrix
implements PCAInterface {
    private DenseMatrix gramMatrix;
    private EVD evd;
    private double[] eigenvalues;
    private double[][] eigenvectors;

    public PCA_MTJ_EVD_DenseMatrix(double[][] gramMatrix) {
        this.gramMatrix = new DenseMatrix(gramMatrix);
        this.runEVD();
    }

    private void runEVD() {
        int gramDimension = this.gramMatrix.numRows();
        try {
            this.evd = EVD.factorize(this.gramMatrix);
        }
        catch (NotConvergedException e2) {
            throw new RuntimeException(e2);
        }
        this.eigenvalues = this.evd.getRealEigenvalues();
        DenseMatrix eigenvectorMatrix = this.evd.getRightEigenvectors();
        this.eigenvectors = LinearAlgebraUtils.reshape1DArray(eigenvectorMatrix.getData(), gramDimension, gramDimension);
        EigenPair[] eigenPairs = LinearAlgebraUtils.createReverseSortedEigenpairs(this.eigenvalues, this.eigenvectors);
        this.eigenvalues = LinearAlgebraUtils.extractEigenvaluesFromEigenpairs(eigenPairs);
        this.eigenvectors = ArrayUtils.transpose(LinearAlgebraUtils.extractEigenvectorsFromEigenpairs(eigenPairs));
    }

    @Override
    public double[] getVariances() {
        return this.eigenvalues;
    }

    @Override
    public double[][] getPrincipalComponents() {
        return this.eigenvectors;
    }
}

