/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import hex.DMatrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.glrm.GlrmRegularizer;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.svd.SVD;
import hex.svd.SVDModel;
import hex.util.DimensionReductionUtils;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.api.ModelCacheManager;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class GLRM
extends ModelBuilder<GLRMModel, GLRMModel.GLRMParameters, GLRMModel.GLRMOutput> {
    private static final double TOLERANCE = 1.0E-10;
    private transient int _ncolA;
    private transient int _ncolY;
    private transient int _ncolX;
    boolean _wideDataset = false;
    private transient GlrmLoss[] _lossFunc;
    private ArrayList<Integer> _binaryColumnIndices;

    @Override
    protected GLRMDriver trainModelImpl() {
        return new GLRMDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    protected void checkMemoryFootPrint_impl() {
        HeartBeat hb = H2O.SELF._heartbeat;
        double p2 = LinearAlgebraUtils.numColsExp(this._train, true);
        double r2 = this._train.numRows();
        long mem_usage = (long)((double)hb._cpus_allowed * p2 * (double)((GLRMModel.GLRMParameters)this._parms)._k * 8.0 * 2.0);
        long mem_usage_w = (long)((double)hb._cpus_allowed * r2 * (double)((GLRMModel.GLRMParameters)this._parms)._k * 8.0 * 2.0);
        long max_mem = H2O.SELF._heartbeat.get_free_mem();
        if (mem_usage > max_mem && mem_usage_w > max_mem) {
            String msg = "Archtypes in matrix Y cannot fit in the driver node's memory (" + PrettyPrint.bytes(mem_usage) + " > " + PrettyPrint.bytes(max_mem) + ") - try reducing k, the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
        }
        if (mem_usage > mem_usage_w) {
            this._wideDataset = true;
        }
    }

    public void setWideDataset(boolean isWide) {
        this._wideDataset = isWide;
    }

    public GLRM(GLRMModel.GLRMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GLRM(GLRMModel.GLRMParameters parms, Job<GLRMModel> job) {
        super(parms, job);
        this.init(false);
    }

    public GLRM(boolean startup_once) {
        super(new GLRMModel.GLRMParameters(), startup_once);
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        this._ncolX = ((GLRMModel.GLRMParameters)this._parms)._k;
        this._ncolA = this._train == null ? -1 : this._train.numCols();
        this._ncolY = this._train == null ? -1 : LinearAlgebraUtils.numColsExp(this._train, true);
        this.initLoss();
        if (((GLRMModel.GLRMParameters)this._parms)._gamma_x < 0.0) {
            this.error("_gamma_x", "gamma must be a non-negative number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._gamma_y < 0.0) {
            this.error("_gamma_y", "gamma_y must be a non-negative number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._max_iterations < 1 || (double)((GLRMModel.GLRMParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._init_step_size <= 0.0) {
            this.error("_init_step_size", "init_step_size must be a positive number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._min_step_size < 0.0 || ((GLRMModel.GLRMParameters)this._parms)._min_step_size > ((GLRMModel.GLRMParameters)this._parms)._init_step_size) {
            this.error("_min_step_size", "min_step_size must be between 0 and " + ((GLRMModel.GLRMParameters)this._parms)._init_step_size);
        }
        if (((GLRMModel.GLRMParameters)this._parms)._recover_svd && ((GLRMModel.GLRMParameters)this._parms)._impute_original && ((GLRMModel.GLRMParameters)this._parms)._transform != DataInfo.TransformType.NONE) {
            this.error("_recover_svd", "_recover_svd and _impute_original cannot both be true if _train is transformed");
        }
        if (null == this._train) {
            return;
        }
        if (this._ncolA < 2) {
            this.error("_train", "_train must have more than one column");
        }
        if (this._valid != null && this._valid.numRows() != this._train.numRows()) {
            this.error("_valid", "_valid must have same number of rows as _train");
        }
        if (this._ncolY > 5000) {
            this.warn("_train", "_train has " + this._ncolY + " columns when categoricals are expanded. Algorithm may be slow.");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._loading_name) {
            this.warn("loading_name", "loading_name is deprecated, use representation_name instead.");
            if (null == ((GLRMModel.GLRMParameters)this._parms)._representation_name) {
                ((GLRMModel.GLRMParameters)this._parms)._representation_name = ((GLRMModel.GLRMParameters)this._parms)._loading_name;
            }
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._representation_name && null != ((GLRMModel.GLRMParameters)this._parms)._loading_name && !((GLRMModel.GLRMParameters)this._parms)._representation_name.equals(((GLRMModel.GLRMParameters)this._parms)._loading_name)) {
            this.warn("_representation_name and _loading_name", "Are not equal.  _representation_name will be used since _loading_name is deprecated.");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._representation_name && this.dest().toString().equals(((GLRMModel.GLRMParameters)this._parms)._representation_name)) {
            this.error("representation_name", "representation_name and model_id cannot use the same string.");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._loading_name && this.dest().toString().equals(((GLRMModel.GLRMParameters)this._parms)._loading_name)) {
            this.error("loading_name", "loading_name and model_id cannot use the same string.");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._k < 1 || ((GLRMModel.GLRMParameters)this._parms)._k > this._ncolY) {
            this.error("_k", "_k must be between 1 and " + this._ncolY + " inclusive");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._user_y) {
            int user_y_cols;
            if (((GLRMModel.GLRMParameters)this._parms)._init != GlrmInitialization.User) {
                this.error("_init", "init must be 'User' if providing user-specified points");
            }
            Frame user_y = ((GLRMModel.GLRMParameters)this._parms)._user_y.get();
            assert (user_y != null);
            int n2 = user_y_cols = ((GLRMModel.GLRMParameters)this._parms)._expand_user_y ? this._ncolA : this._ncolY;
            if (user_y.numCols() != user_y_cols) {
                this.error("_user_y", "The user-specified Y must have the same number of columns (" + user_y_cols + ") as the training observations");
            } else if (user_y.numRows() != (long)((GLRMModel.GLRMParameters)this._parms)._k) {
                this.error("_user_y", "The user-specified Y must have k = " + ((GLRMModel.GLRMParameters)this._parms)._k + " rows");
            } else {
                int zero_vec = 0;
                Vec[] centersVecs = user_y.vecs();
                for (int c2 = 0; c2 < this._ncolA; ++c2) {
                    if (centersVecs[c2].naCnt() > 0L) {
                        this.error("_user_y", "The user-specified Y cannot contain any missing values");
                        break;
                    }
                    if (!centersVecs[c2].isConst() || centersVecs[c2].max() != 0.0) continue;
                    ++zero_vec;
                }
                if (zero_vec == this._ncolA) {
                    this.error("_user_y", "The user-specified Y cannot all be zero");
                }
            }
        }
        if (((GLRMModel.GLRMParameters)this._parms)._user_x != null) {
            if (((GLRMModel.GLRMParameters)this._parms)._init != GlrmInitialization.User) {
                this.error("_init", "init must be 'User' if providing user-specified points");
            }
            Frame user_x = ((GLRMModel.GLRMParameters)this._parms)._user_x.get();
            assert (user_x != null);
            if (user_x.numCols() != ((GLRMModel.GLRMParameters)this._parms)._k) {
                this.error("_user_x", "The user-specified X must have k = " + ((GLRMModel.GLRMParameters)this._parms)._k + " columns");
            } else if (user_x.numRows() != this._train.numRows()) {
                this.error("_user_x", "The user-specified X must have the same number of rows (" + this._train.numRows() + ") as the training observations");
            } else {
                int zero_vec = 0;
                Vec[] centersVecs = user_x.vecs();
                for (int c3 = 0; c3 < ((GLRMModel.GLRMParameters)this._parms)._k; ++c3) {
                    if (centersVecs[c3].naCnt() > 0L) {
                        this.error("_user_x", "The user-specified X cannot contain any missing values");
                        break;
                    }
                    if (!centersVecs[c3].isConst() || centersVecs[c3].max() != 0.0) continue;
                    ++zero_vec;
                }
                if (zero_vec == ((GLRMModel.GLRMParameters)this._parms)._k) {
                    this.error("_user_x", "The user-specified X cannot all be zero");
                }
            }
        }
        for (int i2 = 0; i2 < this._ncolA; ++i2) {
            if (!this._train.vec(i2).isString() && !this._train.vec(i2).isUUID()) continue;
            throw H2O.unimpl("GLRM cannot handle String or UUID data");
        }
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    private void initLoss() {
        int num_loss_by_cols_idx;
        int num_loss_by_cols = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col == null ? 0 : ((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length;
        int n2 = num_loss_by_cols_idx = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx == null ? 0 : ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx.length;
        if (((GLRMModel.GLRMParameters)this._parms)._period <= 0) {
            this.error("_period", "_period must be a positive integer");
        }
        if (!((GLRMModel.GLRMParameters)this._parms)._loss.isForNumeric()) {
            this.error("_loss", (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss) + " is not a numeric loss function");
        }
        if (!((GLRMModel.GLRMParameters)this._parms)._multi_loss.isForCategorical()) {
            this.error("_multi_loss", (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._multi_loss) + " is not a multivariate loss function");
        }
        if (num_loss_by_cols != num_loss_by_cols_idx && num_loss_by_cols_idx > 0) {
            this.error("_loss_by_col", "Sizes of arrays _loss_by_col and _loss_by_col_idx must be the same");
        }
        if (this._train == null) {
            return;
        }
        this._binaryColumnIndices = new ArrayList();
        this._lossFunc = new GlrmLoss[this._ncolA];
        for (int i2 = 0; i2 < this._ncolA; ++i2) {
            Vec vi = this._train.vec(i2);
            this._lossFunc[i2] = vi.isCategorical() ? ((GLRMModel.GLRMParameters)this._parms)._multi_loss : ((GLRMModel.GLRMParameters)this._parms)._loss;
        }
        String[] origColumnNames = ((GLRMModel.GLRMParameters)this._parms).train().names();
        ArrayList<String> newColumnNames = new ArrayList<String>(Arrays.asList(this._train._names));
        if (num_loss_by_cols > 0) {
            if (num_loss_by_cols_idx == 0) {
                if (num_loss_by_cols == origColumnNames.length) {
                    this.assignLossByCol(num_loss_by_cols, newColumnNames, origColumnNames);
                } else {
                    this.error("_loss_by_col", "Number of override loss functions should be the same as the number of columns in the input frame; or otherwise an explicit _loss_by_col_idx should be provided.");
                }
            }
            if (num_loss_by_cols_idx == num_loss_by_cols) {
                this.assignLossByCol(num_loss_by_cols, newColumnNames, origColumnNames);
            }
        }
        for (int i3 = 0; i3 < this._ncolA; ++i3) {
            Vec vi = this._train.vec(i3);
            GlrmLoss lossi = this._lossFunc[i3];
            if (vi.isNumeric()) {
                if (!vi.isBinary()) {
                    if (!lossi.isForNumeric()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)lossi) + " cannot be applied to numeric column " + i3);
                    }
                } else if (!lossi.isForBinary() && !lossi.isForNumeric()) {
                    this.error("_loss_by_col", "Loss function " + (Object)((Object)lossi) + " cannot be applied to binary column " + i3);
                }
            } else if (vi.isCategorical()) {
                if (vi.isBinary()) {
                    if (!lossi.isForBinary() && !lossi.isForCategorical()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)lossi) + " cannot be applied to binary column " + i3);
                    } else if (lossi.isForBinary()) {
                        this._binaryColumnIndices.add(i3);
                    }
                } else if (!lossi.isForCategorical()) {
                    this.error("_loss_by_col", "Loss function " + (Object)((Object)lossi) + " cannot be applied to categorical column " + i3);
                }
            }
            if (lossi != GlrmLoss.Periodic) continue;
            lossi.setParameters(((GLRMModel.GLRMParameters)this._parms)._period);
        }
    }

    private void assignLossByCol(int num_loss_by_cols, ArrayList<String> newColumnNames, String[] origColumnNames) {
        for (int i2 = 0; i2 < num_loss_by_cols; ++i2) {
            int cidx = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx == null ? i2 : ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx[i2];
            String colNames = origColumnNames[cidx];
            if (cidx < 0 || cidx >= origColumnNames.length) {
                this.error("_loss_by_col_idx", "Column index " + cidx + " must be in [0," + this._ncolA + ")");
                continue;
            }
            if (!newColumnNames.contains(colNames)) continue;
            this._lossFunc[newColumnNames.indexOf((Object)colNames)] = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i2];
        }
    }

    public static double frobenius2(double[][] x2) {
        if (x2 == null) {
            return 0.0;
        }
        double frob = 0.0;
        double[][] dArray = x2;
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] xs;
            for (double j2 : xs = dArray[i2]) {
                frob += j2 * j2;
            }
        }
        return frob;
    }

    public final boolean hasClosedForm(long na_cnt) {
        if (na_cnt != 0L) {
            return false;
        }
        for (GlrmLoss lossi : this._lossFunc) {
            if (lossi == GlrmLoss.Quadratic) continue;
            return false;
        }
        return !(((GLRMModel.GLRMParameters)this._parms)._gamma_x != 0.0 && ((GLRMModel.GLRMParameters)this._parms)._regularization_x != GlrmRegularizer.None && ((GLRMModel.GLRMParameters)this._parms)._regularization_x != GlrmRegularizer.Quadratic || ((GLRMModel.GLRMParameters)this._parms)._gamma_y != 0.0 && ((GLRMModel.GLRMParameters)this._parms)._regularization_y != GlrmRegularizer.None && ((GLRMModel.GLRMParameters)this._parms)._regularization_y != GlrmRegularizer.Quadratic);
    }

    public static double[][] transform(double[][] centers, double[] normSub, double[] normMul, int ncats, int nnums) {
        double[] mults;
        int K2 = centers.length;
        int N2 = centers[0].length;
        assert (ncats + nnums == N2);
        double[][] value = new double[K2][N2];
        double[] means = normSub == null ? MemoryManager.malloc8d(nnums) : normSub;
        double[] dArray = mults = normMul == null ? MemoryManager.malloc8d(nnums) : normMul;
        if (normMul == null) {
            Arrays.fill(mults, 1.0);
        }
        for (int clu = 0; clu < K2; ++clu) {
            System.arraycopy(centers[clu], 0, value[clu], 0, ncats);
            for (int col = 0; col < nnums; ++col) {
                value[clu][ncats + col] = (centers[clu][ncats + col] - means[col]) * mults[col];
            }
        }
        return value;
    }

    public static double[][] expandCats(double[][] sdata, DataInfo dinfo) {
        if (sdata == null || dinfo._cats == 0) {
            return sdata;
        }
        assert (sdata[0].length == dinfo._adaptedFrame.numCols());
        int catsexp = dinfo._catOffsets[dinfo._catOffsets.length - 1];
        double[][] cexp = new double[sdata.length][catsexp + dinfo._nums];
        for (int i2 = 0; i2 < sdata.length; ++i2) {
            LinearAlgebraUtils.expandRow(sdata[i2], dinfo, cexp[i2], false);
        }
        return cexp;
    }

    protected static int idx_xold(int c2, int ncolA) {
        return ncolA + c2;
    }

    protected static int idx_xnew(int c2, int ncolA, int ncolX) {
        return ncolA + ncolX + c2;
    }

    public static double yArcheTypeVal(Archetypes yt, int j2, int k2) {
        return yt._transposed ? yt._archetypes[j2][k2] : yt._archetypes[k2][j2];
    }

    public static Chunk xFrameVec(Chunk[] chks, int c2, int offset) {
        return chks[offset + c2];
    }

    public static void getXChunk(Frame xVecs, int chunkIdx, Chunk[] xChunks) {
        int xWidth = xChunks.length;
        for (int j2 = 0; j2 < xWidth; ++j2) {
            xChunks[j2] = xVecs.vec(j2).chunkForChunkIdx(chunkIdx);
        }
    }

    public static ArrayList<Integer> findtAChunkIndices(Frame tAVecs, int xStart, int xEnd, Archetypes yt) {
        ArrayList<Integer> tAcidx = new ArrayList<Integer>();
        int tANChunks = tAVecs.anyVec().nChunks();
        if (tANChunks == 1) {
            tAcidx.add(0);
            return tAcidx;
        }
        int startTAcidx = 0;
        int numCats = yt._catOffsets.length - 1;
        int numCatColumns = yt._catOffsets[numCats];
        xStart = GLRM.findOriginalColIndex(xStart, numCats, numCatColumns, yt);
        xEnd = GLRM.findOriginalColIndex(xEnd, numCats, numCatColumns, yt);
        GLRM.findGoodCidx(tAVecs, tAcidx, false, xStart, tANChunks, startTAcidx);
        startTAcidx = tAcidx.get(0);
        if (startTAcidx < tANChunks - 1) {
            GLRM.findGoodCidx(tAVecs, tAcidx, true, xEnd, tANChunks, startTAcidx);
        }
        return tAcidx;
    }

    public static ArrayList<Integer> findXChunkIndices(Frame xVecs, int taStart, int taEnd, Archetypes yt) {
        ArrayList<Integer> xcidx = new ArrayList<Integer>();
        int xNChunks = xVecs.anyVec().nChunks();
        if (xNChunks == 1) {
            xcidx.add(0);
            return xcidx;
        }
        int startTAcidx = 0;
        int numCats = yt._catOffsets.length - 1;
        taStart = GLRM.findExpColIndex(taStart, numCats, yt);
        taEnd = GLRM.findExpColIndex(taEnd, numCats, yt);
        GLRM.findGoodCidx(xVecs, xcidx, false, taStart, xNChunks, startTAcidx);
        startTAcidx = xcidx.get(0);
        if (startTAcidx < xNChunks - 1) {
            GLRM.findGoodCidx(xVecs, xcidx, true, taEnd, xNChunks, startTAcidx);
        }
        return xcidx;
    }

    public static void findGoodCidx(Frame xVecs, ArrayList<Integer> currentList, boolean addIndex, int taIndex, int xNChunks, int startTAcidx) {
        Chunk[] xChunks = new Chunk[1];
        for (int index = startTAcidx; index < xNChunks; ++index) {
            xChunks[0] = xVecs.vec(0).chunkForChunkIdx(index);
            long xStart = xChunks[0].start();
            long xEnd = xStart + (long)xChunks[0]._len;
            if ((long)taIndex >= xStart && (long)taIndex < xEnd) {
                if (currentList.size() > 0) {
                    if (currentList.contains(index)) break;
                    currentList.add(index);
                    break;
                }
                currentList.add(index);
                break;
            }
            if (!addIndex || currentList.contains(index)) continue;
            currentList.add(index);
        }
    }

    private static int findExpColIndex(int oldIndex, int numCats, Archetypes yt) {
        if (oldIndex < numCats) {
            return yt._catOffsets[oldIndex];
        }
        return oldIndex - numCats + yt._catOffsets[numCats];
    }

    private static int findOriginalColIndex(int oldIndex, int numCats, int totEnumColumns, Archetypes yt) {
        if (oldIndex < totEnumColumns) {
            for (int index = 1; index < yt._catOffsets.length; ++index) {
                if (oldIndex >= yt._catOffsets[index]) continue;
                return index - 1;
            }
        }
        return oldIndex - totEnumColumns + numCats;
    }

    private static class CholMulTask
    extends MRTask<CholMulTask> {
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        CholeskyDecomposition _chol;

        CholMulTask(CholeskyDecomposition chol, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul) {
            assert (yt != null && yt.rank() <= ncolX);
            assert (ncats <= ncolA);
            this._yt = yt;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ncats = ncats;
            this._chol = chol;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        @Override
        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            double[] xrow = new double[this._ncolX];
            for (int row = 0; row < cs[0]._len; ++row) {
                for (int k2 = 0; k2 < this._ncolX; ++k2) {
                    int d2;
                    double x2 = 0.0;
                    for (d2 = 0; d2 < this._ncats; ++d2) {
                        double a2 = cs[d2].atd(row);
                        if (Double.isNaN(a2)) continue;
                        x2 += this._yt.getCat(d2, (int)a2, k2);
                    }
                    for (d2 = this._ncats; d2 < this._ncolA; ++d2) {
                        int ds = d2 - this._ncats;
                        double a3 = cs[d2].atd(row);
                        if (Double.isNaN(a3)) continue;
                        x2 += (a3 - this._normSub[ds]) * this._normMul[ds] * this._yt.getNum(ds, k2);
                    }
                    xrow[k2] = x2;
                }
                Matrix tmp = this._chol.solve(new Matrix(new double[][]{xrow}).transpose());
                xrow = tmp.getColumnPackedCopy();
                int i2 = 0;
                for (int d3 = this._ncolA; d3 < this._ncolA + this._ncolX; ++d3) {
                    cs[d3].set(row, xrow[i2]);
                    cs[d3 + this._ncolX].set(row, xrow[i2++]);
                }
                assert (i2 == xrow.length);
            }
        }
    }

    private static class ObjCalc
    extends MRTask<ObjCalc> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        final boolean _regX;
        double _loss;
        double _xold_reg;

        ObjCalc(GLRMModel.GLRMParameters parms, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, int weightId) {
            this(parms, yt, ncolA, ncolX, ncats, normSub, normMul, lossFunc, weightId, false);
        }

        ObjCalc(GLRMModel.GLRMParameters parms, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, int weightId, boolean regX) {
            assert (yt != null && yt.rank() == ncolX);
            assert (ncats <= ncolA);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ncats = ncats;
            this._regX = regX;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        private Chunk chk_xnew(Chunk[] chks, int c2) {
            return chks[this._ncolA + this._ncolX + c2];
        }

        @Override
        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            Chunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            this._xold_reg = 0.0;
            this._loss = 0.0;
            double[] xrow = null;
            double[] xy = null;
            if (this._yt._numLevels[0] > 0) {
                xy = new double[this._yt._numLevels[0]];
            }
            if (this._regX) {
                xrow = new double[this._ncolX];
            }
            for (int row = 0; row < cs[0]._len; ++row) {
                int j2;
                double cweight = chkweight.atd(row);
                assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                for (j2 = 0; j2 < this._ncats; ++j2) {
                    this._loss += cweight * this.lossDueToCategorical(cs, j2, row, xy);
                }
                for (j2 = this._ncats; j2 < this._ncolA; ++j2) {
                    this._loss += cweight * this.lossDueToNumeric(cs, j2, row, this._ncats);
                }
                if (!this._regX) continue;
                this._xold_reg += this.regularizationTermOldX(cs, row, xrow, this._ncolA, this._ncolA + this._ncolX, this._ncolX);
            }
        }

        private double regularizationTermOldX(Chunk[] cs, int row, double[] xrow, int colStart, int colEnd, int colWidth) {
            int idx = 0;
            for (int j2 = colStart; j2 < colEnd; ++j2) {
                xrow[idx] = cs[j2].atd(row);
                ++idx;
            }
            assert (idx == colWidth);
            return this._parms._regularization_x.regularize(xrow);
        }

        private double lossDueToNumeric(Chunk[] cs, int j2, int row, int offsetA) {
            double a2 = cs[j2].atd(row);
            if (Double.isNaN(a2)) {
                return 0.0;
            }
            double txy = 0.0;
            int js = j2 - offsetA;
            for (int k2 = 0; k2 < this._ncolX; ++k2) {
                txy += this.chk_xnew(cs, k2).atd(row) * this._yt.getNum(js, k2);
            }
            return this._lossFunc[j2].loss(txy, (a2 - this._normSub[js]) * this._normMul[js]);
        }

        private double lossDueToCategorical(Chunk[] cs, int colInd, int row, double[] xy) {
            double a2 = cs[colInd].atd(row);
            if (Double.isNaN(a2)) {
                return 0.0;
            }
            int catColJLevel = this._yt._numLevels[colInd];
            Arrays.fill(xy, 0, catColJLevel, 0.0);
            for (int level = 0; level < catColJLevel; ++level) {
                for (int k2 = 0; k2 < this._ncolX; ++k2) {
                    int n2 = level;
                    xy[n2] = xy[n2] + this.chk_xnew(cs, k2).atd(row) * this._yt.getCat(colInd, level, k2);
                }
            }
            return this._lossFunc[colInd].mloss(xy, (int)a2, catColJLevel);
        }

        @Override
        public void reduce(ObjCalc other) {
            this._loss += other._loss;
            this._xold_reg += other._xold_reg;
        }
    }

    private static class ObjCalcW
    extends MRTask<ObjCalcW> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final boolean _regX;
        final Frame _xVecs;
        final int _xOffset;
        double _loss;
        static double _xold_reg;

        ObjCalcW(GLRMModel.GLRMParameters parms, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, boolean regX, Frame xVecs, int xOffset) {
            assert (yt != null && yt.rank() == ncolX);
            assert (ncats <= ncolA);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ncats = ncats;
            this._regX = regX;
            this._xVecs = xVecs;
            this._normSub = normSub;
            this._normMul = normMul;
            this._xOffset = xOffset;
        }

        @Override
        public void map(Chunk[] cs) {
            double[] chkweight = this._yt._weights;
            int numTArow = cs[0]._len;
            int tArowStart = (int)cs[0].start();
            int tArowEnd = numTArow + tArowStart - 1;
            Chunk[] xChunks = new Chunk[this._parms._k * 2];
            int startxcidx = cs[0].cidx();
            if (this._regX && startxcidx == 0) {
                this.calXOldReg(this._yt._archetypes, this._yt._archetypes.length);
            }
            ArrayList<Integer> xChunkIndices = GLRM.findXChunkIndices(this._xVecs, tArowStart, tArowEnd, this._yt);
            double[] xy = null;
            int numColIndexOffset = this._yt._catOffsets[this._ncats] - this._ncats;
            if (this._yt._numLevels[tArowStart] > 0) {
                xy = new double[this._yt._numLevels[tArowStart]];
            }
            GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
            int xChunkRowStart = (int)xChunks[0].start();
            int xChunkSize = xChunks[0]._len;
            int xRow = 0;
            int tARow = 0;
            assert (tArowStart >= xChunkRowStart && tArowStart < xChunkRowStart + xChunkSize);
            for (int rowIndex = 0; rowIndex < numTArow; ++rowIndex) {
                double a2;
                int colIndex;
                tARow = rowIndex + tArowStart;
                if (tARow < this._ncats) {
                    int catRowLevel = this._yt._numLevels[tARow];
                    for (colIndex = 0; colIndex < cs.length; ++colIndex) {
                        a2 = cs[colIndex].atd(rowIndex);
                        if (Double.isNaN(a2)) continue;
                        Arrays.fill(xy, 0, catRowLevel, 0.0);
                        for (int level = 0; level < catRowLevel; ++level) {
                            xRow = level + this._yt._catOffsets[tARow] - xChunkRowStart;
                            if (xRow >= xChunkSize) {
                                if (xChunkIndices.size() < 1) {
                                    Log.err("GLRM train", "Chunks mismatch between A transpose and X frame.");
                                } else {
                                    GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
                                    xChunkRowStart = (int)xChunks[0].start();
                                    xChunkSize = xChunks[0]._len;
                                    xRow = level + this._yt._catOffsets[tARow] - xChunkRowStart;
                                }
                            }
                            for (int innerCol = 0; innerCol < this._parms._k; ++innerCol) {
                                int n2 = level;
                                xy[n2] = xy[n2] + GLRM.xFrameVec(xChunks, innerCol, this._xOffset).atd(xRow) * GLRM.yArcheTypeVal(this._yt, colIndex, innerCol);
                            }
                        }
                        this._loss += chkweight[colIndex] * this._lossFunc[tARow].mloss(xy, (int)a2, catRowLevel);
                    }
                    continue;
                }
                xRow = tARow - xChunkRowStart + numColIndexOffset;
                if (xRow >= xChunkSize) {
                    if (xChunkIndices.size() < 1) {
                        Log.err("GLRM train", "Chunks mismatch between A transpose and X frame.");
                    } else {
                        GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
                        xChunkRowStart = (int)xChunks[0].start();
                        xChunkSize = xChunks[0]._len;
                        xRow = tARow - xChunkRowStart + numColIndexOffset;
                    }
                }
                int numRow = tARow - this._ncats;
                for (colIndex = 0; colIndex < cs.length; ++colIndex) {
                    a2 = cs[colIndex].atd(rowIndex);
                    if (Double.isNaN(a2)) continue;
                    double txy = 0.0;
                    for (int innerCol = 0; innerCol < this._parms._k; ++innerCol) {
                        txy += GLRM.xFrameVec(xChunks, innerCol, this._xOffset).atd(xRow) * GLRM.yArcheTypeVal(this._yt, colIndex, innerCol);
                    }
                    this._loss += chkweight[colIndex] * this._lossFunc[tARow].loss(txy, (a2 - this._normSub[numRow]) * this._normMul[numRow]);
                }
            }
        }

        private void calXOldReg(double[][] yvals, int yLen) {
            for (int j2 = 0; j2 < yLen; ++j2) {
                double[] xrow = Arrays.copyOf(yvals[j2], this._parms._k);
                _xold_reg += this._parms._regularization_x.regularize(xrow);
            }
        }

        @Override
        public void reduce(ObjCalcW other) {
            this._loss += other._loss;
        }
    }

    private static class UpdateY
    extends MRTask<UpdateY> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final double _alpha;
        final Archetypes _ytold;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        double[][] _ytnew;
        double _yreg;

        UpdateY(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, int weightId) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ytold = yt;
            this._yreg = 0.0;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        private Chunk chk_xnew(Chunk[] chks, int c2) {
            return chks[this._ncolA + this._ncolX + c2];
        }

        @Override
        public void map(Chunk[] cs) {
            int j2;
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            this._ytnew = new double[this._ytold.nfeatures()][this._ncolX];
            Chunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            double[] xy = null;
            double[] grad = null;
            if (this._ytold._numLevels[0] > 0) {
                xy = new double[this._ytold._numLevels[0]];
                grad = new double[this._ytold._numLevels[0]];
            }
            for (j2 = 0; j2 < this._ncats; ++j2) {
                int catColJLevel = this._ytold._numLevels[j2];
                for (int row = 0; row < cs[0]._len; ++row) {
                    double a2 = cs[j2].atd(row);
                    if (Double.isNaN(a2)) continue;
                    double cweight = chkweight.atd(row);
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    Arrays.fill(xy, 0.0);
                    for (int level = 0; level < catColJLevel; ++level) {
                        for (int k2 = 0; k2 < this._ncolX; ++k2) {
                            int n2 = level;
                            xy[n2] = xy[n2] + this.chk_xnew(cs, k2).atd(row) * this._ytold.getCat(j2, level, k2);
                        }
                    }
                    double[] weight = this._lossFunc[j2].mlgrad(xy, (int)a2, grad, catColJLevel);
                    for (int level = 0; level < catColJLevel; ++level) {
                        for (int k3 = 0; k3 < this._ncolX; ++k3) {
                            double[] dArray = this._ytnew[this._ytold.getCatCidx(j2, level)];
                            int n3 = k3;
                            dArray[n3] = dArray[n3] + cweight * weight[level] * this.chk_xnew(cs, k3).atd(row);
                        }
                    }
                }
            }
            for (j2 = this._ncats; j2 < this._ncolA; ++j2) {
                int js = j2 - this._ncats;
                int yidx = this._ytold.getNumCidx(js);
                for (int row = 0; row < cs[0]._len; ++row) {
                    double a3 = cs[j2].atd(row);
                    if (Double.isNaN(a3)) continue;
                    double cweight = chkweight.atd(row);
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    double txy = 0.0;
                    for (int k4 = 0; k4 < this._ncolX; ++k4) {
                        txy += this.chk_xnew(cs, k4).atd(row) * this._ytold.getNum(js, k4);
                    }
                    double weight = cweight * this._lossFunc[j2].lgrad(txy, (a3 - this._normSub[js]) * this._normMul[js]);
                    for (int k5 = 0; k5 < this._ncolX; ++k5) {
                        double[] dArray = this._ytnew[yidx];
                        int n4 = k5;
                        dArray[n4] = dArray[n4] + weight * this.chk_xnew(cs, k5).atd(row);
                    }
                }
            }
        }

        @Override
        public void reduce(UpdateY other) {
            ArrayUtils.add(this._ytnew, other._ytnew);
        }

        @Override
        protected void postGlobal() {
            assert (this._ytnew.length == this._ytold.nfeatures() && this._ytnew[0].length == this._ytold.rank());
            RandomBase rand = RandomUtils.getRNG(this._parms._seed);
            for (int j2 = 0; j2 < this._ytnew.length; ++j2) {
                double[] u2 = new double[this._ytnew[0].length];
                for (int k2 = 0; k2 < this._ytnew[0].length; ++k2) {
                    u2[k2] = this._ytold._archetypes[j2][k2] - this._alpha * this._ytnew[j2][k2];
                }
                this._ytnew[j2] = this._parms._regularization_y.rproxgrad(u2, this._alpha * this._parms._gamma_y, rand);
                this._yreg += this._parms._regularization_y.regularize(this._ytnew[j2]);
            }
        }
    }

    private static class UpdateXeY
    extends MRTask<UpdateXeY> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final double _alpha;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final Frame _tAVecs;
        final int[] _finalCatIndex;
        double _yreg;

        UpdateXeY(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, Frame tAVecs) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._tAVecs = tAVecs;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._normSub = normSub;
            this._normMul = normMul;
            this._finalCatIndex = new int[this._ncats];
            for (int index = 0; index < this._ncats; ++index) {
                this._finalCatIndex[index] = this._yt._catOffsets[index + 1] - 1;
            }
        }

        @Override
        public void map(Chunk[] cs) {
            double[] chkweight = this._yt._weights;
            int numXRow = cs[0]._len;
            int xRowStart = (int)cs[0].start();
            int xRowEnd = xRowStart + numXRow - 1;
            Chunk[] tAChunks = new Chunk[this._ncolA];
            Chunk[] xChunksN = new Chunk[cs.length];
            int numCatColumns = this._yt._catOffsets[this._ncats];
            int xTARowStart = GLRM.findOriginalColIndex(xRowStart, this._ncats, numCatColumns, this._yt);
            int xTARowEnd = GLRM.findOriginalColIndex(xRowEnd, this._ncats, numCatColumns, this._yt);
            double[][] xMat = null;
            double[] xy = null;
            double[] prod = null;
            double[][] tgradEnum = null;
            double[][] uEnum = null;
            ArrayList<Integer> tAChunkIndices = GLRM.findtAChunkIndices(this._tAVecs, xRowStart, xRowEnd, this._yt);
            GLRM.getXChunk(this._tAVecs, tAChunkIndices.remove(0), tAChunks);
            int tAColNum = tAChunks.length;
            int tAChunkRowStart = (int)tAChunks[0].start();
            int tAChunkSize = tAChunks[0]._len;
            int xRow = 0;
            if (this._yt._numLevels[tAChunkRowStart] > 0) {
                tgradEnum = new double[this._yt._numLevels[tAChunkRowStart]][this._ncolX];
                uEnum = new double[this._yt._numLevels[tAChunkRowStart]][this._ncolX];
                xMat = new double[this._yt._numLevels[tAChunkRowStart]][this._ncolX];
                xy = new double[this._yt._numLevels[tAChunkRowStart]];
                prod = new double[this._yt._numLevels[tAChunkRowStart]];
            }
            double a2 = 0.0;
            double[] tgrad = new double[this._ncolX];
            double[] u2 = new double[this._ncolX];
            RandomBase rand = RandomUtils.getRNG(0L);
            this._yreg = 0.0;
            int row = 0;
            int rowX = 0;
            int rowXTrue = 0;
            int currentXRowstart = 0;
            int currentXRowEnd = 0;
            for (int tArow = xTARowStart; tArow <= xTARowEnd; ++tArow) {
                int k2;
                row = tArow - tAChunkRowStart;
                if (row >= tAChunkSize) {
                    GLRM.getXChunk(this._tAVecs, tAChunkIndices.remove(0), tAChunks);
                    tAChunkRowStart = (int)tAChunks[0].start();
                    tAChunkSize = tAChunks[0]._len;
                    row = tArow - tAChunkRowStart;
                }
                rand.setSeed(this._parms._seed + cs[0].start() + (long)row);
                Arrays.fill(tgrad, 0.0);
                if (tArow < this._ncats) {
                    int level;
                    int catColJLevel = this._yt._numLevels[tArow];
                    for (level = 0; level < tgradEnum.length; ++level) {
                        Arrays.fill(tgradEnum[level], 0, this._parms._k, 0.0);
                    }
                    for (int j2 = 0; j2 < tAColNum; ++j2) {
                        if (j2 == 0) {
                            xRow = rowX + xRowStart;
                            rowXTrue = this._yt._catOffsets[tArow];
                            int levelSeen = 0;
                            if (xRow > rowXTrue) {
                                ArrayList<Integer> tempXChunkCidx = GLRM.findXChunkIndices(this._fr, rowXTrue, xRow - 1, this._yt);
                                GLRM.getXChunk(this._fr, tempXChunkCidx.remove(0), xChunksN);
                                int tempXStart = (int)xChunksN[0].start();
                                int tempXSize = xChunksN[0]._len;
                                for (int rowN = rowXTrue; rowN < xRow; ++rowN) {
                                    int relRowX = rowN - tempXStart;
                                    if (relRowX > tempXSize) {
                                        if (tempXChunkCidx.size() < 1) {
                                            Log.err("GLRM train", "Chunks mismatch between A transpose and X frame.");
                                        } else {
                                            GLRM.getXChunk(this._fr, tempXChunkCidx.remove(0), xChunksN);
                                            tempXStart = (int)xChunksN[0].start();
                                            tempXSize = xChunksN[0]._len;
                                            relRowX = rowN - tempXStart;
                                        }
                                    }
                                    for (k2 = 0; k2 < this._ncolX; ++k2) {
                                        xMat[levelSeen][k2] = GLRM.xFrameVec(xChunksN, k2, 0).atd(relRowX);
                                    }
                                    ++levelSeen;
                                }
                            }
                            currentXRowstart = levelSeen;
                            for (int level2 = levelSeen; level2 < catColJLevel && rowX <= xRowEnd; ++level2) {
                                for (int k3 = 0; k3 < this._ncolX; ++k3) {
                                    xMat[levelSeen][k3] = GLRM.xFrameVec(cs, k3, 0).atd(rowX);
                                }
                                ++levelSeen;
                                ++rowX;
                                ++xRow;
                            }
                            currentXRowEnd = levelSeen;
                            int levelLeft = catColJLevel - levelSeen;
                            if (levelLeft > 0) {
                                int endXRow = xRow + levelLeft - 1;
                                ArrayList<Integer> tempXChunkCidx = GLRM.findXChunkIndices(this._fr, xRow, endXRow, this._yt);
                                GLRM.getXChunk(this._fr, tempXChunkCidx.remove(0), xChunksN);
                                int tempXStart = (int)xChunksN[0].start();
                                int tempXSize = xChunksN[0]._len;
                                for (int rowN = xRow; rowN <= endXRow; ++rowN) {
                                    Arrays.fill(tgradEnum[levelSeen], 0, this._ncolX, 0.0);
                                    int relRowX = rowN - tempXStart;
                                    if (relRowX > tempXSize) {
                                        if (tempXChunkCidx.size() < 1) {
                                            Log.err("GLRM train", "Chunks mismatch between A transpose and X frame.");
                                        } else {
                                            GLRM.getXChunk(this._fr, tempXChunkCidx.remove(0), xChunksN);
                                            tempXStart = (int)xChunksN[0].start();
                                            tempXSize = xChunksN[0]._len;
                                            relRowX = rowN - tempXStart;
                                        }
                                    }
                                    for (int k4 = 0; k4 < this._ncolX; ++k4) {
                                        xMat[levelSeen][k4] = GLRM.xFrameVec(xChunksN, k4, 0).atd(relRowX);
                                    }
                                    ++levelSeen;
                                }
                            }
                        }
                        double cweight = chkweight[j2];
                        assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                        a2 = tAChunks[j2].atd(row);
                        if (Double.isNaN(a2)) continue;
                        Arrays.fill(xy, 0, catColJLevel, 0.0);
                        for (int level3 = 0; level3 < catColJLevel; ++level3) {
                            for (int k5 = 0; k5 < this._ncolX; ++k5) {
                                int n2 = level3;
                                xy[n2] = xy[n2] + xMat[level3][k5] * GLRM.yArcheTypeVal(this._yt, j2, k5);
                            }
                        }
                        double[] weight = this._lossFunc[tArow].mlgrad(xy, (int)a2, prod, catColJLevel);
                        for (int c2 = 0; c2 < catColJLevel; ++c2) {
                            for (int k6 = 0; k6 < this._ncolX; ++k6) {
                                double[] dArray = tgradEnum[c2];
                                int n3 = k6;
                                dArray[n3] = dArray[n3] + weight[c2] * cweight * GLRM.yArcheTypeVal(this._yt, j2, k6);
                            }
                        }
                    }
                    for (level = currentXRowstart; level < currentXRowEnd; ++level) {
                        for (int k7 = 0; k7 < this._ncolX; ++k7) {
                            uEnum[level][k7] = xMat[level][k7] - this._alpha * tgradEnum[level][k7];
                        }
                        double[] xnew = this._parms._regularization_y.rproxgrad(uEnum[level], this._alpha * this._parms._gamma_y, rand);
                        this._yreg += this._parms._regularization_y.regularize(xnew);
                        int trueXRow = level + this._yt._catOffsets[tArow];
                        xRow = trueXRow - xRowStart;
                        for (int k8 = 0; k8 < this._ncolX; ++k8) {
                            GLRM.xFrameVec(cs, k8, this._parms._k).set(xRow, xnew[k8]);
                        }
                    }
                    continue;
                }
                rowX = GLRM.findExpColIndex(tArow, this._ncats, this._yt) - xRowStart;
                int numRow = tArow - this._ncats;
                for (int j3 = 0; j3 < tAColNum; ++j3) {
                    double cweight = chkweight[j3];
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    a2 = tAChunks[j3].atd(row);
                    if (Double.isNaN(a2)) continue;
                    double txy = 0.0;
                    for (int k9 = 0; k9 < this._ncolX; ++k9) {
                        txy += GLRM.xFrameVec(cs, k9, 0).atd(rowX) * GLRM.yArcheTypeVal(this._yt, j3, k9);
                    }
                    double weight = cweight * this._lossFunc[tArow].lgrad(txy, (a2 - this._normSub[numRow]) * this._normMul[numRow]);
                    for (k2 = 0; k2 < this._ncolX; ++k2) {
                        int n4 = k2;
                        tgrad[n4] = tgrad[n4] + weight * GLRM.yArcheTypeVal(this._yt, j3, k2);
                    }
                }
                for (int k10 = 0; k10 < this._ncolX; ++k10) {
                    double xold = GLRM.xFrameVec(cs, k10, 0).atd(rowX);
                    u2[k10] = xold - this._alpha * tgrad[k10];
                }
                double[] xnew = this._parms._regularization_y.rproxgrad(u2, this._alpha * this._parms._gamma_y, rand);
                this._yreg += this._parms._regularization_y.regularize(xnew);
                for (int k11 = 0; k11 < this._ncolX; ++k11) {
                    GLRM.xFrameVec(cs, k11, this._parms._k).set(rowX, xnew[k11]);
                }
            }
        }

        @Override
        public void reduce(UpdateXeY other) {
            this._yreg += other._yreg;
        }
    }

    private static class UpdateYeX
    extends MRTask<UpdateYeX> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final double _alpha;
        final Archetypes _ytold;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final Frame _xVecs;
        double[][] _ytnew;
        double _xreg;

        UpdateYeX(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, Frame xVecs) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ytold = yt;
            this._xreg = 0.0;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._normSub = normSub;
            this._normMul = normMul;
            this._xVecs = xVecs;
        }

        @Override
        public void map(Chunk[] cs) {
            double[] chkweight = this._ytold._weights;
            int numTArow = cs[0]._len;
            int tArowStart = (int)cs[0].start();
            int tArowEnd = numTArow + numTArow - 1;
            Chunk[] xChunks = new Chunk[this._parms._k * 2];
            this._ytnew = new double[this._ytold.nfeatures()][this._ncolX];
            double[] xy = null;
            double[] grad = null;
            if (this._ytold._numLevels[tArowStart] > 0) {
                xy = new double[this._ytold._numLevels[tArowStart]];
                grad = new double[this._ytold._numLevels[tArowStart]];
            }
            ArrayList<Integer> xChunkIndices = GLRM.findXChunkIndices(this._xVecs, tArowStart, tArowEnd, this._ytold);
            int numColIndexOffset = this._ytold._catOffsets[this._ncats] - this._ncats;
            GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
            int xChunkRowStart = (int)xChunks[0].start();
            int xChunkSize = xChunks[0]._len;
            int xRow = 0;
            int tARow = 0;
            for (int row = 0; row < cs[0]._len; ++row) {
                double a2;
                double cweight;
                int j2;
                tARow = row + tArowStart;
                if (tARow < this._ncats) {
                    int catColJLevel = this._ytold._numLevels[tARow];
                    for (j2 = 0; j2 < cs.length; ++j2) {
                        cweight = chkweight[j2];
                        assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                        a2 = cs[j2].atd(row);
                        if (Double.isNaN(a2)) continue;
                        Arrays.fill(xy, 0.0);
                        for (int level = 0; level < catColJLevel; ++level) {
                            xRow = level + this._ytold._catOffsets[tARow] - xChunkRowStart;
                            if (xRow >= xChunkSize) {
                                if (xChunkIndices.size() < 1) {
                                    Log.err("GLRM train updateYeX", "Chunks mismatch between A transpose and X frame.");
                                } else {
                                    GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
                                    xChunkRowStart = (int)xChunks[0].start();
                                    xChunkSize = xChunks[0]._len;
                                    xRow = level + this._ytold._catOffsets[tARow] - xChunkRowStart;
                                }
                            }
                            for (int k2 = 0; k2 < this._ncolX; ++k2) {
                                int n2 = level;
                                xy[n2] = xy[n2] + GLRM.xFrameVec(xChunks, k2, 0).atd(xRow) * GLRM.yArcheTypeVal(this._ytold, j2, k2);
                            }
                        }
                        double[] weight = this._lossFunc[tARow].mlgrad(xy, (int)a2, grad, catColJLevel);
                        for (int level = 0; level < catColJLevel; ++level) {
                            xRow = level + this._ytold._catOffsets[tARow] - xChunkRowStart;
                            for (int k3 = 0; k3 < this._ncolX; ++k3) {
                                double[] dArray = this._ytnew[j2];
                                int n3 = k3;
                                dArray[n3] = dArray[n3] + cweight * weight[level] * GLRM.xFrameVec(xChunks, k3, 0).atd(xRow);
                            }
                        }
                    }
                    continue;
                }
                xRow = tARow - xChunkRowStart + numColIndexOffset;
                if (xRow >= xChunkSize) {
                    if (xChunkIndices.size() < 1) {
                        Log.err("GLRM train", "Chunks mismatch between A transpose and X frame.");
                    } else {
                        GLRM.getXChunk(this._xVecs, xChunkIndices.remove(0), xChunks);
                        xChunkRowStart = (int)xChunks[0].start();
                        xChunkSize = xChunks[0]._len;
                        xRow = tARow - xChunkRowStart + numColIndexOffset;
                    }
                }
                int numRow = tARow - this._ncats;
                for (j2 = 0; j2 < cs.length; ++j2) {
                    cweight = chkweight[j2];
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    a2 = cs[j2].atd(row);
                    if (Double.isNaN(a2)) continue;
                    double txy = 0.0;
                    for (int k4 = 0; k4 < this._ncolX; ++k4) {
                        txy += GLRM.xFrameVec(xChunks, k4, 0).atd(xRow) * GLRM.yArcheTypeVal(this._ytold, j2, k4);
                    }
                    double weight = cweight * this._lossFunc[tARow].lgrad(txy, (a2 - this._normSub[numRow]) * this._normMul[numRow]);
                    for (int k5 = 0; k5 < this._ncolX; ++k5) {
                        double[] dArray = this._ytnew[j2];
                        int n4 = k5;
                        dArray[n4] = dArray[n4] + weight * GLRM.xFrameVec(xChunks, k5, 0).atd(xRow);
                    }
                }
            }
        }

        @Override
        public void reduce(UpdateYeX other) {
            ArrayUtils.add(this._ytnew, other._ytnew);
        }

        @Override
        protected void postGlobal() {
            assert (this._ytnew.length == this._ytold.nfeatures() && this._ytnew[0].length == this._ytold.rank());
            RandomBase rand = RandomUtils.getRNG(this._parms._seed);
            for (int j2 = 0; j2 < this._ytnew.length; ++j2) {
                double[] u2 = new double[this._ytnew[0].length];
                for (int k2 = 0; k2 < this._ytnew[0].length; ++k2) {
                    u2[k2] = this._ytold._archetypes[j2][k2] - this._alpha * this._ytnew[j2][k2];
                }
                this._ytnew[j2] = this._parms._regularization_x.rproxgrad(u2, this._alpha * this._parms._gamma_x, rand);
                this._xreg += this._parms._regularization_x.regularize(this._ytnew[j2]);
            }
        }
    }

    private static class UpdateX
    extends MRTask<UpdateX> {
        GLRMModel.GLRMParameters _parms;
        GlrmLoss[] _lossFunc;
        final double _alpha;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        double _xreg;

        UpdateX(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GlrmLoss[] lossFunc, int weightId) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        private Chunk chk_xold(Chunk[] chks, int c2) {
            return chks[this._ncolA + c2];
        }

        private Chunk chk_xnew(Chunk[] chks, int c2) {
            return chks[this._ncolA + this._ncolX + c2];
        }

        @Override
        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            double[] a2 = new double[this._ncolA];
            double[] tgrad = new double[this._ncolX];
            double[] u2 = new double[this._ncolX];
            Chunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            RandomBase rand = RandomUtils.getRNG(0L);
            this._xreg = 0.0;
            double[] xy = null;
            double[] prod = null;
            if (this._yt._numLevels[0] > 0) {
                xy = new double[this._yt._numLevels[0]];
                prod = new double[this._yt._numLevels[0]];
            }
            for (int row = 0; row < cs[0]._len; ++row) {
                int j2;
                rand.setSeed(this._parms._seed + cs[0].start() + (long)row);
                Arrays.fill(tgrad, 0.0);
                double cweight = chkweight.atd(row);
                assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                for (j2 = 0; j2 < this._ncats; ++j2) {
                    double weights;
                    int cidx;
                    int c2;
                    a2[j2] = cs[j2].atd(row);
                    if (Double.isNaN(a2[j2])) continue;
                    int catColJLevel = this._yt._numLevels[j2];
                    Arrays.fill(xy, 0, catColJLevel, 0.0);
                    for (int level = 0; level < catColJLevel; ++level) {
                        for (int k2 = 0; k2 < this._ncolX; ++k2) {
                            int n2 = level;
                            xy[n2] = xy[n2] + this.chk_xold(cs, k2).atd(row) * this._yt.getCat(j2, level, k2);
                        }
                    }
                    double[] weight = this._lossFunc[j2].mlgrad(xy, (int)a2[j2], prod, catColJLevel);
                    if (this._yt._transposed) {
                        for (c2 = 0; c2 < catColJLevel; ++c2) {
                            cidx = this._yt.getCatCidx(j2, c2);
                            weights = cweight * weight[c2];
                            double[] yArchetypes = this._yt._archetypes[cidx];
                            for (int k3 = 0; k3 < this._ncolX; ++k3) {
                                int n3 = k3;
                                tgrad[n3] = tgrad[n3] + weights * yArchetypes[k3];
                            }
                        }
                        continue;
                    }
                    for (c2 = 0; c2 < catColJLevel; ++c2) {
                        cidx = this._yt.getCatCidx(j2, c2);
                        weights = cweight * weight[c2];
                        for (int k4 = 0; k4 < this._ncolX; ++k4) {
                            int n4 = k4;
                            tgrad[n4] = tgrad[n4] + weights * this._yt._archetypes[k4][cidx];
                        }
                    }
                }
                for (j2 = this._ncats; j2 < this._ncolA; ++j2) {
                    int js = j2 - this._ncats;
                    a2[j2] = cs[j2].atd(row);
                    if (Double.isNaN(a2[j2])) continue;
                    double xy1 = 0.0;
                    for (int k5 = 0; k5 < this._ncolX; ++k5) {
                        xy1 += this.chk_xold(cs, k5).atd(row) * this._yt.getNum(js, k5);
                    }
                    double weight = cweight * this._lossFunc[j2].lgrad(xy1, (a2[j2] - this._normSub[js]) * this._normMul[js]);
                    for (int k6 = 0; k6 < this._ncolX; ++k6) {
                        int n5 = k6;
                        tgrad[n5] = tgrad[n5] + weight * this._yt.getNum(js, k6);
                    }
                }
                for (int k7 = 0; k7 < this._ncolX; ++k7) {
                    double xold = this.chk_xold(cs, k7).atd(row);
                    u2[k7] = xold - this._alpha * tgrad[k7];
                }
                double[] xnew = this._parms._regularization_x.rproxgrad(u2, this._alpha * this._parms._gamma_x, rand);
                this._xreg += this._parms._regularization_x.regularize(xnew);
                for (int k8 = 0; k8 < this._ncolX; ++k8) {
                    this.chk_xnew(cs, k8).set(row, xnew[k8]);
                }
            }
        }

        @Override
        public void reduce(UpdateX other) {
            this._xreg += other._xreg;
        }
    }

    public static class updateXVecs
    extends MRTask<updateXVecs> {
        int _startCol;
        int _numCols;
        int _endCols;

        public updateXVecs(int startCol, int numCols) {
            assert (startCol >= 0);
            assert (numCols > 0);
            this._startCol = startCol;
            this._numCols = numCols;
            this._endCols = startCol + numCols;
        }

        @Override
        public void map(Chunk[] chks) {
            for (int colIndex = this._startCol; colIndex < this._endCols; ++colIndex) {
                for (int rowIndex = 0; rowIndex < chks[0]._len; ++rowIndex) {
                    GLRM.xFrameVec(chks, colIndex, 0).set(rowIndex, GLRM.xFrameVec(chks, colIndex, this._numCols).atd(rowIndex));
                }
            }
        }
    }

    private static class InitialXKMeans
    extends MRTask<InitialXKMeans> {
        GLRMModel.GLRMParameters _parms;
        KMeansModel _model;
        final int _ncolA;
        final int _ncolX;

        InitialXKMeans(GLRMModel.GLRMParameters parms, KMeansModel model, int ncolA, int ncolX) {
            this._parms = parms;
            this._model = model;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
        }

        @Override
        public void map(Chunk[] chks) {
            double[] tmp = new double[this._ncolA];
            RandomBase rand = RandomUtils.getRNG(0L);
            for (int row = 0; row < chks[0]._len; ++row) {
                double[] p2 = this._model.score_ratio(chks, row, tmp);
                rand.setSeed(this._parms._seed + chks[0].start() + (long)row);
                p2 = this._parms._regularization_x.project(p2, rand);
                for (int c2 = 0; c2 < p2.length; ++c2) {
                    chks[this._ncolA + c2].set(row, p2[c2]);
                    chks[this._ncolA + this._ncolX + c2].set(row, p2[c2]);
                }
            }
        }
    }

    private static class InitialXSVD
    extends MRTask<InitialXSVD> {
        final double[] _diag;
        final int _ncolU;
        final int _offX;
        final int _offW;

        InitialXSVD(double[] diag, int ncolU, int ncolA, int ncolX) {
            assert (diag != null && diag.length == ncolU);
            this._diag = diag;
            this._ncolU = ncolU;
            this._offX = ncolU + ncolA;
            this._offW = this._offX + ncolX;
        }

        @Override
        public void map(Chunk[] chks) {
            for (int row = 0; row < chks[0]._len; ++row) {
                for (int c2 = 0; c2 < this._ncolU; ++c2) {
                    double ud = chks[c2].atd(row) * this._diag[c2];
                    chks[this._offX + c2].set(row, ud);
                    chks[this._offW + c2].set(row, ud);
                }
            }
        }
    }

    private static class InitialXProj
    extends MRTask<InitialXProj> {
        GLRMModel.GLRMParameters _parms;
        final int _ncolA;
        final int _ncolX;

        InitialXProj(GLRMModel.GLRMParameters parms, int ncolA, int ncolX) {
            this._parms = parms;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
        }

        @Override
        public void map(Chunk[] chks) {
            RandomBase rand = RandomUtils.getRNG(this._parms._seed);
            for (int row = 0; row < chks[0]._len; ++row) {
                rand.setSeed(this._parms._seed + chks[0].start() + (long)row);
                double[] xrow = ArrayUtils.gaussianVector(this._ncolX, rand);
                xrow = this._parms._regularization_x.project(xrow, rand);
                for (int c2 = 0; c2 < xrow.length; ++c2) {
                    chks[this._ncolA + c2].set(row, xrow[c2]);
                    chks[this._ncolA + this._ncolX + c2].set(row, xrow[c2]);
                }
            }
        }
    }

    protected static final class Archetypes
    extends Iced<Archetypes> {
        double[][] _archetypes;
        boolean _transposed;
        final int[] _catOffsets;
        final int[] _numLevels;
        double[] _weights;

        Archetypes(double[][] y2, boolean transposed, int[] catOffsets, int[] numLevels) {
            this._archetypes = y2;
            this._transposed = transposed;
            this._catOffsets = catOffsets;
            this._numLevels = numLevels;
            this._weights = null;
        }

        Archetypes(double[][] y2, boolean transposed, int[] catOffsets, int[] numLevels, double[] weights) {
            this._archetypes = y2;
            this._transposed = transposed;
            this._catOffsets = catOffsets;
            this._numLevels = numLevels;
            this._weights = Arrays.copyOf(weights, weights.length);
        }

        public int rank() {
            return this._transposed ? this._archetypes[0].length : this._archetypes.length;
        }

        public int nfeatures() {
            return this._transposed ? this._archetypes.length : this._archetypes[0].length;
        }

        public double[][] getY(boolean transpose) {
            return transpose ^ this._transposed ? ArrayUtils.transpose(this._archetypes) : this._archetypes;
        }

        public TwoDimTable buildTable(String[] features, boolean transpose) {
            int rank = this.rank();
            int nfeat = this.nfeatures();
            assert (features != null && features.length == this.nfeatures());
            double[][] yraw = this.getY(transpose);
            if (transpose) {
                Object[] colTypes = new String[rank];
                Object[] colFormats = new String[rank];
                String[] colHeaders = new String[rank];
                Arrays.fill(colTypes, "double");
                Arrays.fill(colFormats, "%5f");
                for (int i2 = 0; i2 < colHeaders.length; ++i2) {
                    colHeaders[i2] = "Arch" + String.valueOf(i2 + 1);
                }
                return new TwoDimTable("Archetypes", null, features, colHeaders, (String[])colTypes, (String[])colFormats, "", new String[yraw.length][], yraw);
            }
            String[] rowNames = new String[rank];
            Object[] colTypes = new String[nfeat];
            Object[] colFormats = new String[nfeat];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            for (int i3 = 0; i3 < rowNames.length; ++i3) {
                rowNames[i3] = "Arch" + String.valueOf(i3 + 1);
            }
            return new TwoDimTable("Archetypes", null, rowNames, features, (String[])colTypes, (String[])colFormats, "", new String[yraw.length][], yraw);
        }

        public int getNumCidx(int j2) {
            return this._catOffsets[this._catOffsets.length - 1] + j2;
        }

        public int getCatCidx(int j2, int level) {
            return GlrmMojoModel.getCatCidx(j2, level, this._numLevels, this._catOffsets);
        }

        protected final double getNum(int j2, int k2) {
            int cidx = GlrmMojoModel.getNumCidx(j2, this._catOffsets);
            return this._transposed ? this._archetypes[cidx][k2] : this._archetypes[k2][cidx];
        }

        protected final double lmulNumCol(double[] x2, int j2) {
            return GlrmMojoModel.lmulNumCol(x2, j2, this._transposed, this._archetypes, this._catOffsets);
        }

        protected final double getCat(int j2, int level, int k2) {
            int cidx = this.getCatCidx(j2, level);
            return this._transposed ? this._archetypes[cidx][k2] : this._archetypes[k2][cidx];
        }

        protected final double[][] getCatBlock(int j2) {
            int catColJLevel = this._numLevels[j2];
            assert (catColJLevel != 0) : "Number of levels in categorical column cannot be zero";
            double[][] block = new double[this.rank()][catColJLevel];
            if (this._transposed) {
                for (int level = 0; level < catColJLevel; ++level) {
                    int cidx = this.getCatCidx(j2, level);
                    for (int k2 = 0; k2 < this.rank(); ++k2) {
                        block[k2][level] = this._archetypes[cidx][k2];
                    }
                }
            } else {
                for (int level = 0; level < catColJLevel; ++level) {
                    int cidx = this.getCatCidx(j2, level);
                    for (int k3 = 0; k3 < this.rank(); ++k3) {
                        block[k3][level] = this._archetypes[k3][cidx];
                    }
                }
            }
            return block;
        }

        protected final double[] lmulCatBlock(double[] x2, int j2) {
            return GlrmMojoModel.lmulCatBlock(x2, j2, this._numLevels, this._transposed, this._archetypes, this._catOffsets);
        }
    }

    class GLRMDriver
    extends ModelBuilder.Driver {
        private transient Frame _rebalancedTrain;

        GLRMDriver() {
            super(GLRM.this);
        }

        private double[][] initialXY(DataInfo tinfo, Frame dfrm, GLRMModel model, long na_cnt) {
            Model.Parameters parms;
            double[][] centers_exp = null;
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == GlrmInitialization.User) {
                Frame userYFrame;
                Frame frame = userYFrame = ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_y == null ? null : ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_y.get();
                if (userYFrame != null) {
                    Vec[] yVecs = userYFrame.vecs();
                    if (((GLRMModel.GLRMParameters)GLRM.this._parms)._expand_user_y) {
                        double[][] centers = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][GLRM.this._ncolA];
                        for (int c2 = 0; c2 < GLRM.this._ncolA; ++c2) {
                            for (int r2 = 0; r2 < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++r2) {
                                centers[r2][c2] = yVecs[c2].at(r2);
                            }
                        }
                        centers = ArrayUtils.permuteCols(centers, tinfo._permutation);
                        centers_exp = GLRM.expandCats(centers, tinfo);
                    } else {
                        centers_exp = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][GLRM.this._ncolY];
                        for (int c3 = 0; c3 < GLRM.this._ncolY; ++c3) {
                            for (int r3 = 0; r3 < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++r3) {
                                centers_exp[r3][c3] = yVecs[c3].at(r3);
                            }
                        }
                    }
                } else {
                    centers_exp = ArrayUtils.gaussianArray(((GLRMModel.GLRMParameters)GLRM.this._parms)._k, GLRM.this._ncolY, ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed);
                }
                if (((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x != null) {
                    Frame tmp = new Frame(dfrm);
                    tmp.add(((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x.get());
                    new MRTask(){

                        @Override
                        public void map(Chunk[] cs) {
                            for (int row = 0; row < cs[0]._len; ++row) {
                                for (int i2 = GLRM.this._ncolA; i2 < GLRM.this._ncolA + GLRM.this._ncolX; ++i2) {
                                    double x2 = cs[2 * GLRM.this._ncolX + i2].atd(row);
                                    cs[i2].set(row, x2);
                                    cs[GLRM.this._ncolX + i2].set(row, x2);
                                }
                            }
                        }
                    }.doAll(tmp);
                } else {
                    InitialXProj xtsk = new InitialXProj((GLRMModel.GLRMParameters)GLRM.this._parms, GLRM.this._ncolA, GLRM.this._ncolX);
                    xtsk.doAll(dfrm);
                }
                return centers_exp;
            }
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == GlrmInitialization.Random) {
                centers_exp = ArrayUtils.gaussianArray(((GLRMModel.GLRMParameters)GLRM.this._parms)._k, GLRM.this._ncolY, ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed);
                InitialXProj xtsk = new InitialXProj((GLRMModel.GLRMParameters)GLRM.this._parms, GLRM.this._ncolA, GLRM.this._ncolX);
                xtsk.doAll(dfrm);
            } else if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == GlrmInitialization.SVD) {
                parms = new SVDModel.SVDParameters();
                parms._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                parms._ignored_columns = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignored_columns;
                parms._ignore_const_cols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignore_const_cols;
                parms._score_each_iteration = ((GLRMModel.GLRMParameters)GLRM.this._parms)._score_each_iteration;
                parms._use_all_factor_levels = true;
                parms._nv = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                parms._transform = ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform;
                parms._svd_method = ((GLRMModel.GLRMParameters)GLRM.this._parms)._svd_method;
                parms._max_iterations = parms._svd_method == SVDModel.SVDParameters.Method.Randomized ? ((GLRMModel.GLRMParameters)GLRM.this._parms)._k : ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                parms._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                parms._keep_u = true;
                parms._impute_missing = true;
                parms._save_v_frame = false;
                SVDModel svd = (SVDModel)ModelCacheManager.get(parms);
                if (svd == null) {
                    SVD svdP = new SVD((SVDModel.SVDParameters)parms, GLRM.this._job, true, model);
                    svdP.setWideDataset(GLRM.this._wideDataset);
                    svd = (SVDModel)svdP.trainModelNested(this._rebalancedTrain);
                }
                ((GLRMModel.GLRMOutput)model._output)._init_key = svd._key;
                assert (((SVDModel.SVDOutput)svd._output)._permutation.length == tinfo._permutation.length);
                for (int i2 = 0; i2 < tinfo._permutation.length; ++i2) {
                    assert (((SVDModel.SVDOutput)svd._output)._permutation[i2] == tinfo._permutation[i2]);
                }
                centers_exp = ArrayUtils.transpose(((SVDModel.SVDOutput)svd._output)._v);
                ((GLRMModel.GLRMParameters)GLRM.this._parms)._k = ((SVDModel.SVDParameters)svd._parms)._nv;
                double[] dsqrt = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
                for (int i3 = 0; i3 < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++i3) {
                    dsqrt[i3] = Math.sqrt(((SVDModel.SVDOutput)svd._output)._d[i3]);
                    ArrayUtils.mult(centers_exp[i3], dsqrt[i3]);
                }
                Frame uFrm = (Frame)DKV.get(((SVDModel.SVDOutput)svd._output)._u_key).get();
                assert (uFrm.numCols() == ((GLRMModel.GLRMParameters)GLRM.this._parms)._k);
                assert (uFrm.isCompatible(dfrm));
                Frame fullFrm = new Frame(uFrm).add(dfrm);
                InitialXSVD xtsk = new InitialXSVD(dsqrt, ((GLRMModel.GLRMParameters)GLRM.this._parms)._k, GLRM.this._ncolA, GLRM.this._ncolX);
                xtsk.doAll(fullFrm);
            } else if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == GlrmInitialization.PlusPlus) {
                parms = new KMeansModel.KMeansParameters();
                ((KMeansModel.KMeansParameters)parms)._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                ((KMeansModel.KMeansParameters)parms)._ignored_columns = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignored_columns;
                ((KMeansModel.KMeansParameters)parms)._ignore_const_cols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignore_const_cols;
                ((KMeansModel.KMeansParameters)parms)._score_each_iteration = ((GLRMModel.GLRMParameters)GLRM.this._parms)._score_each_iteration;
                ((KMeansModel.KMeansParameters)parms)._init = KMeans.Initialization.PlusPlus;
                ((KMeansModel.KMeansParameters)parms)._k = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                ((KMeansModel.KMeansParameters)parms)._max_iterations = ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                ((KMeansModel.KMeansParameters)parms)._standardize = true;
                ((KMeansModel.KMeansParameters)parms)._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                ((KMeansModel.KMeansParameters)parms)._pred_indicator = true;
                KMeansModel km4 = (KMeansModel)ModelCacheManager.get(parms);
                if (km4 == null) {
                    km4 = (KMeansModel)new KMeans((KMeansModel.KMeansParameters)parms, GLRM.this._job).trainModelNested(this._rebalancedTrain);
                }
                ((GLRMModel.GLRMOutput)model._output)._init_key = km4._key;
                double frob = GLRM.frobenius2(((KMeansModel.KMeansOutput)km4._output)._centers_raw);
                if (frob != 0.0 && !Double.isNaN(frob) && !GLRM.this.hasClosedForm(na_cnt)) {
                    Log.info("Initializing X to matrix of weights inversely correlated with cluster distances");
                    InitialXKMeans xtsk = new InitialXKMeans((GLRMModel.GLRMParameters)GLRM.this._parms, km4, GLRM.this._ncolA, GLRM.this._ncolX);
                    xtsk.doAll(dfrm);
                }
                double[][] centers = ArrayUtils.permuteCols(((KMeansModel.KMeansOutput)km4._output)._centers_raw, tinfo.mapNames(((KMeansModel.KMeansOutput)km4._output)._names));
                centers = GLRM.transform(centers, tinfo._normSub, tinfo._normMul, tinfo._cats, tinfo._nums);
                centers_exp = GLRM.expandCats(centers, tinfo);
            } else {
                GLRM.this.error("_init", "Initialization method " + (Object)((Object)((GLRMModel.GLRMParameters)GLRM.this._parms)._init) + " is undefined");
            }
            assert (centers_exp != null && centers_exp.length == ((GLRMModel.GLRMParameters)GLRM.this._parms)._k && centers_exp[0].length == GLRM.this._ncolY) : "Y must have " + ((GLRMModel.GLRMParameters)GLRM.this._parms)._k + " rows and " + GLRM.access$100(GLRM.this) + " columns";
            double frob = GLRM.frobenius2(centers_exp);
            if (frob == 0.0 || Double.isNaN(frob)) {
                GLRM.this.warn("_init", "Initialization failed. Setting initial Y to standard normal random matrix instead");
                centers_exp = ArrayUtils.gaussianArray(((GLRMModel.GLRMParameters)GLRM.this._parms)._k, GLRM.this._ncolY);
            }
            RandomBase rand = RandomUtils.getRNG(((GLRMModel.GLRMParameters)GLRM.this._parms)._seed);
            for (int i4 = 0; i4 < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++i4) {
                centers_exp[i4] = ((GLRMModel.GLRMParameters)GLRM.this._parms)._regularization_y.project(centers_exp[i4], rand);
            }
            return centers_exp;
        }

        private void initialXClosedForm(DataInfo dinfo, Archetypes yt_arch, double[] normSub, double[] normMul) {
            CholeskyDecomposition yychol;
            Log.info("Initializing X = AY'(YY' + gamma I)^(-1) where A = training data");
            double[][] ygram = ArrayUtils.formGram(yt_arch._archetypes);
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y > 0.0) {
                int i2 = 0;
                while (i2 < ygram.length) {
                    double[] dArray = ygram[i2];
                    int n2 = i2++;
                    dArray[n2] = dArray[n2] + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y;
                }
            }
            if (!(yychol = this.regularizedCholesky(ygram, 10, false)).isSPD()) {
                Log.warn("Initialization failed: (YY' + gamma I) is non-SPD. Setting initial X to standard normal random matrix. Results will be numerically unstable");
            } else {
                CholMulTask cmtsk = new CholMulTask(yychol, yt_arch, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, normSub, normMul);
                cmtsk.doAll(dinfo._adaptedFrame);
            }
        }

        private boolean isDone(GLRMModel model, int steps_in_row, double step) {
            if (GLRM.this.stop_requested()) {
                return true;
            }
            if (((GLRMModel.GLRMOutput)model._output)._iterations >= ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations) {
                return true;
            }
            if (((GLRMModel.GLRMOutput)model._output)._updates >= ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_updates) {
                return true;
            }
            if (step <= ((GLRMModel.GLRMParameters)GLRM.this._parms)._min_step_size) {
                return true;
            }
            return ((GLRMModel.GLRMOutput)model._output)._iterations >= ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations && steps_in_row > 3 && Math.abs(((GLRMModel.GLRMOutput)model._output)._avg_change_obj) < 1.0E-10;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram, int max_attempts) {
            double addedL2 = 0.0;
            Gram.Cholesky chol = gram.cholesky(null);
            for (int attempts = 0; !chol.isSPD() && attempts < max_attempts; ++attempts) {
                addedL2 = addedL2 == 0.0 ? 1.0E-5 : (addedL2 *= 10.0);
                gram.addDiag(addedL2);
                Log.info("Added L2 regularization = " + addedL2 + " to diagonal of Gram matrix");
                gram.cholesky(chol);
            }
            if (!chol.isSPD()) {
                throw new Gram.NonSPDMatrixException();
            }
            return chol;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram) {
            return this.regularizedCholesky(gram, 10);
        }

        public CholeskyDecomposition regularizedCholesky(double[][] gram, int max_attempts, boolean throw_exception) {
            int attempts = 0;
            double addedL2 = 0.0;
            Matrix gmat = new Matrix(gram);
            CholeskyDecomposition chol = new CholeskyDecomposition(gmat);
            while (!chol.isSPD() && attempts < max_attempts) {
                addedL2 = addedL2 == 0.0 ? 1.0E-5 : (addedL2 *= 10.0);
                ++attempts;
                for (int i2 = 0; i2 < gram.length; ++i2) {
                    gmat.set(i2, i2, addedL2);
                }
                Log.info("Added L2 regularization = " + addedL2 + " to diagonal of Gram matrix");
                chol = new CholeskyDecomposition(gmat);
            }
            if (!chol.isSPD() && throw_exception) {
                throw new Gram.NonSPDMatrixException();
            }
            return chol;
        }

        public void recoverSVD(GLRMModel model, DataInfo xinfo, DataInfo dinfo) {
            Gram.GramTask xgram = (Gram.GramTask)new Gram.GramTask(GLRM.this._job._key, xinfo).doAll(xinfo._adaptedFrame);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask(GLRM.this._job._key, dinfo).doAll(dinfo._adaptedFrame.subframe(0, GLRM.this._ncolA));
            Gram.Cholesky xxchol = this.regularizedCholesky(xgram._gram);
            long nobs = xgram._nobs;
            Matrix x_r = new Matrix(xxchol.getL()).transpose();
            x_r = x_r.times(Math.sqrt(nobs));
            Matrix yt = new Matrix(((GLRMModel.GLRMOutput)model._output)._archetypes_raw.getY(true));
            QRDecomposition yt_qr = new QRDecomposition(yt);
            Matrix yt_r = yt_qr.getR();
            Matrix rrmul = x_r.times(yt_r.transpose());
            SingularValueDecomposition rrsvd = new SingularValueDecomposition(rrmul);
            double[] sval = rrsvd.getSingularValues();
            double dfcorr = nobs > 1L ? (double)nobs / ((double)nobs - 1.0) : 1.0;
            double oneOverNobsm1 = nobs > 1L ? 1.0 / Math.sqrt(nobs - 1L) : 1.0;
            ((GLRMModel.GLRMOutput)model._output)._std_deviation = Arrays.copyOf(sval, sval.length);
            ArrayUtils.mult(((GLRMModel.GLRMOutput)model._output)._std_deviation, oneOverNobsm1);
            ((GLRMModel.GLRMOutput)model._output)._total_variance = dfcorr * dgram._gram.diagSum();
            double maxSumVal = ArrayUtils.l2norm2(((GLRMModel.GLRMOutput)model._output)._std_deviation);
            if (maxSumVal > ((GLRMModel.GLRMOutput)model._output)._total_variance) {
                double catScale = Math.sqrt(((GLRMModel.GLRMOutput)model._output)._total_variance / maxSumVal);
                ArrayUtils.mult(((GLRMModel.GLRMOutput)model._output)._std_deviation, catScale);
            }
            double[] vars = new double[((GLRMModel.GLRMOutput)model._output)._std_deviation.length];
            double[] prop_var = new double[vars.length];
            double[] cum_var = new double[vars.length];
            DimensionReductionUtils.generateIPC(((GLRMModel.GLRMOutput)model._output)._std_deviation, ((GLRMModel.GLRMOutput)model._output)._total_variance, vars, prop_var, cum_var);
            Object[] colTypes = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Object[] colFormats = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            String[] colHeaders = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            String[] pcHeaders = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            for (int i2 = 0; i2 < colHeaders.length; ++i2) {
                colHeaders[i2] = "Vec" + String.valueOf(i2 + 1);
                pcHeaders[i2] = "pc" + String.valueOf(i2 + 1);
            }
            ((GLRMModel.GLRMOutput)model._output)._importance = new TwoDimTable("Importance of components", null, new String[]{"Standard deviation", "Proportion of Variance", "Cumulative Proportion"}, pcHeaders, (String[])colTypes, (String[])colFormats, "", new String[3][], new double[][]{((GLRMModel.GLRMOutput)model._output)._std_deviation, prop_var, cum_var});
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._recover_svd) {
                Matrix eigvec = yt_qr.getQ().times(rrsvd.getV());
                ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw = eigvec.getArray();
                ((GLRMModel.GLRMOutput)model._output)._singular_vals = rrsvd.getSingularValues();
                assert (((GLRMModel.GLRMOutput)model._output)._names_expanded.length == ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw.length);
                ((GLRMModel.GLRMOutput)model._output)._eigenvectors = new TwoDimTable("Eigenvectors", null, ((GLRMModel.GLRMOutput)model._output)._names_expanded, colHeaders, (String[])colTypes, (String[])colFormats, "", new String[((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw.length][], ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeImpl() {
            ArrayList keep;
            Keyed xVecs;
            Lockable xwF2;
            Lockable xwF;
            Lockable frTA;
            Frame fr;
            Keyed tempinfo;
            Keyed tinfo;
            Keyed xinfo;
            Keyed dinfo;
            GLRMModel model;
            block64: {
                model = null;
                dinfo = null;
                xinfo = null;
                tinfo = null;
                tempinfo = null;
                fr = null;
                frTA = null;
                xwF = null;
                xwF2 = null;
                xVecs = null;
                int colCount = GLRM.this._ncolA;
                ObjCalc objtsk = null;
                ObjCalcW objtskw = null;
                Archetypes yt = null;
                Archetypes ytnew = null;
                try {
                    boolean regX;
                    int i2;
                    GLRM.this.init(true);
                    if (GLRM.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + GLRM.this.validationErrors());
                    }
                    model = new GLRMModel(GLRM.this.dest(), (GLRMModel.GLRMParameters)GLRM.this._parms, new GLRMModel.GLRMOutput(GLRM.this));
                    model.delete_and_lock(GLRM.this._job);
                    this._rebalancedTrain = new Frame(GLRM.this._train);
                    tinfo = new DataInfo(GLRM.this._train, GLRM.this._valid, 0, true, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put(((DataInfo)tinfo)._key, tinfo);
                    tempinfo = new DataInfo(GLRM.this._train, null, 0, true, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    this.correctForBinaryLoss((DataInfo)tinfo);
                    ((GLRMModel.GLRMOutput)model._output)._permutation = ((DataInfo)tinfo)._permutation;
                    ((GLRMModel.GLRMOutput)model._output)._nnums = ((DataInfo)tinfo)._nums;
                    ((GLRMModel.GLRMOutput)model._output)._ncats = ((DataInfo)tinfo)._cats;
                    ((GLRMModel.GLRMOutput)model._output)._catOffsets = ((DataInfo)tinfo)._catOffsets;
                    int[] numLevels = ((DataInfo)tinfo)._adaptedFrame.cardinality();
                    for (int colIndex = ((DataInfo)tinfo)._cats; colIndex < GLRM.this._train.numCols() && numLevels[colIndex] > -1; ++colIndex) {
                        numLevels[colIndex] = -1;
                    }
                    if (GLRM.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + GLRM.this.validationErrors());
                    }
                    ((GLRMModel.GLRMOutput)model._output)._catOffsets = ((DataInfo)tinfo)._catOffsets;
                    ((GLRMModel.GLRMOutput)model._output)._names_expanded = ((DataInfo)tinfo).coefNames();
                    double[] dArray = ((GLRMModel.GLRMOutput)model._output)._normSub = ((DataInfo)tinfo)._normSub == null ? new double[((DataInfo)tinfo)._nums] : ((DataInfo)tinfo)._normSub;
                    if (((DataInfo)tinfo)._normMul == null) {
                        ((GLRMModel.GLRMOutput)model._output)._normMul = new double[((DataInfo)tinfo)._nums];
                        Arrays.fill(((GLRMModel.GLRMOutput)model._output)._normMul, 1.0);
                    } else {
                        ((GLRMModel.GLRMOutput)model._output)._normMul = ((DataInfo)tinfo)._normMul;
                    }
                    assert (GLRM.this._lossFunc != null && GLRM.this._lossFunc.length == GLRM.this._train.numCols());
                    ((GLRMModel.GLRMOutput)model._output)._lossFunc = new GlrmLoss[GLRM.this._lossFunc.length];
                    for (int i3 = 0; i3 < GLRM.this._lossFunc.length; ++i3) {
                        ((GLRMModel.GLRMOutput)model._output)._lossFunc[i3] = GLRM.this._lossFunc[((DataInfo)tinfo)._permutation[i3]];
                    }
                    long nobs = GLRM.this._train.numRows() * (long)GLRM.this._train.numCols();
                    long na_cnt = 0L;
                    for (int i4 = 0; i4 < GLRM.this._train.numCols(); ++i4) {
                        na_cnt += GLRM.this._train.vec(i4).naCnt();
                    }
                    ((GLRMModel.GLRMOutput)model._output)._nobs = nobs - na_cnt;
                    fr = new Frame(GLRM.this._train);
                    Vec anyvec = fr.anyVec();
                    assert (anyvec != null);
                    for (i2 = 0; i2 < GLRM.this._ncolX; ++i2) {
                        fr.add("xcol_" + i2, anyvec.makeZero());
                    }
                    for (i2 = 0; i2 < GLRM.this._ncolX; ++i2) {
                        fr.add("wcol_" + i2, anyvec.makeZero());
                    }
                    dinfo = new DataInfo(fr, null, 0, true, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put(((DataInfo)dinfo)._key, dinfo);
                    fr = ((DataInfo)dinfo)._adaptedFrame;
                    int weightId = ((DataInfo)dinfo)._weights ? ((DataInfo)dinfo).weightChunkId() : -1;
                    GLRM.this._job.update(1L, "Initializing X and Y matrices");
                    double[][] yinit = this.initialXY((DataInfo)tinfo, ((DataInfo)dinfo)._adaptedFrame, model, na_cnt);
                    ytnew = yt = new Archetypes(ArrayUtils.transpose(yinit), true, ((DataInfo)tinfo)._catOffsets, numLevels);
                    double yreg = ((GLRMModel.GLRMParameters)GLRM.this._parms)._regularization_y.regularize(yt._archetypes);
                    if ((((GLRMModel.GLRMParameters)GLRM.this._parms)._init != GlrmInitialization.User || ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x == null) && GLRM.this.hasClosedForm(na_cnt)) {
                        this.initialXClosedForm((DataInfo)dinfo, yt, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul);
                    }
                    if (GLRM.this._wideDataset) {
                        colCount = (int)GLRM.this._train.numRows();
                        frTA = this.generateFrameOfZeros(GLRM.this._ncolA, colCount);
                        new ArrayUtils();
                        xwF = ArrayUtils.frame(ArrayUtils.transpose(yinit));
                        new ArrayUtils();
                        xwF2 = ArrayUtils.frame(ArrayUtils.transpose(yinit));
                        ((Frame)xwF).add((Frame)xwF2);
                        new DMatrix.TransposeTsk((Frame)frTA).doAll(((DataInfo)dinfo)._adaptedFrame.subframe(0, GLRM.this._ncolA));
                        yinit = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][colCount];
                        for (int index = colCount; index < colCount + GLRM.this._ncolX; ++index) {
                            int trueIndex = index - colCount;
                            yinit[trueIndex] = ((FrameUtils.Vec2ArryTsk)new FrameUtils.Vec2ArryTsk((int)colCount).doAll((Vec[])new Vec[]{((DataInfo)dinfo)._adaptedFrame.vec((int)(trueIndex + ((GLRM)GLRM.this)._ncolA))})).res;
                        }
                        double[] tempWeights = new double[(int)GLRM.this._train.numRows()];
                        if (weightId < 0) {
                            Arrays.fill(tempWeights, 1.0);
                        } else {
                            tempWeights = ((FrameUtils.Vec2ArryTsk)new FrameUtils.Vec2ArryTsk((int)weightId).doAll((Vec[])new Vec[]{((DataInfo)dinfo)._adaptedFrame.vec((int)weightId)})).res;
                        }
                        ytnew = yt = new Archetypes(ArrayUtils.transpose(yinit), true, ((DataInfo)tinfo)._catOffsets, numLevels, tempWeights);
                        GLRM.this.setTrain(GLRM.this.rebalance((Frame)xwF, false, GLRM.this._result + ".temporary.xwF"));
                    }
                    GLRM.this._job.update(1L, "Computing initial objective function");
                    boolean bl = regX = ((GLRMModel.GLRMParameters)GLRM.this._parms)._regularization_x != GlrmRegularizer.None && ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x != 0.0;
                    if (GLRM.this._wideDataset) {
                        objtskw = new ObjCalcW((GLRMModel.GLRMParameters)GLRM.this._parms, yt, colCount, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, regX, (Frame)xwF, 0);
                        objtskw.doAll((Frame)frTA);
                        ((GLRMModel.GLRMOutput)model._output)._objective = objtskw._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * ObjCalcW._xold_reg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                    } else {
                        objtsk = new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, yt, GLRM.this._ncolA, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId, regX);
                        objtsk.doAll(fr);
                        ((GLRMModel.GLRMOutput)model._output)._objective = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * objtsk._xold_reg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                    }
                    ((GLRMModel.GLRMOutput)model._output)._archetypes_raw = yt;
                    ((GLRMModel.GLRMOutput)model._output)._iterations = 0;
                    ((GLRMModel.GLRMOutput)model._output)._updates = 0;
                    ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = 2.0E-10;
                    ((GLRMModel.GLRMOutput)model._output)._step_size = 0.0;
                    model.update(GLRM.this._job);
                    double step = ((GLRMModel.GLRMParameters)GLRM.this._parms)._init_step_size;
                    int steps_in_row = 0;
                    while (!this.isDone(model, steps_in_row, step)) {
                        GLRM.this._job.update(1L, "Iteration " + String.valueOf(((GLRMModel.GLRMOutput)model._output)._iterations + 1) + " of alternating minimization");
                        UpdateX xtsk = null;
                        UpdateYeX yextsk = null;
                        double alpha = step / (double)GLRM.this._ncolA;
                        if (GLRM.this._wideDataset) {
                            yextsk = new UpdateYeX((GLRMModel.GLRMParameters)GLRM.this._parms, yt, alpha, GLRM.this._ncolA, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, (Frame)xwF);
                            double[][] yttmp = ((UpdateYeX)yextsk.doAll((Frame)frTA))._ytnew;
                            ytnew = new Archetypes(yttmp, true, ((DataInfo)tinfo)._catOffsets, numLevels, ytnew._weights);
                        } else {
                            xtsk = new UpdateX((GLRMModel.GLRMParameters)GLRM.this._parms, yt, alpha, GLRM.this._ncolA, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                            xtsk.doAll(((DataInfo)dinfo)._adaptedFrame);
                        }
                        ++((GLRMModel.GLRMOutput)model._output)._updates;
                        if (((GLRMModel.GLRMOutput)model._output)._updates < ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_updates) {
                            if (GLRM.this._wideDataset) {
                                UpdateXeY xeytsk = new UpdateXeY((GLRMModel.GLRMParameters)GLRM.this._parms, ytnew, alpha, colCount, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, (Frame)frTA);
                                xeytsk.doAll((Frame)xwF);
                                yreg = xeytsk._yreg;
                            } else {
                                UpdateY ytsk = new UpdateY((GLRMModel.GLRMParameters)GLRM.this._parms, yt, alpha, GLRM.this._ncolA, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                                double[][] yttmp = ((UpdateY)ytsk.doAll((Frame)((DataInfo)dinfo)._adaptedFrame))._ytnew;
                                ytnew = new Archetypes(yttmp, true, ((DataInfo)tinfo)._catOffsets, numLevels);
                                yreg = ytsk._yreg;
                            }
                            ++((GLRMModel.GLRMOutput)model._output)._updates;
                        }
                        double obj_new = 0.0;
                        if (GLRM.this._wideDataset) {
                            objtskw = new ObjCalcW((GLRMModel.GLRMParameters)GLRM.this._parms, ytnew, colCount, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, regX, (Frame)xwF, ((GLRMModel.GLRMParameters)GLRM.this._parms)._k);
                            objtskw.doAll((Frame)frTA);
                            obj_new = objtskw._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * yextsk._xreg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                        } else {
                            objtsk = new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, ytnew, GLRM.this._ncolA, GLRM.this._ncolX, ((DataInfo)tinfo)._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                            objtsk.doAll(((DataInfo)dinfo)._adaptedFrame);
                            obj_new = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * xtsk._xreg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                        }
                        ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = (((GLRMModel.GLRMOutput)model._output)._objective - obj_new) / (double)nobs;
                        ++((GLRMModel.GLRMOutput)model._output)._iterations;
                        if (((GLRMModel.GLRMOutput)model._output)._avg_change_obj > 0.0) {
                            yt = ytnew;
                            ((GLRMModel.GLRMOutput)model._output)._archetypes_raw = ytnew;
                            ((GLRMModel.GLRMOutput)model._output)._objective = obj_new;
                            step *= 1.05;
                            steps_in_row = Math.max(1, steps_in_row + 1);
                            if (GLRM.this._wideDataset) {
                                new updateXVecs(0, GLRM.this._ncolX).doAll((Frame)xwF);
                            } else {
                                new updateXVecs(GLRM.this._ncolA, GLRM.this._ncolX).doAll(((DataInfo)dinfo)._adaptedFrame);
                            }
                        } else {
                            step /= Math.max(1.5, (double)(-steps_in_row));
                            steps_in_row = Math.min(0, steps_in_row - 1);
                            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._verbose) {
                                Log.info("Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective increased to " + obj_new + "; reducing step size to " + step);
                                GLRM.this._job.update(0L, "Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective increased to " + obj_new + "; reducing step size to " + step);
                            }
                        }
                        ((GLRMModel.GLRMOutput)model._output)._training_time_ms.add(System.currentTimeMillis());
                        ((GLRMModel.GLRMOutput)model._output)._history_step_size.add(step);
                        ((GLRMModel.GLRMOutput)model._output)._history_objective.add(((GLRMModel.GLRMOutput)model._output)._objective);
                        model.update(GLRM.this._job);
                    }
                    ((GLRMModel.GLRMOutput)model._output)._representation_name = StringUtils.isNullOrEmpty(((GLRMModel.GLRMParameters)GLRM.this._parms)._representation_name) ? "GLRMLoading_" + Key.rand() : ((GLRMModel.GLRMParameters)GLRM.this._parms)._representation_name;
                    ((GLRMModel.GLRMOutput)model._output)._representation_key = Key.make(((GLRMModel.GLRMOutput)model._output)._representation_name);
                    ((GLRMModel.GLRMOutput)model._output)._x_factor_key = ((GLRMModel.GLRMOutput)model._output)._representation_key;
                    String[] xnames = new String[GLRM.this._ncolX];
                    for (int i5 = 0; i5 < GLRM.this._ncolX; ++i5) {
                        xnames[i5] = "Arch" + String.valueOf(i5 + 1);
                    }
                    Frame x2 = null;
                    if (GLRM.this._wideDataset) {
                        new ArrayUtils();
                        x2 = ArrayUtils.frame(((GLRMModel.GLRMOutput)model._output)._representation_key, xnames, yt._transposed ? yt._archetypes : ArrayUtils.transpose(yt._archetypes));
                        yt._archetypes = ((FrameUtils.Vecs2ArryTsk)new FrameUtils.Vecs2ArryTsk((int)((GLRM)GLRM.this)._ncolY, (int)((GLRMModel.GLRMParameters)GLRM.this._parms)._k).doAll((Frame)xwF)).res;
                        ((GLRMModel.GLRMOutput)model._output)._archetypes_raw = new Archetypes(yt._archetypes, yt._transposed, ((DataInfo)tinfo)._catOffsets, numLevels);
                    } else {
                        Vec[] xvecs = new Vec[GLRM.this._ncolX];
                        for (int i6 = 0; i6 < GLRM.this._ncolX; ++i6) {
                            xvecs[i6] = fr.vec(GLRM.idx_xold(i6, GLRM.this._ncolA));
                        }
                        x2 = new Frame(((GLRMModel.GLRMOutput)model._output)._representation_key, xnames, xvecs);
                    }
                    xinfo = new DataInfo(x2, null, 0, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put(x2);
                    DKV.put(xinfo);
                    ((GLRMModel.GLRMOutput)model._output)._step_size = step;
                    ((GLRMModel.GLRMOutput)model._output)._history_step_size.add(step);
                    ((GLRMModel.GLRMOutput)model._output)._archetypes = yt.buildTable(((GLRMModel.GLRMOutput)model._output)._names_expanded, false);
                    this.recoverSVD(model, (DataInfo)xinfo, (DataInfo)tempinfo);
                    ((GLRMModel.GLRMOutput)model._output)._training_metrics = model.scoreMetricsOnly(((GLRMModel.GLRMParameters)GLRM.this._parms).train());
                    ((GLRMModel.GLRMOutput)model._output)._validation_metrics = model.scoreMetricsOnly(((GLRMModel.GLRMParameters)GLRM.this._parms).valid());
                    ((GLRMModel.GLRMOutput)model._output)._model_summary = this.createModelSummaryTable((GLRMModel.GLRMOutput)model._output);
                    ((GLRMModel.GLRMOutput)model._output)._scoring_history = this.createScoringHistoryTable((GLRMModel.GLRMOutput)model._output);
                    model.update(GLRM.this._job);
                    keep = new ArrayList();
                    if (((GLRMModel.GLRMOutput)model._output)._iterations != 0) break block64;
                }
                catch (Throwable throwable) {
                    ArrayList keep2 = new ArrayList();
                    if (((GLRMModel.GLRMOutput)model._output)._iterations == 0) {
                        GLRM.this.warn("_max_runtime_secs", "model may not be properly built due to timeout.  Set max_runtime_secs to 0 or increase its value.");
                    }
                    if (model != null) {
                        Frame loadingFrm = (Frame)DKV.getGet(((GLRMModel.GLRMOutput)model._output)._representation_key);
                        if (loadingFrm != null) {
                            for (Vec vec : loadingFrm.vecs()) {
                                keep2.add(vec._key);
                            }
                        }
                        model.unlock(GLRM.this._job);
                    }
                    if (tinfo != null) {
                        tinfo.remove();
                    }
                    if (dinfo != null) {
                        dinfo.remove();
                    }
                    if (xinfo != null) {
                        xinfo.remove();
                    }
                    if (tempinfo != null) {
                        tempinfo.remove();
                    }
                    if (xwF != null) {
                        xwF.delete();
                    }
                    if (xwF2 != null) {
                        xwF2.delete();
                    }
                    if (xVecs != null) {
                        xVecs.remove();
                    }
                    if (frTA != null) {
                        frTA.delete();
                    }
                    if (fr != null && !GLRM.this._wideDataset) {
                        for (int i7 = 0; i7 < GLRM.this._ncolX; ++i7) {
                            fr.vec(GLRM.idx_xnew(i7, GLRM.this._ncolA, GLRM.this._ncolX)).remove();
                        }
                    }
                    Scope.untrack(keep2);
                    throw throwable;
                }
                GLRM.this.warn("_max_runtime_secs", "model may not be properly built due to timeout.  Set max_runtime_secs to 0 or increase its value.");
            }
            if (model != null) {
                Frame loadingFrm = (Frame)DKV.getGet(((GLRMModel.GLRMOutput)model._output)._representation_key);
                if (loadingFrm != null) {
                    for (Vec vec : loadingFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
                model.unlock(GLRM.this._job);
            }
            if (tinfo != null) {
                tinfo.remove();
            }
            if (dinfo != null) {
                dinfo.remove();
            }
            if (xinfo != null) {
                xinfo.remove();
            }
            if (tempinfo != null) {
                tempinfo.remove();
            }
            if (xwF != null) {
                xwF.delete();
            }
            if (xwF2 != null) {
                xwF2.delete();
            }
            if (xVecs != null) {
                xVecs.remove();
            }
            if (frTA != null) {
                frTA.delete();
            }
            if (fr != null && !GLRM.this._wideDataset) {
                for (int i8 = 0; i8 < GLRM.this._ncolX; ++i8) {
                    fr.vec(GLRM.idx_xnew(i8, GLRM.this._ncolA, GLRM.this._ncolX)).remove();
                }
            }
            Scope.untrack(keep);
        }

        private Frame generateFrameOfZeros(int rowCount, int colCount) {
            Vec tempVec = Vec.makeZero(rowCount);
            return new Frame(tempVec.makeZeros(colCount));
        }

        private void correctForBinaryLoss(DataInfo tinfo) {
            for (int index = 0; index < tinfo._nums; ++index) {
                if (!GLRM.this._lossFunc[tinfo._permutation[index + tinfo._cats]].isForBinary()) continue;
                if (tinfo._normMul != null) {
                    tinfo._normMul[index] = 1.0;
                }
                if (tinfo._normSub == null) continue;
                tinfo._normSub[index] = 0.0;
            }
            if (GLRM.this._binaryColumnIndices != null && GLRM.this._binaryColumnIndices.size() > 0) {
                int colIndex;
                int binaryLossCols = GLRM.this._binaryColumnIndices.size();
                int numCatColumns = tinfo._cats;
                int numNumColumns = tinfo._nums;
                tinfo._cats -= binaryLossCols;
                tinfo._nums += binaryLossCols;
                int[] catOffsetsTemp = new int[tinfo._cats + 1];
                boolean[] catMissingTemp = new boolean[tinfo._cats];
                int[] catNAFillTemp = new int[tinfo._cats];
                int[] permutationTemp = new int[tinfo._permutation.length];
                int[] numOffsetsTemp = new int[tinfo._nums];
                int[] cardinalities = GLRM.this._train.cardinality();
                int[] currentCardinality = new int[tinfo._cats];
                double[] normMulTemp = new double[tinfo._nums];
                double[] normSubTemp = new double[tinfo._nums];
                double[] numMeansTemp = new double[tinfo._nums];
                int newColIndex = 0;
                for (colIndex = 0; colIndex < numCatColumns; ++colIndex) {
                    if (GLRM.this._binaryColumnIndices.contains(tinfo._permutation[colIndex])) continue;
                    permutationTemp[newColIndex] = tinfo._permutation[colIndex];
                    catMissingTemp[newColIndex] = tinfo._catMissing[colIndex];
                    catNAFillTemp[newColIndex] = tinfo.catNAFill(colIndex);
                    currentCardinality[newColIndex] = cardinalities[colIndex];
                    catOffsetsTemp[newColIndex + 1] = catOffsetsTemp[newColIndex] + currentCardinality[newColIndex];
                    ++newColIndex;
                }
                numOffsetsTemp[0] = catOffsetsTemp[newColIndex];
                for (colIndex = 0; colIndex < binaryLossCols; ++colIndex) {
                    permutationTemp[colIndex + newColIndex] = (Integer)GLRM.this._binaryColumnIndices.get(colIndex);
                    normMulTemp[colIndex] = 1.0;
                    normSubTemp[colIndex] = 0.0;
                    numMeansTemp[colIndex] = 0.0;
                    if (colIndex <= 0) continue;
                    numOffsetsTemp[colIndex] = numOffsetsTemp[colIndex - 1] + 1;
                }
                for (colIndex = 0; colIndex < numNumColumns; ++colIndex) {
                    int newColumnIndex = colIndex + binaryLossCols;
                    if (tinfo._normSub != null) {
                        normMulTemp[newColumnIndex] = tinfo._normMul[colIndex];
                    }
                    if (tinfo._normSub != null) {
                        normSubTemp[newColumnIndex] = tinfo._normSub[colIndex];
                    }
                    if (tinfo._numMeans != null) {
                        numMeansTemp[newColumnIndex] = tinfo._numMeans[colIndex];
                    }
                    numOffsetsTemp[newColumnIndex] = numOffsetsTemp[newColumnIndex - 1] + 1;
                    int numColIndex = newColumnIndex + tinfo._cats;
                    permutationTemp[numColIndex] = tinfo._permutation[numColIndex];
                }
                tinfo._catOffsets = Arrays.copyOf(catOffsetsTemp, catOffsetsTemp.length);
                tinfo._catMissing = Arrays.copyOf(catMissingTemp, tinfo._cats);
                tinfo.setCatNAFill(Arrays.copyOf(catNAFillTemp, tinfo._cats));
                tinfo._permutation = Arrays.copyOf(permutationTemp, tinfo._permutation.length);
                tinfo._numOffsets = Arrays.copyOf(numOffsetsTemp, tinfo._nums);
                if (tinfo._normMul != null) {
                    tinfo._normMul = Arrays.copyOf(normMulTemp, tinfo._nums);
                }
                if (tinfo._normSub != null) {
                    tinfo._normSub = Arrays.copyOf(normSubTemp, tinfo._nums);
                }
                if (tinfo._numMeans != null) {
                    tinfo._numMeans = Arrays.copyOf(numMeansTemp, tinfo._nums);
                    tinfo._numNAFill = tinfo._numMeans;
                }
                GLRM.this._ncolY = GLRM.this._ncolY - binaryLossCols;
            }
        }

        private TwoDimTable createModelSummaryTable(GLRMModel.GLRMOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Number of Iterations");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Final Step Size");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Final Objective Value");
            colTypes.add("double");
            colFormat.add("%.5f");
            TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            int row = 0;
            int col = 0;
            table.set(row, col++, output._iterations);
            table.set(row, col++, output._history_step_size.get(output._history_step_size.size() - 1));
            table.set(row, col, output._objective);
            return table;
        }

        private TwoDimTable createScoringHistoryTable(GLRMModel.GLRMOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Timestamp");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Duration");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Iterations");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Step Size");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Objective");
            colTypes.add("double");
            colFormat.add("%.5f");
            int rows = output._training_time_ms.size();
            TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            for (int row = 0; row < rows; ++row) {
                int col = 0;
                assert (row < table.getRowDim());
                assert (col < table.getColDim());
                DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
                table.set(row, col++, fmt.print(output._training_time_ms.get(row)));
                table.set(row, col++, PrettyPrint.msecs(output._training_time_ms.get(row) - GLRM.this._job.start_time(), true));
                table.set(row, col++, row);
                table.set(row, col++, output._history_step_size.get(row));
                table.set(row, col, output._history_objective.get(row));
            }
            return table;
        }
    }
}

