/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.FrameTask2;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMUtils;
import hex.gram.Gram;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.MathUtils;

public abstract class GLMTask {
    static final double EPS = 1.0E-10;
    static final double ZEROEQUAL = 1.0E-8;
    static final double ONEEQUAL = 0.99999999;

    static double computeMultinomialEtas(double[] etas, double[] exps) {
        double maxRow = ArrayUtils.maxValue(etas);
        double sumExp = 0.0;
        int K2 = etas.length;
        for (int c2 = 0; c2 < K2; ++c2) {
            double x2 = Math.exp(etas[c2] - maxRow);
            sumExp += x2;
            exps[c2 + 1] = x2;
        }
        double reg = 1.0 / sumExp;
        for (int c3 = 0; c3 < etas.length; ++c3) {
            int n2 = c3 + 1;
            exps[n2] = exps[n2] * reg;
        }
        exps[0] = 0.0;
        exps[0] = ArrayUtils.maxIndex(exps) - 1;
        return Math.log(sumExp) + maxRow;
    }

    static double sumOper(double y2, double multiplier, int opVal) {
        double summation = 0.0;
        int val = 0;
        while ((double)val < y2) {
            double temp;
            double d2 = temp = opVal == 0 ? Math.log(((double)val + multiplier) / (double)(val + 1)) : 1.0 / ((double)val * multiplier * multiplier + multiplier);
            summation += opVal == 0 ? temp : (opVal == 1 ? temp : (opVal == 2 ? temp * temp * ((double)(2 * val) * multiplier + 1.0) : Math.log(multiplier + (double)val)));
            ++val;
        }
        return summation;
    }

    static class GLMIncrementalGramTask
    extends MRTask<GLMIncrementalGramTask> {
        final int[] _newCols;
        final DataInfo _dinfo;
        double[][] _gram;
        double[] _xy;
        final double[] _beta;
        final GLMModel.GLMWeightsFun _glmf;

        public GLMIncrementalGramTask(int[] newCols, DataInfo dinfo, GLMModel.GLMWeightsFun glmf, double[] beta) {
            this._newCols = newCols;
            this._glmf = glmf;
            this._dinfo = dinfo;
            this._beta = beta;
        }

        @Override
        public void map(Chunk[] chks) {
            GLMModel.GLMWeights glmw = new GLMModel.GLMWeights();
            double[] wsum = new double[this._dinfo.fullN() + 1];
            double ywsum = 0.0;
            DataInfo.Rows rows = this._dinfo.rows(chks);
            double[][] gram = new double[this._newCols.length][this._dinfo.fullN() + 1];
            double[] xy = new double[this._newCols.length];
            int ns = this._dinfo.numStart();
            double sparseOffset = rows._sparse ? GLM.sparseOffset(this._beta, this._dinfo) : 0.0;
            block0: for (int rid = 0; rid < rows._nrows; ++rid) {
                int i2;
                int j2 = 0;
                DataInfo.Row r2 = rows.row(rid);
                if (r2.weight == 0.0) continue;
                if (this._beta != null) {
                    this._glmf.computeWeights(r2.response(0), r2.innerProduct(this._beta) + sparseOffset, r2.offset, r2.weight, glmw);
                } else {
                    glmw.w = r2.weight;
                    glmw.z = r2.response(0);
                }
                r2.addToArray(glmw.w, wsum);
                ywsum += glmw.z * glmw.w;
                for (i2 = 0; i2 < r2.nBins; ++i2) {
                    while (j2 < this._newCols.length && this._newCols[j2] < r2.binIds[i2]) {
                        ++j2;
                    }
                    if (j2 == this._newCols.length || this._newCols[j2] >= ns) break;
                    if (r2.binIds[i2] != this._newCols[j2]) continue;
                    r2.addToArray(glmw.w, gram[j2]);
                    int n2 = j2++;
                    xy[n2] = xy[n2] + glmw.w * glmw.z;
                }
                while (j2 < this._newCols.length && this._newCols[j2] < ns) {
                    ++j2;
                }
                if (r2.numIds != null) {
                    for (i2 = 0; i2 < r2.nNums; ++i2) {
                        while (j2 < this._newCols.length && this._newCols[j2] < r2.numIds[i2]) {
                            ++j2;
                        }
                        if (j2 == this._newCols.length) continue block0;
                        if (r2.numIds[i2] != this._newCols[j2]) continue;
                        double wx = glmw.w * r2.numVals[i2];
                        r2.addToArray(wx, gram[j2]);
                        int n3 = j2++;
                        xy[n3] = xy[n3] + wx * glmw.z;
                    }
                    continue;
                }
                while (j2 < this._newCols.length) {
                    int id = this._newCols[j2];
                    double x2 = r2.numVals[id - this._dinfo.numStart()];
                    if (x2 != 0.0) {
                        double wx = glmw.w * x2;
                        r2.addToArray(wx, gram[j2]);
                        int n4 = j2;
                        xy[n4] = xy[n4] + wx * glmw.z;
                    }
                    ++j2;
                }
                assert (j2 == this._newCols.length);
            }
            if (rows._sparse && this._dinfo._normSub != null) {
                int k2;
                int numstart = Arrays.binarySearch(this._newCols, ns);
                if (numstart < 0) {
                    numstart = -numstart - 1;
                }
                for (k2 = 0; k2 < numstart; ++k2) {
                    int i3 = this._newCols[k2];
                    double[] row = gram[k2];
                    for (int j3 = ns; j3 < row.length - 1; ++j3) {
                        double mean_j = this._dinfo.normSub(j3 - ns);
                        double scale_j = this._dinfo.normMul(j3 - ns);
                        gram[k2][j3] = gram[k2][j3] - mean_j * scale_j * wsum[i3];
                    }
                }
                k2 = numstart;
                while (k2 < gram.length) {
                    int j4;
                    int i4 = this._newCols[k2];
                    double mean_i = this._dinfo.normSub(i4 - ns);
                    double scale_i = this._dinfo.normMul(i4 - ns);
                    for (j4 = 0; j4 < this._dinfo.numStart(); ++j4) {
                        double[] dArray = gram[k2];
                        int n5 = j4;
                        dArray[n5] = dArray[n5] - mean_i * scale_i * wsum[j4];
                    }
                    for (j4 = ns; j4 < gram[k2].length - 1; ++j4) {
                        double mean_j = this._dinfo.normSub(j4 - ns);
                        double scale_j = this._dinfo.normMul(j4 - ns);
                        gram[k2][j4] = gram[k2][j4] - mean_j * scale_j * wsum[i4] - mean_i * scale_i * wsum[j4] + mean_i * mean_j * scale_i * scale_j * wsum[wsum.length - 1];
                    }
                    double[] dArray = gram[k2];
                    int n6 = gram[k2].length - 1;
                    dArray[n6] = dArray[n6] - mean_i * scale_i * wsum[gram[k2].length - 1];
                    int n7 = k2++;
                    xy[n7] = xy[n7] - ywsum * mean_i * scale_i;
                }
            }
            this._gram = gram;
            this._xy = xy;
        }

        @Override
        public void reduce(GLMIncrementalGramTask gt) {
            ArrayUtils.add(this._xy, gt._xy);
            for (int i2 = 0; i2 < this._gram.length; ++i2) {
                ArrayUtils.add(this._gram[i2], gt._gram[i2]);
            }
        }
    }

    public static class ComputeSETsk
    extends FrameTask2<ComputeSETsk> {
        final double[] _betaNew;
        double _sumsqe;
        double _wsum;
        transient double _sparseOffsetOld = 0.0;
        transient double _sparseOffsetNew = 0.0;
        final GLMModel.GLMWeightsFun _glmf;
        transient GLMModel.GLMWeights _glmw;

        public ComputeSETsk(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] betaNew, GLMModel.GLMParameters parms) {
            super(cmp, dinfo, jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._betaNew = betaNew;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffsetNew = GLM.sparseOffset(this._betaNew, this._dinfo);
            }
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            double z2 = r2.response(0) - r2.offset;
            double w2 = r2.weight;
            if (this._glmf._family != GLMModel.GLMParameters.Family.gaussian) {
                double etaOld = r2.innerProduct(this._betaNew) + this._sparseOffsetNew;
                this._glmf.computeWeights(r2.response(0), etaOld, r2.offset, r2.weight, this._glmw);
                z2 = this._glmw.z;
                w2 = this._glmw.w;
            }
            double eta = this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie) ? r2.innerProduct(this._betaNew) + this._sparseOffsetNew + r2.offset : r2.innerProduct(this._betaNew) + this._sparseOffsetNew;
            double xmu = this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie) ? this._glmf.linkInv(eta) : 0.0;
            this._sumsqe += this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie) ? (r2.response(0) - xmu) * (r2.response(0) - xmu) * r2.weight / Math.pow(xmu, this._glmf._var_power) : w2 * (eta - z2) * (eta - z2);
            this._wsum += Math.sqrt(w2);
        }

        @Override
        public void reduce(ComputeSETsk c2) {
            this._sumsqe += c2._sumsqe;
            this._wsum += c2._wsum;
        }
    }

    public static class GLMGenerateWeightsTask
    extends MRTask<GLMGenerateWeightsTask> {
        final GLMModel.GLMParameters _params;
        final double[] _betaw;
        double[] denums;
        double wsum;
        double wsumu;
        DataInfo _dinfo;
        double _likelihood;

        public GLMGenerateWeightsTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters glm, double[] betaw) {
            this._params = glm;
            this._betaw = betaw;
            this._dinfo = dinfo;
        }

        @Override
        public void map(Chunk[] chunks) {
            Chunk wChunk = chunks[chunks.length - 3];
            Chunk zChunk = chunks[chunks.length - 2];
            Chunk zTilda = chunks[chunks.length - 1];
            chunks = Arrays.copyOf(chunks, chunks.length - 3);
            this.denums = new double[this._dinfo.fullN() + 1];
            DataInfo.Row r2 = this._dinfo.newDenseRow();
            for (int i2 = 0; i2 < chunks[0]._len; ++i2) {
                int j2;
                double mu;
                double z2;
                double w2;
                this._dinfo.extractDenseRow(chunks, i2, r2);
                if (r2.isBad() || r2.weight == 0.0) {
                    wChunk.set(i2, 0L);
                    zChunk.set(i2, 0L);
                    zTilda.set(i2, 0L);
                    continue;
                }
                double y2 = r2.response(0);
                assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y2 > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
                assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y2 && y2 <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y2;
                int numStart = this._dinfo.numStart();
                double d2 = 1.0;
                double eta = r2.innerProduct(this._betaw);
                if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                    w2 = r2.weight;
                    z2 = y2 - r2.offset;
                    mu = 0.0;
                } else {
                    mu = this._params.linkInv(eta + r2.offset);
                    double var = Math.max(1.0E-6, this._params.variance(mu));
                    d2 = this._params.linkDeriv(mu);
                    z2 = eta + (y2 - mu) * d2;
                    w2 = r2.weight / (var * d2 * d2);
                }
                this._likelihood += this._params.likelihood(y2, mu);
                zTilda.set(i2, eta - this._betaw[this._betaw.length - 1]);
                assert (w2 >= 0.0 || Double.isNaN(w2)) : "invalid weight " + w2;
                wChunk.set(i2, w2);
                zChunk.set(i2, z2);
                this.wsum += w2;
                this.wsumu += r2.weight;
                for (j2 = 0; j2 < r2.nBins; ++j2) {
                    int n2 = r2.binIds[j2];
                    this.denums[n2] = this.denums[n2] + w2;
                }
                for (j2 = 0; j2 < r2.nNums; ++j2) {
                    int id;
                    int n3 = id = r2.numIds == null ? j2 + numStart : r2.numIds[j2];
                    this.denums[n3] = this.denums[n3] + w2 * r2.get(id) * r2.get(id);
                }
            }
        }

        @Override
        public void reduce(GLMGenerateWeightsTask git) {
            ArrayUtils.add(this.denums, git.denums);
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            super.reduce(git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqIntercept
    extends MRTask<GLMCoordinateDescentTaskSeqIntercept> {
        final double[] _betaold;
        public double _temp;
        DataInfo _dinfo;

        public GLMCoordinateDescentTaskSeqIntercept(double[] betaold, DataInfo dinfo) {
            this._betaold = betaold;
            this._dinfo = dinfo;
        }

        @Override
        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            DataInfo.Row r2 = this._dinfo.newDenseRow();
            for (int i2 = 0; i2 < chunks[0]._len; ++i2) {
                if (filterChunk.atd(i2) == 1.0) continue;
                this._dinfo.extractDenseRow(chunks, i2, r2);
                this._temp = (double)wChunk.at8(i2) * (zChunk.atd(i2) - r2.innerProduct(this._betaold));
            }
        }

        @Override
        public void reduce(GLMCoordinateDescentTaskSeqIntercept git) {
            this._temp += git._temp;
            super.reduce(git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqNaive
    extends MRTask<GLMCoordinateDescentTaskSeqNaive> {
        public double[] _normMulold;
        public double[] _normSubold;
        public double[] _normMulnew;
        public double[] _normSubnew;
        final double[] _betaold;
        final double[] _betanew;
        final int[] _catLvls_new;
        final int[] _catLvls_old;
        public double[] _temp;
        boolean _skipFirst;
        long _nobs;
        int _cat_num;
        boolean _interceptnew;
        boolean _interceptold;

        public GLMCoordinateDescentTaskSeqNaive(boolean interceptold, boolean interceptnew, int cat_num, double[] betaold, double[] betanew, int[] catLvlsold, int[] catLvlsnew, double[] normMulold, double[] normSubold, double[] normMulnew, double[] normSubnew, boolean skipFirst) {
            this._normMulold = normMulold;
            this._normSubold = normSubold;
            this._normMulnew = normMulnew;
            this._normSubnew = normSubnew;
            this._cat_num = cat_num;
            this._betaold = betaold;
            this._betanew = betanew;
            this._interceptold = interceptold;
            this._interceptnew = interceptnew;
            this._catLvls_old = catLvlsold;
            this._catLvls_new = catLvlsnew;
            this._skipFirst = skipFirst;
        }

        @Override
        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk ztildaChunk = chunks[cnt++];
            Chunk xpChunk = null;
            Chunk xChunk = null;
            this._temp = new double[this._betaold.length];
            if (this._interceptnew) {
                xChunk = new C0DChunk(1.0, chunks[0]._len);
                xpChunk = chunks[cnt++];
            } else if (this._interceptold) {
                xChunk = chunks[cnt++];
                xpChunk = new C0DChunk(1.0, chunks[0]._len);
            } else {
                xChunk = chunks[cnt++];
                xpChunk = chunks[cnt++];
            }
            for (int i2 = 0; i2 < chunks[0]._len; ++i2) {
                double betanew = 0.0;
                double betaold = 0.0;
                double w2 = wChunk.atd(i2);
                if (w2 == 0.0) continue;
                ++this._nobs;
                int observation_level = 0;
                int observation_level_p = 0;
                double val = 1.0;
                double valp = 1.0;
                if (this._cat_num == 1) {
                    observation_level = (int)xChunk.at8(i2);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    observation_level_p = (int)xpChunk.at8(i2);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                        --observation_level_p;
                    }
                } else if (this._cat_num == 2) {
                    val = xChunk.atd(i2);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    observation_level_p = (int)xpChunk.at8(i2);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level_p;
                    }
                } else if (this._cat_num == 3) {
                    val = xChunk.atd(i2);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    valp = xpChunk.atd(i2);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                } else if (this._cat_num == 4) {
                    observation_level = (int)xChunk.at8(i2);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                    }
                    valp = xpChunk.atd(i2);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                }
                if (observation_level >= 0) {
                    betaold = this._betaold[observation_level];
                }
                if (observation_level_p >= 0) {
                    betanew = this._betanew[observation_level_p];
                }
                if (this._interceptnew) {
                    ztildaChunk.set(i2, ztildaChunk.atd(i2) - betaold + valp * betanew);
                    this._temp[0] = this._temp[0] + w2 * (zChunk.atd(i2) - ztildaChunk.atd(i2));
                    continue;
                }
                ztildaChunk.set(i2, ztildaChunk.atd(i2) - val * betaold + valp * betanew);
                if (observation_level < 0) continue;
                int n2 = observation_level;
                this._temp[n2] = this._temp[n2] + w2 * val * (zChunk.atd(i2) - ztildaChunk.atd(i2));
            }
        }

        @Override
        public void reduce(GLMCoordinateDescentTaskSeqNaive git) {
            ArrayUtils.add(this._temp, git._temp);
            this._nobs += git._nobs;
            super.reduce(git);
        }
    }

    public static class DataAddW2AugXZ
    extends MRTask<DataAddW2AugXZ> {
        public DataInfo _dinfo;
        public int _wdataID;
        public int[] _randCatLevels;
        public int _dataColNumber;
        public int _numColStart;
        public int _numRandCol;
        Job _job;
        public long _dataRows;

        public DataAddW2AugXZ(Job job, DataInfo dInfo, int[] randCatLevels) {
            this._job = job;
            this._dinfo = dInfo;
            this._wdataID = 1;
            this._dataColNumber = this._dinfo.fullN() + 1;
            this._numColStart = this._dinfo._cats == 0 ? 0 : this._dinfo._catOffsets[this._dinfo._cats];
            this._numRandCol = randCatLevels.length;
            this._randCatLevels = randCatLevels;
            this._dataRows = this._dinfo._adaptedFrame.numRows();
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartIdx = chunks[0].start();
            if (chkStartIdx < this._dataRows) {
                int numColAugXZ = chunks.length;
                Chunk[] dinfoChunks = new Chunk[this._dinfo._adaptedFrame.numCols()];
                double[] processedRow = new double[chunks.length];
                int[] dinfoChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, chkStartIdx, dinfoChunks, null, null);
                int dinfoChunkRelRow = dinfoChunkInfo[2];
                int chunkLen = chkStartIdx + (long)chunks[0]._len >= this._dataRows ? (int)(this._dataRows - chkStartIdx) : chunks[0]._len;
                DataInfo.Row row = this._dinfo.newDenseRow();
                for (int index = 0; index < chunkLen; ++index) {
                    if (dinfoChunkRelRow >= dinfoChunkInfo[1]) {
                        dinfoChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, dinfoChunkInfo[0] + 1, (long)dinfoChunkRelRow + dinfoChunks[0].start(), dinfoChunks, null, null);
                        dinfoChunkRelRow = dinfoChunkInfo[2];
                    }
                    this._dinfo.extractDenseRow(dinfoChunks, dinfoChunkRelRow, row);
                    Arrays.fill(processedRow, 0.0);
                    double wdata = row.response[this._wdataID];
                    row.scalarProduct(wdata, processedRow, this._numColStart);
                    int offset = this._dataColNumber;
                    for (int randColIndex = 0; randColIndex < this._numRandCol; ++randColIndex) {
                        int processRowIdx = offset + (int)row.response[4 + randColIndex];
                        processedRow[processRowIdx] = wdata;
                        offset += this._randCatLevels[randColIndex];
                    }
                    for (int colIndex = 0; colIndex < numColAugXZ; ++colIndex) {
                        chunks[colIndex].set(index, processedRow[colIndex]);
                    }
                    ++dinfoChunkRelRow;
                }
            }
        }

        public static void getAllChunks(Frame augXZ, int chkIdx, Chunk[] chks, int[] vecIdx) {
            if (vecIdx == null) {
                int chkLen = chks.length;
                for (int chkIndex = 1; chkIndex < chkLen; ++chkIndex) {
                    chks[chkIndex] = augXZ.vec(chkIndex).chunkForChunkIdx(chkIdx);
                }
            } else {
                int veclen = vecIdx.length;
                for (int index = 1; index < veclen; ++index) {
                    chks[index] = augXZ.vec(vecIdx[index]).chunkForChunkIdx(chkIdx);
                }
            }
        }

        public static int getOneSingleChunk(Frame augXZ, int chkIdx, long currentRowAbs, Chunk[] chks, int[] vecIdx) {
            chkIdx = chkIdx >= augXZ.vec(0).nChunks() ? 0 : chkIdx;
            chks[0] = vecIdx == null ? augXZ.vec(0).chunkForChunkIdx(chkIdx) : augXZ.vec(vecIdx[0]).chunkForChunkIdx(chkIdx);
            long strow = chks[0].start();
            long endrow = (long)chks[0].len() + strow;
            if (currentRowAbs >= strow && currentRowAbs < endrow) {
                return -1;
            }
            if (currentRowAbs < strow) {
                return chkIdx - 1;
            }
            return chkIdx + 1;
        }

        public static int[] getCorrectChunk(Frame augXZ, int chkIdx, long currentRowAbs, Chunk[] chks, int[] vecIdx, int[] returnInfo) {
            int currentIdx;
            assert (currentRowAbs < augXZ.numRows());
            int n2 = currentIdx = chkIdx >= augXZ.vec(0).nChunks() ? 0 : chkIdx;
            while (currentIdx >= 0) {
                currentIdx = DataAddW2AugXZ.getOneSingleChunk(augXZ, currentIdx, currentRowAbs, chks, vecIdx);
            }
            DataAddW2AugXZ.getAllChunks(augXZ, chks[0].cidx(), chks, vecIdx);
            if (returnInfo == null) {
                returnInfo = new int[]{chks[0].cidx(), chks[0].len(), (int)(currentRowAbs - chks[0].start())};
            }
            return returnInfo;
        }
    }

    public static class CalculateW4Data
    extends MRTask<CalculateW4Data> {
        GLMModel.GLMParameters _parms;
        public DataInfo _dinfo;
        public int _prior_weightID;
        public int _wdataID;
        public int _offsetID;
        public int[] _random_columnsID;
        public int[] _randCatLevels;
        public int _augZID;
        public int _etaOldID;
        public int _dataColNumber;
        public int _numColStart;
        public double[] _beta;
        public double[] _ubeta;
        public double[] _psi;
        public double[] _phi;
        public double _tau;
        public int _numRandCol;
        Job _job;
        public double _sumEtaDiffSq;
        public double _sumEtaSq;
        public double _HL_correction;

        public CalculateW4Data(Job job, DataInfo dInfo, GLMModel.GLMParameters params, int[] randCatLevels, double[] beta, double[] ubeta, double[] psi, double[] phi, double tau, double hlCorrection) {
            this._job = job;
            this._dinfo = dInfo;
            this._parms = params;
            this._prior_weightID = this._dinfo._weights ? this._dinfo.weightChunkId() : -1;
            this._augZID = this._dinfo.responseChunkId(2);
            this._wdataID = this._dinfo.responseChunkId(1);
            this._etaOldID = this._dinfo.responseChunkId(3);
            this._offsetID = this._dinfo._offset ? this._dinfo.offsetChunkId() : -1;
            this._dataColNumber = this._dinfo.fullN() + 1;
            this._numColStart = this._dinfo.numCats() == 0 ? 0 : this._dinfo._catOffsets[this._dinfo._cats];
            this._numRandCol = this._parms._random_columns.length;
            this._random_columnsID = this._parms._random_columns;
            this._randCatLevels = randCatLevels;
            this._beta = beta;
            this._ubeta = ubeta;
            this._psi = psi;
            this._phi = phi;
            this._tau = tau;
            this._HL_correction = hlCorrection;
            this._sumEtaDiffSq = 0.0;
            this._sumEtaSq = 0.0;
        }

        @Override
        public void map(Chunk[] chunks) {
            GLMModel.GLMWeightsFun glmfun = new GLMModel.GLMWeightsFun(this._parms._family, this._parms._link, this._parms._tweedie_variance_power, this._parms._tweedie_link_power, 0.0);
            DataInfo.Row row = this._dinfo.newDenseRow();
            for (int i2 = 0; i2 < chunks[0]._len; ++i2) {
                this._dinfo.extractDenseRow(chunks, i2, row);
                if (row.isBad() || row.weight == 0.0) continue;
                double eta = row.innerProduct(this._beta) + row.offset;
                for (int index = 0; index < this._numRandCol; ++index) {
                    eta += this._ubeta[(int)row.response(4 + index)];
                }
                if (Double.isNaN(eta)) {
                    throw H2O.fail("GLM.MME diverged! Try different starting values.");
                }
                double etaDiff = eta - row.response(3);
                chunks[this._etaOldID].set(i2, eta);
                this._sumEtaDiffSq += etaDiff * etaDiff;
                this._sumEtaSq += eta * eta;
                double mu = glmfun.linkInv(eta);
                double temp = glmfun.linkInvDeriv(mu);
                double zi = eta - row.offset + (row.response(0) - mu) / temp - this._HL_correction;
                chunks[this._augZID].set(i2, zi);
                double wdata = row.weight * temp * temp / (glmfun.variance(mu) * this._tau);
                chunks[this._wdataID].set(i2, Math.sqrt(wdata));
            }
        }

        @Override
        public void reduce(CalculateW4Data other) {
            this._sumEtaDiffSq += other._sumEtaDiffSq;
            this._sumEtaSq += other._sumEtaSq;
        }
    }

    public static class HelpercAIC
    extends MRTask<HelpercAIC> {
        final double TWOPI = Math.PI * 2;
        final double _logOneO2pisd = -Math.log(Math.sqrt(Math.PI * 2));
        public double _p;
        public double _devOphi;
        public double _constT;
        boolean _weightPresent;
        final double _varFix;

        public HelpercAIC(boolean weightP, double varFix) {
            this._weightPresent = weightP;
            this._varFix = varFix;
        }

        @Override
        public void map(Chunk[] chunks) {
            this._p = 0.0;
            this._devOphi = 0.0;
            this._constT = 0.0;
            int chunkLen = chunks[0].len();
            for (int rowIndex = 0; rowIndex < chunkLen; ++rowIndex) {
                double weight = this._weightPresent ? chunks[2].atd(rowIndex) : 1.0;
                double glm_phi = this._varFix / weight;
                this._constT += Math.log(Math.PI * 2 * glm_phi);
                this._p += chunks[0].atd(rowIndex);
                this._devOphi += chunks[1].atd(rowIndex) / glm_phi;
            }
        }

        @Override
        public void reduce(HelpercAIC other) {
            this._p += other._p;
            this._constT += other._constT;
            this._devOphi += other._devOphi;
        }
    }

    public static class CalculateAugZW
    extends MRTask<CalculateAugZW> {
        GLMModel.GLMParameters _parms;
        public DataInfo _dinfo;
        public int[] _random_columnsID;
        public int _augZID;
        public int _dataColNumber;
        public int _randColNumber;
        public int _numColStart;
        public int _numRandCol;
        public long _numDataRows;
        Job _job;
        Frame _prior_weight_psi;
        public int[] _dinfoWCol;
        public int[] _weightWCol;

        public CalculateAugZW(Job job, DataInfo dInfo, GLMModel.GLMParameters params, Frame prior_weight_psi, int randCatLevels, int dinfoRespColStart, int weightColStart) {
            this._job = job;
            this._dinfo = dInfo;
            this._parms = params;
            this._prior_weight_psi = prior_weight_psi;
            this._augZID = this._dinfo.responseChunkId(2);
            this._dataColNumber = this._dinfo.fullN() + 1;
            this._numColStart = this._dinfo._cats == 0 ? 0 : this._dinfo._catOffsets[this._dinfo._cats];
            this._numRandCol = this._parms._random_columns.length;
            this._random_columnsID = new int[this._numRandCol];
            System.arraycopy(this._parms._random_columns, 0, this._random_columnsID, 0, this._numRandCol);
            this._randColNumber = randCatLevels;
            this._numDataRows = this._dinfo._adaptedFrame.numRows();
            this._dinfoWCol = new int[]{dinfoRespColStart, dinfoRespColStart + 1};
            this._weightWCol = new int[]{weightColStart, weightColStart + 1};
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartIdx = chunks[0].start();
            int chunkLen = chunks[0]._len;
            Chunk[] augzwChunks = new Chunk[2];
            int[] extraChkInfo = new int[3];
            extraChkInfo = chkStartIdx < this._numDataRows ? DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, chkStartIdx, augzwChunks, this._dinfoWCol, extraChkInfo) : DataAddW2AugXZ.getCorrectChunk(this._prior_weight_psi, 0, chkStartIdx - this._numDataRows, augzwChunks, this._weightWCol, extraChkInfo);
            int extraRelRow = extraChkInfo[2];
            for (int rowIndex = 0; rowIndex < chunkLen; ++rowIndex) {
                if (extraRelRow >= extraChkInfo[1]) {
                    long chkAbsRowNumber = (long)rowIndex + chkStartIdx;
                    extraChkInfo = chkAbsRowNumber < this._numDataRows ? DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, extraChkInfo[0], chkAbsRowNumber, augzwChunks, this._dinfoWCol, extraChkInfo) : DataAddW2AugXZ.getCorrectChunk(this._prior_weight_psi, extraChkInfo[0], chkAbsRowNumber - this._numDataRows, augzwChunks, this._weightWCol, extraChkInfo);
                    extraRelRow = extraChkInfo[2];
                }
                chunks[0].set(rowIndex, augzwChunks[0].atd(extraRelRow) * augzwChunks[1].atd(extraRelRow));
                ++extraRelRow;
            }
        }
    }

    public static class CalculateAugZWRandCols
    extends MRTask<CalculateAugZWRandCols> {
        public long _numDataRows;
        Job _job;
        Frame _prior_weight_psi;
        public int[] _weightWCol;

        public CalculateAugZWRandCols(Job job, Frame prior_weight_psi, int weightColStart, long numDataRows) {
            this._job = job;
            this._prior_weight_psi = prior_weight_psi;
            this._numDataRows = numDataRows;
            this._weightWCol = new int[]{weightColStart, weightColStart + 1};
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartIdx = chunks[0].start();
            long chkEndIdx = chkStartIdx + (long)chunks[0]._len;
            if (chkStartIdx > this._numDataRows || chkEndIdx > this._numDataRows) {
                int chunkLen = chunks[0]._len;
                int chunkStartRow = chkStartIdx > this._numDataRows ? 0 : (int)(this._numDataRows - chkStartIdx);
                Chunk[] augzwChunks = new Chunk[2];
                int[] extraChkInfo = new int[3];
                extraChkInfo = DataAddW2AugXZ.getCorrectChunk(this._prior_weight_psi, 0, (long)chunkStartRow + chkStartIdx - this._numDataRows, augzwChunks, this._weightWCol, extraChkInfo);
                int extraRelRow = extraChkInfo[2];
                for (int rowIndex = chunkStartRow; rowIndex < chunkLen; ++rowIndex) {
                    if (extraRelRow >= extraChkInfo[1]) {
                        extraChkInfo = DataAddW2AugXZ.getCorrectChunk(this._prior_weight_psi, extraChkInfo[0] + 1, (long)extraRelRow + augzwChunks[0].start(), augzwChunks, this._weightWCol, extraChkInfo);
                        extraRelRow = extraChkInfo[2];
                    }
                    chunks[0].set(rowIndex, augzwChunks[0].atd(extraRelRow) * augzwChunks[1].atd(extraRelRow));
                    ++extraRelRow;
                }
            }
        }
    }

    public static class CalculateAugZWData
    extends MRTask<CalculateAugZWData> {
        public DataInfo _dinfo;
        public long _numDataRows;
        Job _job;
        public int[] _dinfoWCol;

        public CalculateAugZWData(Job job, DataInfo dInfo, int dinfoRespColStart) {
            this._job = job;
            this._dinfo = dInfo;
            this._numDataRows = this._dinfo._adaptedFrame.numRows();
            this._dinfoWCol = new int[]{dinfoRespColStart, dinfoRespColStart + 1};
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartIdx = chunks[0].start();
            if (chkStartIdx < this._numDataRows) {
                long lastChkIdx = chkStartIdx + (long)chunks[0]._len;
                int chunkLen = lastChkIdx < this._numDataRows ? chunks[0]._len : (int)(this._numDataRows - chkStartIdx);
                Chunk[] augzwChunks = new Chunk[2];
                int[] extraChkInfo = new int[3];
                extraChkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, chkStartIdx, augzwChunks, this._dinfoWCol, extraChkInfo);
                int extraRelRow = extraChkInfo[2];
                for (int rowIndex = 0; rowIndex < chunkLen; ++rowIndex) {
                    if (extraRelRow >= extraChkInfo[1]) {
                        long chkAbsRowNumber = (long)rowIndex + chkStartIdx;
                        extraChkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, extraChkInfo[0], chkAbsRowNumber, augzwChunks, this._dinfoWCol, extraChkInfo);
                        extraRelRow = extraChkInfo[2];
                    }
                    chunks[0].set(rowIndex, augzwChunks[0].atd(extraRelRow) * augzwChunks[1].atd(extraRelRow));
                    ++extraRelRow;
                }
            }
        }
    }

    public static class ExpandRandomColumns
    extends MRTask<ExpandRandomColumns> {
        Job _job;
        int[] _randomColIndices;
        int[] _randomColLevels;
        int _numRandCols;
        int _startRandomExpandedColumn;

        public ExpandRandomColumns(Job job, int[] randomColIndices, int[] randomColLevels, int startExpandedCol) {
            this._job = job;
            this._randomColIndices = randomColIndices;
            this._randomColLevels = randomColLevels;
            this._startRandomExpandedColumn = startExpandedCol;
            this._numRandCols = randomColIndices.length;
        }

        @Override
        public void map(Chunk[] chunks) {
            int chunkRowLen = chunks[0].len();
            int columnOffset = this._startRandomExpandedColumn;
            for (int colIndex = 0; colIndex < this._numRandCols; ++colIndex) {
                for (int rowIndex = 0; rowIndex < chunkRowLen; ++rowIndex) {
                    int randColVal = (int)chunks[this._randomColIndices[colIndex]].atd(rowIndex) + columnOffset;
                    chunks[randColVal].set(rowIndex, 1L);
                }
                columnOffset += this._randomColLevels[colIndex];
            }
        }
    }

    public static class ReturnGLMMMERunInfoData
    extends MRTask<ReturnGLMMMERunInfoData> {
        public DataInfo _dinfo;
        public Frame _qMatrix;
        Job _job;
        double _sumDev;
        double _sumEtaDiffSq;
        double _sumEtaSq;
        public int _totalaugXZCol;
        public int[] _dinfoWCol;
        public long _numDataRow;
        GLMModel.GLMParameters _parms;

        public ReturnGLMMMERunInfoData(Job job, DataInfo datainfo, Frame qMatrix, int[] dinfoWCol, GLMModel.GLMParameters params) {
            this._job = job;
            this._dinfo = datainfo;
            this._qMatrix = qMatrix;
            this._sumDev = 0.0;
            this._sumEtaDiffSq = 0.0;
            this._sumEtaSq = 0.0;
            this._totalaugXZCol = qMatrix.numCols();
            this._dinfoWCol = dinfoWCol;
            this._numDataRow = this._dinfo._adaptedFrame.numRows();
            this._parms = params;
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartRowIdx = chunks[0].start();
            if (chkStartRowIdx < this._numDataRow) {
                GLMModel.GLMWeightsFun glmfun = null;
                long maxRowIndex = chkStartRowIdx + (long)chunks[0].len();
                int chkRowNumber = maxRowIndex >= this._numDataRow ? chunks[0].len() - (int)(maxRowIndex - this._numDataRow) : chunks[0].len();
                Chunk[] chunksqMatrix = new Chunk[this._totalaugXZCol];
                int[] qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, 0, chkStartRowIdx, chunksqMatrix, null, null);
                int qMatrixRelRow = qMatrixInfo[2];
                Chunk[] chunks4ZDev = new Chunk[4];
                int[] zdevChunkInfo = new int[3];
                glmfun = new GLMModel.GLMWeightsFun(this._parms._family, this._parms._link, this._parms._tweedie_variance_power, this._parms._tweedie_link_power, 0.0);
                zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, chkStartRowIdx, chunks4ZDev, this._dinfoWCol, zdevChunkInfo);
                int zdevAbsRelRowNumber = zdevChunkInfo[2];
                for (int rowIndex = 0; rowIndex < chkRowNumber; ++rowIndex) {
                    if (zdevAbsRelRowNumber >= zdevChunkInfo[1]) {
                        zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, zdevChunkInfo[0] + 1, (long)zdevAbsRelRowNumber + chunks4ZDev[0].start(), chunks4ZDev, this._dinfoWCol, zdevChunkInfo);
                        zdevAbsRelRowNumber = zdevChunkInfo[2];
                    }
                    if (qMatrixRelRow > qMatrixInfo[1]) {
                        qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, 1 + qMatrixInfo[0], (long)qMatrixRelRow + chunksqMatrix[0].start(), chunksqMatrix, null, qMatrixInfo);
                        qMatrixRelRow = qMatrixInfo[2];
                    }
                    if (glmfun == null) {
                        glmfun = new GLMModel.GLMWeightsFun(this._parms._family, this._parms._link, this._parms._tweedie_variance_power, this._parms._tweedie_link_power, 0.0);
                    }
                    this._sumDev += this.setZDevEta(chunks4ZDev, chunks, rowIndex, zdevAbsRelRowNumber, glmfun);
                    ReturnGLMMMERunInfoData.setHv(chunksqMatrix, chunks[1], rowIndex, qMatrixRelRow);
                    ++qMatrixRelRow;
                    ++zdevAbsRelRowNumber;
                }
            }
        }

        @Override
        public void reduce(ReturnGLMMMERunInfoData other) {
            this._sumEtaDiffSq += other._sumEtaDiffSq;
            this._sumEtaSq += other._sumEtaSq;
            this._sumDev += other._sumDev;
        }

        public static void setHv(Chunk[] qmat, Chunk hv, int relRowIndex, int qmatRelRowIndex) {
            int numCol = qmat.length;
            double rowSum = 0.0;
            for (int colIndex = 0; colIndex < numCol; ++colIndex) {
                double temp = qmat[colIndex].atd(qmatRelRowIndex);
                rowSum += temp * temp;
            }
            hv.set(relRowIndex, rowSum > 0.99999999 ? 0.99999999 : rowSum);
        }

        public double setZDevEta(Chunk[] dinfoChunks, Chunk[] destChunk, int relRowIndex, int dinfoRowIndex, GLMModel.GLMWeightsFun glmfun) {
            destChunk[0].set(relRowIndex, dinfoChunks[1].atd(dinfoRowIndex));
            double eta = dinfoChunks[2].atd(dinfoRowIndex);
            destChunk[3].set(relRowIndex, eta);
            double temp2 = eta - destChunk[5].atd(relRowIndex);
            this._sumEtaDiffSq += temp2 * temp2;
            this._sumEtaSq += eta * eta;
            double temp = dinfoChunks[0].atd(dinfoRowIndex) - glmfun.linkInv(eta);
            destChunk[4].set(relRowIndex, temp);
            double prior_weight = dinfoChunks[3] == null ? 1.0 : dinfoChunks[3].atd(dinfoRowIndex);
            double devVal = prior_weight * temp * temp;
            destChunk[2].set(relRowIndex, devVal < 1.0E-8 ? 1.0E-8 : devVal);
            return devVal;
        }
    }

    public static class ReturnGLMMMERunInfoRandCols
    extends MRTask<ReturnGLMMMERunInfoRandCols> {
        public DataInfo _dinfo;
        public Frame _w_prior_wpsi;
        public Frame _qMatrix;
        Job _job;
        double _sumDev;
        public int _totalqMatrixCols;
        public int[] _wpriorwpsiCol;
        public long _numDataRow;
        GLMModel.GLMParameters _parms;
        public double[] _psi;
        public double[] _ubeta;
        public int[] _cumRandCatLevels;
        public int _numRandCol;

        public ReturnGLMMMERunInfoRandCols(Job job, DataInfo datainfo, Frame wpriorwpsi, Frame qmatrix, int[] wCol, GLMModel.GLMParameters params, double[] psi, double[] ubeta, int[] cumRandCatLevels) {
            this._job = job;
            this._w_prior_wpsi = wpriorwpsi;
            this._qMatrix = qmatrix;
            this._sumDev = 0.0;
            this._totalqMatrixCols = qmatrix.numCols();
            this._wpriorwpsiCol = wCol;
            this._numDataRow = datainfo._adaptedFrame.numRows();
            this._parms = params;
            this._psi = psi;
            this._ubeta = ubeta;
            this._cumRandCatLevels = cumRandCatLevels;
            this._numRandCol = cumRandCatLevels.length;
        }

        @Override
        public void map(Chunk[] chunks) {
            GLMModel.GLMWeightsFun[] glmfunRand = null;
            long chkStartRowIdx = chunks[0].start();
            long maxChkRowIdx = chunks[0].start() + (long)chunks[0].len();
            if (chkStartRowIdx >= this._numDataRow || this._numDataRow < maxChkRowIdx) {
                int chunkRowStart;
                int chkRowNumber = chunks[0].len();
                chkStartRowIdx = chkStartRowIdx >= this._numDataRow ? chkStartRowIdx : this._numDataRow;
                Chunk[] chunksqMatrix = new Chunk[this._totalqMatrixCols];
                int[] qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, 0, chkStartRowIdx, chunksqMatrix, null, null);
                Chunk[] chunks4ZDev = new Chunk[4];
                int[] zdevChunkInfo = new int[3];
                long rowOffset = chkStartRowIdx - this._numDataRow;
                zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._w_prior_wpsi, 0, rowOffset, chunks4ZDev, this._wpriorwpsiCol, zdevChunkInfo);
                int zdevRelRowNumber = zdevChunkInfo[2];
                int qMatrixRelRow = qMatrixInfo[2];
                glmfunRand = ReturnGLMMMERunInfoRandCols.getRandGLMFuns(glmfunRand, this._numRandCol, this._parms);
                for (int rowIndex = chunkRowStart = (int)(chkStartRowIdx - chunks[0].start()); rowIndex < chkRowNumber; ++rowIndex) {
                    if (zdevRelRowNumber >= zdevChunkInfo[1]) {
                        zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._w_prior_wpsi, zdevChunkInfo[0] + 1, (long)zdevRelRowNumber + chunks4ZDev[0].start(), chunks4ZDev, this._wpriorwpsiCol, zdevChunkInfo);
                        zdevRelRowNumber = zdevChunkInfo[2];
                        if (glmfunRand == null) {
                            glmfunRand = ReturnGLMMMERunInfoRandCols.getRandGLMFuns(glmfunRand, this._numRandCol, this._parms);
                        }
                    }
                    if (qMatrixRelRow >= qMatrixInfo[1]) {
                        qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, qMatrixInfo[0] + 1, (long)qMatrixRelRow + chunksqMatrix[0].start(), chunksqMatrix, null, qMatrixInfo);
                        qMatrixRelRow = qMatrixInfo[2];
                    }
                    int randIndex = RandColAddW2AugXZ.findRandColIndex(this._cumRandCatLevels, zdevRelRowNumber);
                    this._sumDev += ReturnGLMMMERunInfoRandCols.setZDevEta(chunks4ZDev, chunks, rowIndex, zdevRelRowNumber, (int)((long)zdevRelRowNumber + chunks4ZDev[0].start()), this._psi, this._ubeta);
                    ReturnGLMMMERunInfoRandCols.setHv(chunksqMatrix, chunks[1], rowIndex, qMatrixRelRow);
                    ++qMatrixRelRow;
                    ++zdevRelRowNumber;
                }
            }
        }

        public static GLMModel.GLMWeightsFun[] getRandGLMFuns(GLMModel.GLMWeightsFun[] randGLMs, int numRandFuncs, GLMModel.GLMParameters params) {
            if (randGLMs == null) {
                randGLMs = new GLMModel.GLMWeightsFun[numRandFuncs];
            }
            for (int index = 0; index < numRandFuncs; ++index) {
                GLMModel.GLMParameters.Link randlink = params._rand_link == null ? params._rand_family[index].defaultLink : params._rand_link[index];
                randGLMs[index] = new GLMModel.GLMWeightsFun(params._rand_family[index], randlink, params._tweedie_variance_power, params._tweedie_link_power, 0.0);
            }
            return randGLMs;
        }

        @Override
        public void reduce(ReturnGLMMMERunInfoRandCols other) {
            this._sumDev += other._sumDev;
        }

        public static void setHv(Chunk[] qmat, Chunk hv, int relRowIndex, int qmatRelRowIndex) {
            int numCol = qmat.length;
            double rowSum = 0.0;
            for (int colIndex = 0; colIndex < numCol; ++colIndex) {
                double temp = qmat[colIndex].atd(qmatRelRowIndex);
                rowSum += temp * temp;
            }
            hv.set(relRowIndex, rowSum > 0.99999999 ? 0.99999999 : rowSum);
        }

        public static double setZDevEta(Chunk[] wpsiChunks, Chunk[] destChunk, int relRowIndex, int wpsiRowIndex, int abswpsiRowIndex, double[] psi, double[] ubeta) {
            destChunk[0].set(relRowIndex, wpsiChunks[1].atd(wpsiRowIndex));
            double temp = psi[abswpsiRowIndex] - ubeta[abswpsiRowIndex];
            double devVal = wpsiChunks[0].atd(wpsiRowIndex) * temp * temp;
            destChunk[2].set(relRowIndex, devVal < 1.0E-8 ? 1.0E-8 : devVal);
            return devVal;
        }
    }

    public static class ReturnGLMMMERunInfo
    extends MRTask<ReturnGLMMMERunInfo> {
        public DataInfo _dinfo;
        public Frame _w_prior_wpsi;
        public Frame _qMatrix;
        Job _job;
        double _sumDev;
        double _sumEtaDiffSq;
        double _sumEtaSq;
        public int _totalaugXZCol;
        public int[] _dinfoWCol;
        public int[] _wpriorwpsiCol;
        public long _numDataRow;
        public int _maxdinfoCol;
        GLMModel.GLMParameters _parms;
        public double[] _psi;
        public double[] _ubeta;
        public int[] _cumRandCatLevels;
        public int _numRandCol;

        public ReturnGLMMMERunInfo(Job job, DataInfo datainfo, Frame wpriorwpsi, Frame qMatrix, int[] dinfoWCol, int[] wCol, GLMModel.GLMParameters params, double[] psi, double[] ubeta, int[] cumRandCatLevels) {
            this._job = job;
            this._dinfo = datainfo;
            this._w_prior_wpsi = wpriorwpsi;
            this._qMatrix = qMatrix;
            this._sumDev = 0.0;
            this._sumEtaDiffSq = 0.0;
            this._sumEtaSq = 0.0;
            this._totalaugXZCol = qMatrix.numCols();
            this._dinfoWCol = dinfoWCol;
            this._wpriorwpsiCol = wCol;
            this._numDataRow = this._dinfo._adaptedFrame.numRows();
            this._maxdinfoCol = this._dinfo._weights ? 4 : 3;
            this._parms = params;
            this._psi = psi;
            this._ubeta = ubeta;
            this._cumRandCatLevels = cumRandCatLevels;
            this._numRandCol = cumRandCatLevels.length;
        }

        public static GLMModel.GLMWeightsFun[] getRandGLMFuns(GLMModel.GLMWeightsFun[] randGLMs, int numRandFuncs, GLMModel.GLMParameters params) {
            if (randGLMs == null) {
                randGLMs = new GLMModel.GLMWeightsFun[numRandFuncs];
            }
            for (int index = 0; index < numRandFuncs; ++index) {
                GLMModel.GLMParameters.Link randlink = params._rand_link == null ? params._rand_family[index].defaultLink : params._rand_link[index];
                randGLMs[index] = new GLMModel.GLMWeightsFun(params._rand_family[index], randlink, params._tweedie_variance_power, params._tweedie_link_power, 0.0);
            }
            return randGLMs;
        }

        @Override
        public void reduce(ReturnGLMMMERunInfo other) {
            this._sumEtaDiffSq += other._sumEtaDiffSq;
            this._sumEtaSq += other._sumEtaSq;
        }

        @Override
        public void map(Chunk[] chunks) {
            boolean usingWpsi;
            GLMModel.GLMWeightsFun glmfun = null;
            GLMModel.GLMWeightsFun[] glmfunRand = null;
            long chkStartRowIdx = chunks[0].start();
            int chkRowNumber = chunks[0].len();
            Chunk[] chunksqMatrix = new Chunk[this._totalaugXZCol];
            int[] qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, 0, chkStartRowIdx, chunksqMatrix, null, null);
            Chunk[] chunks4ZDev = new Chunk[4];
            int[] zdevChunkInfo = new int[3];
            long rowOffset = chkStartRowIdx - this._numDataRow;
            if (chkStartRowIdx >= this._numDataRow) {
                usingWpsi = true;
                zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._w_prior_wpsi, 0, rowOffset, chunks4ZDev, this._wpriorwpsiCol, zdevChunkInfo);
                glmfunRand = ReturnGLMMMERunInfo.getRandGLMFuns(glmfunRand, this._numRandCol, this._parms);
            } else {
                usingWpsi = false;
                glmfun = new GLMModel.GLMWeightsFun(this._parms._family, this._parms._link, this._parms._tweedie_variance_power, this._parms._tweedie_link_power, 0.0);
                zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, chkStartRowIdx, chunks4ZDev, this._dinfoWCol, zdevChunkInfo);
            }
            for (int rowIndex = 0; rowIndex < chkRowNumber; ++rowIndex) {
                int zdevAbsRelRowNumber;
                int n2 = zdevAbsRelRowNumber = usingWpsi ? (int)((long)rowIndex + rowOffset) : rowIndex + zdevChunkInfo[2];
                if (!usingWpsi && zdevAbsRelRowNumber >= zdevChunkInfo[1]) {
                    long rowAbsIndex = (long)rowIndex + chkStartRowIdx;
                    if (rowAbsIndex >= this._numDataRow) {
                        usingWpsi = true;
                        zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._w_prior_wpsi, 0, rowAbsIndex - this._numDataRow, chunks4ZDev, this._wpriorwpsiCol, zdevChunkInfo);
                        if (glmfunRand == null) {
                            glmfunRand = ReturnGLMMMERunInfo.getRandGLMFuns(glmfunRand, this._numRandCol, this._parms);
                        }
                    } else {
                        zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._dinfo._adaptedFrame, 0, rowAbsIndex, chunks4ZDev, this._dinfoWCol, zdevChunkInfo);
                        if (glmfun == null) {
                            glmfun = new GLMModel.GLMWeightsFun(this._parms._family, this._parms._link, this._parms._tweedie_variance_power, this._parms._tweedie_link_power, 0.0);
                        }
                    }
                    zdevAbsRelRowNumber = usingWpsi ? (int)((long)rowIndex + rowOffset) : rowIndex + zdevChunkInfo[2];
                } else if (usingWpsi && zdevAbsRelRowNumber - zdevChunkInfo[0] >= zdevChunkInfo[1]) {
                    zdevChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._w_prior_wpsi, 0, zdevAbsRelRowNumber, chunks4ZDev, this._wpriorwpsiCol, zdevChunkInfo);
                    if (glmfunRand == null) {
                        glmfunRand = ReturnGLMMMERunInfo.getRandGLMFuns(glmfunRand, this._numRandCol, this._parms);
                    }
                    zdevAbsRelRowNumber = (int)((long)rowIndex + rowOffset);
                }
                this._sumDev += this.calDev(usingWpsi, this._cumRandCatLevels, zdevAbsRelRowNumber, chunks4ZDev, chunks, rowIndex, glmfun, glmfunRand, this._psi, this._ubeta);
                int n3 = qMatrixInfo[2];
                qMatrixInfo[2] = n3 + 1;
                ReturnGLMMMERunInfo.setHv(chunksqMatrix, chunks[1], rowIndex, n3);
                if (qMatrixInfo[2] <= qMatrixInfo[1]) continue;
                qMatrixInfo = DataAddW2AugXZ.getCorrectChunk(this._qMatrix, 1 + qMatrixInfo[0], chkStartRowIdx, chunksqMatrix, null, qMatrixInfo);
            }
        }

        public static void setHv(Chunk[] qmat, Chunk hv, int relRowIndex, int qmatRelRowIndex) {
            int numCol = qmat.length;
            double rowSum = 0.0;
            for (int colIndex = 0; colIndex < numCol; ++colIndex) {
                double temp = qmat[colIndex].atd(qmatRelRowIndex);
                rowSum += temp * temp;
            }
            hv.set(relRowIndex, rowSum > 0.99999999 ? 0.99999999 : rowSum);
        }

        public double calDev(boolean usingWpsi, int[] _cumRandCatLevels, int zdevAbsRelRowNumber, Chunk[] chunks4ZDev, Chunk[] chunks, int rowIndex, GLMModel.GLMWeightsFun glmfun, GLMModel.GLMWeightsFun[] glmfunRand, double[] psi, double[] ubeta) {
            if (usingWpsi) {
                int randIndex = RandColAddW2AugXZ.findRandColIndex(_cumRandCatLevels, zdevAbsRelRowNumber);
                return ReturnGLMMMERunInfo.setZDevEta(chunks4ZDev, chunks, rowIndex, (int)((long)zdevAbsRelRowNumber - chunks[0].start()), zdevAbsRelRowNumber, glmfunRand[randIndex], psi, ubeta);
            }
            return this.setZDevEta(chunks4ZDev, chunks, rowIndex, zdevAbsRelRowNumber, glmfun);
        }

        public static double setZDevEta(Chunk[] wpsiChunks, Chunk[] destChunk, int relRowIndex, int wpsiRowIndex, int abswpsiRowIndex, GLMModel.GLMWeightsFun glmfuns, double[] psi, double[] ubeta) {
            destChunk[0].set(relRowIndex, wpsiChunks[1].atd(wpsiRowIndex));
            double temp = psi[abswpsiRowIndex] - ubeta[abswpsiRowIndex];
            double devVal = wpsiChunks[0].atd(wpsiRowIndex) * temp * temp;
            destChunk[2].set(relRowIndex, devVal < 1.0E-8 ? 1.0E-8 : devVal);
            return devVal;
        }

        public double setZDevEta(Chunk[] dinfoChunks, Chunk[] destChunk, int relRowIndex, int dinfoRowIndex, GLMModel.GLMWeightsFun glmfun) {
            destChunk[0].set(relRowIndex, dinfoChunks[1].atd(dinfoRowIndex));
            double eta = dinfoChunks[2].atd(dinfoRowIndex);
            destChunk[3].set(relRowIndex, eta);
            double temp2 = eta - destChunk[5].atd(relRowIndex);
            this._sumEtaDiffSq += temp2 * temp2;
            this._sumEtaSq += eta * eta;
            double temp = dinfoChunks[0].atd(dinfoRowIndex) - glmfun.linkInv(eta);
            destChunk[4].set(relRowIndex, temp);
            double prior_weight = dinfoChunks[3] == null ? 1.0 : dinfoChunks[3].atd(dinfoRowIndex);
            double devVal = prior_weight * temp * temp;
            destChunk[2].set(relRowIndex, devVal < 1.0E-8 ? 1.0E-8 : devVal);
            return devVal;
        }
    }

    public static class CopyPartsOfFrame
    extends MRTask<CopyPartsOfFrame> {
        public Frame _sourceFrame;
        public int[] _destColIndices;
        public int[] _sourceColIndices;
        public long _nrowsToCopy;

        public CopyPartsOfFrame(Frame fr, int[] destFrameColID, int[] sourceFrameColID, long numRows) {
            int index;
            int numCols;
            this._sourceFrame = fr;
            if (sourceFrameColID == null) {
                numCols = fr.numCols();
                this._sourceColIndices = new int[numCols];
                for (index = 0; index < numCols; ++index) {
                    this._sourceColIndices[index] = index;
                }
            } else {
                this._sourceColIndices = sourceFrameColID;
            }
            if (destFrameColID == null) {
                numCols = this._sourceColIndices.length;
                this._destColIndices = new int[numCols];
                for (index = 0; index < numCols; ++index) {
                    this._destColIndices[index] = index;
                }
            } else {
                this._destColIndices = destFrameColID;
            }
            assert (this._destColIndices.length == this._sourceColIndices.length);
            this._nrowsToCopy = numRows;
        }

        @Override
        public void map(Chunk[] chunks) {
            int colLen = this._sourceColIndices.length;
            long chkStartIdx = chunks[0].start();
            Chunk[] sourceChunks = new Chunk[colLen];
            long lastRowIndex = chkStartIdx + (long)chunks[0].len();
            if (chkStartIdx < this._nrowsToCopy) {
                int rowLen = lastRowIndex > this._nrowsToCopy ? (int)(this._nrowsToCopy - chkStartIdx) : chunks[0].len();
                int[] fetchedChkInfo = DataAddW2AugXZ.getCorrectChunk(this._sourceFrame, 0, chkStartIdx, sourceChunks, this._sourceColIndices, null);
                int fetchedChkRelRow = fetchedChkInfo[2];
                for (int rowIndex = 0; rowIndex < rowLen; ++rowIndex) {
                    if (fetchedChkRelRow >= fetchedChkInfo[1]) {
                        fetchedChkInfo = DataAddW2AugXZ.getCorrectChunk(this._sourceFrame, fetchedChkInfo[0] + 1, (long)fetchedChkRelRow + sourceChunks[0].start(), sourceChunks, this._sourceColIndices, fetchedChkInfo);
                        fetchedChkRelRow = fetchedChkInfo[2];
                    }
                    for (int colIndex = 0; colIndex < colLen; ++colIndex) {
                        chunks[this._destColIndices[colIndex]].set(rowIndex, sourceChunks[colIndex].atd(fetchedChkRelRow));
                    }
                    ++fetchedChkRelRow;
                }
            }
        }
    }

    public static class ExtractFrameFromSourceWithProcess
    extends MRTask<ExtractFrameFromSourceWithProcess> {
        public Frame _sourceFrame;
        int[] _devhvColIdx;
        long _startRowIndex;
        long _lengthToCopy;

        public ExtractFrameFromSourceWithProcess(Frame sourceFrame, int[] devHvColIdx, long startRowIndex, long lengthCopy) {
            this._sourceFrame = sourceFrame;
            this._devhvColIdx = devHvColIdx;
            this._startRowIndex = startRowIndex;
            this._lengthToCopy = lengthCopy;
        }

        @Override
        public void map(Chunk[] chunks) {
            long startChkIdx = chunks[0].start();
            int chkLen = chunks[0].len();
            long sourceChkIdx = this._startRowIndex + startChkIdx;
            Chunk[] sourceChunks = new Chunk[this._devhvColIdx.length];
            int[] fetchedChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._sourceFrame, 0, sourceChkIdx, sourceChunks, this._devhvColIdx, null);
            int fetchedRelRowIndex = fetchedChunkInfo[2];
            for (int rowIndex = 0; rowIndex < chkLen && (long)rowIndex + startChkIdx < this._lengthToCopy; ++rowIndex) {
                if (fetchedRelRowIndex >= fetchedChunkInfo[1]) {
                    fetchedChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._sourceFrame, fetchedChunkInfo[0] + 1, (long)fetchedRelRowIndex + sourceChunks[0].start(), sourceChunks, this._devhvColIdx, fetchedChunkInfo);
                    fetchedRelRowIndex = fetchedChunkInfo[2];
                }
                double temp = 1.0 - sourceChunks[1].atd(fetchedRelRowIndex);
                chunks[0].set(rowIndex, sourceChunks[0].atd(fetchedRelRowIndex) / temp);
                chunks[2].set(rowIndex, temp / 2.0);
                ++fetchedRelRowIndex;
            }
        }
    }

    public static class CalculateEtaInfo
    extends MRTask<CalculateEtaInfo> {
        public double _sumEtaDiffSq = 0.0;
        public double _sumEtaSq = 0.0;
        public int[] _etaOetaN;

        public CalculateEtaInfo(int[] etaOldetaNew) {
            this._etaOetaN = etaOldetaNew;
        }

        @Override
        public void map(Chunk[] chunks) {
            this._sumEtaDiffSq = 0.0;
            this._sumEtaSq = 0.0;
            int chkLen = chunks[0].len();
            for (int rowIndex = 0; rowIndex < chkLen; ++rowIndex) {
                double tempetaN = chunks[this._etaOetaN[1]].atd(rowIndex);
                double tempetaDiff = chunks[this._etaOetaN[0]].atd(rowIndex) - tempetaN;
                this._sumEtaSq += tempetaN * tempetaN;
                this._sumEtaDiffSq += tempetaDiff * tempetaDiff;
            }
        }

        @Override
        public void reduce(CalculateEtaInfo other) {
            this._sumEtaDiffSq += other._sumEtaDiffSq;
            this._sumEtaSq += other._sumEtaSq;
        }
    }

    public static class GenerateResid
    extends MRTask<GenerateResid> {
        public Job _job;
        double _oneOverSqrtSumDevONMP;
        int _hvColIdx;
        int _residColIdx;
        long _numDataRows;

        public GenerateResid(Job job, double oneOverSqrtSumDevONMP, int hvColIdx, int residColIdx, long numDataRows) {
            this._job = job;
            this._oneOverSqrtSumDevONMP = oneOverSqrtSumDevONMP;
            this._hvColIdx = hvColIdx;
            this._residColIdx = residColIdx;
            this._numDataRows = numDataRows;
        }

        @Override
        public void map(Chunk[] chunks) {
            long absRowIdx;
            long chkStartRowIdx = chunks[0].start();
            int chkRowNumber = chunks[0].len();
            for (int rowIndex = 0; rowIndex < chkRowNumber && (absRowIdx = (long)rowIndex + chkStartRowIdx) < this._numDataRows; ++rowIndex) {
                double tempVal = chunks[this._residColIdx].atd(rowIndex) * this._oneOverSqrtSumDevONMP;
                chunks[this._residColIdx].set(rowIndex, tempVal / Math.sqrt(1.0 - chunks[this._hvColIdx].atd(rowIndex)));
            }
        }
    }

    public static class CalculateW4Rand
    extends MRTask<CalculateW4Rand> {
        GLMModel.GLMParameters _parms;
        public int[] _cumRandCatLevels;
        public double[] _psi;
        public double[] _phi;
        public int _numRandCol;
        Job _job;
        double[] _vi;

        public CalculateW4Rand(Job job, GLMModel.GLMParameters params, int[] randCatLevels, double[] psi, double[] phi, double[] vi) {
            this._job = job;
            this._parms = params;
            this._numRandCol = this._parms._random_columns.length;
            this._cumRandCatLevels = ArrayUtils.cumsum(randCatLevels);
            this._psi = psi;
            this._phi = phi;
            this._vi = vi;
        }

        public static int findRandColIndex(int[] cumrandCatLevels, long colIndex) {
            int len = cumrandCatLevels.length;
            for (int index = 0; index < len; ++index) {
                if (colIndex >= (long)cumrandCatLevels[index]) continue;
                return index;
            }
            return len - 1;
        }

        @Override
        public void map(Chunk[] chunks) {
            GLMModel.GLMWeightsFun[] glmfunRand = ReturnGLMMMERunInfo.getRandGLMFuns(null, this._numRandCol, this._parms);
            for (int index = 0; index < chunks[0]._len; ++index) {
                int randIndex = CalculateW4Rand.findRandColIndex(this._cumRandCatLevels, index);
                double temp = glmfunRand[randIndex].linkInvDeriv(this._phi[index]);
                double ui = glmfunRand[randIndex].linkInv(this._vi[index]);
                double zmi = this._vi[index] + (this._psi[index] - ui) / temp;
                chunks[2].set(index, zmi);
                double wpsi = chunks[0].atd(index) * temp * temp / (glmfunRand[randIndex].variance(this._psi[index]) * this._phi[index]);
                chunks[1].set(index, Math.sqrt(wpsi));
            }
        }
    }

    public static class RandColAddW2AugXZ
    extends MRTask<RandColAddW2AugXZ> {
        public int[] _cumRandCatLevels;
        public int _randNumColStart;
        public long _randRowStart;
        Job _job;
        Frame _prior_weights_psi;
        public int _totAugxzColNumber;
        public int[] _weightID;

        public RandColAddW2AugXZ(Job job, int[] randCatLevels, Frame prior_weights_psi, int wpsiID, long randRowStart, int randNumColStart, int augXZColNum) {
            this._job = job;
            this._prior_weights_psi = prior_weights_psi;
            this._weightID = new int[]{wpsiID};
            this._cumRandCatLevels = ArrayUtils.cumsum(randCatLevels);
            this._randRowStart = randRowStart;
            this._randNumColStart = randNumColStart;
            this._totAugxzColNumber = augXZColNum;
        }

        public static int findRandColIndex(int[] cumrandCatLevels, long colIndex) {
            int len = cumrandCatLevels.length;
            for (int index = 0; index < len; ++index) {
                if (colIndex >= (long)cumrandCatLevels[index]) continue;
                return index;
            }
            return len - 1;
        }

        @Override
        public void map(Chunk[] chunks) {
            long chkStartIdx = chunks[0].start();
            if (chkStartIdx + (long)chunks[0].len() >= this._randRowStart) {
                Chunk[] priorWeightsWpsi = new Chunk[1];
                int chkRowStart = (int)(this._randRowStart - chkStartIdx);
                chkRowStart = chkRowStart > 0 ? chkRowStart : 0;
                long chkWeightRowStart = (long)chkRowStart + chkStartIdx - this._randRowStart;
                int[] weightChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._prior_weights_psi, 0, chkWeightRowStart, priorWeightsWpsi, this._weightID, null);
                int chkWeightRelRow = weightChunkInfo[2];
                int psiColumnIndex = (int)priorWeightsWpsi[0].start() + this._randNumColStart + chkWeightRelRow;
                for (int index = chkRowStart; index < chunks[0]._len; ++index) {
                    int colIndex;
                    if (chkWeightRelRow >= weightChunkInfo[1]) {
                        weightChunkInfo = DataAddW2AugXZ.getCorrectChunk(this._prior_weights_psi, weightChunkInfo[0] + 1, (long)chkWeightRelRow + priorWeightsWpsi[0].start(), priorWeightsWpsi, this._weightID, weightChunkInfo);
                        chkWeightRelRow = weightChunkInfo[2];
                    }
                    double wpsi = priorWeightsWpsi[0].atd(chkWeightRelRow);
                    for (colIndex = 0; colIndex < psiColumnIndex; ++colIndex) {
                        chunks[colIndex].set(index, 0.0);
                    }
                    chunks[psiColumnIndex].set(index, wpsi);
                    for (colIndex = ++psiColumnIndex; colIndex < this._totAugxzColNumber; ++colIndex) {
                        chunks[colIndex].set(index, 0.0);
                    }
                    ++chkWeightRelRow;
                }
            }
        }
    }

    public static class GLMIterationTask
    extends FrameTask2<GLMIterationTask> {
        final GLMModel.GLMWeightsFun _glmf;
        double[][] _beta_multinomial;
        double[] _beta;
        protected Gram _gram;
        double[] _xy;
        double _yy;
        final double[] _ymu;
        long _nobs;
        public double _likelihood;
        private transient GLMModel.GLMWeights _w;
        private transient GLMModel.GLMWeightsFun _glmfTweedie;
        double wsum;
        double wsumu;
        double _sumsqe;
        int _c = -1;
        private transient double _sparseOffset;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(null, dinfo, jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
        }

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta, int c2) {
            super(null, dinfo, jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
            this._c = c2;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
            this._w = new GLMModel.GLMWeights();
            if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie)) {
                this._glmfTweedie = new GLMModel.GLMWeightsFun(this._glmf._family, this._glmf._link, this._glmf._var_power, this._glmf._link_power, this._glmf._theta);
            }
        }

        public Gram getGram() {
            return this._gram;
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            int i2;
            double w2;
            double wz;
            if (r2.isBad() || r2.weight == 0.0) {
                return;
            }
            ++this._nobs;
            double y2 = r2.response(0);
            this._yy += y2 * y2;
            int numStart = this._dinfo.numStart();
            if (this._glmf._family == GLMModel.GLMParameters.Family.multinomial) {
                y2 = y2 == (double)this._c ? 1.0 : 0.0;
                double mu = r2.response(1);
                double eta = r2.response(2);
                double d2 = mu * (1.0 - mu);
                if (d2 == 0.0) {
                    d2 = 1.0E-10;
                }
                wz = r2.weight * (eta * d2 + (y2 - mu));
                w2 = r2.weight * d2;
            } else if (this._beta != null) {
                if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie)) {
                    this._glmfTweedie.computeWeights(y2, r2.innerProduct(this._beta) + this._sparseOffset, r2.offset, r2.weight, this._w);
                } else {
                    this._glmf.computeWeights(y2, r2.innerProduct(this._beta) + this._sparseOffset, r2.offset, r2.weight, this._w);
                }
                w2 = this._w.w;
                wz = this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie) ? this._w.z : w2 * this._w.z;
                this._likelihood += this._w.l;
            } else {
                w2 = r2.weight;
                wz = w2 * (y2 - r2.offset);
            }
            this.wsum += w2;
            this.wsumu += r2.weight;
            for (i2 = 0; i2 < r2.nBins; ++i2) {
                int n2 = r2.binIds[i2];
                this._xy[n2] = this._xy[n2] + wz;
            }
            for (i2 = 0; i2 < r2.nNums; ++i2) {
                int id = r2.numIds == null ? i2 + numStart : r2.numIds[i2];
                double val = r2.numVals[i2];
                int n3 = id;
                this._xy[n3] = this._xy[n3] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n4 = this._xy.length - 1;
                this._xy[n4] = this._xy[n4] + wz;
            }
            this._gram.addRow(r2, w2);
        }

        @Override
        public void chunkDone() {
            this.adjustForSparseStandardizedZeros();
        }

        @Override
        public void reduce(GLMIterationTask git) {
            ArrayUtils.add(this._xy, git._xy);
            this._gram.add(git._gram);
            this._nobs += git._nobs;
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            this._sumsqe += git._sumsqe;
            this._yy += git._yy;
            super.reduce(git);
        }

        private void adjustForSparseStandardizedZeros() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i2;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i2 = ns; i2 < this._dinfo.fullN(); ++i2) {
                    int j2;
                    double iMean = this._dinfo._normSub[i2 - ns] * this._dinfo._normMul[i2 - ns];
                    for (j2 = 0; j2 < ns; ++j2) {
                        double[] dArray = this._gram._xx[i2 - this._gram._diagN];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] - interceptRow[j2] * iMean;
                    }
                    for (j2 = ns; j2 <= i2; ++j2) {
                        double jMean = this._dinfo._normSub[j2 - ns] * this._dinfo._normMul[j2 - ns];
                        double[] dArray = this._gram._xx[i2 - this._gram._diagN];
                        int n3 = j2;
                        dArray[n3] = dArray[n3] - (interceptRow[i2] * jMean + interceptRow[j2] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j3 = ns; j3 < this._dinfo.fullN(); ++j3) {
                        int n4 = j3;
                        interceptRow[n4] = interceptRow[n4] - nobs * this._dinfo._normSub[j3 - ns] * this._dinfo._normMul[j3 - ns];
                    }
                }
                for (i2 = ns; i2 < this._dinfo.fullN(); ++i2) {
                    int n5 = i2;
                    this._xy[n5] = this._xy[n5] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i2 - ns] * this._dinfo._normMul[i2 - ns];
                }
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs(this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class GLMMultinomialUpdate
    extends FrameTask2<GLMMultinomialUpdate> {
        private final double[][] _beta;
        private final int _c;
        private transient double[] _sparseOffsets;
        private transient double[] _etas;
        private transient Chunk _sumExpChunk;
        private transient Chunk _maxRowChunk;

        public GLMMultinomialUpdate(DataInfo dinfo, Key jobKey, double[] beta, int c2) {
            super(null, dinfo, jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix(beta, dinfo.fullN() + 1);
            this._c = c2;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d(this._beta.length);
            this._etas = MemoryManager.malloc8d(this._beta.length);
            if (this._sparse) {
                for (int i2 = 0; i2 < this._beta.length; ++i2) {
                    this._sparseOffsets[i2] = GLM.sparseOffset(this._beta[i2], this._dinfo);
                }
            }
        }

        @Override
        public void map(Chunk[] chks) {
            this._sumExpChunk = chks[chks.length - 2];
            this._maxRowChunk = chks[chks.length - 1];
            super.map(chks);
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            double maxrow = 0.0;
            for (int i2 = 0; i2 < this._beta.length; ++i2) {
                this._etas[i2] = r2.innerProduct(this._beta[i2]) + this._sparseOffsets[i2];
                if (!(this._etas[i2] > maxrow)) continue;
                maxrow = this._etas[i2];
            }
            double sumExp = 0.0;
            for (int i3 = 0; i3 < this._beta.length; ++i3) {
                sumExp += Math.exp(this._etas[i3] - maxrow);
            }
            this._maxRowChunk.set(r2.cid, this._etas[this._c]);
            this._sumExpChunk.set(r2.cid, Math.exp(this._etas[this._c] - maxrow) / sumExp);
        }
    }

    public static class GLMIterationTaskMultinomial
    extends FrameTask2<GLMIterationTaskMultinomial> {
        final int _c;
        final double[] _beta;
        double[] _xy;
        Gram _gram;
        transient double _sparseOffset;

        public GLMIterationTaskMultinomial(DataInfo dinfo, Key jobKey, double[] beta, int c2) {
            super(null, dinfo, jobKey);
            this._beta = beta;
            this._c = c2;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            int i2;
            double mu;
            double y2 = r2.response(0);
            double sumExp = r2.response(1);
            double maxRow = r2.response(2);
            int numStart = this._dinfo.numStart();
            y2 = y2 == (double)this._c ? 1.0 : 0.0;
            double eta = r2.innerProduct(this._beta) + this._sparseOffset;
            if (eta > maxRow) {
                maxRow = eta;
            }
            double etaExp = Math.exp(eta - maxRow);
            double d2 = mu = etaExp == Double.POSITIVE_INFINITY ? 1.0 : etaExp / (sumExp += etaExp);
            if (mu < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d3 = mu * (1.0 - mu);
            double wz = r2.weight * (eta * d3 + (y2 - mu));
            double w2 = r2.weight * d3;
            for (i2 = 0; i2 < r2.nBins; ++i2) {
                int n2 = r2.binIds[i2];
                this._xy[n2] = this._xy[n2] + wz;
            }
            for (i2 = 0; i2 < r2.nNums; ++i2) {
                int id = r2.numIds == null ? i2 + numStart : r2.numIds[i2];
                double val = r2.numVals[i2];
                int n3 = id;
                this._xy[n3] = this._xy[n3] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n4 = this._xy.length - 1;
                this._xy[n4] = this._xy[n4] + wz;
            }
            this._gram.addRow(r2, w2);
        }

        @Override
        public void reduce(GLMIterationTaskMultinomial glmt) {
            ArrayUtils.add(this._xy, glmt._xy);
            this._gram.add(glmt._gram);
        }
    }

    public static class GLMMultinomialWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMMultinomialWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r2) {
            double eta = r2.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r2.response(0), eta, r2.weight, r2.offset, this._ws);
            r2.weight = this._ws.w;
            r2.offset = 0.0;
            r2.setResponse(0, this._ws.z);
            super.processRow(r2);
        }
    }

    public static class GLMWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r2) {
            double eta = r2.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r2.response(0), eta, r2.weight, r2.offset, this._ws);
            r2.weight = this._ws.w;
            r2.offset = 0.0;
            r2.setResponse(0, this._ws.z);
            super.processRow(r2);
        }
    }

    public static class LSTask
    extends FrameTask2<LSTask> {
        public double[] _xy;
        public Gram _gram;
        final int numStart;

        public LSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey) {
            super(cmp, dinfo, jobKey);
            this.numStart = this._dinfo.numStart();
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            int i2;
            double wz = r2.weight * (r2.response(0) - r2.offset);
            for (i2 = 0; i2 < r2.nBins; ++i2) {
                int n2 = r2.binIds[i2];
                this._xy[n2] = this._xy[n2] + wz;
            }
            for (i2 = 0; i2 < r2.nNums; ++i2) {
                int id = r2.numIds == null ? i2 + this.numStart : r2.numIds[i2];
                double val = r2.numVals[i2];
                int n3 = id;
                this._xy[n3] = this._xy[n3] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n4 = this._xy.length - 1;
                this._xy[n4] = this._xy[n4] + wz;
            }
            this._gram.addRow(r2, r2.weight);
        }

        @Override
        public void reduce(LSTask lst) {
            ArrayUtils.add(this._xy, lst._xy);
            this._gram.add(lst._gram);
        }

        @Override
        public void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i2;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i2 = ns; i2 < this._dinfo.fullN(); ++i2) {
                    int j2;
                    double iMean = this._dinfo._normSub[i2 - ns] * this._dinfo._normMul[i2 - ns];
                    for (j2 = 0; j2 < ns; ++j2) {
                        double[] dArray = this._gram._xx[i2 - this._gram._diagN];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] - interceptRow[j2] * iMean;
                    }
                    for (j2 = ns; j2 <= i2; ++j2) {
                        double jMean = this._dinfo._normSub[j2 - ns] * this._dinfo._normMul[j2 - ns];
                        double[] dArray = this._gram._xx[i2 - this._gram._diagN];
                        int n3 = j2;
                        dArray[n3] = dArray[n3] - (interceptRow[i2] * jMean + interceptRow[j2] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j3 = ns; j3 < this._dinfo.fullN(); ++j3) {
                        int n4 = j3;
                        interceptRow[n4] = interceptRow[n4] - nobs * this._dinfo._normSub[j3 - ns] * this._dinfo._normMul[j3 - ns];
                    }
                }
                for (i2 = ns; i2 < this._dinfo.fullN(); ++i2) {
                    int n5 = i2;
                    this._xy[n5] = this._xy[n5] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i2 - ns] * this._dinfo._normMul[i2 - ns];
                }
            }
        }
    }

    public static class GLMMultinomialGradientTask
    extends GLMMultinomialGradientBaseTask {
        public GLMMultinomialGradientTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            super(job, dinfo, lambda, beta, reg);
        }

        public GLMMultinomialGradientTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            super(job, dinfo, lambda, beta, glmp);
        }

        public GLMMultinomialGradientTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp, double[][][] penaltyMat, int[][] gamCols) {
            super(job, dinfo, lambda, beta, glmp, penaltyMat, gamCols);
        }

        @Override
        public void calMultipliersNGradients(double[][] etas, double[][] etasOffset, double[] ws, double[] vals, int[] ids, Chunk response, Chunk[] chks, int M2, int P2, int numStart) {
            int i2;
            if (this._glmp != null && this._link == GLMModel.GLMParameters.Link.ologit && (this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.AUTO) || this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH))) {
                this.computeGradientMultipliersLH(etas, etasOffset, response.getDoubles(vals, 0, M2), ws);
            } else if (this._glmp != null && this._link == GLMModel.GLMParameters.Link.ologit && this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR)) {
                this.computeGradientMultipliersSQERR(etas, etasOffset, response.getDoubles(vals, 0, M2), ws);
            } else {
                this.computeGradientMultipliers(etas, response.getDoubles(vals, 0, M2), ws);
            }
            this.computeCategoricalGrads(chks, etas, vals, ids);
            this.computeNumericGrads(chks, etas, vals, ids);
            double[] g2 = this._gradient[P2 - 1];
            if (this._link == GLMModel.GLMParameters.Link.ologit) {
                for (i2 = 0; i2 < etasOffset.length; ++i2) {
                    ArrayUtils.add(g2, etasOffset[i2]);
                }
            } else {
                for (i2 = 0; i2 < etas.length; ++i2) {
                    ArrayUtils.add(g2, etas[i2]);
                }
            }
            if (this._dinfo._normSub != null) {
                double[] icpt = this._gradient[P2 - 1];
                for (int i3 = 0; i3 < this._dinfo._normSub.length; ++i3) {
                    if (!chks[this._dinfo._cats + i3].isSparseZero()) continue;
                    ArrayUtils.wadd(this._gradient[numStart + i3], icpt, -this._dinfo._normSub[i3] * this._dinfo._normMul[i3]);
                }
            }
        }
    }

    public static abstract class GLMMultinomialGradientBaseTask
    extends MRTask<GLMMultinomialGradientBaseTask> {
        final double[][] _beta;
        final transient double _currentLambda;
        final transient double _reg;
        public double[][] _gradient;
        double _likelihood;
        Job _job;
        final boolean _sparse;
        final DataInfo _dinfo;
        GLMModel.GLMParameters.Link _link;
        GLMModel.GLMParameters _glmp;
        int _secondToLast;
        int _theLast;
        int _interceptId;
        double[][][] _penaltyMat;
        int[][] _gamBetaIndices;

        public GLMMultinomialGradientBaseTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            this._currentLambda = lambda;
            this._reg = reg;
            this._beta = new double[beta[0].length][beta.length];
            for (int i2 = 0; i2 < this._beta.length; ++i2) {
                for (int j2 = 0; j2 < this._beta[i2].length; ++j2) {
                    this._beta[i2][j2] = beta[j2][i2];
                }
            }
            this._job = job;
            this._sparse = FrameUtils.sparseRatio(dinfo._adaptedFrame) < 0.125;
            this._dinfo = dinfo;
            if (this._dinfo._offset) {
                throw H2O.unimpl();
            }
        }

        public GLMMultinomialGradientBaseTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            this(job, dinfo, lambda, beta, glmp._obj_reg);
            this._theLast = beta.length - 1;
            this._secondToLast = this._theLast - 1;
            this._interceptId = this._beta.length - 1;
            this._link = glmp._link;
            this._glmp = glmp;
        }

        public GLMMultinomialGradientBaseTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp, double[][][] penaltyMat, int[][] gamCols) {
            this(job, dinfo, lambda, beta, glmp._obj_reg);
            this._theLast = beta.length - 1;
            this._secondToLast = this._theLast - 1;
            this._interceptId = this._beta.length - 1;
            this._link = glmp._link;
            this._glmp = glmp;
            this._penaltyMat = penaltyMat;
            this._gamBetaIndices = gamCols;
        }

        public final void computeCategoricalEtas(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c2 = chks[cid];
                if (c2.isSparseZero()) {
                    int nvals = c2.getSparseDoubles(vals, ids, -1.0);
                    for (int i2 = 0; i2 < nvals; ++i2) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i2]);
                        if (id < 0) continue;
                        ArrayUtils.add(etas[ids[i2]], this._beta[id]);
                    }
                    continue;
                }
                c2.getIntegers(ids, 0, c2._len, -1);
                for (int i3 = 0; i3 < ids.length; ++i3) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i3]);
                    if (id < 0) continue;
                    ArrayUtils.add(etas[i3], this._beta[id]);
                }
            }
        }

        public final void computeCategoricalGrads(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c2 = chks[cid];
                if (c2.isSparseZero()) {
                    int nvals = c2.getSparseDoubles(vals, ids, -1.0);
                    for (int i2 = 0; i2 < nvals; ++i2) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i2]);
                        if (id < 0) continue;
                        ArrayUtils.add(this._gradient[id], etas[ids[i2]]);
                    }
                    continue;
                }
                c2.getIntegers(ids, 0, c2._len, -1);
                for (int i3 = 0; i3 < ids.length; ++i3) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i3]);
                    if (id < 0) continue;
                    ArrayUtils.add(this._gradient[id], etas[i3]);
                }
            }
        }

        public final void computeNumericEtas(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double[] b2 = this._beta[numOff + cid];
                double scale = this._dinfo._normMul != null ? this._dinfo._normMul[cid] : 1.0;
                double NA2 = this._dinfo._numNAFill[cid];
                Chunk c2 = chks[cid + this._dinfo._cats];
                if (c2.isSparseZero() || c2.isSparseNA()) {
                    int nvals = c2.getSparseDoubles(vals, ids, NA2);
                    for (int i2 = 0; i2 < nvals; ++i2) {
                        double d2 = vals[i2] * scale;
                        ArrayUtils.wadd(etas[ids[i2]], b2, d2);
                    }
                    continue;
                }
                c2.getDoubles(vals, 0, vals.length, NA2);
                double off = this._dinfo._normSub != null ? this._dinfo._normSub[cid] : 0.0;
                for (int i3 = 0; i3 < vals.length; ++i3) {
                    double d3 = (vals[i3] - off) * scale;
                    ArrayUtils.wadd(etas[i3], b2, d3);
                }
            }
        }

        public final void computeNumericGrads(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double scale;
                double[] g2 = this._gradient[numOff + cid];
                double NA2 = this._dinfo._numNAFill[cid];
                Chunk c2 = chks[cid + this._dinfo._cats];
                double d2 = scale = this._dinfo._normMul == null ? 1.0 : this._dinfo._normMul[cid];
                if (c2.isSparseZero() || c2.isSparseNA()) {
                    int nVals = c2.getSparseDoubles(vals, ids, NA2);
                    for (int i2 = 0; i2 < nVals; ++i2) {
                        ArrayUtils.wadd(g2, etas[ids[i2]], vals[i2] * scale);
                    }
                    continue;
                }
                double off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                c2.getDoubles(vals, 0, vals.length, NA2);
                for (int i3 = 0; i3 < vals.length; ++i3) {
                    ArrayUtils.wadd(g2, etas[i3], (vals[i3] - off) * scale);
                }
            }
        }

        final void computeGradientMultipliersLH(double[][] etas, double[][] etasOffset, double[] ys, double[] ws) {
            int K2 = this._beta[0].length;
            double[] tempEtas = new double[K2];
            for (int row = 0; row < etas.length; ++row) {
                double w2 = ws[row];
                if (w2 == 0.0) {
                    Arrays.fill(etas[row], 0.0);
                    continue;
                }
                System.arraycopy(etas[row], 0, tempEtas, 0, K2);
                Arrays.fill(etas[row], 0.0);
                int y2 = (int)ys[row];
                if (y2 == 0) {
                    etasOffset[row][0] = this._glmp.linkInv(tempEtas[0]) - 1.0;
                    etas[row][0] = etasOffset[row][0];
                    this._likelihood -= w2 * tempEtas[y2] - Math.log(1.0 + Math.exp(tempEtas[y2]));
                } else if (y2 == this._theLast) {
                    etasOffset[row][this._secondToLast] = this._glmp.linkInv(tempEtas[this._secondToLast]);
                    etas[row][0] = etasOffset[row][this._secondToLast];
                    this._likelihood += w2 * Math.log(1.0 + Math.exp(tempEtas[this._secondToLast]));
                } else {
                    double yJm1;
                    int lastC = y2 - 1;
                    double yJ = this._glmp.linkInv(tempEtas[y2]);
                    double den = yJ - (yJm1 = this._glmp.linkInv(tempEtas[lastC]));
                    den = den == 0.0 ? 1.0E-10 : den;
                    this._likelihood -= w2 * Math.log(den);
                    etas[row][0] = yJ + yJm1 - 1.0;
                    double oneMcdfPC = 1.0 - yJm1;
                    oneMcdfPC = oneMcdfPC == 0.0 ? 1.0E-10 : oneMcdfPC;
                    double oneOthreshold = 1.0 - Math.exp(this._beta[this._interceptId][lastC] - this._beta[this._interceptId][y2]);
                    oneOthreshold = oneOthreshold == 0.0 ? 1.0E-10 : oneOthreshold;
                    double oneOverThreshold = 1.0 / oneOthreshold;
                    etasOffset[row][y2] = (yJ - 1.0) * oneOverThreshold / oneMcdfPC;
                    yJ = yJ == 0.0 ? 1.0E-10 : yJ;
                    etasOffset[row][lastC] = yJm1 * oneOverThreshold / yJ;
                }
                for (int c2 = 1; c2 < K2; ++c2) {
                    etas[row][c2] = etas[row][0];
                }
            }
        }

        final void computeGradientMultipliersSQERR(double[][] etas, double[][] etasOffset, double[] ys, double[] ws) {
            int K2 = this._beta[0].length;
            double[] tempEtas = new double[K2];
            for (int row = 0; row < etas.length; ++row) {
                int c2;
                double w2 = ws[row];
                if (w2 == 0.0) {
                    Arrays.fill(etas[row], 0.0);
                    continue;
                }
                System.arraycopy(etas[row], 0, tempEtas, 0, K2);
                Arrays.fill(etas[row], 0.0);
                int y2 = (int)ys[row];
                for (c2 = 0; c2 < y2; ++c2) {
                    if (!(tempEtas[c2] > 0.0)) continue;
                    etasOffset[row][c2] = tempEtas[c2];
                    double[] dArray = etas[row];
                    dArray[0] = dArray[0] + tempEtas[c2];
                    this._likelihood += w2 * 0.5 * tempEtas[c2] * tempEtas[c2];
                }
                for (c2 = y2; c2 < this._theLast; ++c2) {
                    if (!(tempEtas[c2] <= 0.0)) continue;
                    etasOffset[row][c2] = tempEtas[c2];
                    double[] dArray = etas[row];
                    dArray[0] = dArray[0] + tempEtas[c2];
                    this._likelihood += w2 * 0.5 * tempEtas[c2] * tempEtas[c2];
                }
                for (c2 = 1; c2 < K2; ++c2) {
                    etas[row][c2] = etas[row][0];
                }
            }
        }

        final void computeGradientMultipliers(double[][] etas, double[] ys, double[] ws) {
            int K2 = this._beta[0].length;
            double[] exps = new double[K2 + 1];
            for (int i2 = 0; i2 < etas.length; ++i2) {
                double w2 = ws[i2];
                if (w2 == 0.0) {
                    Arrays.fill(etas[i2], 0.0);
                    continue;
                }
                int y2 = (int)ys[i2];
                double logSumExp = GLMTask.computeMultinomialEtas(etas[i2], exps);
                this._likelihood -= w2 * (etas[i2][y2] - logSumExp);
                for (int c2 = 0; c2 < K2; ++c2) {
                    etas[i2][c2] = w2 * (exps[c2 + 1] - (double)(y2 == c2 ? 1 : 0));
                }
            }
        }

        @Override
        public void map(Chunk[] chks) {
            int i2;
            if (this._job != null && this._job.stop_requested()) {
                throw new Job.JobCancelledException();
            }
            int numStart = this._dinfo.numStart();
            int K2 = this._beta[0].length;
            int P2 = this._beta.length;
            int M2 = chks[0]._len;
            this._gradient = new double[P2][K2];
            double[][] etas = new double[M2][K2];
            double[][] etasOffset = new double[M2][K2];
            double[] offsets = new double[K2];
            for (int k2 = 0; k2 < K2; ++k2) {
                offsets[k2] = this._beta[P2 - 1][k2];
            }
            if (this._dinfo._normSub != null) {
                for (i2 = 0; i2 < this._dinfo._nums; ++i2) {
                    if (!chks[this._dinfo._cats + i2].isSparseZero()) continue;
                    ArrayUtils.wadd(offsets, this._beta[numStart + i2], -this._dinfo._normSub[i2] * this._dinfo._normMul[i2]);
                }
            }
            for (i2 = 0; i2 < chks[0]._len; ++i2) {
                System.arraycopy(offsets, 0, etas[i2], 0, K2);
            }
            Chunk response = chks[this._dinfo.responseChunkId(0)];
            double[] ws = MemoryManager.malloc8d(M2);
            if (this._dinfo._weights) {
                ws = chks[this._dinfo.weightChunkId()].getDoubles(ws, 0, M2);
            } else {
                Arrays.fill(ws, 1.0);
            }
            chks = Arrays.copyOf(chks, chks.length - 1 - (this._dinfo._weights ? 1 : 0));
            double[] vals = MemoryManager.malloc8d(M2);
            int[] ids = MemoryManager.malloc4(M2);
            this.computeCategoricalEtas(chks, etas, vals, ids);
            this.computeNumericEtas(chks, etas, vals, ids);
            this.calMultipliersNGradients(etas, etasOffset, ws, vals, ids, response, chks, M2, P2, numStart);
        }

        public abstract void calMultipliersNGradients(double[][] var1, double[][] var2, double[] var3, double[] var4, int[] var5, Chunk var6, Chunk[] var7, int var8, int var9, int var10);

        @Override
        public void reduce(GLMMultinomialGradientBaseTask gmgt) {
            if (this._gradient != gmgt._gradient) {
                ArrayUtils.add(this._gradient, gmgt._gradient);
            }
            this._likelihood += gmgt._likelihood;
        }

        @Override
        public void postGlobal() {
            ArrayUtils.mult(this._gradient, this._reg);
            int P2 = this._beta.length;
            if (this._currentLambda > 0.0) {
                for (int c2 = 0; c2 < P2 - 1; ++c2) {
                    for (int j2 = 0; j2 < this._beta[0].length; ++j2) {
                        double[] dArray = this._gradient[c2];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] + this._currentLambda * this._beta[c2][j2];
                    }
                }
            }
            if (this._penaltyMat != null && this._gamBetaIndices != null) {
                GLMUtils.updateGradGamMultinomial(this._gradient, this._penaltyMat, this._gamBetaIndices, this._beta);
            }
        }

        public double[] gradient() {
            double[] res = MemoryManager.malloc8d(this._gradient.length * this._gradient[0].length);
            int P2 = this._gradient.length;
            for (int k2 = 0; k2 < this._gradient[0].length; ++k2) {
                for (int i2 = 0; i2 < this._gradient.length; ++i2) {
                    res[k2 * P2 + i2] = this._gradient[i2][k2];
                }
            }
            return res;
        }
    }

    static class GLMMultinomialLikelihoodTask
    extends GLMMultinomialGradientBaseTask {
        public GLMMultinomialLikelihoodTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            super(job, dinfo, lambda, beta, reg);
        }

        public GLMMultinomialLikelihoodTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            super(job, dinfo, lambda, beta, glmp);
        }

        @Override
        public void calMultipliersNGradients(double[][] etas, double[][] etasOffset, double[] ws, double[] vals, int[] ids, Chunk response, Chunk[] chks, int M2, int P2, int numStart) {
            this.computeGradientMultipliers(etas, response.getDoubles(vals, 0, M2), ws);
        }
    }

    public static class GLMGaussianGradientTask
    extends GLMGradientTask {
        public GLMGaussianGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.gaussian && parms._link == GLMModel.GLMParameters.Link.identity);
        }

        public GLMGaussianGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCol) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCol);
            assert (parms._family == GLMModel.GLMParameters.Family.gaussian && parms._link == GLMModel.GLMParameters.Link.identity);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            for (int i2 = 0; i2 < es.length; ++i2) {
                double w2 = ws[i2];
                if (w2 == 0.0 || Double.isNaN(ys[i2])) {
                    es[i2] = 0.0;
                    continue;
                }
                double e2 = es[i2];
                double y2 = ys[i2];
                double d2 = e2 - y2;
                double wd = w2 * d2;
                this._likelihood += wd * d2;
                es[i2] = wd;
            }
        }
    }

    static class GLMBinomialGradientTask
    extends GLMGradientTask {
        public GLMBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.binomial && parms._link == GLMModel.GLMParameters.Link.logit || parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && parms._link == GLMModel.GLMParameters.Link.logit);
        }

        public GLMBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCol) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCol);
            assert (parms._family == GLMModel.GLMParameters.Family.binomial && parms._link == GLMModel.GLMParameters.Link.logit || parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && parms._link == GLMModel.GLMParameters.Link.logit);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            for (int i2 = 0; i2 < es.length; ++i2) {
                if (Double.isNaN(ys[i2]) || ws[i2] == 0.0) {
                    es[i2] = 0.0;
                    continue;
                }
                double e2 = es[i2];
                double w2 = ws[i2];
                double yr = ys[i2];
                double ym = 1.0 / (Math.exp(-e2) + 1.0);
                if (ym != yr) {
                    this._likelihood += w2 * (MathUtils.y_log_y(yr, ym) + MathUtils.y_log_y(1.0 - yr, 1.0 - ym));
                }
                es[i2] = ws[i2] * (ym - yr);
            }
        }
    }

    static class GLMQuasiBinomialGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMQuasiBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        public GLMQuasiBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCols) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCols);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l2 = 0.0;
            for (int i2 = 0; i2 < es.length; ++i2) {
                double p2 = this._glmf.linkInv(es[i2]);
                if (p2 == 0.0) {
                    p2 = 1.0E-15;
                }
                if (p2 == 1.0) {
                    p2 = 0.999999999999999;
                }
                es[i2] = -ws[i2] * (ys[i2] - p2);
                l2 += ys[i2] * Math.log(p2) + (1.0 - ys[i2]) * Math.log(1.0 - p2);
            }
            this._likelihood = -l2;
        }
    }

    static class GLMNegativeBinomialGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMNegativeBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        public GLMNegativeBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCols) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCols);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l2 = 0.0;
            for (int i2 = 0; i2 < es.length; ++i2) {
                if (Double.isNaN(ys[i2]) || ws[i2] == 0.0) {
                    es[i2] = 0.0;
                    continue;
                }
                double eta = es[i2];
                double mu = this._glmf.linkInv(eta);
                double yr = ys[i2];
                if (mu > 0.0 && yr > 0.0) {
                    double invSum = 1.0 / (1.0 + mu * this._glmf._theta);
                    double muDeriv = this._glmf.linkInvDeriv(mu);
                    es[i2] = ws[i2] * (invSum - yr / mu + this._glmf._theta * yr * invSum) * muDeriv;
                    l2 -= ws[i2] * (GLMTask.sumOper(yr, this._glmf._invTheta, 0) - (yr + this._glmf._invTheta) * Math.log(1.0 + this._glmf._theta * mu) + yr * Math.log(mu) + yr * Math.log(this._glmf._theta));
                    continue;
                }
                if (!(mu > 0.0) || yr != 0.0) continue;
                es[i2] = ws[i2] * (this._glmf.linkInvDeriv(mu) / (1.0 + this._glmf._theta * mu));
                l2 += this._glmf._invTheta * Math.log(1.0 + this._glmf._theta * mu);
            }
            this._likelihood = l2;
        }
    }

    static class GLMPoissonGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMPoissonGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        public GLMPoissonGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCols) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCols);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l2 = 0.0;
            for (int i2 = 0; i2 < es.length; ++i2) {
                if (Double.isNaN(ys[i2]) || ws[i2] == 0.0) {
                    es[i2] = 0.0;
                    continue;
                }
                double eta = es[i2];
                double mu = Math.exp(eta);
                double yr = ys[i2];
                double diff = mu - yr;
                l2 += ws[i2] * (yr == 0.0 ? mu : yr * Math.log(yr / mu) + diff);
                es[i2] = ws[i2] * diff;
            }
            this._likelihood = 2.0 * l2;
        }
    }

    static class GLMGenericGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMGenericGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        public GLMGenericGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamCols) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta, penaltyMat, gamCols);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l2 = 0.0;
            for (int i2 = 0; i2 < es.length; ++i2) {
                if (Double.isNaN(ys[i2]) || ws[i2] == 0.0) {
                    es[i2] = 0.0;
                    continue;
                }
                double mu = this._glmf.linkInv(es[i2]);
                mu = mu == 0.0 ? 1.0E-6 : mu;
                l2 += ws[i2] * this._glmf.likelihood(ys[i2], mu);
                double var = this._glmf.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.tweedie)) {
                    this._glmf._oneOeta = 1.0 / (es[i2] == 0.0 ? 1.0E-6 : es[i2]);
                    this._glmf._oneOetaSquare = this._glmf._oneOeta * this._glmf._oneOeta;
                    es[i2] = ws[i2] * this._glmf.linkInvDeriv(mu) * (this._glmf._var_power == 1.0 ? 1.0 - ys[i2] / mu : (this._glmf._var_power == 2.0 ? 1.0 / mu - ys[i2] * Math.pow(mu, -this._glmf._var_power) : Math.pow(mu, this._glmf._oneMinusVarPower) - ys[i2] * Math.pow(mu, -this._glmf._var_power)));
                    continue;
                }
                es[i2] = ws[i2] * (mu - ys[i2]) / (var * this._glmf.linkDeriv(mu));
            }
            this._likelihood = l2;
        }
    }

    static abstract class GLMGradientTask
    extends MRTask<GLMGradientTask> {
        final double[] _beta;
        public double[] _gradient;
        public double _likelihood;
        final transient double _currentLambda;
        final transient double _reg;
        protected final DataInfo _dinfo;
        public double[][][] _penalty_mat;
        public int[][] _gamBetaIndices;

        protected GLMGradientTask(Key jobKey, DataInfo dinfo, double reg, double lambda, double[] beta) {
            this._dinfo = dinfo;
            this._beta = (double[])beta.clone();
            this._reg = reg;
            this._currentLambda = lambda;
        }

        protected GLMGradientTask(Key jobKey, DataInfo dinfo, double reg, double lambda, double[] beta, double[][][] penaltyMat, int[][] gamBetaInd) {
            this(jobKey, dinfo, reg, lambda, beta);
            this._penalty_mat = penaltyMat;
            this._gamBetaIndices = gamBetaInd;
        }

        protected abstract void computeGradientMultipliers(double[] var1, double[] var2, double[] var3);

        private final void computeCategoricalEtas(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c2 = chks[cid];
                if (c2.isSparseZero()) {
                    int nvals = c2.getSparseDoubles(vals, ids, -1.0);
                    for (int i2 = 0; i2 < nvals; ++i2) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i2]);
                        if (id < 0) continue;
                        int n2 = ids[i2];
                        etas[n2] = etas[n2] + this._beta[id];
                    }
                    continue;
                }
                c2.getIntegers(ids, 0, c2._len, -1);
                for (int i3 = 0; i3 < ids.length; ++i3) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i3]);
                    if (id < 0) continue;
                    int n3 = i3;
                    etas[n3] = etas[n3] + this._beta[id];
                }
            }
        }

        private final void computeCategoricalGrads(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c2 = chks[cid];
                if (c2.isSparseZero()) {
                    int nvals = c2.getSparseDoubles(vals, ids, -1.0);
                    for (int i2 = 0; i2 < nvals; ++i2) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i2]);
                        if (id < 0) continue;
                        int n2 = id;
                        this._gradient[n2] = this._gradient[n2] + etas[ids[i2]];
                    }
                    continue;
                }
                c2.getIntegers(ids, 0, c2._len, -1);
                for (int i3 = 0; i3 < ids.length; ++i3) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i3]);
                    if (id < 0) continue;
                    int n3 = id;
                    this._gradient[n3] = this._gradient[n3] + etas[i3];
                }
            }
        }

        private final void computeNumericEtas(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                int i2;
                int nvals;
                double scale = this._dinfo._normMul != null ? this._dinfo._normMul[cid] : 1.0;
                double off = this._dinfo._normSub != null ? this._dinfo._normSub[cid] : 0.0;
                double NA2 = this._dinfo._numNAFill[cid];
                Chunk c2 = chks[cid + this._dinfo._cats];
                double b2 = scale * this._beta[numOff + cid];
                if (c2.isSparseZero()) {
                    nvals = c2.getSparseDoubles(vals, ids, NA2);
                    for (i2 = 0; i2 < nvals; ++i2) {
                        int n2 = ids[i2];
                        etas[n2] = etas[n2] + vals[i2] * b2;
                    }
                    continue;
                }
                if (c2.isSparseNA()) {
                    nvals = c2.getSparseDoubles(vals, ids, NA2);
                    for (i2 = 0; i2 < nvals; ++i2) {
                        int n3 = ids[i2];
                        etas[n3] = etas[n3] + (vals[i2] - off) * b2;
                    }
                    continue;
                }
                c2.getDoubles(vals, 0, vals.length, NA2);
                for (int i3 = 0; i3 < vals.length; ++i3) {
                    int n4 = i3;
                    etas[n4] = etas[n4] + (vals[i3] - off) * b2;
                }
            }
        }

        private final void computeNumericGrads(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double off;
                double offset;
                double NA2 = this._dinfo._numNAFill[cid];
                Chunk c2 = chks[cid + this._dinfo._cats];
                double scale = this._dinfo._normMul == null ? 1.0 : this._dinfo._normMul[cid];
                double d2 = offset = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                if (c2.isSparseZero()) {
                    double g2 = 0.0;
                    int nVals = c2.getSparseDoubles(vals, ids, NA2);
                    for (int i2 = 0; i2 < nVals; ++i2) {
                        g2 += (vals[i2] - offset) * scale * etas[ids[i2]];
                    }
                    this._gradient[numOff + cid] = g2;
                    continue;
                }
                if (c2.isSparseNA()) {
                    off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                    double g3 = 0.0;
                    int nVals = c2.getSparseDoubles(vals, ids, NA2);
                    for (int i3 = 0; i3 < nVals; ++i3) {
                        g3 += (vals[i3] - off) * scale * etas[ids[i3]];
                    }
                    this._gradient[numOff + cid] = g3;
                    continue;
                }
                off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                c2.getDoubles(vals, 0, vals.length, NA2);
                double g4 = 0.0;
                for (int i4 = 0; i4 < vals.length; ++i4) {
                    g4 += (vals[i4] - off) * scale * etas[i4];
                }
                this._gradient[numOff + cid] = g4;
            }
        }

        @Override
        public void map(Chunk[] chks) {
            this._gradient = MemoryManager.malloc8d(this._beta.length);
            Chunk response = chks[chks.length - this._dinfo._responses];
            Chunk weights = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, response._len);
            double[] ws = weights.getDoubles(MemoryManager.malloc8d(weights._len), 0, weights._len);
            double[] ys = response.getDoubles(MemoryManager.malloc8d(weights._len), 0, response._len);
            double[] etas = MemoryManager.malloc8d(response._len);
            if (this._dinfo._offset) {
                chks[this._dinfo.offsetChunkId()].getDoubles(etas, 0, etas.length);
            }
            double sparseOffset = 0.0;
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normSub != null) {
                for (int i2 = 0; i2 < this._dinfo._nums; ++i2) {
                    if (!chks[this._dinfo._cats + i2].isSparseZero()) continue;
                    sparseOffset -= this._beta[numStart + i2] * this._dinfo._normSub[i2] * this._dinfo._normMul[i2];
                }
            }
            ArrayUtils.add(etas, sparseOffset + this._beta[this._beta.length - 1]);
            double[] vals = MemoryManager.malloc8d(response._len);
            int[] ids = MemoryManager.malloc4(response._len);
            this.computeCategoricalEtas(chks, etas, vals, ids);
            this.computeNumericEtas(chks, etas, vals, ids);
            this.computeGradientMultipliers(etas, ys, ws);
            this.computeCategoricalGrads(chks, etas, vals, ids);
            this.computeNumericGrads(chks, etas, vals, ids);
            this._gradient[this._gradient.length - 1] = ArrayUtils.sum(etas);
            if (this._dinfo._normSub != null) {
                double icpt = this._gradient[this._gradient.length - 1];
                for (int i3 = 0; i3 < this._dinfo._nums; ++i3) {
                    if (!chks[this._dinfo._cats + i3].isSparseZero()) continue;
                    double d2 = this._dinfo._normSub[i3] * this._dinfo._normMul[i3];
                    int n2 = numStart + i3;
                    this._gradient[n2] = this._gradient[n2] - d2 * icpt;
                }
            }
        }

        @Override
        public final void reduce(GLMGradientTask gmgt) {
            ArrayUtils.add(this._gradient, gmgt._gradient);
            this._likelihood += gmgt._likelihood;
        }

        @Override
        public final void postGlobal() {
            ArrayUtils.mult(this._gradient, this._reg);
            for (int j2 = 0; j2 < this._beta.length - 1; ++j2) {
                int n2 = j2;
                this._gradient[n2] = this._gradient[n2] + this._currentLambda * this._beta[j2];
            }
            if (this._penalty_mat != null && this._gamBetaIndices != null) {
                GLMUtils.updateGradGam(this._gradient, this._penalty_mat, this._gamBetaIndices, this._beta, this._dinfo._activeCols);
            }
        }
    }

    public static class YMUTask
    extends MRTask<YMUTask> {
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        final int _responseId;
        final int _weightId;
        final int _offsetId;
        final int _nums;
        final int _numOff;
        final boolean _skipNAs;
        final boolean _computeWeightedMeanSigmaResponse;
        private MathUtils.BasicStats _basicStats;
        private MathUtils.BasicStats _basicStatsResponse;
        double[] _yMu;
        final int _nClasses;
        private double[] _predictorSDs;
        private final boolean _expandedResponse;

        public double[] predictorMeans() {
            return this._basicStats.mean();
        }

        public double[] predictorSDs() {
            if (this._predictorSDs != null) {
                return this._predictorSDs;
            }
            this._predictorSDs = this._basicStats.sigma();
            return this._predictorSDs;
        }

        public double[] responseMeans() {
            return this._basicStatsResponse.mean();
        }

        public double[] responseSDs() {
            return this._basicStatsResponse.sigma();
        }

        public YMUTask(DataInfo dinfo, int nclasses, boolean computeWeightedMeanSigmaResponse, boolean skipNAs, boolean haveResponse, boolean expandedResponse) {
            this._nums = dinfo._nums;
            this._numOff = dinfo._cats;
            this._responseId = haveResponse ? dinfo.responseChunkId(0) : -1;
            this._weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
            this._offsetId = dinfo._offset ? dinfo.offsetChunkId() : -1;
            this._nClasses = nclasses;
            this._computeWeightedMeanSigmaResponse = computeWeightedMeanSigmaResponse;
            this._skipNAs = skipNAs;
            this._expandedResponse = this._nClasses == 1 || expandedResponse;
        }

        @Override
        public void setupLocal() {
        }

        @Override
        public void map(Chunk[] chunks) {
            int i2;
            this._yMu = new double[this._nClasses];
            double[] ws = MemoryManager.malloc8d(chunks[0].len());
            if (this._weightId != -1) {
                chunks[this._weightId].getDoubles(ws, 0, ws.length);
            } else {
                Arrays.fill(ws, 1.0);
            }
            boolean changedWeights = false;
            if (this._skipNAs) {
                double[] vals = MemoryManager.malloc8d(chunks[0]._len);
                int[] ids = MemoryManager.malloc4(vals.length);
                for (i2 = 0; i2 < chunks.length; ++i2) {
                    int n2 = vals.length;
                    if (chunks[i2].isSparseZero()) {
                        n2 = chunks[i2].getSparseDoubles(vals, ids);
                    } else {
                        chunks[i2].getDoubles(vals, 0, n2);
                    }
                    for (int r2 = 0; r2 < n2; ++r2) {
                        if (ws[r2] == 0.0 || !Double.isNaN(vals[r2])) continue;
                        ws[r2] = 0.0;
                        changedWeights = true;
                    }
                }
                if (changedWeights && this._weightId != -1) {
                    chunks[this._weightId].set(ws);
                }
            }
            Chunk response = this._responseId < 0 ? null : chunks[this._responseId];
            double[] numsResponse = null;
            this._basicStats = new MathUtils.BasicStats(this._nums);
            if (this._computeWeightedMeanSigmaResponse) {
                this._basicStatsResponse = new MathUtils.BasicStats(this._nClasses);
                numsResponse = MemoryManager.malloc8d(this._nClasses);
            }
            for (i2 = 0; i2 < this._nums; ++i2) {
                Chunk c2 = chunks[i2 + this._numOff];
                int r3 = c2.nextNZ(-1);
                while (r3 < c2._len) {
                    double w2 = ws[r3];
                    if (w2 != 0.0) {
                        double d2 = c2.atd(r3);
                        this._basicStats.add(d2, w2, i2);
                    }
                    r3 = c2.nextNZ(r3);
                }
            }
            if (response == null) {
                return;
            }
            long nobs = 0L;
            double wsum = 0.0;
            for (double w3 : ws) {
                if (w3 != 0.0) {
                    ++nobs;
                }
                wsum += w3;
            }
            this._basicStats.setNobs(nobs, wsum);
            for (int r4 = 0; r4 < response._len; ++r4) {
                double d3;
                double w4 = ws[r4];
                if (w4 == 0.0) continue;
                if (this._computeWeightedMeanSigmaResponse) {
                    if (this._expandedResponse) {
                        for (int i3 = 0; i3 < this._nClasses; ++i3) {
                            numsResponse[i3] = chunks[chunks.length - this._nClasses + i3].atd(r4);
                        }
                    } else {
                        Arrays.fill(numsResponse, 0.0);
                        d3 = response.atd(r4);
                        if (Double.isNaN(d3)) {
                            Arrays.fill(numsResponse, Double.NaN);
                        } else {
                            numsResponse[(int)d3] = 1.0;
                        }
                    }
                    this._basicStatsResponse.add(numsResponse, w4);
                }
                if (Double.isNaN(d3 = response.atd(r4))) continue;
                if (this._nClasses > 2) {
                    int n3 = (int)d3;
                    this._yMu[n3] = this._yMu[n3] + w4;
                } else {
                    this._yMu[0] = this._yMu[0] + w4 * d3;
                }
                if (d3 < this._yMin) {
                    this._yMin = d3;
                }
                if (!(d3 > this._yMax)) continue;
                this._yMax = d3;
            }
            if (this._basicStatsResponse != null) {
                this._basicStatsResponse.setNobs(nobs, wsum);
            }
            for (int i4 = 0; i4 < this._nums; ++i4) {
                if (chunks[i4 + this._numOff].isSparseZero()) {
                    this._basicStats.fillSparseZeros(i4);
                    continue;
                }
                if (!chunks[i4 + this._numOff].isSparseNA()) continue;
                this._basicStats.fillSparseNAs(i4);
            }
        }

        @Override
        public void postGlobal() {
            ArrayUtils.mult(this._yMu, 1.0 / this._basicStats._wsum);
        }

        @Override
        public void reduce(YMUTask ymt) {
            if (ymt._basicStats.nobs() > 0L && ymt._basicStats.nobs() > 0L) {
                ArrayUtils.add(this._yMu, ymt._yMu);
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
                this._basicStats.reduce(ymt._basicStats);
                if (this._computeWeightedMeanSigmaResponse) {
                    this._basicStatsResponse.reduce(ymt._basicStatsResponse);
                }
            } else if (this._basicStats.nobs() == 0L) {
                this._yMu = ymt._yMu;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
                this._basicStats = ymt._basicStats;
                this._basicStatsResponse = ymt._basicStatsResponse;
            }
        }

        public double wsum() {
            return this._basicStats._wsum;
        }

        public long nobs() {
            return this._basicStats.nobs();
        }
    }

    static class WeightedSDTask
    extends MRTask<WeightedSDTask> {
        final int _weightId;
        final double[] _mean;
        public double[] _varSum;

        public WeightedSDTask(int wId, double[] mean) {
            this._weightId = wId;
            this._mean = mean;
        }

        @Override
        public void map(Chunk[] chks) {
            double[] weights = null;
            if (this._weightId != -1) {
                weights = MemoryManager.malloc8d(chks[this._weightId]._len);
                chks[this._weightId].getDoubles(weights, 0, weights.length);
                chks = ArrayUtils.remove(chks, this._weightId);
            }
            this._varSum = MemoryManager.malloc8d(this._mean.length);
            double[] vals = MemoryManager.malloc8d(chks[0]._len);
            int[] ids = MemoryManager.malloc4(chks[0]._len);
            for (int c2 = 0; c2 < this._mean.length; ++c2) {
                double mu = this._mean[c2];
                int n2 = chks[c2].getSparseDoubles(vals, ids);
                double s2 = 0.0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    double d2 = vals[i2];
                    if (Double.isNaN(d2)) continue;
                    d2 -= mu;
                    if (this._weightId != -1) {
                        s2 += weights[ids[i2]] * d2 * d2;
                        continue;
                    }
                    s2 += d2 * d2;
                }
                this._varSum[c2] = s2;
            }
        }

        @Override
        public void reduce(WeightedSDTask t2) {
            ArrayUtils.add(this._varSum, t2._varSum);
        }
    }

    static class GLMResDevTaskMultinomial
    extends FrameTask2<GLMResDevTaskMultinomial> {
        final double[][] _beta;
        double _likelihood;
        final int _nclasses;
        long _nobs;
        private transient double[] _sparseOffsets;

        public GLMResDevTaskMultinomial(Key jobKey, DataInfo dinfo, double[] beta, int nclasses) {
            super(null, dinfo, jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix(beta, beta.length / nclasses);
            this._nclasses = nclasses;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d(this._nclasses);
            if (this._sparse) {
                for (int c2 = 0; c2 < this._nclasses; ++c2) {
                    this._sparseOffsets[c2] = GLM.sparseOffset(this._beta[c2], this._dinfo);
                }
            }
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            int c2;
            ++this._nobs;
            double sumExp = 0.0;
            for (c2 = 0; c2 < this._nclasses; ++c2) {
                sumExp += Math.exp(r2.innerProduct(this._beta[c2]) + this._sparseOffsets[c2]);
            }
            c2 = (int)r2.response(0);
            this._likelihood -= r2.weight * (r2.innerProduct(this._beta[c2]) + this._sparseOffsets[c2] - Math.log(sumExp));
        }

        @Override
        public void reduce(GLMResDevTaskMultinomial gt) {
            this._nobs += gt._nobs;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._likelihood * 2.0 / (double)this._nobs;
        }

        public double dev() {
            return this._likelihood * 2.0;
        }
    }

    static class GLMResDevTaskOrdinal
    extends FrameTask2<GLMResDevTaskOrdinal> {
        final double[][] _beta;
        double _likelihood;
        final int _nclasses;
        final int _lastClass;
        final int _secondToLast;
        long _nobs;
        private transient double[] _sparseOffsets;

        public GLMResDevTaskOrdinal(Key jobKey, DataInfo dinfo, double[] beta, int nclasses) {
            super(null, dinfo, jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix(beta, beta.length / nclasses);
            this._nclasses = nclasses;
            this._lastClass = nclasses - 1;
            this._secondToLast = this._lastClass - 1;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d(this._nclasses);
            if (this._sparse) {
                for (int c2 = 0; c2 < this._nclasses; ++c2) {
                    this._sparseOffsets[c2] = GLM.sparseOffset(this._beta[c2], this._dinfo);
                }
            }
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            ++this._nobs;
            int c2 = (int)r2.response(0);
            if (c2 == 0) {
                double eta = r2.innerProduct(this._beta[0]) + this._sparseOffsets[c2];
                this._likelihood -= r2.weight * (eta - Math.log(1.0 + Math.exp(eta)));
            } else if (c2 == this._lastClass) {
                this._likelihood += r2.weight * Math.log(1.0 + Math.exp(r2.innerProduct(this._beta[this._secondToLast]) + this._sparseOffsets[c2]));
            } else {
                double eta = Math.exp(r2.innerProduct(this._beta[c2]) + this._sparseOffsets[c2]);
                double etaM1 = Math.exp(r2.innerProduct(this._beta[c2]) + this._sparseOffsets[c2 - 1]);
                this._likelihood -= r2.weight * Math.log(eta / (1.0 + eta) - etaM1 / (1.0 + etaM1));
            }
        }

        @Override
        public void reduce(GLMResDevTaskOrdinal gt) {
            this._nobs += gt._nobs;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._likelihood * 2.0 / (double)this._nobs;
        }

        public double dev() {
            return this._likelihood * 2.0;
        }
    }

    static class GLMResDevTask
    extends FrameTask2<GLMResDevTask> {
        final GLMModel.GLMWeightsFun _glmf;
        final double[] _beta;
        double _resDev = 0.0;
        long _nobs;
        double _likelihood;
        private transient GLMModel.GLMWeights _glmw;
        private final double _sparseOffset;

        public GLMResDevTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double[] beta) {
            super(null, dinfo, jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._beta = beta;
            this._sparseOffset = this._sparse ? GLM.sparseOffset(this._beta, this._dinfo) : 0.0;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            this._glmf.computeWeights(r2.response(0), r2.innerProduct(this._beta) + this._sparseOffset, r2.offset, r2.weight, this._glmw);
            this._resDev += this._glmw.dev;
            this._likelihood += this._glmw.l;
            ++this._nobs;
        }

        @Override
        public void reduce(GLMResDevTask gt) {
            this._nobs += gt._nobs;
            this._resDev += gt._resDev;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._resDev / (double)this._nobs;
        }

        public double dev() {
            return this._resDev;
        }
    }

    static class NullDevTask
    extends MRTask<NullDevTask> {
        double _nullDev;
        final double[] _ymu;
        final GLMModel.GLMWeightsFun _glmf;
        final boolean _hasWeights;
        final boolean _hasOffset;

        public NullDevTask(GLMModel.GLMWeightsFun glmf, double[] ymu, boolean hasWeights, boolean hasOffset) {
            this._glmf = glmf;
            this._ymu = ymu;
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
        }

        @Override
        public void map(Chunk[] chks) {
            int i2 = 0;
            int len = chks[0]._len;
            Chunk w2 = this._hasWeights ? chks[i2++] : new C0DChunk(1.0, len);
            Chunk o2 = this._hasOffset ? chks[i2++] : new C0DChunk(0.0, len);
            Chunk r2 = chks[i2];
            if (this._glmf._family != GLMModel.GLMParameters.Family.multinomial) {
                double ymu = this._glmf.link(this._ymu[0]);
                for (int j2 = 0; j2 < len; ++j2) {
                    this._nullDev += w2.atd(j2) * this._glmf.deviance(r2.atd(j2), this._glmf.linkInv(ymu + o2.atd(j2)));
                }
            } else {
                throw H2O.unimpl();
            }
        }

        @Override
        public void reduce(NullDevTask ndt) {
            this._nullDev += ndt._nullDev;
        }
    }
}

