/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DMatrix;
import hex.DataInfo;
import hex.GLMMetrics;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsHGLM;
import hex.ModelMetricsRegressionGLM;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.glm.ComputationState;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import hex.svd.SVD;
import hex.svd.SVDModel;
import hex.util.CheckpointUtils;
import hex.util.LinearAlgebraUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.Value;
import water.exceptions.H2OFailException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static NumberFormat lambdaFormatter = new DecimalFormat(".##E0");
    static NumberFormat devFormatter = new DecimalFormat(".##");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    public static final int SCORING_INTERVAL_MSEC = 15000;
    public int[] _randC;
    public String _generatedWeights = null;
    public String[] _randCoeffNames = null;
    public String[] _randomColNames = null;
    public double[][][] _penaltyMatrix = null;
    public String[][] _gamColnames = null;
    public int[][] _gamColIndices = null;
    public static int _totalBetaLen;
    public static int _betaLenPerClass;
    private boolean _earlyStopEnabled = false;
    private boolean _checkPointFirstIter = false;
    private boolean _betaConstraintsOn = false;
    private transient GLMDriver _driver;
    private double _lambdaCVEstimate = Double.NaN;
    private int _bestCVSubmodel;
    private boolean _doInit = true;
    private double[] _xval_deviances;
    private double[] _xval_sd;
    private double[] _xval_deviances_generate_SH;
    private double[] _xval_sd_generate_SH;
    private int[] _xval_iters_generate_SH;
    private boolean _insideCVCheck = false;
    private boolean _enumInCS = false;
    private Frame _betaConstraints = null;
    private boolean _cvRuns = false;
    DataInfo _dinfo;
    private transient DataInfo _validDinfo;
    private transient ScoringHistory _scoringHistory;
    private transient LambdaSearchScoringHistory _lambdaSearchScoringHistory;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private double _lmax;
    private double _gmax;
    private transient long _nobs;
    private transient GLMModel _model;
    private boolean _earlyStop = false;
    private GLMGradientInfo _ginfoStart;
    private double _betaDiffStart;
    private double[] _betaStart;
    private transient double[] _nullBeta;
    protected static final long WORK_TOTAL = 1000000L;
    transient Key[] _toRemove;
    private transient ComputationState _state;

    public GLM(boolean startup_once) {
        super(new GLMModel.GLMParameters(), startup_once);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms, double[][][] penaltyMatrix, String[][] gamColnames) {
        super(parms);
        this.init(false);
        this._penaltyMatrix = penaltyMatrix;
        this._gamColnames = gamColnames;
    }

    public GLM(GLMModel.GLMParameters parms, Key dest) {
        super(parms, dest);
        this.init(false);
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    @Override
    public boolean havePojo() {
        return true;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    public void computeCrossValidation() {
        this.init(true);
        this._cvRuns = true;
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        super.computeCrossValidation();
    }

    private double[] alignSubModelsAcrossCVModels(ModelBuilder[] cvModelBuilders) {
        int i2;
        double[] alphas = Arrays.stream(cvModelBuilders).mapToDouble(cv -> {
            GLM g2 = (GLM)cv;
            return ((GLMModel.GLMOutput)g2._model._output)._submodels[((GLMModel.GLMOutput)g2._model._output)._selected_submodel_idx].alpha_value;
        }).distinct().toArray();
        int[] alphaIndices = new int[alphas.length];
        int k2 = 0;
        for (int i3 = 0; i3 < ((GLMModel.GLMParameters)this._parms)._alpha.length; ++i3) {
            for (int j2 = 0; j2 < alphas.length; ++j2) {
                if (alphas[j2] != ((GLMModel.GLMParameters)this._parms)._alpha[i3]) continue;
                alphaIndices[k2] = i3;
                if (k2 < j2) {
                    double tmpAlpha = alphas[k2];
                    alphas[k2] = alphas[j2];
                    alphas[j2] = tmpAlpha;
                }
                ++k2;
            }
        }
        int[] alphaChangePoints = new int[alphas.length + 1];
        int[] alphaSubmodels = new int[((GLMModel.GLMParameters)this._parms)._alpha.length];
        for (i2 = 0; i2 < cvModelBuilders.length; ++i2) {
            GLM g2 = (GLM)cvModelBuilders[i2];
            Map<Double, List<GLMModel.Submodel>> submodels = Arrays.stream(((GLMModel.GLMOutput)g2._model._output)._submodels).collect(Collectors.groupingBy(sm -> sm.alpha_value));
            for (int j3 = 0; j3 < ((GLMModel.GLMParameters)this._parms)._alpha.length; ++j3) {
                alphaSubmodels[j3] = Math.max(alphaSubmodels[j3], submodels.containsKey(((GLMModel.GLMParameters)this._parms)._alpha[j3]) ? submodels.get(((GLMModel.GLMParameters)this._parms)._alpha[j3]).size() : 0);
            }
        }
        for (i2 = 0; i2 < alphas.length; ++i2) {
            alphaChangePoints[i2 + 1] = alphaChangePoints[i2] + alphaSubmodels[alphaIndices[i2]];
        }
        double[] alphasAndLambdas = new double[alphaChangePoints[alphas.length] * 2];
        for (int i4 = 0; i4 < cvModelBuilders.length; ++i4) {
            GLM g3 = (GLM)cvModelBuilders[i4];
            GLMModel.Submodel[] alignedSubmodels = new GLMModel.Submodel[alphaChangePoints[alphas.length]];
            double lastAlpha = -1.0;
            int alphaIdx = -1;
            k2 = 0;
            int nNullsUntilSelectedSubModel = 0;
            for (int j4 = 0; j4 < ((GLMModel.GLMOutput)g3._model._output)._submodels.length; ++j4) {
                if (lastAlpha != ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].alpha_value) {
                    lastAlpha = ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].alpha_value;
                    if (alphaIdx + 1 < alphas.length && lastAlpha == alphas[alphaIdx + 1]) {
                        k2 = 0;
                        ++alphaIdx;
                        if (((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx >= j4) {
                            nNullsUntilSelectedSubModel = alphaChangePoints[alphaIdx] - j4;
                        }
                    }
                }
                if (alphaIdx < 0 || ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].alpha_value != alphas[alphaIdx]) continue;
                alignedSubmodels[alphaChangePoints[alphaIdx] + k2] = ((GLMModel.GLMOutput)g3._model._output)._submodels[j4];
                assert (alphasAndLambdas[alphaChangePoints[alphaIdx] + k2] == 0.0 || alphasAndLambdas[alphaChangePoints[alphaIdx] + k2] == ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].alpha_value && alphasAndLambdas[alphaChangePoints[alphas.length] + alphaChangePoints[alphaIdx] + k2] == ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].lambda_value);
                alphasAndLambdas[alphaChangePoints[alphaIdx] + k2] = ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].alpha_value;
                alphasAndLambdas[alphaChangePoints[alphas.length] + alphaChangePoints[alphaIdx] + k2] = ((GLMModel.GLMOutput)g3._model._output)._submodels[j4].lambda_value;
                ++k2;
            }
            assert (((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx == ((GLMModel.GLMOutput)g3._model._output)._best_submodel_idx);
            assert (((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx == ((GLMModel.GLMOutput)g3._model._output)._best_lambda_idx);
            assert (((GLMModel.GLMOutput)g3._model._output)._submodels[((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx].alpha_value == alignedSubmodels[((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel].alpha_value && ((GLMModel.GLMOutput)g3._model._output)._submodels[((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx].lambda_value == alignedSubmodels[((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel].lambda_value);
            ((GLMModel.GLMOutput)g3._model._output)._submodels = alignedSubmodels;
            ((GLMModel.GLMOutput)g3._model._output).setSubmodelIdx(((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel, (GLMModel.GLMParameters)g3._parms);
        }
        return alphasAndLambdas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        int bestId1se;
        GLM g2;
        int i3;
        int i4;
        this.setMaxRuntimeSecsForMainModel();
        double bestTestDev = Double.POSITIVE_INFINITY;
        double[] alphasAndLambdas = this.alignSubModelsAcrossCVModels(cvModelBuilders);
        int numOfSubmodels = alphasAndLambdas.length / 2;
        int lmin_max = 0;
        boolean lambdasSorted = ((GLMModel.GLMParameters)this._parms)._lambda.length >= 1;
        for (i4 = 1; i4 < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i4) {
            if (!(((GLMModel.GLMParameters)this._parms)._lambda[i4] >= ((GLMModel.GLMParameters)this._parms)._lambda[i4 - 1])) continue;
            lambdasSorted = false;
            break;
        }
        if (lambdasSorted) {
            for (i4 = 0; i4 < cvModelBuilders.length; ++i4) {
                GLM g3 = (GLM)cvModelBuilders[i4];
                lmin_max = Math.max(lmin_max, ((GLMModel.GLMOutput)g3._model._output)._selected_submodel_idx + 1);
            }
        } else {
            lmin_max = numOfSubmodels;
        }
        this._xval_deviances = new double[lmin_max];
        this._xval_sd = new double[lmin_max];
        int bestId = 0;
        int cnt = 0;
        for (int lidx = 0; lidx < lmin_max; ++lidx) {
            double testDev = 0.0;
            double testDevSq = 0.0;
            for (int i5 = 0; i5 < cvModelBuilders.length; ++i5) {
                GLM g4 = (GLM)cvModelBuilders[i5];
                if (((GLMModel.GLMOutput)g4._model._output)._submodels[lidx] == null) {
                    double alpha = g4._state.alpha();
                    try {
                        g4._insideCVCheck = true;
                        g4._state.setAlpha(alphasAndLambdas[lidx]);
                        g4._driver.computeSubmodel(lidx, alphasAndLambdas[lidx + numOfSubmodels], Double.NaN, Double.NaN);
                    }
                    finally {
                        g4._insideCVCheck = false;
                        g4._state.setAlpha(alpha);
                    }
                }
                assert (alphasAndLambdas[lidx] == ((GLMModel.GLMOutput)g4._model._output)._submodels[lidx].alpha_value && alphasAndLambdas[lidx + numOfSubmodels] == ((GLMModel.GLMOutput)g4._model._output)._submodels[lidx].lambda_value);
                testDev += ((GLMModel.GLMOutput)g4._model._output)._submodels[lidx].devianceValid;
                testDevSq += ((GLMModel.GLMOutput)g4._model._output)._submodels[lidx].devianceValid * ((GLMModel.GLMOutput)g4._model._output)._submodels[lidx].devianceValid;
            }
            double testDevAvg = testDev / (double)cvModelBuilders.length;
            double testDevSE = testDevSq - testDevAvg * testDev;
            this._xval_sd[lidx] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
            this._xval_deviances[lidx] = testDevAvg;
            if (testDevAvg < bestTestDev) {
                bestTestDev = testDevAvg;
                bestId = lidx;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha != null && ((GLMModel.GLMParameters)this._parms)._alpha.length > 1 || !lambdasSorted || !(testDevAvg > bestTestDev) || ++cnt != 3) continue;
            lmin_max = lidx;
            break;
        }
        for (i3 = 0; i3 < cvModelBuilders.length; ++i3) {
            g2 = (GLM)cvModelBuilders[i3];
            if (g2._toRemove == null) continue;
            for (Key k2 : g2._toRemove) {
                Keyed.remove(k2);
            }
        }
        for (i3 = 0; i3 < cvModelBuilders.length; ++i3) {
            g2 = (GLM)cvModelBuilders[i3];
            ((GLMModel.GLMOutput)g2._model._output).setSubmodelIdx(bestId, (GLMModel.GLMParameters)g2._parms);
        }
        double bestDev = this._xval_deviances[bestId];
        double bestDev1se = bestDev + this._xval_sd[bestId];
        int finalBestId = bestId;
        Integer[] orderedLambdaIndices = (Integer[])IntStream.range(0, lmin_max).filter(i2 -> alphasAndLambdas[i2] == alphasAndLambdas[finalBestId]).boxed().sorted((a2, b2) -> (int)Math.signum(alphasAndLambdas[b2 + numOfSubmodels] - alphasAndLambdas[a2 + numOfSubmodels])).toArray(Integer[]::new);
        for (bestId1se = IntStream.range(0, orderedLambdaIndices.length).filter(i2 -> orderedLambdaIndices[i2] == finalBestId).findFirst().orElse(orderedLambdaIndices.length - 1); bestId1se > 0 && this._xval_deviances[orderedLambdaIndices[bestId1se - 1]] <= bestDev1se; --bestId1se) {
        }
        this._lambdaCVEstimate = alphasAndLambdas[numOfSubmodels + bestId];
        bestId1se = orderedLambdaIndices[bestId1se];
        ((GLMModel.GLMOutput)this._model._output)._lambda_1se = alphasAndLambdas[numOfSubmodels + bestId1se];
        ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{alphasAndLambdas[bestId]};
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            int newLminMax = 0;
            int newBestId = 0;
            for (int i6 = 0; i6 < lmin_max; ++i6) {
                if (alphasAndLambdas[i6] != ((GLMModel.GLMParameters)this._parms)._alpha[0]) continue;
                ++newLminMax;
                if (i6 >= bestId) continue;
                ++newBestId;
            }
            ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, newLminMax + 1);
            ((GLMModel.GLMOutput)this._model._output)._selected_submodel_idx = newBestId;
            this._bestCVSubmodel = newBestId;
            this._xval_deviances = Arrays.copyOfRange(this._xval_deviances, bestId - newBestId, lmin_max + 1);
            this._xval_sd = Arrays.copyOfRange(this._xval_sd, bestId - newBestId, lmin_max + 1);
        } else {
            ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{alphasAndLambdas[numOfSubmodels + bestId]};
            ((GLMModel.GLMOutput)this._model._output)._selected_submodel_idx = 0;
            this._bestCVSubmodel = 0;
        }
        if (((GLMModel.GLMParameters)this._parms)._generate_scoring_history) {
            this.generateCVScoringHistory(cvModelBuilders);
        }
        for (int i7 = 0; i7 < cvModelBuilders.length; ++i7) {
            GLM g5 = (GLM)cvModelBuilders[i7];
            GLMModel gm = g5._model;
            gm.write_lock(this._job);
            gm.update(this._job);
            gm.unlock(this._job);
        }
        if (this._betaConstraints != null) {
            DKV.remove(this._betaConstraints._key);
            this._betaConstraints.delete();
            this._betaConstraints = null;
        }
        this._doInit = false;
    }

    private void generateCVScoringHistory(ModelBuilder[] cvModelBuilders) {
        int devianceTestLength = Integer.MAX_VALUE;
        List[] cvModelIters = new List[cvModelBuilders.length];
        for (int i2 = 0; i2 < cvModelBuilders.length; ++i2) {
            GLM g2 = (GLM)cvModelBuilders[i2];
            if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                if (g2._lambdaSearchScoringHistory._lambdaDevTest.size() < devianceTestLength) {
                    devianceTestLength = g2._lambdaSearchScoringHistory._lambdaDevTest.size();
                }
                cvModelIters[i2] = new ArrayList(g2._lambdaSearchScoringHistory._lambdaIters);
                continue;
            }
            if (g2._scoringHistory._lambdaDevTest.size() < devianceTestLength) {
                devianceTestLength = g2._scoringHistory._lambdaDevTest.size();
            }
            cvModelIters[i2] = new ArrayList(g2._scoringHistory._scoringIters);
        }
        this._xval_deviances_generate_SH = new double[devianceTestLength];
        this._xval_sd_generate_SH = new double[devianceTestLength];
        this._xval_iters_generate_SH = new int[devianceTestLength];
        int countIndex = 0;
        for (int index = 0; index < devianceTestLength; ++index) {
            double testDev = 0.0;
            double testDevSq = 0.0;
            int[] foldIterIndex = GLM.findIterIndexAcrossFolds(cvModelIters, index);
            if (foldIterIndex == null) continue;
            this._xval_iters_generate_SH[countIndex] = (Integer)cvModelIters[0].get(index);
            for (int modelIndex = 0; modelIndex < cvModelBuilders.length; ++modelIndex) {
                GLM g3 = (GLM)cvModelBuilders[modelIndex];
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    testDev += ((Double)g3._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex])).doubleValue();
                    testDevSq += (Double)g3._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]) * (Double)g3._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]);
                    continue;
                }
                testDev += ((Double)g3._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex])).doubleValue();
                testDevSq += (Double)g3._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]) * (Double)g3._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]);
            }
            double testDevAvg = testDev / (double)cvModelBuilders.length;
            double testDevSE = testDevSq - testDevAvg * testDevAvg;
            this._xval_sd_generate_SH[countIndex] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
            this._xval_deviances_generate_SH[countIndex++] = testDevAvg;
        }
        this._xval_sd_generate_SH = Arrays.copyOf(this._xval_sd_generate_SH, countIndex);
        this._xval_deviances_generate_SH = Arrays.copyOf(this._xval_deviances_generate_SH, countIndex);
        this._xval_iters_generate_SH = Arrays.copyOf(this._xval_iters_generate_SH, countIndex);
    }

    public static int[] findIterIndexAcrossFolds(List<Integer>[] cvModelIters, int fold0Index) {
        int numFolds = cvModelIters.length;
        int[] iterIndexAcrossFolds = new int[numFolds];
        int fold0Iter = cvModelIters[0].get(fold0Index);
        iterIndexAcrossFolds[0] = fold0Index;
        for (int foldIndex = 1; foldIndex < numFolds; ++foldIndex) {
            if (cvModelIters[foldIndex].get(fold0Index) == fold0Iter) {
                iterIndexAcrossFolds[foldIndex] = fold0Index;
                continue;
            }
            int currFoldIterIndex = ArrayUtils.find(cvModelIters[foldIndex].toArray(), Integer.valueOf(fold0Iter));
            if (currFoldIterIndex < 0) {
                return null;
            }
            iterIndexAcrossFolds[foldIndex] = currFoldIterIndex;
        }
        return iterIndexAcrossFolds;
    }

    protected void checkMemoryFootPrint(DataInfo activeData) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM || ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
            int p2 = activeData.fullN();
            HeartBeat hb = H2O.SELF._heartbeat;
            long mem_usage = (long)((double)(hb._cpus_allowed * (p2 * p2 + activeData.largestCat()) * 8) * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            long max_mem = hb.get_free_mem();
            if (((GLMModel.GLMParameters)this._parms)._HGLM) {
                int expandedRandColValues = ArrayUtils.sum(this._randC);
                mem_usage = (long)(expandedRandColValues * expandedRandColValues * 5) + (this._nobs + (long)expandedRandColValues) * 5L;
            }
            if (mem_usage > max_mem) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes(mem_usage) + " > " + PrettyPrint.bytes(max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
            }
        }
    }

    @Override
    public int nclasses() {
        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            return this._nclass;
        }
        if (GLMModel.GLMParameters.Family.binomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.quasibinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.fractionalbinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            return 2;
        }
        return 1;
    }

    private double[] getNullBeta() {
        if (this._nullBeta == null) {
            if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this._nullBeta = MemoryManager.malloc8d((this._dinfo.fullN() + 1) * this.nclasses());
                int N2 = this._dinfo.fullN() + 1;
                if (((GLMModel.GLMParameters)this._parms)._intercept) {
                    if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                        int i2;
                        RandomBase rng = RandomUtils.getRNG(((GLMModel.GLMParameters)this._parms)._seed);
                        int lastClass = this.nclasses() - 1;
                        double[] tempIcpt = new double[lastClass];
                        for (i2 = 0; i2 < lastClass; ++i2) {
                            tempIcpt[i2] = (-1.0 + 2.0 * rng.nextDouble()) * (double)this.nclasses();
                        }
                        Arrays.sort(tempIcpt);
                        for (i2 = 0; i2 < lastClass; ++i2) {
                            this._nullBeta[this._dinfo.fullN() + i2 * N2] = tempIcpt[i2];
                        }
                    } else {
                        for (int i3 = 0; i3 < this.nclasses(); ++i3) {
                            this._nullBeta[this._dinfo.fullN() + i3 * N2] = Math.log(this._state._ymu[i3]);
                        }
                    }
                }
            } else {
                this._nullBeta = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
                this._nullBeta[this._dinfo.fullN()] = ((GLMModel.GLMParameters)this._parms)._intercept && !GLMModel.GLMParameters.Family.quasibinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)this._parms).link(this._state._ymu[0]) : 0.0;
            }
        }
        return this._nullBeta;
    }

    @Override
    protected boolean computePriorClassDistribution() {
        return GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && this.nclasses() > 2;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (this._response != null) {
            if (!this.isClassifier() && this._response.isCategorical()) {
                this.error("_response", H2O.technote(2, "Regression requires numeric response, got categorical."));
            }
            if ((GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("_solver", "Solvers GRADIENT_DESCENT_LH and GRADIENT_DESCENT_SQERR are only supported for ordinal regression.  Do not choose them unless you specify your family to be ordinal");
            }
            switch (((GLMModel.GLMParameters)this._parms)._family) {
                case AUTO: {
                    if (this.nclasses() == 1 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.identity && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.log && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.inverse) {
                        this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default, identity, log or inverse."));
                        break;
                    }
                    if (this.nclasses() == 2 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.logit) {
                        this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default or logit."));
                        break;
                    }
                    if (!(this.nclasses() > 2 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.multinomial)) break;
                    this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default or multinomial."));
                    break;
                }
                case binomial: {
                    if (this._response.isBinary() || this._nclass == 2) break;
                    this.error("_family", H2O.technote(2, "Binomial requires the response to be a 2-class categorical or a binary column (0/1)"));
                    break;
                }
                case multinomial: {
                    if (this._nclass > 2) break;
                    this.error("_family", H2O.technote(2, "Multinomial requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    break;
                }
                case poisson: 
                case negativebinomial: {
                    if (this._nclass != 1) {
                        this.error("_family", "Poisson and Negative Binomial require the response to be numeric.");
                    }
                    if (this._response.min() < 0.0) {
                        this.error("_family", "Poisson and Negative Binomial require response >= 0");
                    }
                    if (!this._response.isInt()) {
                        this.warn("_family", "Poisson and Negative Binomial expect non-negative integer response, got floats.");
                    }
                    if (!GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) break;
                    if (((GLMModel.GLMParameters)this._parms)._theta <= 0.0 || ((GLMModel.GLMParameters)this._parms)._theta > 1.0) {
                        this.error("_family", "Illegal Negative Binomial theta value.  Valid theta values be > 0 and <= 1.");
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._invTheta = 1.0 / ((GLMModel.GLMParameters)this._parms)._theta;
                    break;
                }
                case gamma: {
                    if (this._nclass != 1) {
                        this.error("_distribution", H2O.technote(2, "Gamma requires the response to be numeric."));
                    }
                    if (!(this._response.min() <= 0.0)) break;
                    this.error("_family", "Response value for gamma distribution must be greater than 0.");
                    break;
                }
                case tweedie: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote(2, "Tweedie requires the response to be numeric."));
                    break;
                }
                case quasibinomial: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote(2, "Quasi_binomial requires the response to be numeric."));
                    break;
                }
                case ordinal: {
                    if (this._nclass <= 2) {
                        this.error("_family", H2O.technote(2, "Ordinal requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    }
                    if (((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.oprobit && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.ologlog) break;
                    this.error("_link", "Ordinal regression only supports ologit as link.");
                    break;
                }
                case gaussian: {
                    break;
                }
                case fractionalbinomial: {
                    Object resp = this.train().vec(((GLMModel.GLMParameters)this._parms)._response_column);
                    if (!(((Vec)resp).min() < 0.0) && !(((Vec)resp).max() > 1.0)) break;
                    this.error("response", String.format("Response '%s' must be between 0 and 1 for fractional_binomial family. Min: %f, Max: %f", ((GLMModel.GLMParameters)this._parms)._response_column, ((Vec)resp).min(), ((Vec)resp).max()));
                    break;
                }
                default: {
                    this.error("_family", "Invalid distribution: " + (Object)((Object)((GLMModel.GLMParameters)this._parms)._distribution));
                }
            }
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values != null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() != GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "When plug values are provided - Missing Values Handling needs to be explicitly set to PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values == null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "No plug values frame provided for Missing Values Handling = PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._HGLM) {
            for (int randInx : ((GLMModel.GLMParameters)this._parms)._random_columns) {
                if (((GLMModel.GLMParameters)this._parms).train().vec(randInx).isCategorical()) continue;
                this.error("HGLM random_columns", "Must contain categorical columns.");
            }
        }
        if (expensive) {
            BetaConstraint bc;
            boolean skippingRows;
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == 0) {
                this.error("_max_iterations", H2O.technote(2, "if specified, must be >= 1."));
            }
            if (this.error_count() > 0) {
                return;
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._stopping_rounds > 0) {
                this.error("early stop", " cannot run when lambda_search=True.  Lambda_search has its own early-stopping mechanism");
            }
            if (!((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._stopping_rounds > 0) {
                this._earlyStopEnabled = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS ? 0.0 : 0.5};
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._nlambdas == -1) {
                ((GLMModel.GLMParameters)this._parms)._nlambdas = ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0 ? 30 : 100;
            }
            this._lambdaSearchScoringHistory = new LambdaSearchScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1);
            this._scoringHistory = new ScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1, ((GLMModel.GLMParameters)this._parms)._generate_scoring_history);
            this._train.bulkRollups();
            this._t0 = System.currentTimeMillis();
            if ((((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) && !((GLMModel.GLMParameters)this._parms)._HGLM) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
                ((GLMModel.GLMParameters)this._parms)._family = this._nclass == 1 ? GLMModel.GLMParameters.Family.gaussian : (this._nclass == 2 ? GLMModel.GLMParameters.Family.binomial : GLMModel.GLMParameters.Family.multinomial);
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            if (((GLMModel.GLMParameters)this._parms)._plug_values != null) {
                Frame plugValues = ((GLMModel.GLMParameters)this._parms)._plug_values.get();
                if (plugValues == null) {
                    this.error("_plug_values", "Supplied plug values frame with key=`" + ((GLMModel.GLMParameters)this._parms)._plug_values + "` doesn't exist.");
                } else if (plugValues.numRows() != 1L) {
                    this.error("_plug_values", "Plug values frame needs to have exactly 1 row.");
                }
            }
            if (this.hasOffsetCol() && GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.warn("offset_column", " has no effect on multinomial and will be ignored.");
                if (((GLMModel.GLMParameters)this._parms)._ignored_columns != null) {
                    List<String> ignoredCols = Arrays.asList(((GLMModel.GLMParameters)this._parms)._ignored_columns);
                    ignoredCols.add(((GLMModel.GLMParameters)this._parms)._offset_column);
                    ((GLMModel.GLMParameters)this._parms)._ignored_columns = ignoredCols.toArray(new String[0]);
                } else {
                    ((GLMModel.GLMParameters)this._parms)._ignored_columns = new String[]{((GLMModel.GLMParameters)this._parms)._offset_column};
                }
                ((GLMModel.GLMParameters)this._parms)._offset_column = null;
                this._offset = null;
            }
            if (this.hasOffsetCol() && GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("offset_column", " does not work with ordinal family right now.  Will be fixed in the future.");
            }
            if ((((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || ((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) && (((GLMModel.GLMParameters)this._parms)._beta_constraints != null || ((GLMModel.GLMParameters)this._parms)._non_negative)) {
                this.error(((GLMModel.GLMParameters)this._parms)._non_negative ? "non_negative" : "beta_constraints", " does not work with " + (Object)((Object)((GLMModel.GLMParameters)this._parms)._family) + " family.");
            }
            boolean standardizeQ = ((GLMModel.GLMParameters)this._parms)._HGLM ? false : ((GLMModel.GLMParameters)this._parms)._standardize;
            this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, standardizeQ ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GLMModel.GLMParameters)this._parms).imputeMissing(), ((GLMModel.GLMParameters)this._parms).makeImputer(), false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol(), ((GLMModel.GLMParameters)this._parms).interactionSpec());
            _totalBetaLen = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? (this._dinfo.fullN() + 1) * this.nclasses() : this._dinfo.fullN() + 1;
            int n2 = _betaLenPerClass = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? _totalBetaLen / this.nclasses() : _totalBetaLen;
            if (GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType)) {
                this._gamColIndices = GLMUtils.extractAdaptedFrameIndices(this._dinfo._adaptedFrame, this._gamColnames, this._dinfo._numOffsets[0] - this._dinfo._cats);
            }
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses;
                int n3 = numclasses = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? this.nclasses() : 1;
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS) {
                    int n4 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses : numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] > 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations *= 10;
                    }
                } else {
                    int n5 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : 50;
                }
            }
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
            }
            this._state = new ComputationState(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, null, this.nclasses(), this._penaltyMatrix, this._gamColIndices);
            boolean bl = skippingRows = ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip && this._train.hasNAs();
            if (this.hasWeightCol() || skippingRows) {
                GLMTask.YMUTask ymt;
                boolean setWeights = skippingRows;
                if (setWeights) {
                    Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
                    this._generatedWeights = "__glm_gen_weights";
                    this._dinfo.setWeights("__glm_gen_weights", wc);
                }
                if ((ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(this._dinfo, GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? this.nclasses() : 1, setWeights, skippingRows, true, false).doAll(this._dinfo._adaptedFrame)).wsum() == 0.0) {
                    throw new IllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or impute your missing values prior to calling glm.");
                }
                Log.info(this.LogMsg("using " + ymt.nobs() + " nobs out of " + this._dinfo._adaptedFrame.numRows() + " total"));
                this._nobs = ymt.nobs();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / ymt.wsum();
                }
                if (!((GLMModel.GLMParameters)this._parms)._stdOverride) {
                    this._dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
                }
                if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._state._ymu = MemoryManager.malloc8d(this._nclass);
                    for (int i2 = 0; i2 < this._state._ymu.length; ++i2) {
                        this._state._ymu[i2] = this._priorClassDist[i2];
                    }
                } else {
                    double[] dArray;
                    if (((GLMModel.GLMParameters)this._parms)._intercept) {
                        dArray = ymt._yMu;
                    } else {
                        double[] dArray2 = new double[1];
                        dArray = dArray2;
                        dArray2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(0.0);
                    }
                    this._state._ymu = dArray;
                }
            } else {
                this._nobs = this._train.numRows();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / (double)this._nobs;
                }
                if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._state._ymu = MemoryManager.malloc8d(this._nclass);
                    for (int i3 = 0; i3 < this._state._ymu.length; ++i3) {
                        this._state._ymu[i3] = this._priorClassDist[i3];
                    }
                } else {
                    this._state._ymu = new double[]{((GLMModel.GLMParameters)this._parms)._intercept ? this._train.lastVec().mean() : ((GLMModel.GLMParameters)this._parms).linkInv(0.0)};
                }
            }
            boolean betaContsOn = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null || ((GLMModel.GLMParameters)this._parms)._non_negative;
            boolean bl2 = this._betaConstraintsOn = betaContsOn && (GLMModel.GLMParameters.Solver.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.COORDINATE_DESCENT.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)this._parms)._solver));
            if (((GLMModel.GLMParameters)this._parms)._beta_constraints != null && !this._enumInCS && GLMUtils.findEnumInBetaCS(((GLMModel.GLMParameters)this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)this._parms)) {
                if (this._betaConstraints == null) {
                    this._betaConstraints = GLMUtils.expandedCatCS(((GLMModel.GLMParameters)this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)this._parms);
                    DKV.put(this._betaConstraints);
                }
                this._enumInCS = true;
            }
            BetaConstraint betaConstraint = bc = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null ? new BetaConstraint(((GLMModel.GLMParameters)this._parms)._beta_constraints.get()) : new BetaConstraint();
            if (betaContsOn && !this._betaConstraintsOn) {
                this.warn("Beta Constraints", " will be disabled except for solver AUTO, COORDINATE_DESCENT, IRLSM or L_BFGS.  It is not available for ordinal or multinomial families.");
            }
            if ((bc.hasBounds() || bc.hasProximalPenalty()) && ((GLMModel.GLMParameters)this._parms)._compute_p_values) {
                this.error("_compute_p_values", "P-values can not be computed for constrained problems");
            }
            if (bc.hasBounds() && ((GLMModel.GLMParameters)this._parms)._early_stopping) {
                this.warn("beta constraint and early_stopping", "if both are enabled may degrade model performance.");
            }
            this._state.setBC(bc);
            if (this.hasOffsetCol() && ((GLMModel.GLMParameters)this._parms)._intercept && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                GLMGradientSolver gslvr = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType) ? new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC(), this._penaltyMatrix, this._gamColIndices) : new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC());
                double[] x2 = new L_BFGS().solve((OptimizationUtils.GradientSolver)gslvr, (double[])new double[]{-this._offset.mean()}).coefs;
                Log.info(this.LogMsg("fitted intercept = " + x2[0]));
                x2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(x2[0]);
                this._state._ymu = x2;
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(this._state._ymu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - this._state._ymu[0])));
            }
            ArrayList<Vec> vecs = new ArrayList<Vec>();
            if (this._weights != null) {
                vecs.add(this._weights);
            }
            if (this._offset != null) {
                vecs.add(this._offset);
            }
            vecs.add(this._response);
            double[] beta = this.getNullBeta();
            if (((GLMModel.GLMParameters)this._parms)._HGLM) {
                this.setHGLMInitValues(beta);
                ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{0.0};
            } else {
                if (((GLMModel.GLMParameters)this._parms)._startval != null) {
                    if (((GLMModel.GLMParameters)this._parms)._startval.length != beta.length) {
                        throw new IllegalArgumentException("Initial coefficient length (" + ((GLMModel.GLMParameters)this._parms)._startval.length + ") does not equal to actual GLM coefficient length(" + beta.length + ").\n  The order of coefficients should be the following:\n" + String.join((CharSequence)"\n", this._dinfo._adaptedFrame._names) + "\n Intercept.\n  Run your model without specifying startval to find out the actual coefficients names and lengths.");
                    }
                    System.arraycopy(((GLMModel.GLMParameters)this._parms)._startval, 0, beta, 0, beta.length);
                }
                GLMGradientInfo ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType) ? new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC(), this._penaltyMatrix, this._gamColIndices).getGradient(beta) : new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC()).getGradient(beta);
                this._lmax = this.lmax(ginfo._gradient);
                this._gmax = this._lmax * Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
                this._state.setLambdaMax(this._lmax);
                this._state.setgMax(this._gmax);
                if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                    double d2 = ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._nobs >> 4 > (long)this._dinfo.fullN() ? 1.0E-4 : 0.01;
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio *= 0.01;
                    }
                }
                this._betaStart = new double[beta.length];
                System.arraycopy(beta, 0, this._betaStart, 0, beta.length);
                this._state.updateState(beta, ginfo);
                if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                    if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                        ((GLMModel.GLMParameters)this._parms)._lambda = new double[((GLMModel.GLMParameters)this._parms)._nlambdas];
                        double dec = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                        ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._lmax;
                        double l2 = this._lmax;
                        for (int i4 = 1; i4 < ((GLMModel.GLMParameters)this._parms)._nlambdas; ++i4) {
                            ((GLMModel.GLMParameters)this._parms)._lambda[i4] = l2 *= dec;
                        }
                    } else {
                        ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{10.0 * ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio * this._lmax};
                    }
                }
                if (!Double.isNaN(this._lambdaCVEstimate)) {
                    for (int i5 = 0; i5 < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i5) {
                        if (!(((GLMModel.GLMParameters)this._parms)._lambda[i5] < this._lambdaCVEstimate)) continue;
                        ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, i5 + 1);
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
                    ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._objective_epsilon == -1.0) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._objective_epsilon = 1.0E-4;
                } else {
                    double d3 = ((GLMModel.GLMParameters)this._parms)._objective_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._gradient_epsilon == -1.0) {
                double d4 = ((GLMModel.GLMParameters)this._parms)._gradient_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._gradient_epsilon *= 0.01;
                }
            }
            if (((GLMModel.GLMParameters)this._parms).hasCheckpoint()) {
                if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._checkPointFirstIter = true;
                }
                if (!GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
                    this.error("_checkpoint", "GLM checkpoint is supported only for IRLSM.  Please specify it explicitly.  Do not use AUTO or default");
                }
                Value cv = DKV.get(((GLMModel.GLMParameters)this._parms)._checkpoint);
                CheckpointUtils.getAndValidateCheckpointModel(this, GLMModel.GLMParameters.CHECKPOINT_NON_MODIFIABLE_FIELDS, cv);
            }
            this.buildModel();
        }
    }

    public void setHGLMInitValues(double[] beta) {
        this._randC = new int[((GLMModel.GLMParameters)this._parms)._random_columns.length];
        this._randomColNames = new String[((GLMModel.GLMParameters)this._parms)._random_columns.length];
        for (int rcInd = 0; rcInd < ((GLMModel.GLMParameters)this._parms)._random_columns.length; ++rcInd) {
            this._randC[rcInd] = ((GLMModel.GLMParameters)this._parms).train().vec(((GLMModel.GLMParameters)this._parms)._random_columns[rcInd]).cardinality();
            this._randomColNames[rcInd] = ((GLMModel.GLMParameters)this._parms).train().name(((GLMModel.GLMParameters)this._parms)._random_columns[rcInd]);
        }
        int fixedEffectSize = beta.length;
        int randomEffectSize = ArrayUtils.sum(this._randC);
        this._randCoeffNames = this.findExpandedRandColNames();
        double tau = 0.0;
        double[] phi = new double[randomEffectSize];
        double[] psi = new double[randomEffectSize];
        double[] ubeta = new double[randomEffectSize];
        double hlcorrection = 0.0;
        Vec tempVec = Vec.makeOne(randomEffectSize);
        Frame randWeights = new Frame(tempVec.makeOnes(3));
        randWeights.setNames(new String[]{"prior_weghts", "wpsi", "zmi"});
        if (((GLMModel.GLMParameters)this._parms)._startval == null) {
            GLMModel tempModel = this.runGLMModel(((GLMModel.GLMParameters)this._parms)._standardize, GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Link.family_default, ((GLMModel.GLMParameters)this._parms)._train, ((GLMModel.GLMParameters)this._parms)._response_column, null, ((GLMModel.GLMParameters)this._parms)._ignored_columns, false);
            System.arraycopy(tempModel.beta(), 0, beta, 0, beta.length);
            ModelMetricsRegressionGLM tMetric = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)tempModel._output)._training_metrics;
            double init_sig_e = 0.6 * tMetric.residual_deviance() / (double)tMetric.residual_degrees_of_freedom();
            double init_sig_u = init_sig_e * 0.66;
            init_sig_e = this.restrictMag(init_sig_e);
            init_sig_u = this.restrictMag(init_sig_u);
            Arrays.fill(phi, init_sig_u / (double)this._randC.length);
            tau = init_sig_e;
            this._state.setHGLMComputationState(beta, ubeta, psi, phi, hlcorrection, tau, randWeights, this._randCoeffNames);
            tempModel.remove();
            tMetric.remove();
        } else {
            this.copyUserInitialValues(fixedEffectSize, randomEffectSize, beta, ubeta, phi, hlcorrection, psi, randWeights, this._randCoeffNames);
            ((GLMModel.GLMParameters)this._parms)._startval = null;
        }
    }

    private String[] findExpandedRandColNames() {
        String[] randExpandedColNames = new String[ArrayUtils.sum(this._randC)];
        int numRandCols = this._randC.length;
        String[] randColNames = new String[numRandCols];
        int offset = 0;
        for (int index = 0; index < numRandCols; ++index) {
            int randomColIndex = ((GLMModel.GLMParameters)this._parms)._random_columns[index];
            String[] domains = ((GLMModel.GLMParameters)this._parms).train().vec(randomColIndex).domain();
            int domainLen = domains.length;
            randColNames[index] = ((GLMModel.GLMParameters)this._parms).train().name(randomColIndex);
            for (int insideInd = 0; insideInd < domainLen; ++insideInd) {
                randExpandedColNames[offset + insideInd] = randColNames[index] + "_" + insideInd;
            }
            offset += domainLen;
        }
        return randExpandedColNames;
    }

    public double restrictMag(double val) {
        if (val < 1.0E-4) {
            return 0.1;
        }
        return val;
    }

    public void copyUserInitialValues(int fixedEffectSize, int randomEffectSize, double[] beta, double[] ubeta, double[] phi, double hlcorrection, double[] psi, Frame randWeights, String[] randCoeffNames) {
        int off = 0;
        int lengthLimit = fixedEffectSize;
        int totalstartvallen = fixedEffectSize + randomEffectSize + this._randC.length + 1;
        assert (((GLMModel.GLMParameters)this._parms)._startval.length == totalstartvallen) : "Expected startval length: " + totalstartvallen + ", Actual startval length: " + ((GLMModel.GLMParameters)this._parms)._startval.length;
        for (int fixedInd = off; fixedInd < lengthLimit; ++fixedInd) {
            beta[fixedInd] = ((GLMModel.GLMParameters)this._parms)._startval[fixedInd];
        }
        lengthLimit += randomEffectSize;
        for (int randomInd = off += fixedEffectSize; randomInd < lengthLimit; ++randomInd) {
            ubeta[randomInd - off] = ((GLMModel.GLMParameters)this._parms)._startval[randomInd];
        }
        lengthLimit += this._randC.length;
        int sig_u_off = 0;
        for (int siguInd = off += randomEffectSize; siguInd < lengthLimit; ++siguInd) {
            double init_sig_u = ((GLMModel.GLMParameters)this._parms)._startval[siguInd];
            for (int index = 0; index < this._randC[siguInd - off]; ++index) {
                phi[index + sig_u_off] = init_sig_u;
            }
            sig_u_off += this._randC[siguInd - off];
        }
        double tau = ((GLMModel.GLMParameters)this._parms)._startval[lengthLimit];
        if (tau < 1.0E-4 || ArrayUtils.minValue(phi) < 1.0E-4) {
            this.error("init_sig_u, init_sig_e", "unacceptable initial values supplied for variance parameter or dispersion parameter of the random effects.  They need to exceed 0.0001.");
        }
        this._state.setHGLMComputationState(beta, ubeta, psi, phi, hlcorrection, tau, randWeights, randCoeffNames);
    }

    private GLMModel runGLMModel(boolean standardize, GLMModel.GLMParameters.Family family, GLMModel.GLMParameters.Link link, Key<Frame> trainKey, String responseColName, String weightColumns, String[] ignored_columns, boolean computePValue) {
        GLMModel.GLMParameters tempParams = new GLMModel.GLMParameters();
        tempParams._train = trainKey;
        tempParams._family = family;
        tempParams._link = link;
        tempParams._lambda = new double[]{0.0};
        tempParams._standardize = standardize;
        tempParams._response_column = responseColName;
        tempParams._ignored_columns = ignored_columns;
        tempParams._weights_column = weightColumns;
        tempParams._compute_p_values = computePValue;
        tempParams._useDispersion1 = computePValue;
        GLMModel model = (GLMModel)new GLM(tempParams).trainModel().get();
        return model;
    }

    private void restoreScoringHistoryFromCheckpoint() {
        String[] stringArray;
        TwoDimTable scoringHistory = ((GLMModel.GLMOutput)this._model._output)._scoring_history;
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "iteration";
            stringArray2[1] = "timestamp";
            stringArray2[2] = "lambda";
            stringArray2[3] = "predictors";
            stringArray2[4] = "deviance_train";
            stringArray2[5] = "deviance_test";
            stringArray = stringArray2;
            stringArray2[6] = "alpha";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "iteration";
            stringArray3[1] = "timestamp";
            stringArray3[2] = "negative_log_likelihood";
            stringArray3[3] = "objective";
            stringArray3[4] = "sum(etai-eta0)^2";
            stringArray = stringArray3;
            stringArray3[5] = "convergence";
        }
        String[] colHeaders2Restore = stringArray;
        int num2Copy = ((GLMModel.GLMParameters)this._parms)._HGLM || ((GLMModel.GLMParameters)this._parms)._lambda_search ? colHeaders2Restore.length : colHeaders2Restore.length - 2;
        int[] colHeadersIndex = GLM.grabHeaderIndex(scoringHistory, num2Copy, colHeaders2Restore);
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            this._lambdaSearchScoringHistory.restoreFromCheckpoint(scoringHistory, colHeadersIndex);
        } else {
            this._scoringHistory.restoreFromCheckpoint(scoringHistory, colHeadersIndex, ((GLMModel.GLMParameters)this._parms)._HGLM);
        }
    }

    static int[] grabHeaderIndex(TwoDimTable sHist, int numHeaders, String[] colHeadersUseful) {
        int[] colHeadersIndex = new int[numHeaders];
        List<String> colHeadersList = Arrays.asList(sHist.getColHeaders());
        for (int colInd = 0; colInd < numHeaders; ++colInd) {
            if (colInd == 0) {
                int indexFound = colHeadersList.indexOf(colHeadersUseful[colInd]);
                if (indexFound < 0) {
                    indexFound = colHeadersList.indexOf(colHeadersUseful[colInd] + "s");
                }
                colHeadersIndex[colInd] = indexFound;
                continue;
            }
            colHeadersIndex[colInd] = colHeadersList.indexOf(colHeadersUseful[colInd]);
        }
        return colHeadersIndex;
    }

    private void buildModel() {
        if (((GLMModel.GLMParameters)this._parms).hasCheckpoint()) {
            GLMModel model = ((GLMModel)DKV.getGet(((GLMModel.GLMParameters)this._parms)._checkpoint)).deepClone(this._result);
            model._parms = this._parms;
            this._model = model;
            this.restoreScoringHistoryFromCheckpoint();
        } else {
            this._model = new GLMModel(this._result, (GLMModel.GLMParameters)this._parms, this, this._state._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._lmax, this._nobs);
        }
        ((GLMModel.GLMOutput)this._model._output).setLambdas((GLMModel.GLMParameters)this._parms);
        ((GLMModel.GLMOutput)this._model._output)._ymu = (double[])this._state._ymu.clone();
        this._model.delete_and_lock(this._job);
    }

    private Key[] removeLater(Key ... k2) {
        this._toRemove = this._toRemove == null ? k2 : ArrayUtils.append(this._toRemove, k2);
        return k2;
    }

    @Override
    protected GLMDriver trainModelImpl() {
        this._driver = new GLMDriver();
        return this._driver;
    }

    private final double lmax(double[] grad) {
        if (GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType)) {
            int totGamCols = 0;
            for (int numG = 0; numG < this._penaltyMatrix.length; ++numG) {
                totGamCols += this._penaltyMatrix[numG].length;
            }
            int endIndex = grad.length - totGamCols;
            return Math.max(ArrayUtils.maxValue(grad, 0, endIndex), -ArrayUtils.minValue(grad, 0, endIndex)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
        }
        return Math.max(ArrayUtils.maxValue(grad), -ArrayUtils.minValue(grad)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private boolean updateEarlyStop() {
        return this._earlyStop || ScoreKeeper.stopEarly(this._model.scoreKeepers(), ((GLMModel.GLMParameters)this._parms)._stopping_rounds, ScoreKeeper.ProblemType.forSupervised(this._nclass > 1), ((GLMModel.GLMParameters)this._parms)._stopping_metric, ((GLMModel.GLMParameters)this._parms)._stopping_tolerance, "model's last", true);
    }

    private GLMModel.GLMParameters.Solver defaultSolver() {
        GLMModel.GLMParameters.Solver s2 = GLMModel.GLMParameters.Solver.IRLSM;
        if (((GLMModel.GLMParameters)this._parms)._remove_collinear_columns) {
            Log.info(this.LogMsg("picked solver " + (Object)((Object)s2)));
            ((GLMModel.GLMParameters)this._parms)._solver = s2;
            return s2;
        }
        int max_active = 0;
        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            for (int c2 = 0; c2 < this._nclass; ++c2) {
                max_active += this._state.activeDataMultinomial(c2).fullN();
            }
        } else {
            max_active = this._state.activeData().fullN();
        }
        if (max_active >= 5000) {
            s2 = GLMModel.GLMParameters.Solver.L_BFGS;
        } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            s2 = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (this._state.activeBC().hasBounds() && !this._state.activeBC().hasProximalPenalty()) {
            s2 = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
            s2 = GLMModel.GLMParameters.Solver.L_BFGS;
        } else {
            Log.info(this.LogMsg("picked solver " + (Object)((Object)s2)));
        }
        if (s2 != GLMModel.GLMParameters.Solver.L_BFGS && ((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
            ((GLMModel.GLMParameters)this._parms)._max_active_predictors = 5000;
        }
        ((GLMModel.GLMParameters)this._parms)._solver = s2;
        return s2;
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        BetaConstraint bc = this._state.activeBC();
        if (this._state.activeBC()._betaGiven != null && bc._rho != null) {
            for (int i2 = 0; i2 < bc._betaGiven.length; ++i2) {
                double diff = beta[i2] - bc._betaGiven[i2];
                proximalPen += diff * diff * bc._rho[i2];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm(beta, ((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2(beta, ((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private String LogMsg(String msg) {
        return "GLM[dest=" + this.dest() + ", " + this._state + "] " + msg;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        return GLM.expandVec(beta, activeCols, fullN, 0.0);
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN, double filler) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d(fullN);
        Arrays.fill(res, filler);
        int i2 = 0;
        for (int c2 : activeCols) {
            res[c2] = beta[i2++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static double[] doUpdateCD(double[] grads, double[] ary, double diff, int variable_min, int variable_max) {
        int i2;
        for (i2 = 0; i2 < variable_min; ++i2) {
            int n2 = i2;
            grads[n2] = grads[n2] + diff * ary[i2];
        }
        for (i2 = variable_max; i2 < grads.length; ++i2) {
            int n3 = i2;
            grads[n3] = grads[n3] + diff * ary[i2];
        }
        return grads;
    }

    public double[] COD_solve(ComputationState.GramXY gram, double alpha, double lambda) {
        double[] res = this.COD_solve(gram.gram.getXX(), gram.xy, gram.getCODGradients(), gram.newCols, alpha, lambda);
        gram.newCols = new int[0];
        return res;
    }

    private double[] COD_solve(double[][] xx, double[] xy, double[] grads, int[] newCols, double alpha, double lambda) {
        double wsumInv = 1.0 / xx[xx.length - 1][xx.length - 1];
        double betaEpsilon = ((GLMModel.GLMParameters)this._parms)._beta_epsilon * ((GLMModel.GLMParameters)this._parms)._beta_epsilon;
        double updateEpsilon = 0.01 * betaEpsilon;
        double l1pen = lambda * alpha;
        double l2pen = lambda * (1.0 - alpha);
        double[] diagInv = MemoryManager.malloc8d(xx.length);
        for (int i2 = 0; i2 < diagInv.length; ++i2) {
            diagInv[i2] = 1.0 / (xx[i2][i2] + l2pen);
        }
        DataInfo activeData = this._state.activeData();
        int[][] nzs = new int[activeData.numStart()][];
        int sparseCnt = 0;
        if (nzs.length > 1000) {
            int[] nzs_ary = new int[xx.length];
            for (int i3 = 0; i3 < activeData._cats; ++i3) {
                int var_min = activeData._catOffsets[i3];
                int var_max = activeData._catOffsets[i3 + 1];
                for (int l2 = var_min; l2 < var_max; ++l2) {
                    int j2;
                    int k2 = 0;
                    double[] x2 = xx[l2];
                    for (j2 = 0; j2 < var_min; ++j2) {
                        if (x2[j2] == 0.0) continue;
                        nzs_ary[k2++] = j2;
                    }
                    for (j2 = var_max; j2 < activeData.numStart(); ++j2) {
                        if (x2[j2] == 0.0) continue;
                        nzs_ary[k2++] = j2;
                    }
                    if (k2 >= nzs_ary.length - var_max + var_min >> 3) continue;
                    ++sparseCnt;
                    nzs[l2] = Arrays.copyOf(nzs_ary, k2);
                }
            }
        }
        BetaConstraint bc = this._state.activeBC();
        double[] beta = (double[])this._state.beta().clone();
        int numStart = activeData.numStart();
        if (newCols != null) {
            for (int id : newCols) {
                double b2 = bc.applyBounds(ADMM.shrinkage(grads[id], l1pen) * diagInv[id], id);
                if (b2 == 0.0) continue;
                GLM.doUpdateCD(grads, xx[id], -b2, id, id + 1);
                beta[id] = b2;
            }
        }
        int iter1 = 0;
        int P2 = xy.length - 1;
        double maxDiff = 0.0;
        while (iter1++ < Math.max(P2, 500)) {
            int i4;
            maxDiff = 0.0;
            for (i4 = 0; i4 < activeData._cats; ++i4) {
                for (int j3 = activeData._catOffsets[i4]; j3 < activeData._catOffsets[i4 + 1]; ++j3) {
                    double b3 = bc.applyBounds(ADMM.shrinkage(grads[j3], l1pen) * diagInv[j3], j3);
                    double bd = beta[j3] - b3;
                    if (bd == 0.0) continue;
                    double diff = bd * bd * xx[j3][j3];
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    if (nzs[j3] == null) {
                        GLM.doUpdateCD(grads, xx[j3], bd, activeData._catOffsets[i4], activeData._catOffsets[i4 + 1]);
                    } else {
                        int[] ids;
                        double[] x3 = xx[j3];
                        int[] nArray = ids = nzs[j3];
                        int n2 = nArray.length;
                        for (int i5 = 0; i5 < n2; ++i5) {
                            int id;
                            int n3 = id = nArray[i5];
                            grads[n3] = grads[n3] + bd * x3[id];
                        }
                        GLM.doUpdateCD(grads, x3, bd, 0, activeData.numStart());
                    }
                    beta[j3] = b3;
                }
            }
            for (i4 = numStart; i4 < P2; ++i4) {
                double b4 = bc.applyBounds(ADMM.shrinkage(grads[i4], l1pen) * diagInv[i4], i4);
                double bd = beta[i4] - b4;
                double diff = bd * bd * xx[i4][i4];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                if (!(diff > updateEpsilon)) continue;
                GLM.doUpdateCD(grads, xx[i4], bd, i4, i4 + 1);
                beta[i4] = b4;
            }
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                double b5 = bc.applyBounds(grads[P2] * wsumInv, P2);
                double bd = beta[P2] - b5;
                double diff = bd * bd * xx[P2][P2];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                GLM.doUpdateCD(grads, xx[P2], bd, P2, P2 + 1);
                beta[P2] = b5;
            }
            if (!(maxDiff < betaEpsilon)) continue;
            break;
        }
        return beta;
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i2 = 0; i2 < dinfo._nums; ++i2) {
                etaOffset -= beta[i2 + ns] * dinfo._normSub[i2] * dinfo._normMul[i2];
            }
        }
        return etaOffset;
    }

    public static class PlugValuesImputer
    implements DataInfo.Imputer {
        private final Frame _plug_vals;

        public PlugValuesImputer(Frame plugValues) {
            this._plug_vals = plugValues;
        }

        @Override
        public int imputeCat(String name, Vec v2, boolean useAllFactorLevels) {
            String value;
            String[] domain = v2.domain();
            Vec pvec = this.pvec(name);
            if (pvec.isCategorical()) {
                value = pvec.domain()[(int)pvec.at(0L)];
            } else if (pvec.isString()) {
                value = pvec.stringAt(0L);
            } else {
                throw new IllegalStateException("Plug value for a categorical column `" + name + "` cannot by of type " + pvec.get_type_str() + "!");
            }
            int valueIndex = ArrayUtils.find(domain, value);
            if (valueIndex < 0) {
                throw new IllegalStateException("Plug value `" + value + "` of column `" + name + "` is not a member of the column's domain!");
            }
            return valueIndex;
        }

        @Override
        public double imputeNum(String name, Vec v2) {
            Vec pvec = this.pvec(name);
            if (v2.isNumeric() || v2.isTime()) {
                return pvec.at(0L);
            }
            throw new IllegalStateException("Plug value for a column `" + name + "` of type " + v2.get_type_str() + " cannot by of type " + pvec.get_type_str() + "!");
        }

        @Override
        public double[] imputeInteraction(String name, InteractionWrappedVec iv, double[] means) {
            if (iv.isNumericInteraction()) {
                return new double[]{this.imputeNum(name, iv)};
            }
            assert (iv.v1Domain() == null || iv.v2Domain() == null);
            String[] domain = iv.v1Domain() != null ? iv.v1Domain() : iv.v2Domain();
            double[] vals = new double[domain.length];
            for (int i2 = 0; i2 < domain.length; ++i2) {
                vals[i2] = this.pvec(name + "." + domain[i2]).at(0L);
            }
            return vals;
        }

        private Vec pvec(String name) {
            Vec pvec = this._plug_vals.vec(name);
            if (pvec == null) {
                throw new IllegalStateException("Plug value for column `" + name + "` is not defined!");
            }
            return pvec;
        }
    }

    public final class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
        }

        public void setNonNegative() {
            if (this._betaLB == null) {
                this._betaLB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + 1);
                this._betaLB[GLM.this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
            } else {
                for (int i2 = 0; i2 < this._betaLB.length - 1; ++i2) {
                    this._betaLB[i2] = Math.max(0.0, this._betaLB[i2]);
                }
            }
            if (this._betaUB == null) {
                this._betaUB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + 1);
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
            }
        }

        public void applyAllBounds(double[] beta) {
            int betaLength = beta.length;
            for (int index = 0; index < betaLength; ++index) {
                beta[index] = this.applyBounds(beta[index], index);
            }
        }

        public double applyBounds(double d2, int i2) {
            if (this._betaLB != null && d2 < this._betaLB[i2]) {
                return this._betaLB[i2];
            }
            if (this._betaUB != null && d2 > this._betaUB[i2]) {
                return this._betaUB[i2];
            }
            return d2;
        }

        private Frame encodeCategoricalsIfPresent(Frame beta_constraints) {
            String[] coefNames = GLM.this._dinfo.coefNames();
            String[] coefOriginalNames = GLM.this._dinfo.coefOriginalNames();
            Frame transformedFrame = FrameUtils.encodeBetaConstraints(null, coefNames, coefOriginalNames, beta_constraints);
            return transformedFrame;
        }

        public BetaConstraint(Frame beta_constraints) {
            int idx;
            Object[] names;
            int i2;
            int[] map;
            Object[] dom;
            Vec v2;
            if (GLM.this._enumInCS) {
                if (GLM.this._betaConstraints == null) {
                    beta_constraints = GLMUtils.expandedCatCS(((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)GLM.this._parms);
                    DKV.put(beta_constraints);
                    GLM.this._betaConstraints = beta_constraints;
                } else {
                    beta_constraints = GLM.this._betaConstraints;
                }
            }
            if ((v2 = beta_constraints.vec("names")).isString()) {
                dom = new String[(int)v2.length()];
                map = new int[dom.length];
                BufferedString tmpStr = new BufferedString();
                for (int i3 = 0; i3 < dom.length; ++i3) {
                    dom[i3] = v2.atStr(tmpStr, i3).toString();
                    map[i3] = i3;
                }
                Object[] sortedDom = (String[])dom.clone();
                Arrays.sort(sortedDom);
                for (i2 = 1; i2 < sortedDom.length; ++i2) {
                    if (!((String)sortedDom[i2 - 1]).equals(sortedDom[i2])) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i2 - 1] + "'!");
                }
            } else if (v2.isCategorical()) {
                dom = v2.domain();
                map = FrameUtils.asInts(v2);
                int[] sortedMap = MemoryManager.arrayCopyOf(map, map.length);
                Arrays.sort(sortedMap);
                for (int i4 = 1; i4 < sortedMap.length; ++i4) {
                    if (sortedMap[i4 - 1] != sortedMap[i4]) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i4 - 1]] + "'!");
                }
            } else {
                throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
            }
            if (!Arrays.deepEquals(dom, names = ArrayUtils.append(GLM.this._dinfo.coefNames(), "Intercept"))) {
                HashMap<Object, Integer> m4 = new HashMap<Object, Integer>();
                for (i2 = 0; i2 < names.length; ++i2) {
                    m4.put(names[i2], i2);
                }
                int[] newMap = MemoryManager.malloc4(dom.length);
                for (int i5 = 0; i5 < map.length; ++i5) {
                    if (GLM.this._removedCols.contains(dom[map[i5]])) {
                        newMap[i5] = -1;
                        continue;
                    }
                    Integer I2 = (Integer)m4.get(dom[map[i5]]);
                    if (I2 == null) {
                        throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i5]] + "'");
                    }
                    newMap[i5] = I2;
                }
                map = newMap;
            }
            int numoff = GLM.this._dinfo.numStart();
            Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
            Arrays.sort(valid_col_names);
            for (String s2 : beta_constraints.names()) {
                if (Arrays.binarySearch(valid_col_names, s2) >= 0) continue;
                GLM.this.error("beta_constraints", "Unknown column name '" + s2 + "'");
            }
            v2 = beta_constraints.vec("beta_start");
            if (v2 != null) {
                this._betaStart = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i6 = 0; i6 < (int)v2.length(); ++i6) {
                    if (map[i6] == -1) continue;
                    this._betaStart[map[i6]] = v2.at(i6);
                }
            }
            if ((v2 = beta_constraints.vec("beta_given")) != null) {
                this._betaGiven = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i7 = 0; i7 < (int)v2.length(); ++i7) {
                    if (map[i7] == -1) continue;
                    this._betaGiven[map[i7]] = v2.at(i7);
                }
            }
            if ((v2 = beta_constraints.vec("upper_bounds")) != null) {
                this._betaUB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
                for (int i8 = 0; i8 < (int)v2.length(); ++i8) {
                    if (map[i8] == -1) continue;
                    this._betaUB[map[i8]] = v2.at(i8);
                }
            }
            if ((v2 = beta_constraints.vec("lower_bounds")) != null) {
                this._betaLB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                Arrays.fill(this._betaLB, Double.NEGATIVE_INFINITY);
                for (int i9 = 0; i9 < (int)v2.length(); ++i9) {
                    if (map[i9] == -1) continue;
                    this._betaLB[map[i9]] = v2.at(i9);
                }
            }
            if ((v2 = beta_constraints.vec("rho")) != null) {
                this._rho = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i10 = 0; i10 < (int)v2.length(); ++i10) {
                    if (map[i10] == -1) continue;
                    this._rho[map[i10]] = v2.at(i10);
                }
            }
            if ((v2 = beta_constraints.vec("mean")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i11 = 0;
                while ((long)i11 < v2.length()) {
                    if (!v2.isNA(i11) && map[i11] != -1) {
                        int n2 = idx = map == null ? i11 : map[i11];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normSub[idx - GLM.this._dinfo.numStart()] = v2.at(i11);
                        }
                    }
                    ++i11;
                }
            }
            if ((v2 = beta_constraints.vec("std_dev")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i12 = 0;
                while ((long)i12 < v2.length()) {
                    if (!v2.isNA(i12) && map[i12] != -1) {
                        int n3 = idx = map == null ? i12 : map[i12];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normMul[idx - GLM.this._dinfo.numStart()] = 1.0 / v2.at(i12);
                        }
                    }
                    ++i12;
                }
            }
            if (GLM.this._dinfo._normMul != null) {
                double normG = 0.0;
                double normS = 0.0;
                double normLB = 0.0;
                double normUB = 0.0;
                for (int i13 = numoff; i13 < GLM.this._dinfo.fullN(); ++i13) {
                    double s3 = GLM.this._dinfo._normSub[i13 - numoff];
                    double d2 = 1.0 / GLM.this._dinfo._normMul[i13 - numoff];
                    if (this._betaUB != null && !Double.isInfinite(this._betaUB[i13])) {
                        normUB *= s3;
                        int n4 = i13;
                        this._betaUB[n4] = this._betaUB[n4] * d2;
                    }
                    if (this._betaLB != null && !Double.isInfinite(this._betaLB[i13])) {
                        normLB *= s3;
                        int n5 = i13;
                        this._betaLB[n5] = this._betaLB[n5] * d2;
                    }
                    if (this._betaGiven != null) {
                        normG += this._betaGiven[i13] * s3;
                        int n6 = i13;
                        this._betaGiven[n6] = this._betaGiven[n6] * d2;
                    }
                    if (this._betaStart == null) continue;
                    normS += this._betaStart[i13] * s3;
                    int n7 = i13;
                    this._betaStart[n7] = this._betaStart[n7] * d2;
                }
                if (GLM.this._dinfo._intercept) {
                    int n8 = GLM.this._dinfo.fullN();
                    if (this._betaGiven != null) {
                        int n9 = n8;
                        this._betaGiven[n9] = this._betaGiven[n9] + normG;
                    }
                    if (this._betaStart != null) {
                        int n10 = n8;
                        this._betaStart[n10] = this._betaStart[n10] + normS;
                    }
                    if (this._betaLB != null) {
                        int n11 = n8;
                        this._betaLB[n11] = this._betaLB[n11] + normLB;
                    }
                    if (this._betaUB != null) {
                        int n12 = n8;
                        this._betaUB[n12] = this._betaUB[n12] + normUB;
                    }
                }
            }
            if (this._betaStart == null && this._betaGiven != null) {
                this._betaStart = (double[])this._betaGiven.clone();
            }
            if (this._betaStart != null && (this._betaLB != null || this._betaUB != null)) {
                for (int i14 = 0; i14 < this._betaStart.length; ++i14) {
                    if (this._betaLB != null && this._betaLB[i14] > this._betaStart[i14]) {
                        this._betaStart[i14] = this._betaLB[i14];
                    }
                    if (this._betaUB == null || !(this._betaUB[i14] < this._betaStart[i14])) continue;
                    this._betaStart[i14] = this._betaUB[i14];
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
            this.check();
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i2 = 0; i2 < this._betaGiven.length; ++i2) {
                ary[i2][0] = this._betaGiven[i2];
                ary[i2][1] = this._betaLB[i2];
                ary[i2][2] = this._betaUB[i2];
            }
            return ArrayUtils.pprint(ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d2 : this._betaLB) {
                    if (Double.isInfinite(d2)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d2 : this._betaUB) {
                    if (Double.isInfinite(d2)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasProximalPenalty() {
            return this._betaGiven != null && this._rho != null && ArrayUtils.countNonzeros(this._rho) > 0;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i2 = 0; i2 < this._betaGiven.length; ++i2) {
                    double diff = beta[i2] - this._betaGiven[i2];
                    int n2 = i2;
                    grad[n2] = grad[n2] + this._rho[i2] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i2 = 0; i2 < this._betaGiven.length; ++i2) {
                    double diff = beta[i2] - this._betaGiven[i2];
                    res += this._rho[i2] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }

        public void check() {
            if (this._betaLB != null && this._betaUB != null) {
                for (int i2 = 0; i2 < this._betaLB.length; ++i2) {
                    if (this._betaLB[i2] <= this._betaUB[i2]) continue;
                    throw new IllegalArgumentException("lower bounds must be <= upper bounds, " + this._betaLB[i2] + " !<= " + this._betaUB[i2]);
                }
            }
        }

        public BetaConstraint filterExpandedColumns(int[] activeCols) {
            BetaConstraint res = new BetaConstraint();
            if (this._betaLB != null) {
                res._betaLB = ArrayUtils.select(this._betaLB, activeCols);
            }
            if (this._betaUB != null) {
                res._betaUB = ArrayUtils.select(this._betaUB, activeCols);
            }
            if (this._betaGiven != null) {
                res._betaGiven = ArrayUtils.select(this._betaGiven, activeCols);
            }
            if (this._rho != null) {
                res._rho = ArrayUtils.select(this._rho, activeCols);
            }
            if (this._betaStart != null) {
                res._betaStart = ArrayUtils.select(this._betaStart, activeCols);
            }
            return res;
        }
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final BetaConstraint _bc;
        final double _l2pen;
        double[][] _betaMultinomial;
        final Job _job;
        double[][][] _penaltyMatrix;
        int[][] _gamColIndices;

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc) {
            this._job = job;
            this._bc = bc;
            this._parms = glmp;
            this._dinfo = dinfo;
            this._l2pen = l2pen;
        }

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc, double[][][] penaltyMat, int[][] gamColInd) {
            this(job, glmp, dinfo, l2pen, bc);
            this._penaltyMatrix = penaltyMat;
            this._gamColIndices = gamColInd;
        }

        public GLMGradientInfo getMultinomialLikelihood(double[] beta) {
            assert (GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family)) : "GLMGradientInfo.getMultinomialLikelihood is only used by multinomial GLM";
            assert (this._betaMultinomial != null) : "Multinomial coefficents cannot be null.";
            int off = 0;
            for (int i2 = 0; i2 < this._betaMultinomial.length; ++i2) {
                System.arraycopy(beta, off, this._betaMultinomial[i2], 0, this._betaMultinomial[i2].length);
                off += this._betaMultinomial[i2].length;
            }
            GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialLikelihoodTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms).doAll(this._dinfo._adaptedFrame);
            double l2pen = 0.0;
            for (double[] b2 : this._betaMultinomial) {
                l2pen += ArrayUtils.l2norm2(b2, this._dinfo._intercept);
            }
            double smoothval = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothval, null);
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            if (GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)this._parms._family)) {
                int i2;
                if (this._betaMultinomial == null) {
                    int nclasses = _totalBetaLen / _betaLenPerClass;
                    this._betaMultinomial = new double[nclasses][];
                    for (i2 = 0; i2 < nclasses; ++i2) {
                        this._betaMultinomial[i2] = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
                    }
                }
                int off = 0;
                for (i2 = 0; i2 < this._betaMultinomial.length; ++i2) {
                    if (!this._parms._remove_collinear_columns || this._dinfo._activeCols == null || this._dinfo._activeCols.length == _betaLenPerClass) {
                        System.arraycopy(beta, off, this._betaMultinomial[i2], 0, this._betaMultinomial[i2].length);
                    } else {
                        this._betaMultinomial[i2] = ComputationState.extractSubRange(_betaLenPerClass, i2, this._dinfo._activeCols, beta);
                    }
                    off += this._betaMultinomial[i2].length;
                }
                GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b2 : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2(b2, this._dinfo._intercept);
                    if (GLMModel.GLMParameters.Family.ordinal.equals((Object)this._parms._family)) break;
                }
                double[] grad = gt.gradient();
                if (!this._parms._intercept) {
                    for (int i3 = this._dinfo.fullN(); i3 < beta.length; i3 += this._dinfo.fullN() + 1) {
                        grad[i3] = 0.0;
                    }
                }
                double smoothVal = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
                return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothVal, grad);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit || this._parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (GLMModel.GLMParameters.Family.negativebinomial.equals((Object)this._parms._family) ? (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.poisson && this._parms._link == GLMModel.GLMParameters.Link.log ? (GLMTask.GLMGradientTask)new GLMTask.GLMPoissonGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.quasibinomial ? (GLMTask.GLMGradientTask)new GLMTask.GLMQuasiBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame)))));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double gamSmooth = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, _totalBetaLen), this._penaltyMatrix, this._gamColIndices) : 0.0;
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2(beta, true) + gamSmooth;
            if (this._bc != null && this._bc._betaGiven != null && this._bc._rho != null) {
                obj = ProximalGradientSolver.proximal_gradient(gradient, obj, beta, this._bc._betaGiven, this._bc._rho);
            }
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            double l2 = ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)this._job._key, (DataInfo)this._dinfo, (GLMModel.GLMParameters)this._parms, (double[])beta).doAll((Frame)this._dinfo._adaptedFrame))._likelihood;
            double smoothness = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, _totalBetaLen), this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(l2, l2 * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2(beta, true) + smoothness, null);
        }
    }

    public static class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }

        @Override
        public String toString() {
            return "GLM grad info: likelihood = " + this._likelihood + super.toString();
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver,
    ADMM.ProximalSolver {
        final OptimizationUtils.GradientSolver _solver;
        double[] _betaGiven;
        double[] _beta;
        private ProximalGradientInfo _ginfo;
        private final L_BFGS.ProgressMonitor _pm;
        final double[] _rho;
        private final double _objEps;
        private final double _gradEps;
        private int _iter;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s2, double[] betaStart, double[] rho, double objEps, double gradEps, OptimizationUtils.GradientInfo ginfo, L_BFGS.ProgressMonitor pm) {
            this._solver = s2;
            this._rho = rho;
            this._objEps = objEps;
            this._gradEps = gradEps;
            this._pm = pm;
            this._beta = betaStart;
            this._betaGiven = MemoryManager.malloc8d(betaStart.length);
        }

        public static double proximal_gradient(double[] grad, double obj, double[] beta, double[] beta_given, double[] rho) {
            for (int i2 = 0; i2 < beta.length; ++i2) {
                double diff = beta[i2] - beta_given[i2];
                double pen = rho[i2] * diff;
                if (grad != null) {
                    int n2 = i2;
                    grad[n2] = grad[n2] + pen;
                }
                obj += 0.5 * pen * diff;
            }
            return obj;
        }

        private ProximalGradientInfo computeProxGrad(OptimizationUtils.GradientInfo ginfo, double[] beta) {
            assert (!(ginfo instanceof ProximalGradientInfo));
            double[] gradient = (double[])ginfo._gradient.clone();
            double obj = ProximalGradientSolver.proximal_gradient(gradient, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, gradient);
        }

        @Override
        public ProximalGradientInfo getGradient(double[] beta) {
            return this.computeProxGrad(this._solver.getGradient(beta), beta);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getObjective(beta);
            double obj = ProximalGradientSolver.proximal_gradient(null, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, null);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] beta) {
            OptimizationUtils.GradientInfo origGinfo = this._ginfo == null || !Arrays.equals(this._beta, beta) ? this._solver.getGradient(beta) : this._ginfo._origGinfo;
            System.arraycopy(beta_given, 0, this._betaGiven, 0, beta_given.length);
            this._ginfo = this.computeProxGrad(origGinfo, beta);
            L_BFGS.Result r2 = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(this, beta, this._ginfo, this._pm);
            System.arraycopy(r2.coefs, 0, beta, 0, r2.coefs.length);
            this._beta = r2.coefs;
            this._iter += r2.iter;
            this._ginfo = (ProximalGradientInfo)r2.ginfo;
            return r2.converged;
        }

        @Override
        public boolean hasGradient() {
            return true;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            return this.getGradient((double[])beta)._origGinfo;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x2, double lb, double ub) {
            if (x2 < lb) {
                x2 = lb;
            }
            if (x2 > ub) {
                x2 = ub;
            }
            return x2;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d(xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8, intercept);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf(result, result.length);
                for (int i2 = 0; i2 < 1000; ++i2) {
                    this.solve(oldRes, result);
                    double[] g2 = this.gradient((double[])result)._gradient;
                    gerr = Math.max(-ArrayUtils.minValue(g2), ArrayUtils.maxValue(g2));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn("Gram solver did not converge, gerr = " + gerr);
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double[] lb, double[] ub) {
            int i2;
            if (ub != null && lb != null) {
                for (int i3 = 0; i3 < ub.length; ++i3) {
                    assert (ub[i3] >= lb[i3]) : i3 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = gram.fullN() - 1;
            double[] rhos = MemoryManager.malloc8d(xy.length);
            double min2 = Double.POSITIVE_INFINITY;
            for (int i4 = 0; i4 < xy.length - ii; ++i4) {
                double d2 = xy[i4];
                double d3 = d2 = d2 >= 0.0 ? d2 : -d2;
                if (!(d2 < min2) || d2 == 0.0) continue;
                min2 = d2;
            }
            double ybar = xy[icptCol];
            for (i2 = 0; i2 < rhos.length - ii; ++i2) {
                double y2 = xy[i2];
                if (y2 == 0.0) {
                    y2 = min2;
                }
                double xbar = gram.get(icptCol, i2);
                double x2 = (y2 - ybar * xbar) / (gram.get(i2, i2) - xbar * xbar + l2pen);
                rhos[i2] = ADMM.L1Solver.estimateRho(x2, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i2], ub == null ? Double.POSITIVE_INFINITY : ub[i2]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i2 = 0; i2 < xy.length; ++i2) {
                    int n2 = i2;
                    xy[n2] = xy[n2] + proxPen[i2] * beta_given[i2];
                }
            }
            this._xy = xy;
            this._rho = rhos;
            this.computeCholesky(gram, rhos, 1.0E-5, intercept);
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd, boolean intercept) {
            gram.addDiag(rhos);
            if (!intercept) {
                gram.dropIntercept();
                rhos = Arrays.copyOf(rhos, rhos.length - 1);
                this._xy[this._xy.length - 1] = 0.0;
            }
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult(rhos, -1.0));
                gram.addDiag(rhoAdd, !intercept);
                Log.info("Got NonSPD matrix with original rho, re-computing with rho = " + (this._rho[0] + rhoAdd));
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                double rhoAddSum = rhoAdd;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(rhoAdd, !intercept);
                    Log.warn("Still NonSPD matrix, re-computing with rho = " + (rhos[0] + (rhoAddSum += rhoAdd)));
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult(rhos, -1.0));
            ArrayUtils.mult(rhos, -1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i2 = 0; i2 < this._xy.length; ++i2) {
                    result[i2] = this._xy[i2] + this._rho[i2] * beta_given[i2];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i2 = 0; i2 < this._xy.length; ++i2) {
                int n2 = i2;
                grad[n2] = grad[n2] - this._xy[i2];
            }
            return new OptimizationUtils.GradientInfo(Double.NaN, grad);
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMDriver
    extends ModelBuilder.Driver
    implements L_BFGS.ProgressMonitor {
        private long _workPerIteration;
        private transient double[][] _vcov;
        private transient Gram.Cholesky _chol;
        private transient ADMM.L1Solver _lslvr;
        private long _lastScore;
        private transient long _scoringInterval;

        public GLMDriver() {
            super(GLM.this);
            this._lastScore = System.currentTimeMillis();
            this._scoringInterval = 15000L;
        }

        private void doCleanup() {
            try {
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack(GLM.this.removeLater(new Key[]{GLM.this._dinfo.getWeightsVec()._key}));
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    Key[] vecKeys = GLM.this._toRemove;
                    for (int index = 0; index < vecKeys.length; ++index) {
                        Vec tempVec = (Vec)DKV.getGet(vecKeys[index]);
                        tempVec.remove();
                    }
                }
            }
            catch (Exception e2) {
                Log.err("Error while cleaning up GLM " + GLM.this._result);
                Log.err(e2);
            }
        }

        private double[] ADMM_solve(Gram gram, double[] xy) {
            if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns || ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                Gram.Cholesky chol;
                if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    throw H2O.unimpl();
                }
                ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
                Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols, ((GLMModel.GLMParameters)GLM.this._parms)._standardize) : gram.cholesky(null);
                if (!ignoredCols.isEmpty() && !((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i2 = 0; i2 < collinear_cols.length; ++i2) {
                        collinear_cols[i2] = ignoredCols.get(i2);
                    }
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. P-values can not be computed with collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + Arrays.toString(ArrayUtils.select(GLM.this._dinfo.coefNames(), collinear_cols)));
                }
                if (!chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
                this._chol = chol;
                if (!ignoredCols.isEmpty()) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i3 = 0; i3 < collinear_cols.length; ++i3) {
                        collinear_cols[i3] = ignoredCols.get(i3);
                    }
                    Object[] collinear_col_names = ArrayUtils.select(GLM.this._state.activeData().coefNames(), collinear_cols);
                    GLM.this._model.addWarning("Removed collinear columns " + Arrays.toString(collinear_col_names));
                    Log.warn("Removed collinear columns " + Arrays.toString(collinear_col_names));
                    GLM.this._state.removeCols(collinear_cols);
                    gram.dropCols(collinear_cols);
                    xy = ArrayUtils.removeIds(xy, collinear_cols);
                }
                xy = (double[])xy.clone();
                chol.solve(xy);
            } else {
                gram = gram.deep_clone();
                xy = (double[])xy.clone();
                GramSolver slvr = new GramSolver((Gram)gram.clone(), (double[])xy.clone(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, GLM.this._state.l2pen(), GLM.this._state.l1pen(), ((GLM)GLM.this)._state.activeBC()._betaGiven, ((GLM)GLM.this)._state.activeBC()._rho, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                this._chol = slvr._chol;
                if (GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds()) {
                    slvr.solve(xy);
                } else {
                    xy = MemoryManager.malloc8d(xy.length);
                    if (((GLM)GLM.this)._state._u == null && !GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        ((GLM)GLM.this)._state._u = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                    }
                    this._lslvr = new ADMM.L1Solver(1.0E-4, 10000, ((GLM)GLM.this)._state._u);
                    this._lslvr.solve(slvr, xy, GLM.this._state.l1pen(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                }
            }
            return xy;
        }

        private void fitCOD_multinomial(GLMModel.GLMParameters.Solver s2) {
            double[] beta = GLM.this._state.betaMultinomial();
            do {
                beta = (double[])beta.clone();
                for (int c2 = 0; c2 < GLM.this._nclass; ++c2) {
                    OptimizationUtils.LineSearchSolver ls;
                    boolean onlyIcpt;
                    GLM.this._state.setActiveClass(c2);
                    boolean bl = onlyIcpt = GLM.this._state.activeDataMultinomial(c2).fullN() == 0;
                    if (GLM.this._state.l1pen() == 0.0) {
                        if (GLM.this._state.ginfoNull()) {
                            GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
                        }
                        ls = new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomial(c2, beta), GLM.this._state.ginfoMultinomial(c2));
                    } else {
                        ls = new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomial(c2, beta), GLM.this._state.l1pen());
                    }
                    new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c2).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                    ComputationState.GramXY gram = GLM.this._state.computeGram(GLM.this._state.betaMultinomial(c2, beta), s2);
                    double[] betaCnd = GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda());
                    if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract(betaCnd, ls.getX(), betaCnd))) {
                        Log.info(GLM.this.LogMsg("Ls failed " + ls));
                        continue;
                    }
                    GLM.this._state.setBetaMultinomial(c2, beta, ls.getX());
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getMultinomialLikelihood(beta)));
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
            }
        }

        public Frame makeZeroOrOneFrame(long rowNumber, int colNumber, int val, String[] columnNames) {
            Frame madeFrame;
            Vec tempVec = val == 0 ? Vec.makeZero(rowNumber) : Vec.makeOne(rowNumber);
            Frame frame = madeFrame = val == 0 ? new Frame(tempVec.makeZeros(colNumber)) : new Frame(tempVec.makeOnes(colNumber));
            if (columnNames != null) {
                if (columnNames.length == colNumber) {
                    madeFrame.setNames(columnNames);
                } else {
                    throw new IllegalArgumentException("Column names length and number of columns in Frame differ.");
                }
            }
            this.cleanupHGLMMemory(null, null, new Vec[]{tempVec}, null);
            return madeFrame;
        }

        private double[] fitCoeffs(int[] randCatLevels, int totRandCatLevels, Frame returnFrame, int[] dinfoWCol, int[] wCol, int etaOColIndexReturnFrame, int dinfoResponseColID, double[] sumEtaInfo, Frame augXZ, double[][] cholR) {
            GLMTask.CalculateW4Data calculateW4Data;
            Frame qMatrix = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows() + (long)ArrayUtils.sum(GLM.this._randC), GLM.this._state.beta().length + GLM.this._state.ubeta().length, 0, null);
            Frame augZW = this.makeZeroOrOneFrame(augXZ.numRows(), 1, 0, new String[]{"AugZ*W"});
            int betaLength = GLM.this._state.beta().length;
            int ubetaLength = GLM.this._state.ubeta().length;
            double[] start_delta = MemoryManager.malloc8d(betaLength + ubetaLength);
            int iteration = 0;
            new GLMTask.CopyPartsOfFrame(GLM.this._dinfo._adaptedFrame, new int[]{etaOColIndexReturnFrame}, new int[]{GLM.this._dinfo.responseChunkId(dinfoResponseColID)}, GLM.this._dinfo._adaptedFrame.numRows()).doAll(returnFrame);
            new GLMTask.CalculateW4Rand(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.ubeta()).doAll(GLM.this._state.get_priorw_wpsi());
            new GLMTask.RandColAddW2AugXZ(GLM.this._job, GLM.this._randC, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows(), augXZ.numCols() - ArrayUtils.sum(GLM.this._randC), augXZ.numCols()).doAll(augXZ);
            do {
                start_delta = this.calculate_all_beta(start_delta, augXZ, augZW, totRandCatLevels, cholR);
                new GLMTask.CopyPartsOfFrame(augXZ, null, null, qMatrix.numRows()).doAll(qMatrix);
                GLM.this._state.set_beta_HGLM(start_delta, 0, betaLength, true);
                GLM.this._state.set_ubeta_HGLM(start_delta, betaLength, ubetaLength);
                calculateW4Data = this.calculateNewWAugXZ(augXZ, GLM.this._randC);
            } while (this.progressHGLMGLMMME(calculateW4Data._sumEtaDiffSq, calculateW4Data._sumEtaSq, ++iteration, true, null, null, null, null, null, null, null, null));
            if (iteration > ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                Log.debug(GLM.this.LogMsg("HGLM GLM.MME did not converge in " + iteration + " iterations."));
            }
            GLMTask.ReturnGLMMMERunInfoData glmRunInfoData = (GLMTask.ReturnGLMMMERunInfoData)new GLMTask.ReturnGLMMMERunInfoData(GLM.this._job, GLM.this._dinfo, qMatrix, dinfoWCol, (GLMModel.GLMParameters)GLM.this._parms).doAll(returnFrame);
            GLMTask.ReturnGLMMMERunInfoRandCols glmRunInfo = (GLMTask.ReturnGLMMMERunInfoRandCols)new GLMTask.ReturnGLMMMERunInfoRandCols(GLM.this._job, GLM.this._dinfo, GLM.this._state.get_priorw_wpsi(), qMatrix, wCol, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.get_psi(), GLM.this._state.ubeta(), ArrayUtils.cumsum(randCatLevels)).doAll(returnFrame);
            glmRunInfo._sumDev += glmRunInfoData._sumDev;
            new GLMTask.GenerateResid(GLM.this._job, 1.0 / Math.sqrt(glmRunInfo._sumDev / (double)(returnFrame.numRows() - (long)(betaLength + ubetaLength))), 1, 4, GLM.this._dinfo._adaptedFrame.numRows()).doAll(returnFrame);
            sumEtaInfo[0] = glmRunInfoData._sumEtaDiffSq;
            sumEtaInfo[1] = glmRunInfoData._sumEtaSq;
            this.cleanupHGLMMemory(null, new Frame[]{augZW, qMatrix}, null, null);
            return sumEtaInfo;
        }

        public GLMTask.CalculateW4Data calculateNewWAugXZ(Frame augXZ, int[] randCatLevels) {
            GLMTask.CalculateW4Data calculateW4Data = (GLMTask.CalculateW4Data)new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
            new GLMTask.CalculateW4Rand(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.ubeta()).doAll(GLM.this._state.get_priorw_wpsi());
            new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
            new GLMTask.RandColAddW2AugXZ(GLM.this._job, GLM.this._randC, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows(), augXZ.numCols() - ArrayUtils.sum(GLM.this._randC), augXZ.numCols()).doAll(augXZ);
            return calculateW4Data;
        }

        public void copyOver(double[][] cholR, double[][] cholRcopy) {
            int dim1 = cholR.length;
            int dim2 = cholR[0].length;
            for (int index = 0; index < dim1; ++index) {
                System.arraycopy(cholR[index], 0, cholRcopy[index], 0, dim2);
            }
        }

        public double[] calculate_all_beta(double[] start_delta, Frame augXZ, Frame augZW, int totRandCatLevels, double[][] cholRcopy) {
            DataInfo augXZInfo = new DataInfo(augXZ, null, true, DataInfo.TransformType.NONE, true, false, false);
            DKV.put(augXZInfo._key, augXZInfo);
            double[][] cholR = ArrayUtils.transpose(LinearAlgebraUtils.computeQInPlace(GLM.this._job._key, augXZInfo));
            this.copyOver(cholR, cholRcopy);
            Frame qTransposed = DMatrix.transpose(augXZ);
            new GLMTask.CalculateAugZWData(GLM.this._job, GLM.this._dinfo, GLM.this._dinfo.responseChunkId(1)).doAll(augZW);
            new GLMTask.CalculateAugZWRandCols(GLM.this._job, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows()).doAll(augZW);
            double[][] augZWTransposed = new double[][]{FrameUtils.asDoubles(augZW.vec(0))};
            DataInfo qTinfo = new DataInfo(qTransposed, null, true, DataInfo.TransformType.NONE, true, false, false);
            DKV.put(qTinfo._key, qTinfo);
            Frame qTAugZW = ((LinearAlgebraUtils.BMulTask)new LinearAlgebraUtils.BMulTask(GLM.this._job._key, qTinfo, augZWTransposed).doAll(augZWTransposed.length, (byte)3, qTinfo._adaptedFrame)).outputFrame(Key.make("Q*Augz*W"), null, null);
            double[] qtaugzw = ((FrameUtils.Vec2ArryTsk)new FrameUtils.Vec2ArryTsk((int)((int)qTAugZW.numRows())).doAll((Vec[])new Vec[]{qTAugZW.vec((int)0)})).res;
            start_delta = LinearAlgebraUtils.backwardSolve(cholR, qtaugzw, start_delta);
            this.cleanupHGLMMemory(new DataInfo[]{qTinfo, augXZInfo}, new Frame[]{qTransposed, qTAugZW}, null, new Key[]{qTinfo._key, augXZInfo._key});
            return start_delta;
        }

        private void cleanupHGLMMemory(DataInfo[] tempdInfo, Frame[] tempFrames, Vec[] tempVectors, Key[] dkvKeys) {
            int index;
            if (tempdInfo != null) {
                for (index = 0; index < tempdInfo.length; ++index) {
                    if (tempdInfo[index] == null) continue;
                    tempdInfo[index].remove();
                }
            }
            if (tempFrames != null) {
                for (index = 0; index < tempFrames.length; ++index) {
                    if (tempFrames[index] == null) continue;
                    tempFrames[index].delete();
                }
            }
            if (tempVectors != null) {
                for (index = 0; index < tempVectors.length; ++index) {
                    if (tempVectors[index] == null) continue;
                    tempVectors[index].remove();
                }
            }
            if (dkvKeys != null) {
                for (index = 0; index < dkvKeys.length; ++index) {
                    if (dkvKeys[index] == null) continue;
                    DKV.remove(dkvKeys[index]);
                }
            }
        }

        private void fitHGLM() {
            GLMModel fixedModel;
            int[] nArray;
            int numRandCols = ((GLMModel.GLMParameters)GLM.this._parms)._random_columns.length;
            int totRandCatLevels = ArrayUtils.sum(GLM.this._randC);
            int[] cumSumRandLevels = ArrayUtils.cumsum(GLM.this._randC);
            Frame glmmmeReturnFrame = this.makeZeroOrOneFrame((long)totRandCatLevels + GLM.this._dinfo._adaptedFrame.numRows(), 6, 0, new String[]{"AugZ", "hv", "dev", "eta.i", "resid", "etao"});
            Frame hvDataOnly = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows(), 1, 0, new String[]{"hv_data"});
            if (GLM.this._dinfo._weights) {
                int[] nArray2 = new int[4];
                nArray2[0] = GLM.this._dinfo.responseChunkId(0);
                nArray2[1] = GLM.this._dinfo.responseChunkId(2);
                nArray2[2] = GLM.this._dinfo.responseChunkId(3);
                nArray = nArray2;
                nArray2[3] = GLM.this._dinfo.weightChunkId();
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = GLM.this._dinfo.responseChunkId(0);
                nArray3[1] = GLM.this._dinfo.responseChunkId(2);
                nArray = nArray3;
                nArray3[2] = GLM.this._dinfo.responseChunkId(3);
            }
            int[] dinfoWCol = nArray;
            int[] wCol = new int[]{0, 2};
            int[] devHvColIdx = new int[]{2, 1};
            double[] sumEtaInfo = new double[2];
            long numDataRows = GLM.this._dinfo._adaptedFrame.numRows();
            double[][] VC2 = new double[numRandCols][2];
            double[] VC1 = new double[2];
            int iter2 = 0;
            Frame augXZ = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows() + (long)ArrayUtils.sum(GLM.this._randC), GLM.this._state.beta().length + GLM.this._state.ubeta().length, 0, null);
            GLMTask.CalculateW4Data calculateW4Data = (GLMTask.CalculateW4Data)new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._randC, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
            new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
            sumEtaInfo[0] = calculateW4Data._sumEtaDiffSq;
            sumEtaInfo[1] = calculateW4Data._sumEtaSq;
            GLM.this._state.set_sumEtaSquareConvergence(sumEtaInfo);
            GLMModel[] randModels = new GLMModel[numRandCols];
            this.updateProgress(null, null, null, null, null, null, Double.NaN, Double.NaN, false, null, null);
            double[][] cholR = new double[augXZ.numCols()][augXZ.numCols()];
            do {
                if (((GLM)GLM.this)._state._iter > 0) {
                    new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._randC, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
                    new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
                }
                sumEtaInfo = this.fitCoeffs(GLM.this._randC, totRandCatLevels, glmmmeReturnFrame, dinfoWCol, wCol, 5, 3, sumEtaInfo, augXZ, cholR);
                fixedModel = this.fitDataDispersion(glmmmeReturnFrame, devHvColIdx, VC1);
                this.estimateRandomCoeffCh(glmmmeReturnFrame, devHvColIdx, cumSumRandLevels, numRandCols, numDataRows, randModels, VC2);
            } while (this.progressHGLMGLMMME(sumEtaInfo[0], sumEtaInfo[1], iter2, false, fixedModel, randModels, glmmmeReturnFrame, hvDataOnly, VC1, VC2, cholR, augXZ));
            this.scoreAndUpdateModelHGLM(fixedModel, randModels, glmmmeReturnFrame, hvDataOnly, VC1, VC2, sumEtaInfo[0], sumEtaInfo[1], cholR, augXZ, true);
            fixedModel.remove();
            this.cleanupHGLMMemory(null, new Frame[]{glmmmeReturnFrame, hvDataOnly, augXZ, GLM.this._state.get_priorw_wpsi()}, null, null);
        }

        private void estimateRandomCoeffCh(Frame returnFrame, int[] devHvColIdx, int[] cumSumRandLevels, int numRandCols, long numDataRows, GLMModel[] gRandModels, double[][] VC2) {
            long dev2UseStart = numDataRows;
            int startIndex = 0;
            double[] phi = GLM.this._state.get_phi();
            for (int colIndex = 0; colIndex < numRandCols; ++colIndex) {
                double sigma2u;
                Frame constXYWeight = new Frame(this.makeZeroOrOneFrame(cumSumRandLevels[colIndex], 3, 1, new String[]{"response", "X", "weights"}));
                DKV.put(constXYWeight._key, constXYWeight);
                gRandModels[colIndex] = this.buildGammaGLM(returnFrame, constXYWeight, devHvColIdx, dev2UseStart, cumSumRandLevels[colIndex], true);
                double newPhi = sigma2u = Math.exp(gRandModels[colIndex].coefficients().get("Intercept"));
                for (int index = startIndex; index < cumSumRandLevels[colIndex]; ++index) {
                    phi[index] = newPhi;
                }
                GLM.this._state.set_phi(phi);
                startIndex = cumSumRandLevels[colIndex];
                dev2UseStart += (long)cumSumRandLevels[colIndex];
                this.assignEstStdErr(gRandModels[colIndex], VC2[colIndex]);
                this.cleanupHGLMMemory(null, new Frame[]{constXYWeight}, null, new Key[]{constXYWeight._key});
                gRandModels[colIndex].remove();
            }
        }

        public GLMModel fitDataDispersion(Frame returnFrame, int[] devHvColIdx, double[] VC1) {
            Frame constXYWeight = new Frame(this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows(), 3, 1, new String[]{"response", "X", "weights"}));
            DKV.put(constXYWeight._key, constXYWeight);
            GLMModel gfixed = this.buildGammaGLM(returnFrame, constXYWeight, devHvColIdx, 0L, GLM.this._dinfo._adaptedFrame.numRows(), true);
            double sigma2e = Math.exp(gfixed.coefficients().get("Intercept"));
            GLM.this._state.set_tau(sigma2e);
            this.assignEstStdErr(gfixed, VC1);
            this.cleanupHGLMMemory(null, new Frame[]{constXYWeight}, null, new Key[]{constXYWeight._key});
            gfixed.remove();
            return gfixed;
        }

        private void assignEstStdErr(GLMModel glm, double[] VC) {
            double[] stdErr = ((GLMModel.GLMOutput)glm._output).stdErr();
            VC[0] = glm.coefficients().get("Intercept");
            VC[1] = stdErr[0];
        }

        public GLMModel buildGammaGLM(Frame returnFrame, Frame constXYWeight, int[] devHvColIdx, long startRowIndex, long numRows, boolean computePValues) {
            new GLMTask.ExtractFrameFromSourceWithProcess(returnFrame, devHvColIdx, startRowIndex, numRows).doAll(constXYWeight);
            DKV.put(constXYWeight._key, constXYWeight);
            boolean originalPValues = ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values;
            boolean originalDispersion = ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1;
            ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values = computePValues;
            ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 = computePValues;
            GLMModel g11 = GLM.this.runGLMModel(((GLMModel.GLMParameters)GLM.this._parms)._standardize, GLMModel.GLMParameters.Family.gamma, GLMModel.GLMParameters.Link.log, constXYWeight._key, "response", "weights", null, computePValues);
            ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values = originalPValues;
            ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 = originalDispersion;
            return g11;
        }

        private void fitIRLSM_multinomial(GLMModel.GLMParameters.Solver s2) {
            assert (GLM.this._dinfo._responses == 3) : "IRLSM for multinomial needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            if (GLMModel.GLMParameters.Solver.COORDINATE_DESCENT.equals((Object)s2)) {
                this.fitCOD_multinomial(s2);
            } else {
                double[] beta = GLM.this._state.betaMultinomial();
                do {
                    beta = (double[])beta.clone();
                    for (int c2 = 0; c2 < GLM.this._nclass; ++c2) {
                        int lsLength;
                        boolean onlyIcpt = GLM.this._state.activeDataMultinomial(c2).fullN() == 0;
                        GLM.this._state.setActiveClass(c2);
                        OptimizationUtils.LineSearchSolver ls = ((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns ? (GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomialFull(c2, beta), ((GLM)GLM.this)._state._iter == 0 ? GLM.this._state.ginfoMultinomial(c2) : GLM.this._state.ginfoMultinomialRCC(c2)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomialFull(c2, beta), GLM.this._state.l1pen())) : (GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomial(c2, beta), GLM.this._state.ginfoMultinomial(c2)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c2), GLM.this._state.betaMultinomial(c2, beta), GLM.this._state.l1pen()));
                        long t1 = System.currentTimeMillis();
                        if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && ((GLM)GLM.this)._state.activeDataMultinomial()._activeCols != null && _betaLenPerClass != GLM.this._state.activeDataMultinomial().activeCols().length) {
                            double[] shortBeta = GLM.this._state.shrinkFullArray(beta);
                            new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, shortBeta, c2).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        } else {
                            new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c2).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        }
                        long t2 = System.currentTimeMillis();
                        ComputationState.GramXY gram = ((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && ((GLM)GLM.this)._state._iter > 0 ? GLM.this._state.computeGramRCC(ls.getX(), s2) : GLM.this._state.computeGram(ls.getX(), s2);
                        long t3 = System.currentTimeMillis();
                        double[] betaCnd = this.ADMM_solve(gram.gram, gram.xy);
                        long t4 = System.currentTimeMillis();
                        if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && (lsLength = ls.getX().length) != betaCnd.length) {
                            double[] wideBetaCnd = new double[lsLength];
                            ComputationState.fillSubRange(lsLength, 0, ((GLM)GLM.this)._state.activeDataMultinomial()._activeCols, betaCnd, wideBetaCnd);
                            betaCnd = wideBetaCnd;
                        }
                        if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract(betaCnd, ls.getX(), betaCnd))) {
                            Log.info(GLM.this.LogMsg("Ls failed " + ls));
                            continue;
                        }
                        long t5 = System.currentTimeMillis();
                        GLM.this._state.setBetaMultinomial(c2, beta, ls.getX());
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "+" + (t5 - t4) + "=" + (t5 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    }
                    GLM.this._state.setActiveClass(-1);
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._activeColsPerClass = GLM.this._state.activeDataMultinomial().activeCols();
                } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
            }
        }

        private void fitIRLSM_ordinal_default(GLMModel.GLMParameters.Solver s2) {
            assert (GLM.this._dinfo._responses == 3) : "Solver for ordinal needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            double[] beta = GLM.this._state.betaMultinomial();
            int predSize = GLM.this._dinfo.fullN();
            int predSizeP1 = predSize + 1;
            int numClass = ((GLM)GLM.this)._state._nclasses;
            int numIcpt = numClass - 1;
            double[] betaCnd = new double[predSize];
            GLM.this._state.gslvr().getGradient(beta);
            double l1pen = GLM.this._state.lambda() * ((GLM)GLM.this)._state._alpha;
            boolean stopNow = false;
            do {
                int pindex;
                beta = (double[])beta.clone();
                double[] grads = ((GLM)GLM.this)._state.ginfo()._gradient;
                for (pindex = 0; pindex < numIcpt; ++pindex) {
                    int previousIcpt;
                    int icptindex;
                    int n2 = icptindex = (pindex + 1) * predSizeP1 - 1;
                    beta[n2] = beta[n2] - grads[icptindex];
                    if (pindex <= 0 || !(beta[icptindex] < beta[previousIcpt = pindex * predSizeP1 - 1])) continue;
                    GLM.this.warn("Ordinal regression training: ", " intercepts of previous class exceed that of current class.  Make sure your training parameters are set properly.  Training will stop now with the last eligible parameters.");
                    stopNow = true;
                    for (int index = 0; index <= pindex; ++index) {
                        int n3 = icptindex = (index + 1) * predSizeP1 - 1;
                        beta[n3] = beta[n3] + grads[icptindex];
                    }
                    break;
                }
                if (stopNow) break;
                for (pindex = 0; pindex < predSize; ++pindex) {
                    betaCnd[pindex] = grads[pindex];
                    if (l1pen > 0.0) {
                        int n4 = pindex;
                        betaCnd[n4] = betaCnd[n4] + (beta[pindex] > 0.0 ? l1pen : (beta[pindex] == 0.0 ? 0.0 : -l1pen));
                    }
                    int n5 = pindex;
                    beta[n5] = beta[n5] - betaCnd[pindex];
                }
                for (int indC = 1; indC < numIcpt; ++indC) {
                    int indOffset = indC * predSizeP1;
                    for (int index = 0; index < predSize; ++index) {
                        beta[indOffset + index] = beta[index];
                    }
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
        }

        private void fitLSM(GLMModel.GLMParameters.Solver s2) {
            double[] beta;
            long t0 = System.currentTimeMillis();
            ComputationState.GramXY gramXY = GLM.this._state.computeGram(GLM.this._state.beta(), s2);
            Log.info(GLM.this.LogMsg("Gram computed in " + (System.currentTimeMillis() - t0) + "ms"));
            BetaConstraint bc = GLM.this._state.activeBC();
            double[] dArray = beta = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gramXY, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gramXY.gram, gramXY.xy);
            if (GLM.this._betaConstraintsOn) {
                bc.applyAllBounds(beta);
            }
            double[] x2 = ArrayUtils.mmul(gramXY.gram.getXX(), beta);
            for (int i2 = 0; i2 < x2.length; ++i2) {
                x2[i2] = x2[i2] - 2.0 * gramXY.xy[i2];
            }
            double l2 = 0.5 * (ArrayUtils.innerProduct(x2, beta) / ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg + gramXY.yy);
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, l2);
        }

        private void fitIRLSM(GLMModel.GLMParameters.Solver s2) {
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            OptimizationUtils.LineSearchSolver ls = null;
            int iterCnt = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0;
            boolean firstIter = iterCnt == 0;
            BetaConstraint bc = GLM.this._state.activeBC();
            try {
                while (true) {
                    ++iterCnt;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramXY gram = GLM.this._state.computeGram(betaCnd, s2);
                    long t2 = System.currentTimeMillis();
                    if (!((GLM)GLM.this)._state._lsNeeded && (Double.isNaN(gram.likelihood) || GLM.this._state.objective(gram.beta, gram.likelihood) > GLM.this._state.objective() + ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon) && !GLM.this._checkPointFirstIter) {
                        ((GLM)GLM.this)._state._lsNeeded = true;
                    } else {
                        if (!(firstIter || ((GLM)GLM.this)._state._lsNeeded || this.progress(gram.beta, gram.likelihood) || GLM.this._checkPointFirstIter)) {
                            Log.info("DONE after " + (iterCnt - 1) + " iterations (1)");
                            ((GLM)GLM.this)._model._betaCndCheckpoint = betaCnd;
                            return;
                        }
                        if (!GLM.this._checkPointFirstIter) {
                            betaCnd = s2 == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gram.gram, gram.xy);
                        }
                    }
                    firstIter = false;
                    GLM.this._checkPointFirstIter = false;
                    long t3 = System.currentTimeMillis();
                    if (((GLM)GLM.this)._state._lsNeeded) {
                        double[] oldBetaCnd;
                        if (ls == null) {
                            OptimizationUtils.LineSearchSolver lineSearchSolver = ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                        }
                        if (betaCnd.length != (oldBetaCnd = ls.getX()).length) {
                            betaCnd = ComputationState.extractSubRange(betaCnd.length, 0, ((GLM)GLM.this)._state.activeData()._activeCols, betaCnd);
                        }
                        if (!ls.evaluate(ArrayUtils.subtract(betaCnd, oldBetaCnd, betaCnd))) {
                            Log.info(GLM.this.LogMsg("Ls failed " + ls));
                            return;
                        }
                        betaCnd = ls.getX();
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(betaCnd);
                        }
                        if (!this.progress(betaCnd, ls.ginfo())) {
                            return;
                        }
                        long t4 = System.currentTimeMillis();
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                        continue;
                    }
                    if (GLM.this._betaConstraintsOn) {
                        bc.applyAllBounds(betaCnd);
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "=" + (t3 - t1) + "ms, step = " + 1 + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                }
            }
            catch (Gram.NonSPDMatrixException e2) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        private void fitLBFGS() {
            double[] beta = GLM.this._state.beta();
            double l1pen = GLM.this._state.l1pen();
            GLMGradientSolver gslvr = GLM.this._state.gslvr();
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            if (beta == null && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                beta = MemoryManager.malloc8d((GLM.this._state.activeData().fullN() + 1) * GLM.this._nclass);
                int P2 = GLM.this._state.activeData().fullN() + 1;
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    for (int i2 = 0; i2 < GLM.this._nclass; ++i2) {
                        beta[i2 * P2 + P2 - 1] = glmw.link(((GLM)GLM.this)._state._ymu[i2]);
                    }
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    beta[beta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                }
            }
            L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
            assert (beta.length == ((GLM)GLM.this)._state.ginfo()._gradient.length);
            int P3 = GLM.this._dinfo.fullN();
            if (l1pen > 0.0 || GLM.this._state.activeBC().hasBounds()) {
                double[] nullBeta = MemoryManager.malloc8d(beta.length);
                if (GLM.this._dinfo._intercept) {
                    if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        for (int c2 = 0; c2 < GLM.this._nclass; ++c2) {
                            nullBeta[(c2 + 1) * (P3 + 1) - 1] = glmw.link(((GLM)GLM.this)._state._ymu[c2]);
                        }
                    } else {
                        nullBeta[nullBeta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                    }
                }
                GLMGradientInfo ginfo = gslvr.getGradient(nullBeta);
                double[] direction = ArrayUtils.mult((double[])ginfo._gradient.clone(), -1.0);
                double t2 = 1.0;
                if (l1pen > 0.0) {
                    OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente(gslvr, nullBeta);
                    mt.evaluate(direction);
                    t2 = mt.step();
                }
                double[] rho = MemoryManager.malloc8d(beta.length);
                double r2 = GLM.this._state.activeBC().hasBounds() ? 1.0 : 0.1;
                BetaConstraint bc = GLM.this._state.activeBC();
                for (int i3 = 0; i3 < rho.length - 1; ++i3) {
                    rho[i3] = r2 * ADMM.L1Solver.estimateRho(nullBeta[i3] + t2 * direction[i3], l1pen, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[i3], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[i3]);
                }
                for (int ii = P3; ii < rho.length; ii += P3 + 1) {
                    rho[ii] = r2 * ADMM.L1Solver.estimateRho(nullBeta[ii] + t2 * direction[ii], 0.0, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[ii], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[ii]);
                }
                double[] objvals = new double[2];
                objvals[1] = Double.POSITIVE_INFINITY;
                double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                double ADMM_gradEps = 0.001;
                ProximalGradientSolver innerSolver = new ProximalGradientSolver(gslvr, beta, rho, ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * 0.1, ((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon, GLM.this._state.ginfo(), this);
                ADMM.L1Solver l1Solver = new ADMM.L1Solver(ADMM_gradEps, 250, reltol, abstol, ((GLM)GLM.this)._state._u);
                l1Solver._pm = this;
                l1Solver.solve(innerSolver, beta, l1pen, true, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                ((GLM)GLM.this)._state._u = l1Solver._u;
                GLM.this._state.updateState(beta, gslvr.getGradient(beta));
            } else {
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter == 0 && !((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    this.updateProgress(false);
                }
                L_BFGS.Result r3 = lbfgs.solve(gslvr, beta, GLM.this._state.ginfo(), new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                        if (((GLM)GLM.this)._state._iter < 4 || (((GLM)GLM.this)._state._iter & 3) == 0) {
                            Log.info(GLM.this.LogMsg("LBFGS, gradient norm = " + ArrayUtils.linfnorm(ginfo._gradient, false)));
                        }
                        return GLMDriver.this.progress(beta, ginfo);
                    }
                });
                Log.info(GLM.this.LogMsg(r3.toString()));
                GLM.this._state.updateState(r3.coefs, (GLMGradientInfo)r3.ginfo);
            }
        }

        private void fitCOD() {
            double[] beta = GLM.this._state.beta();
            int p2 = GLM.this._state.activeData().fullN() + 1;
            boolean skipFirstLevel = !((GLM)GLM.this)._state.activeData()._useAllFactorLevels;
            double[] betaold = (double[])beta.clone();
            double objold = GLM.this._state.objective();
            int iter2 = 0;
            Vec[] newVecs = ((GLM)GLM.this)._state.activeData()._adaptedFrame.anyVec().makeZeros(3);
            Vec w2 = newVecs[0];
            Vec z2 = newVecs[1];
            Vec zTilda = newVecs[2];
            long startTimeTotalNaive = System.currentTimeMillis();
            while (iter2++ < 30) {
                double percdiff;
                Frame fr = new Frame(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                fr.add("w", w2);
                fr.add("z", z2);
                fr.add("zTilda", zTilda);
                GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._job._key, GLM.this._state.activeData(), (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                double objVal = GLM.this.objVal(gt._likelihood, gt._betaw, GLM.this._state.lambda());
                double[] denums = gt.denums;
                double wsum = gt.wsum;
                double wsumu = gt.wsumu;
                int iter1 = 0;
                while (iter1++ < 100) {
                    boolean intercept;
                    Frame fr2 = new Frame(new Vec[0]);
                    fr2.add("w", w2);
                    fr2.add("z", z2);
                    fr2.add("zTilda", zTilda);
                    for (int i2 = 0; i2 < ((GLM)GLM.this)._state.activeData()._cats; ++i2) {
                        Frame fr3 = new Frame(fr2);
                        int level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i2 + 1] - ((GLM)GLM.this)._state.activeData()._catOffsets[i2];
                        int prev_level_num = 0;
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i2));
                        boolean bl = intercept = i2 == 0;
                        if (!intercept) {
                            prev_level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i2] - ((GLM)GLM.this)._state.activeData()._catOffsets[i2 - 1];
                            fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i2 - 1));
                        }
                        int start_old = ((GLM)GLM.this)._state.activeData()._catOffsets[i2];
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p2 - 1]}, ((GLM)GLM.this)._state.activeData()._catLvls[i2], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[i2 - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[i2]), ((GLM)GLM.this)._state.activeData()._catLvls[i2], ((GLM)GLM.this)._state.activeData()._catLvls[i2 - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        for (int j2 = 0; j2 < level_num; ++j2) {
                            beta[((GLM)GLM.this)._state.activeData()._catOffsets[i2] + j2] = ADMM.shrinkage(stupdate._temp[j2] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[((GLM)GLM.this)._state.activeData()._catOffsets[i2] + j2] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                        }
                    }
                    int cat_num = 2;
                    for (int i3 = 0; i3 < ((GLM)GLM.this)._state.activeData()._nums; ++i3) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i3 + ((GLM)GLM.this)._state.activeData()._cats));
                        intercept = i3 == 0 && GLM.this._state.activeData().numStart() == 0;
                        double[] meannew = null;
                        double[] meanold = null;
                        double[] varnew = null;
                        double[] varold = null;
                        if (i3 > 0 || intercept) {
                            cat_num = 3;
                            if (!intercept) {
                                fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i3 - 1 + ((GLM)GLM.this)._state.activeData()._cats));
                            }
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i3]};
                                meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i3]};
                                if (i3 != 0) {
                                    varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i3 - 1]};
                                    meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i3 - 1]};
                                }
                            }
                            stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart() + i3]}, new double[]{beta[(GLM.this._state.activeData().numStart() + i3 - 1 + p2) % p2]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr3);
                            beta[i3 + ((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i3 + GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            continue;
                        }
                        if (i3 != 0 || intercept) continue;
                        int prev_level_num = GLM.this._state.activeData().numStart() - ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1];
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats - 1));
                        if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                            varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i3]};
                            meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i3]};
                        }
                        stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart()]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], GLM.this._state.activeData().numStart()), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr3);
                        beta[((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                    }
                    if (((GLM)GLM.this)._state.activeData()._nums + ((GLM)GLM.this)._state.activeData()._cats > 0) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1));
                        if (((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1).isCategorical()) {
                            cat_num = 2;
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats]), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        } else {
                            cat_num = 3;
                            double[] meannew = null;
                            double[] varnew = null;
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[((GLM)GLM.this)._state.activeData()._normMul.length - 1]};
                                meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[((GLM)GLM.this)._state.activeData()._normSub.length - 1]};
                            }
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                            beta[beta.length - 1] = iupdate._temp[0] / wsum;
                        }
                    }
                    double maxdiff = ArrayUtils.linfnorm(ArrayUtils.subtract(beta, betaold), false);
                    System.arraycopy(beta, 0, betaold, 0, beta.length);
                    if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                    break;
                }
                if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                objold = objVal;
                Log.debug("iter1 = " + iter1);
            }
            Log.debug("iter2 = " + iter2);
            long endTimeTotalNaive = System.currentTimeMillis();
            long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
            Log.info("Time to run Naive Coordinate Descent " + durationTotalNaive);
            ((GLM)GLM.this)._state._iter = iter2;
            for (Vec v2 : newVecs) {
                v2.remove();
            }
            GLM.this._state.updateState(beta, objold);
        }

        private void fitModel() {
            GLMModel.GLMParameters.Solver solver;
            GLMModel.GLMParameters.Solver solver2 = solver = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO ? GLM.this.defaultSolver() : ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.fitHGLM();
            } else {
                switch (solver) {
                    case COORDINATE_DESCENT: 
                    case IRLSM: {
                        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                            this.fitIRLSM_multinomial(solver);
                            break;
                        }
                        if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                            this.fitIRLSM_ordinal_default(solver);
                            break;
                        }
                        if (GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && GLMModel.GLMParameters.Link.identity.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._link)) {
                            this.fitLSM(solver);
                            break;
                        }
                        this.fitIRLSM(solver);
                        break;
                    }
                    case GRADIENT_DESCENT_LH: 
                    case GRADIENT_DESCENT_SQERR: {
                        if (!GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) break;
                        this.fitIRLSM_ordinal_default(solver);
                        break;
                    }
                    case L_BFGS: {
                        this.fitLBFGS();
                        break;
                    }
                    case COORDINATE_DESCENT_NAIVE: {
                        this.fitCOD();
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                double se = 1.0;
                boolean seEst = false;
                double[] beta = GLM.this._state.beta();
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.poisson) {
                    seEst = true;
                    GLMTask.ComputeSETsk ct = (GLMTask.ComputeSETsk)new GLMTask.ComputeSETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    se = ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 ? 1.0 : ct._sumsqe / (double)(GLM.this._nobs - 1L - (long)GLM.this._state.activeData().fullN());
                }
                double[] zvalues = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                Gram.Cholesky chol = this._chol;
                DataInfo activeData = GLM.this._state.activeData();
                if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                    double[] beta_nostd = activeData.denormalizeBeta(beta);
                    DataInfo.TransformType transform = activeData._predictor_transform;
                    activeData.setPredictorTransform(DataInfo.TransformType.NONE);
                    Gram g2 = ((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask((Key)GLM.this._job._key, (DataInfo)activeData, (GLMModel.GLMWeightsFun)new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms)), (double[])beta_nostd).doAll((Frame)activeData._adaptedFrame))._gram;
                    activeData.setPredictorTransform(transform);
                    g2.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    chol = g2.cholesky(null);
                    beta = beta_nostd;
                } else {
                    Gram g3 = ((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask((Key)GLM.this._job._key, (DataInfo)activeData, (GLMModel.GLMWeightsFun)new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms)), (double[])beta).doAll((Frame)activeData._adaptedFrame))._gram;
                    g3.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    chol = g3.cholesky(null);
                }
                double[][] inv = chol.getInv();
                ArrayUtils.mult(inv, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg * se);
                this._vcov = inv;
                for (int i2 = 0; i2 < zvalues.length; ++i2) {
                    zvalues[i2] = beta[i2] / Math.sqrt(inv[i2][i2]);
                }
                GLM.this._model.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), se, seEst);
            }
        }

        private long timeSinceLastScoring() {
            return System.currentTimeMillis() - this._lastScore;
        }

        private void scoreAndUpdateModelHGLM(GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double sumDiff2, double convergence, double[][] cholR, Frame augXZ, boolean compute_hlik) {
            Log.info(GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms"));
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet(((GLMModel.GLMParameters)GLM.this._parms)._train);
            String[] domain = new String[]{"HGLM_" + ((GLMModel.GLMParameters)GLM.this._parms)._family.toString() + "_" + ((GLMModel.GLMParameters)GLM.this._parms)._rand_family.toString()};
            ModelMetrics.MetricBuilder mb = GLM.this._model.makeMetricBuilder(domain);
            ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd = (ModelMetricsHGLM.MetricBuilderHGLM)((GLMMetricBuilder)mb)._metricBuilder;
            this.updateSimpleHGLMMetrics(fixedModel, randModels, VC1, VC2, mmHGLMBd, sumDiff2, convergence);
            this.calBad(glmmmeReturns, hvDataOnly, mmHGLMBd);
            this.calseFeseRedfReFe(cholR, mmHGLMBd, augXZ);
            if (((GLMModel.GLMParameters)GLM.this._parms)._calc_like && compute_hlik) {
                this.calHlikStuff(mmHGLMBd, glmmmeReturns, augXZ);
                GLM.this._state.set_likelihoodInfo(mmHGLMBd._hlik, mmHGLMBd._pvh, mmHGLMBd._pbvh, mmHGLMBd._caic);
            }
            mb.makeModelMetrics(GLM.this._model, train, GLM.this._dinfo._adaptedFrame, null);
            this.scorePostProcessing(train, t1);
        }

        private void calHlikStuff(ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame glmmmeReturns, Frame augXZ) {
            this.calculateNewWAugXZ(augXZ, GLM.this._randC);
            double cond_hlik = this.calculatecAIC(mmHGLMBd, glmmmeReturns);
            Frame hlikH = this.formHMatrix(augXZ);
            mmHGLMBd._hlik = cond_hlik;
            mmHGLMBd._pvh = cond_hlik - 0.5 * this.calcLogDeterminant(hlikH);
            Frame hlikA = this.formAMatrix(hlikH, augXZ);
            mmHGLMBd._pbvh = cond_hlik - 0.5 * this.calcLogDeterminant(hlikA);
            this.cleanupHGLMMemory(null, new Frame[]{hlikH, hlikA}, null, null);
        }

        private double calcLogDeterminant(Frame frame) {
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = frame._key;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.GramSVD;
            parms._save_v_frame = false;
            parms._nv = frame.numCols();
            SVDModel model = (SVDModel)new SVD(parms).trainModel().get();
            double[] singular_values = ((SVDModel.SVDOutput)model._output)._d;
            double cond = ArrayUtils.minValue(singular_values) / ArrayUtils.maxValue(singular_values);
            if (cond < 1.0E-8) {
                GLM.this.warn("pbvh", "The Hessian used for computing pbvh is ill-conditioned.");
            }
            double sumLog = 0.0;
            double log2Pi = Math.log(Math.PI * 2);
            for (int index = 0; index < parms._nv; ++index) {
                sumLog += Math.log(singular_values[index]) - log2Pi;
            }
            model.delete();
            return sumLog;
        }

        private Frame formAMatrix(Frame hlikH, Frame augXZ) {
            Frame dataFrame = this.getXW1(augXZ);
            DataInfo hlikAInfo = new DataInfo(dataFrame, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask(GLM.this._job._key, hlikAInfo, false, false).doAll(hlikAInfo._adaptedFrame);
            new ArrayUtils();
            Frame leftUp = ArrayUtils.frame(dgram._gram.getXX());
            Frame augzW1 = this.getaugZW1(augXZ);
            Frame tX = DMatrix.transpose(dataFrame);
            int expandedRandColNum = ArrayUtils.sum(GLM.this._randC);
            tX.add(new Frame(this.makeZeroOrOneFrame(tX.numRows(), expandedRandColNum, 0, null)));
            DKV.put(augzW1._key, augzW1);
            new LinearAlgebraUtils.BMulTaskMatrices(augzW1).doAll(tX);
            Frame tXW1z = tX.subframe(tX.numCols() - expandedRandColNum, tX.numCols());
            leftUp.add(tXW1z);
            Frame leftDown = DMatrix.transpose(tXW1z);
            leftDown._key = Key.make();
            leftDown.add(hlikH);
            leftDown.setNames(leftUp.names());
            DKV.put(leftDown._key, leftDown);
            DKV.put(leftUp._key, leftUp);
            String tree = String.format("(rbind %s %s)", leftUp._key, leftDown._key);
            Val val = Rapids.exec(tree);
            Frame amatrix = val.getFrame();
            amatrix._key = Key.make();
            DKV.put(amatrix._key, amatrix);
            this.cleanupHGLMMemory(new DataInfo[]{hlikAInfo}, new Frame[]{dataFrame, leftUp, augzW1, tX, tXW1z, leftDown}, null, null);
            return amatrix;
        }

        private Frame getXW1(Frame augXZ) {
            int numDataCols = augXZ.numCols() - ArrayUtils.sum(GLM.this._randC);
            int[] colIndices = new int[numDataCols];
            for (int index = 0; index < numDataCols; ++index) {
                colIndices[index] = index;
            }
            Frame dataFrame = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, numDataCols, 0, null));
            new GLMTask.CopyPartsOfFrame(augXZ, colIndices, colIndices, GLM.this._nobs).doAll(dataFrame);
            return dataFrame;
        }

        private Frame formHMatrix(Frame augXZ) {
            Frame augZW1 = this.getaugZW1(augXZ);
            DataInfo augZW1Info = new DataInfo(augZW1, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask(GLM.this._job._key, augZW1Info, false, false).doAll(augZW1Info._adaptedFrame);
            Frame wranddata = GLM.this._state.get_priorw_wpsi();
            double[][] W2 = null;
            W2 = ArrayUtils.transpose(((ArrayUtils.FrameToArray)new ArrayUtils.FrameToArray(1, 1, wranddata.numRows(), W2).doAll(wranddata)).getArray());
            ArrayUtils.mult(W2[0], W2[0]);
            dgram._gram.addDiag(W2[0]);
            this.cleanupHGLMMemory(new DataInfo[]{augZW1Info}, new Frame[]{augZW1, wranddata}, null, null);
            new ArrayUtils();
            return ArrayUtils.frame(dgram._gram.getXX());
        }

        private Frame getaugZW1(Frame augXZ) {
            int numRandExpandedCols = ArrayUtils.sum(GLM.this._randC);
            int randIndexStart = augXZ.numCols() - numRandExpandedCols;
            Frame augZW1 = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, numRandExpandedCols, 0, null));
            int[] colIndices = new int[numRandExpandedCols];
            int colNum = augXZ.numCols();
            for (int index = randIndexStart; index < colNum; ++index) {
                colIndices[index - randIndexStart] = index;
            }
            new GLMTask.CopyPartsOfFrame(augXZ, null, colIndices, GLM.this._nobs).doAll(augZW1);
            return augZW1;
        }

        private double calculatecAIC(ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame glmmmeReturns) {
            Frame hv_dev_pw = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, 2, 0, new String[]{"hv", "dev"}));
            new GLMTask.CopyPartsOfFrame(glmmmeReturns, new int[]{0, 1}, new int[]{1, 2}, GLM.this._nobs).doAll(hv_dev_pw);
            if (GLM.this._dinfo._weights) {
                hv_dev_pw.add("weights", GLM.this._dinfo._adaptedFrame.vec(GLM.this._dinfo.weightChunkId()));
            }
            GLMTask.HelpercAIC calcAIC = (GLMTask.HelpercAIC)new GLMTask.HelpercAIC(GLM.this._dinfo._weights, mmHGLMBd._varfix).doAll(hv_dev_pw);
            double constance = -0.5 * calcAIC._constT;
            double cond_hlik = constance - 0.5 * calcAIC._devOphi;
            mmHGLMBd._caic = -2.0 * cond_hlik + 2.0 * calcAIC._p;
            double[] lfvals = this.lfv_du_dv(((GLMModel.GLMParameters)GLM.this._parms)._rand_family, ((GLMModel.GLMParameters)GLM.this._parms)._rand_link, GLM.this._state.get_phi(), GLM.this._state.ubeta());
            hv_dev_pw.remove();
            return cond_hlik += lfvals[0] + lfvals[1];
        }

        public double[] lfv_du_dv(GLMModel.GLMParameters.Family[] family, GLMModel.GLMParameters.Link[] link, double[] phi, double[] u2) {
            double[] vals = new double[2];
            int numRandCols = GLM.this._randC.length;
            for (int k2 = 0; k2 < numRandCols; ++k2) {
                GLMModel.GLMParameters.Family tfamily = family[k2];
                GLMModel.GLMParameters.Link tlink = tfamily.defaultLink;
                if (link != null) {
                    tlink = link[k2];
                }
                GLMModel.GLMWeightsFun glmfun = new GLMModel.GLMWeightsFun(tfamily, tlink, 0.0, 0.0, 0.0);
                int colLength = GLM.this._randC[k2];
                for (int col = 0; col < colLength; ++col) {
                    int index = k2 * colLength + col;
                    if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)tfamily) || !GLMModel.GLMParameters.Link.identity.equals((Object)tlink)) continue;
                    vals[1] = vals[1] + Math.log(Math.abs(glmfun.linkInvDeriv(glmfun.link(u2[index]))));
                    vals[0] = vals[0] - (Math.log(Math.sqrt(Math.PI * 2)) + Math.log(Math.sqrt(phi[index])) + u2[index] * u2[index] / (2.0 * phi[index]));
                }
            }
            return vals;
        }

        private void calseFeseRedfReFe(double[][] cholR, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame augXZ) {
            double[][] RTRInv = LinearAlgebraUtils.chol2Inv(cholR);
            double[] seFeRe = LinearAlgebraUtils.sqrtDiag(RTRInv);
            int sefelen = GLM.this._state.beta().length;
            int serelen = GLM.this._state.ubeta().length;
            if (mmHGLMBd._sefe == null) {
                mmHGLMBd._sefe = new double[sefelen];
            }
            System.arraycopy(seFeRe, 0, mmHGLMBd._sefe, 0, sefelen);
            if (mmHGLMBd._sere == null) {
                mmHGLMBd._sere = new double[serelen];
            }
            System.arraycopy(seFeRe, sefelen, mmHGLMBd._sere, 0, serelen);
            Frame augZ = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, augXZ.numCols(), 0, null));
            new GLMTask.CopyPartsOfFrame(augXZ, null, null, GLM.this._nobs).doAll(augZ);
            DataInfo augzInfo = new DataInfo(augZ, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask(GLM.this._job._key, augzInfo, false, false).doAll(augzInfo._adaptedFrame);
            double[][] gramMatrix = dgram._gram.getXX();
            double pd = ArrayUtils.sum(ArrayUtils.diagArray(LinearAlgebraUtils.matrixMultiply(RTRInv, gramMatrix)));
            mmHGLMBd._dfrefe = Math.round((double)GLM.this._nobs - pd);
            this.cleanupHGLMMemory(new DataInfo[]{augzInfo}, new Frame[]{augZ}, null, null);
        }

        private void calBad(Frame glmmeReturns, Frame hvFrameOnly, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd) {
            new GLMTask.CopyPartsOfFrame(glmmeReturns, new int[]{0}, new int[]{1}, GLM.this._nobs).doAll(hvFrameOnly);
            Vec vec = hvFrameOnly.vec(0);
            double sigma6 = vec.mean() + 6.0 * vec.sigma();
            double maxVec = vec.max();
            mmHGLMBd._bad = maxVec > sigma6 ? ((LinearAlgebraUtils.FindMaxIndex)new LinearAlgebraUtils.FindMaxIndex((int)0, (double)maxVec).doAll((Frame)hvFrameOnly))._maxIndex : -1L;
        }

        private void updateSimpleHGLMMetrics(GLMModel fixedModel, GLMModel[] randModels, double[] VC1, double[][] VC2, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, double sumDiff2, double convergence) {
            int index;
            mmHGLMBd.updateCoeffs(GLM.this._state.beta(), GLM.this._state.ubeta());
            mmHGLMBd.updateSummVC(VC1, VC2, GLM.this._randC);
            mmHGLMBd._varfix = Math.exp(fixedModel.coefficients().get("Intercept"));
            int randColNum = mmHGLMBd._randc.length;
            if (mmHGLMBd._varranef == null) {
                mmHGLMBd._varranef = new double[randColNum];
            }
            boolean converged = true;
            double sumSigma2u = 0.0;
            for (index = 0; index < randColNum; ++index) {
                mmHGLMBd._varranef[index] = Math.exp(randModels[index].coefficients().get("Intercept"));
                sumSigma2u += mmHGLMBd._varranef[index];
            }
            for (index = 0; index < randColNum; ++index) {
                if (!(mmHGLMBd._varranef[index] / (sumSigma2u + mmHGLMBd._varfix) > 0.9999)) continue;
                converged = false;
                break;
            }
            mmHGLMBd._converge = converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            mmHGLMBd._sumetadiffsquare = sumDiff2;
            mmHGLMBd._convergence = convergence;
            mmHGLMBd._iterations = ((GLM)GLM.this)._state._iter;
            mmHGLMBd._nobs = GLM.this._nobs;
        }

        private void scoreAndUpdateModel() {
            Log.info(GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms"));
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet(((GLMModel.GLMParameters)GLM.this._parms)._train);
            GLM.this._model.score(train).delete();
            this.scorePostProcessing(train, t1);
        }

        private void scorePostProcessing(Frame train, long t1) {
            ModelMetrics mtrain = ModelMetrics.getFromDKV(GLM.this._model, train);
            long t2 = System.currentTimeMillis();
            if (mtrain != null) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = mtrain;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_time_ms = t2 - ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time;
                ScoreKeeper trainScore = new ScoreKeeper(Double.NaN);
                trainScore.fillFrom(mtrain);
                Log.info(GLM.this.LogMsg(mtrain.toString()));
            } else {
                Log.info(GLM.this.LogMsg("ModelMetrics mtrain is null"));
            }
            Log.info(GLM.this.LogMsg("Training metrics computed in " + (t2 - t1) + "ms"));
            if (GLM.this._valid != null) {
                Frame valid = (Frame)DKV.getGet(((GLMModel.GLMParameters)GLM.this._parms)._valid);
                GLM.this._model.score(valid).delete();
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = ModelMetrics.getFromDKV(GLM.this._model, valid);
                ScoreKeeper validScore = new ScoreKeeper(Double.NaN);
                validScore.fillFrom(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics);
            }
            GLM.this._model.addScoringInfo((GLMModel.GLMParameters)GLM.this._parms, GLM.this.nclasses(), t2, ((GLM)GLM.this)._state._iter);
            if (((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history) {
                int xval_iter_index;
                double xval_deviance = Double.NaN;
                double xval_se = Double.NaN;
                if (GLM.this._xval_deviances_generate_SH != null && (xval_iter_index = ArrayUtils.find(GLM.this._xval_iters_generate_SH, ((GLM)GLM.this)._state._iter)) > -1) {
                    xval_deviance = GLM.this._xval_deviances_generate_SH[xval_iter_index];
                    xval_se = GLM.this._xval_sd_generate_SH[xval_iter_index];
                }
                if (mtrain != null && GLM.this._valid != null) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        double trainDev = GLM.this._state.deviance() / (double)mtrain._nobs;
                        double validDev = ((GLMMetrics)((Object)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)).residual_deviance() / (double)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics._nobs;
                        GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, validDev, xval_deviance, xval_se, GLM.this._state.alpha());
                    } else {
                        GLM.this._scoringHistory.addIterationScore(mtrain != null, GLM.this._valid != null, ((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective(), GLM.this._state.deviance(), ((GLMMetrics)((Object)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)).residual_deviance(), mtrain._nobs, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics._nobs, GLM.this._state.lambda(), GLM.this._state.alpha());
                    }
                } else if (mtrain != null) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), GLM.this._state.deviance() / (double)mtrain._nobs, Double.NaN, xval_deviance, xval_se, GLM.this._state.alpha());
                    } else {
                        GLM.this._scoringHistory.addIterationScore(mtrain != null, GLM.this._valid != null, ((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective(), GLM.this._state.deviance(), Double.NaN, mtrain._nobs, 1L, GLM.this._state.lambda(), GLM.this._state.alpha());
                    }
                }
                GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = ((GLMModel.GLMParameters)GLM.this._parms)._lambda_search ? GLM.this._lambdaSearchScoringHistory.to2dTable() : (((GLMModel.GLMParameters)GLM.this._parms)._HGLM ? GLM.this._scoringHistory.to2dTableHGLM() : GLM.this._scoringHistory.to2dTable((GLMModel.GLMParameters)GLM.this._parms, GLM.this._xval_deviances_generate_SH, GLM.this._xval_sd_generate_SH));
            GLM.this._model.update(GLM.this._job._key);
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                GLM.this._model.generateSummaryHGLM(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            } else {
                GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            }
            this._lastScore = System.currentTimeMillis();
            long scoringTime = System.currentTimeMillis() - t1;
            this._scoringInterval = Math.max(this._scoringInterval, 20L * scoringTime);
        }

        private void coldStart(double[] devHistoryTrain, double[] devHistoryTest) {
            GLM.this._state.setBeta(GLM.this._betaStart);
            GLM.this._state.setIter(0);
            GLM.this._state.setLambdaSimple(0.0);
            ((GLM)GLM.this)._state._currGram = null;
            GLM.this._state.setBetaDiff(GLM.this._betaDiffStart);
            GLM.this._state.setGradientErr(0.0);
            GLM.this._state.setGinfo(GLM.this._ginfoStart);
            GLM.this._state.setLikelihood(((GLM)GLM.this)._ginfoStart._likelihood);
            GLM.this._state.setAllIn(false);
            GLM.this._state.setGslvrNull();
            GLM.this._state.setActiveDataMultinomialNull();
            GLM.this._state.setActiveDataNull();
            int histLen = devHistoryTrain.length;
            for (int ind = 0; ind < histLen; ++ind) {
                devHistoryTrain[ind] = 0.0;
                devHistoryTest[ind] = 0.0;
            }
        }

        private void addGLMVec(Vec[] vecs, boolean deleteFirst, DataInfo dinfo) {
            String[] vecNames = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? new String[]{"__glm_ExpC", "__glm_ExpNPC"} : new String[]{"__glm_sumExp", "__glm_maxRow"};
            if (deleteFirst) {
                dinfo._adaptedFrame.remove(vecNames);
                dinfo._responses -= vecNames.length;
            }
            dinfo.addResponse(vecNames, vecs);
        }

        protected GLMModel.Submodel computeSubmodel(int i2, double lambda, double nullDevTrain, double nullDevValid) {
            GLMModel.Submodel sm;
            boolean continueFromPreviousSubmodel;
            boolean bl = continueFromPreviousSubmodel = ((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint() && (((GLMModel.GLMParameters)GLM.this._parms)._alpha.length > 1 || ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length > 1) && GLM.this._checkPointFirstIter && !GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family);
            if (lambda >= GLM.this._lmax && GLM.this._state.l1pen() > 0.0) {
                if (continueFromPreviousSubmodel) {
                    sm = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels[i2];
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.alpha(), GLM.this.getNullBeta(), ((GLM)GLM.this)._state._iter, nullDevTrain, nullDevValid, _totalBetaLen);
                    GLM.this._model.addSubmodel(i2, sm);
                }
            } else {
                if (continueFromPreviousSubmodel) {
                    sm = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels[i2];
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.alpha(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0, _totalBetaLen);
                    if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                        sm.ubeta = Arrays.copyOf(GLM.this._state.ubeta(), GLM.this._state.ubeta().length);
                    }
                    GLM.this._model.addSubmodel(i2, sm);
                }
                if (GLM.this._insideCVCheck && ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history && !GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._solver) && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                    boolean nullVecsFound;
                    boolean bl2 = nullVecsFound = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && DKV.get(GLM.this._dinfo._adaptedFrame.vec((String)"__glm_ExpC")._key) == null || GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && DKV.get(GLM.this._dinfo._adaptedFrame.vec((String)"__glm_sumExp")._key) == null;
                    if (nullVecsFound) {
                        DataInfo[] dataInfos = ((GLM)GLM.this)._state._activeDataMultinomial;
                        if (dataInfos != null) {
                            for (int cInd = 0; cInd < GLM.this._nclass; ++cInd) {
                                Vec[] vecs = this.genGLMVectors(dataInfos[cInd], GLM.this._state.beta());
                                this.addGLMVec(vecs, true, dataInfos[cInd]);
                            }
                        }
                        Vec[] vecs = this.genGLMVectors(GLM.this._dinfo, GLM.this._state.beta());
                        this.addGLMVec(vecs, true, GLM.this._dinfo);
                    }
                }
                if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM && !GLM.this._checkPointFirstIter) {
                    GLM.this._state.setLambda(lambda);
                }
                GLM.this.checkMemoryFootPrint(GLM.this._state.activeData());
                do {
                    if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        for (int c2 = 0; c2 < GLM.this._nclass; ++c2) {
                            Log.info(GLM.this.LogMsg("Class " + c2 + " got " + GLM.this._state.activeDataMultinomial(c2).fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total"));
                        }
                    } else {
                        Log.info(GLM.this.LogMsg("Got " + GLM.this._state.activeData().fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total"));
                    }
                    this.fitModel();
                } while (!GLM.this._state.checkKKTs());
                Log.info(GLM.this.LogMsg("solution has " + ArrayUtils.countNonzeros(GLM.this._state.beta()) + " nonzeros"));
                if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.alpha(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, nullDevTrain, nullDevValid, _totalBetaLen);
                    sm.ubeta = Arrays.copyOf(GLM.this._state.ubeta(), GLM.this._state.ubeta().length);
                    GLM.this._model.updateSubmodel(i2, sm);
                } else {
                    double xvalDevSE;
                    double trainDev = GLM.this._state.deviance() / (double)GLM.this._nobs;
                    double validDev = Double.NaN;
                    if (GLM.this._validDinfo != null) {
                        validDev = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta())).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                    }
                    Log.info(GLM.this.LogMsg("train deviance = " + trainDev + ", valid deviance = " + validDev));
                    double xvalDev = GLM.this._xval_deviances == null || GLM.this._xval_deviances.length <= i2 ? -1.0 : GLM.this._xval_deviances[i2];
                    double d2 = xvalDevSE = GLM.this._xval_sd == null || GLM.this._xval_deviances.length <= i2 ? -1.0 : GLM.this._xval_sd[i2];
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, validDev, xvalDev, xvalDevSE, GLM.this._state.alpha());
                    }
                    sm = new GLMModel.Submodel(GLM.this._state.lambda(), GLM.this._state.alpha(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, trainDev, validDev, _totalBetaLen);
                    GLM.this._model.updateSubmodel(i2, sm);
                }
            }
            return sm;
        }

        @Override
        public void computeImpl() {
            try {
                this.doCompute();
            }
            finally {
                if (!(GLM.this._doInit && GLM.this._cvRuns || GLM.this._betaConstraints == null)) {
                    DKV.remove(((GLM)GLM.this)._betaConstraints._key);
                    GLM.this._betaConstraints.delete();
                }
                if (GLM.this._model != null) {
                    GLM.this._model.unlock(GLM.this._job);
                }
            }
        }

        private Vec[] genGLMVectors(DataInfo dinfo, double[] nb) {
            double maxRow = ArrayUtils.maxValue(nb);
            double sumExp = 0.0;
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                int P2 = dinfo.fullN();
                int N2 = dinfo.fullN() + 1;
                for (int i2 = 1; i2 < GLM.this._nclass; ++i2) {
                    sumExp += Math.exp(nb[i2 * N2 + P2] - maxRow);
                }
            }
            Vec[] vecs = dinfo._adaptedFrame.anyVec().makeDoubles(2, new double[]{sumExp, maxRow});
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                Scope.untrack(vecs[0]._key, vecs[1]._key);
                GLM.this.removeLater(new Key[]{vecs[0]._key, vecs[1]._key});
            }
            return vecs;
        }

        private void doCompute() {
            double nullDevTrain = Double.NaN;
            double nullDevValid = Double.NaN;
            if (GLM.this._doInit) {
                GLM.this.init(true);
            }
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(GLM.this);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time = System.currentTimeMillis();
            GLM.this._model;
            GLMModel._totalBetaLength = _totalBetaLen;
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                    nullDevTrain = ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                } else {
                    double d2 = nullDevTrain = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                }
                if (GLM.this._validDinfo != null) {
                    nullDevValid = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                }
                this._workPerIteration = 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._nlambdas;
            } else {
                this._workPerIteration = 1L + 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            if (!GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._solver) && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                Vec[] vecs = this.genGLMVectors(GLM.this._dinfo, GLM.this.getNullBeta());
                this.addGLMVec(vecs, false, GLM.this._dinfo);
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.addWdataZiEtaOld2Response();
            }
            double oldDevTrain = nullDevTrain;
            double oldDevTest = nullDevValid;
            double[] devHistoryTrain = new double[5];
            double[] devHistoryTest = new double[5];
            if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                GLM.this._ginfoStart = GLMUtils.copyGInfo(GLM.this._state.ginfo());
                GLM.this._betaDiffStart = GLM.this._state.getBetaDiff();
            }
            if (((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint()) {
                GLM.this._state.copyCheckModel2State(GLM.this._model, GLM.this._gamColIndices);
                if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length == 1) {
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels = null;
                }
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search & !((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.updateProgress(false);
            }
            int alphaStart = 0;
            int lambdaStart = 0;
            int submodelCount = 0;
            if (((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels != null) {
                submodelCount = GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length - 1;
                alphaStart = submodelCount / ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
                lambdaStart = submodelCount % ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._lambda_array_size = ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
            block0: for (int alphaInd = alphaStart; alphaInd < ((GLMModel.GLMParameters)GLM.this._parms)._alpha.length; ++alphaInd) {
                GLM.this._state.setAlpha(((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd]);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM && alphaInd > 0 && !GLM.this._checkPointFirstIter) {
                    this.coldStart(devHistoryTrain, devHistoryTest);
                }
                for (int i2 = lambdaStart; !(i2 >= ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length || GLM.this._job.stop_requested() || GLM.this.timeout() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length > 0 || ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations != -1 && ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations); ++i2) {
                    if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM && (((GLMModel.GLMParameters)GLM.this._parms)._cold_start || !((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._cold_start) && i2 > 0 && !GLM.this._checkPointFirstIter) {
                        this.coldStart(devHistoryTrain, devHistoryTest);
                    }
                    GLMModel.Submodel sm = this.computeSubmodel(submodelCount, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i2], nullDevTrain, nullDevValid);
                    if (GLM.this._checkPointFirstIter) {
                        GLM.this._checkPointFirstIter = false;
                    }
                    double trainDev = sm.devianceTrain;
                    double testDev = sm.devianceValid;
                    devHistoryTest[submodelCount % devHistoryTest.length] = (oldDevTest - testDev) / oldDevTest;
                    oldDevTest = testDev;
                    devHistoryTrain[submodelCount % devHistoryTrain.length] = (oldDevTrain - trainDev) / oldDevTrain;
                    oldDevTrain = trainDev;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda[i2] < GLM.this._lmax && Double.isNaN(GLM.this._lambdaCVEstimate) && ((GLMModel.GLMParameters)GLM.this._parms)._early_stopping && ((GLM)GLM.this)._state._iter >= devHistoryTrain.length) {
                        double s2 = ArrayUtils.maxValue(devHistoryTrain);
                        if (s2 < 1.0E-4) {
                            Log.info(GLM.this.LogMsg("converged at lambda[" + i2 + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i2] + "alpha[" + alphaInd + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd] + ", improvement on train = " + s2));
                            continue block0;
                        }
                        if (GLM.this._validDinfo != null && ((GLMModel.GLMParameters)GLM.this._parms)._nfolds <= 1 && (s2 = ArrayUtils.maxValue(devHistoryTest)) < 0.0) {
                            Log.info(GLM.this.LogMsg("converged at lambda[" + i2 + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i2] + "alpha[" + alphaInd + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd] + ", improvement on test = " + s2));
                            continue block0;
                        }
                    }
                    if ((((GLMModel.GLMParameters)GLM.this._parms)._lambda_search || ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history) && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval || ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval > 0 && ((GLM)GLM.this)._state._iter % ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval == 0)) {
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx = submodelCount;
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx, (GLMModel.GLMParameters)GLM.this._parms);
                        this.scoreAndUpdateModel();
                    }
                    GLM.this._job.update(this._workPerIteration, "iter=" + ((GLM)GLM.this)._state._iter + " lmb=" + lambdaFormatter.format(GLM.this._state.lambda()) + " alpha=" + lambdaFormatter.format(GLM.this._state.alpha()) + "deviance trn/tst= " + devFormatter.format(trainDev) + "/" + devFormatter.format(testDev) + " P=" + ArrayUtils.countNonzeros(GLM.this._state.beta()));
                    ++submodelCount;
                }
            }
            if (GLM.this._betaConstraintsOn && this.betaConstraintsCheckEnabled()) {
                this.checkCoeffsBounds();
            }
            if (GLM.this.stop_requested() || GLM.this._earlyStop) {
                if (GLM.this.timeout()) {
                    Log.info("Stopping GLM training because of timeout");
                } else if (GLM.this._earlyStop) {
                    Log.info("Stopping GLM training due to hitting earlyStopping criteria.");
                } else {
                    throw new Job.JobCancelledException();
                }
            }
            if (((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.warn("Reached maximum number of iterations " + ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations + "!");
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._nfolds > 1 && !Double.isNaN(GLM.this._lambdaCVEstimate) && GLM.this._bestCVSubmodel < ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx = GLM.this._bestCVSubmodel;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx, (GLMModel.GLMParameters)((GLM)GLM.this)._model._parms);
            } else {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms);
            }
            if (this._vcov != null) {
                GLM.this._model.setVcov(this._vcov);
                GLM.this._model.update(GLM.this._job._key);
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.scoreAndUpdateModel();
            }
            TwoDimTable scoring_history_early_stop = ScoringInfo.createScoringHistoryTable(GLM.this._model.getScoringInfo(), null != ((GLMModel.GLMParameters)GLM.this._parms)._valid, false, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).getModelCategory(), false);
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLMUtils.combineScoringHistory(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history, scoring_history_early_stop);
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._varimp = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).calculateVarimp();
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._variable_importances = ModelMetrics.calcVarImp(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._varimp);
            GLM.this._model.update(GLM.this._job._key);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.update(this._workPerIteration * (long)(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations - ((GLM)GLM.this)._state._iter));
            }
            if (GLM.this._iceptAdjust != 0.0) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept);
                double[] b2 = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._global_beta;
                int n2 = b2.length - 1;
                b2[n2] = b2[n2] + GLM.this._iceptAdjust;
                for (GLMModel.Submodel sm : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels) {
                    int n3 = sm.beta.length - 1;
                    sm.beta[n3] = sm.beta[n3] + GLM.this._iceptAdjust;
                }
                GLM.this._model.update(GLM.this._job._key);
            }
        }

        private boolean betaConstraintsCheckEnabled() {
            return Boolean.parseBoolean(GLM.this.getSysProperty("glm.beta.constraints.checkEnabled", "true")) && !GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family);
        }

        private void checkCoeffsBounds() {
            double[] coeffs;
            BetaConstraint bc = ((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints != null ? new BetaConstraint(((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints.get()) : new BetaConstraint();
            double[] dArray = coeffs = ((GLMModel.GLMParameters)GLM.this._parms)._standardize ? ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).getNormBeta() : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).beta();
            if (bc._betaLB == null || bc._betaUB == null || coeffs == null) {
                return;
            }
            int coeffsLen = bc._betaLB.length;
            for (int index = 0; index < coeffsLen; ++index) {
                if (coeffs[index] == 0.0 || coeffs[index] >= bc._betaLB[index] && coeffs[index] <= bc._betaUB[index]) continue;
                throw new H2OFailException("GLM model coefficients do not fall within beta constraint bounds.");
            }
        }

        public void addWdataZiEtaOld2Response() {
            int index;
            int moreColnum = 3 + ((GLMModel.GLMParameters)GLM.this._parms)._random_columns.length;
            Vec[] vecs = GLM.this._dinfo._adaptedFrame.anyVec().makeZeros(moreColnum);
            String[] colNames = new String[moreColnum];
            colNames[0] = "wData";
            colNames[1] = "zi";
            colNames[2] = "etaOld";
            int[] randColIndices = ((GLMModel.GLMParameters)GLM.this._parms)._random_columns;
            for (index = 3; index < moreColnum; ++index) {
                colNames[index] = ((GLMModel.GLMParameters)GLM.this._parms).train().name(index - 3);
                vecs[index] = ((GLMModel.GLMParameters)GLM.this._parms).train().vec(randColIndices[index - 3]).makeCopy();
            }
            GLM.this._dinfo.addResponse(colNames, vecs);
            for (index = 0; index < moreColnum; ++index) {
                Scope.untrack(vecs[index]._key);
                GLM.this.removeLater(new Key[]{vecs[index]._key});
            }
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.doCleanup();
            super.onCompletion(caller);
        }

        @Override
        public boolean onExceptionalCompletion(Throwable t2, CountedCompleter caller) {
            this.doCleanup();
            return super.onExceptionalCompletion(t2, caller);
        }

        @Override
        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            if (ginfo instanceof ProximalGradientInfo) {
                ginfo = ((ProximalGradientInfo)ginfo)._origGinfo;
                GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                GLM.this._state.updateState(beta, gginfo);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    this.updateProgress(false);
                }
                return !GLM.this.stop_requested() && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
            }
            GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
            if (gginfo._gradient == null) {
                GLM.this._state.updateState(beta, gginfo._likelihood);
            } else {
                GLM.this._state.updateState(beta, gginfo);
            }
            if (!(((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && !((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history || GLM.this._insideCVCheck)) {
                this.updateProgress(true);
            }
            boolean bl = converged = !GLM.this._earlyStopEnabled && GLM.this._state.converged();
            if (converged) {
                Log.info(GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg));
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
        }

        public boolean progressHGLMGLMMME(double sumDiff2, double sumeta2, int iteration, boolean atGLMMME, GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double[][] cholR, Frame augZ) {
            boolean converged;
            boolean bl = converged = !GLM.this._earlyStopEnabled && sumDiff2 < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * sumeta2;
            if (atGLMMME) {
                ++((GLM)GLM.this)._state._iterHGLM_GLMMME;
            } else {
                ++((GLM)GLM.this)._state._iter;
                this.updateProgress(fixedModel, randModels, glmmmeReturns, hvDataOnly, VC1, VC2, sumDiff2, sumDiff2 / sumeta2, true, cholR, augZ);
            }
            return !GLM.this.stop_requested() && !converged && iteration < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
        }

        public boolean progress(double[] beta, double likelihood) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, likelihood);
            if (!(((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && !((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history || GLM.this._insideCVCheck)) {
                this.updateProgress(true);
            }
            boolean bl = converged = !GLM.this._earlyStopEnabled && GLM.this._state.converged();
            if (converged) {
                Log.info(GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg));
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
        }

        protected void updateProgress(GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double sumDiff2, double convergence, boolean canScore, double[][] cholR, Frame augXZ) {
            GLM.this._scoringHistory.addIterationScore(((GLM)GLM.this)._state._iter, ((GLM)GLM.this)._state._sumEtaSquareConvergence);
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval || ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval > 0 && ((GLM)GLM.this)._state._iter % ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval == 0)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), GLM.this._state.ubeta(), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModelHGLM(fixedModel, randModels, glmmmeReturns, hvDataOnly, VC1, VC2, sumDiff2, convergence, cholR, augXZ, false);
                GLM.this._earlyStop = GLM.this._earlyStopEnabled && GLM.this.updateEarlyStop();
            }
        }

        protected void updateProgress(boolean canScore) {
            assert (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search || ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history && !((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._scoringHistory.addIterationScore(((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective());
                GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            }
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval || ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval > 0 && ((GLM)GLM.this)._state._iter % ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval == 0)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModel();
                GLM.this._earlyStop = GLM.this._earlyStopEnabled && GLM.this.updateEarlyStop();
            }
        }
    }

    static class LambdaSearchScoringHistory {
        ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _lambdaDevXval;
        private ArrayList<Double> _lambdaDevXvalSE;
        private ArrayList<Double> _alphas = new ArrayList();

        public LambdaSearchScoringHistory(boolean hasTest, boolean hasXval) {
            if (hasTest) {
                this._lambdaDevTest = new ArrayList();
            }
            if (hasXval) {
                this._lambdaDevXval = new ArrayList();
                this._lambdaDevXvalSE = new ArrayList();
            }
        }

        public ArrayList<Integer> getScoringIters() {
            return this._lambdaIters;
        }

        public ArrayList<Long> getScoringTimes() {
            return this._scoringTimes;
        }

        public ArrayList<Double> getLambdas() {
            return this._lambdas;
        }

        public ArrayList<Double> getAlphas() {
            return this._alphas;
        }

        public ArrayList<Double> getDevTrain() {
            return this._lambdaDevTrain;
        }

        public ArrayList<Double> getDevTest() {
            return this._lambdaDevTest;
        }

        public ArrayList<Integer> getPredictors() {
            return this._lambdaPredictors;
        }

        public synchronized void addLambdaScore(int iter2, int predictors, double lambda, double devRatioTrain, double devRatioTest, double devRatioXval, double devRatoioXvalSE, double alpha) {
            if (this._lambdaIters.size() > 0 && iter2 <= this._lambdaIters.get(this._lambdaIters.size() - 1)) {
                return;
            }
            this._scoringTimes.add(System.currentTimeMillis());
            this._lambdaIters.add(iter2);
            this._alphas.add(alpha);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(predictors);
            this._lambdaDevTrain.add(devRatioTrain);
            if (this._lambdaDevTest != null) {
                this._lambdaDevTest.add(devRatioTest);
            }
            if (this._lambdaDevXval != null) {
                this._lambdaDevXval.add(devRatioXval);
            }
            if (this._lambdaDevXvalSE != null) {
                this._lambdaDevXvalSE.add(devRatoioXvalSE);
            }
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iteration", "lambda", "predictors", "deviance_train"};
            if (this._lambdaDevTest != null) {
                cnames = ArrayUtils.append(cnames, "deviance_test");
            }
            if (this._lambdaDevXval != null) {
                cnames = ArrayUtils.append(cnames, new String[]{"deviance_xval", "deviance_se"});
            }
            String[] ctypes = new String[]{"string", "string", "int", "string", "int", "double"};
            if (this._lambdaDevTest != null) {
                ctypes = ArrayUtils.append(ctypes, "double");
            }
            if (this._lambdaDevXval != null) {
                ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double"});
            }
            String[] cformats = new String[]{"%s", "%s", "%d", "%s", "%d", "%.3f"};
            if (this._lambdaDevTest != null) {
                cformats = ArrayUtils.append(cformats, "%.3f");
            }
            if (this._lambdaDevXval != null) {
                cformats = ArrayUtils.append(cformats, new String[]{"%.3f", "%.3f"});
            }
            cnames = ArrayUtils.append(cnames, "alpha");
            ctypes = ArrayUtils.append(ctypes, "double");
            cformats = ArrayUtils.append(cformats, "%.6f");
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._lambdaIters.size()], cnames, ctypes, cformats, "");
            for (int i2 = 0; i2 < this._lambdaIters.size(); ++i2) {
                int col = 0;
                res.set(i2, col++, DATE_TIME_FORMATTER.print(this._scoringTimes.get(i2)));
                res.set(i2, col++, PrettyPrint.msecs(this._scoringTimes.get(i2) - this._scoringTimes.get(0), true));
                res.set(i2, col++, this._lambdaIters.get(i2));
                res.set(i2, col++, lambdaFormatter.format(this._lambdas.get(i2)));
                res.set(i2, col++, this._lambdaPredictors.get(i2));
                res.set(i2, col++, this._lambdaDevTrain.get(i2));
                if (this._lambdaDevTest != null) {
                    res.set(i2, col++, this._lambdaDevTest.get(i2));
                }
                if (this._lambdaDevXval != null && this._lambdaDevXval.size() > i2) {
                    res.set(i2, col++, this._lambdaDevXval.get(i2));
                    res.set(i2, col++, this._lambdaDevXvalSE.get(i2));
                }
                res.set(i2, col++, this._alphas.get(i2));
            }
            return res;
        }

        void restoreFromCheckpoint(TwoDimTable sHist, int[] colIndices) {
            int numRows = sHist.getRowDim();
            for (int rowInd = 0; rowInd < numRows; ++rowInd) {
                this._scoringTimes.add(DATE_TIME_FORMATTER.parseMillis((String)sHist.get(rowInd, colIndices[1])));
                this._lambdaIters.add((int)((Integer)sHist.get(rowInd, colIndices[0])));
                this._lambdas.add(Double.valueOf((String)sHist.get(rowInd, colIndices[2])));
                this._alphas.add((Double)sHist.get(rowInd, colIndices[6]));
                this._lambdaPredictors.add((int)((Integer)sHist.get(rowInd, colIndices[3])));
                this._lambdaDevTrain.add((double)((Double)sHist.get(rowInd, colIndices[4])));
                if (colIndices[5] <= -1) continue;
                this._lambdaDevTest.add((double)((Double)sHist.get(rowInd, colIndices[5])));
            }
        }
    }

    static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();
        private ArrayList<Double> _convergence = new ArrayList();
        private ArrayList<Double> _sumEtaiSquare = new ArrayList();
        private ArrayList<Double> _lambdas;
        private ArrayList<Double> _lambdaDevTrain;
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _alphas;

        public ArrayList<Integer> getScoringIters() {
            return this._scoringIters;
        }

        public ArrayList<Long> getScoringTimes() {
            return this._scoringTimes;
        }

        public ArrayList<Double> getLikelihoods() {
            return this._likelihoods;
        }

        public ArrayList<Double> getObjectives() {
            return this._objectives;
        }

        public ScoringHistory(boolean hasTest, boolean hasXval, boolean generate_scoring_historty) {
            if (hasTest) {
                this._lambdaDevTest = new ArrayList();
            }
            if (generate_scoring_historty) {
                this._lambdas = new ArrayList();
                this._lambdaDevTrain = new ArrayList();
                if (hasTest) {
                    this._lambdaDevTest = new ArrayList();
                }
                this._alphas = new ArrayList();
            }
        }

        public synchronized void addIterationScore(int iter2, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) >= iter2) {
                return;
            }
            this._scoringIters.add(iter2);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized void addIterationScore(boolean updateTrain, boolean updateValid, int iter2, double likelihood, double obj, double dev, double devValid, long nobs, long nobsValid, double lambda, double alpha) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) >= iter2) {
                return;
            }
            if (updateTrain) {
                this._scoringIters.add(iter2);
                this._scoringTimes.add(System.currentTimeMillis());
                this._likelihoods.add(likelihood);
                this._objectives.add(obj);
                this._lambdaDevTrain.add(dev / (double)nobs);
                this._lambdas.add(lambda);
                this._alphas.add(alpha);
            }
            if (updateValid) {
                this._lambdaDevTest.add(devValid / (double)nobsValid);
            }
        }

        public synchronized void addIterationScore(int iter2, double[] sumEtaInfo) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) >= iter2) {
                return;
            }
            this._scoringIters.add(iter2);
            this._scoringTimes.add(System.currentTimeMillis());
            this._sumEtaiSquare.add(sumEtaInfo[0]);
            this._convergence.add(sumEtaInfo[0] / sumEtaInfo[1]);
        }

        public synchronized TwoDimTable to2dTable(GLMModel.GLMParameters parms, double[] xvalDev, double[] xvalSE) {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "negative_log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            if (parms._generate_scoring_history) {
                cnames = ArrayUtils.append(cnames, new String[]{"alpha", "lambda", "deviance_train"});
                ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double", "double"});
                cformats = ArrayUtils.append(cformats, new String[]{"%.5f", "%.5f", "%.5f"});
                if (this._lambdaDevTest != null) {
                    cnames = ArrayUtils.append(cnames, new String[]{"deviance_test"});
                    ctypes = ArrayUtils.append(ctypes, new String[]{"double"});
                    cformats = ArrayUtils.append(cformats, new String[]{"%.5f"});
                }
                if (xvalDev != null && xvalDev.length > 0) {
                    cnames = ArrayUtils.append(cnames, new String[]{"deviance_xval", "deviance_se"});
                    ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double"});
                    cformats = ArrayUtils.append(cformats, new String[]{"%.5f", "%.5f"});
                }
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            for (int i2 = 0; i2 < this._scoringIters.size(); ++i2) {
                int col = 0;
                res.set(i2, col++, DATE_TIME_FORMATTER.print(this._scoringTimes.get(i2)));
                res.set(i2, col++, PrettyPrint.msecs(this._scoringTimes.get(i2) - this._scoringTimes.get(0), true));
                res.set(i2, col++, this._scoringIters.get(i2));
                res.set(i2, col++, this._likelihoods.get(i2));
                res.set(i2, col++, this._objectives.get(i2));
                if (!parms._generate_scoring_history) continue;
                res.set(i2, col++, this._alphas.get(i2));
                res.set(i2, col++, this._lambdas.get(i2));
                res.set(i2, col++, this._lambdaDevTrain.get(i2));
                if (this._lambdaDevTest != null) {
                    res.set(i2, col++, this._lambdaDevTest.get(i2));
                }
                if (xvalDev == null || i2 >= xvalDev.length) continue;
                res.set(i2, col++, xvalDev[i2]);
                res.set(i2, col, xvalSE[i2]);
            }
            return res;
        }

        public synchronized TwoDimTable to2dTableHGLM() {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "sum(etai-eta0)^2", "convergence"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            for (int i2 = 0; i2 < this._scoringIters.size(); ++i2) {
                int col = 0;
                res.set(i2, col++, DATE_TIME_FORMATTER.print(this._scoringTimes.get(i2)));
                res.set(i2, col++, PrettyPrint.msecs(this._scoringTimes.get(i2) - this._scoringTimes.get(0), true));
                res.set(i2, col++, this._scoringIters.get(i2));
                res.set(i2, col++, this._sumEtaiSquare.get(i2));
                res.set(i2, col++, this._convergence.get(i2));
            }
            return res;
        }

        void restoreFromCheckpoint(TwoDimTable sHist, int[] colIndices, boolean hglm) {
            int numRows = sHist.getRowDim();
            for (int rowInd = 0; rowInd < numRows; ++rowInd) {
                this._scoringIters.add((Integer)sHist.get(rowInd, colIndices[0]));
                this._scoringTimes.add(DATE_TIME_FORMATTER.parseMillis((String)sHist.get(rowInd, colIndices[1])));
                this._likelihoods.add((Double)sHist.get(rowInd, colIndices[2]));
                this._objectives.add((Double)sHist.get(rowInd, colIndices[3]));
                if (!hglm) continue;
                this._convergence.add((Double)sHist.get(rowInd, colIndices[4]));
                this._sumEtaiSquare.add((Double)sHist.get(rowInd, colIndices[5]));
            }
        }
    }
}

