/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import java.util.Arrays;

public class GamUtilsCubicRegression {
    public static double gen_a_m_j(double xjp1, double x2, double hj) {
        return (xjp1 - x2) / hj;
    }

    public static double gen_a_p_j(double xj, double x2, double hj) {
        return (x2 - xj) / hj;
    }

    public static double gen_c_m_j(double xjp1, double x2, double hj) {
        double t2 = xjp1 - x2;
        double t3 = t2 * t2 * t2;
        return (t3 / hj - t2 * hj) / 6.0;
    }

    public static double gen_c_p_j(double xj, double x2, double hj) {
        double t2 = x2 - xj;
        double t3 = t2 * t2 * t2;
        return (t3 / hj - t2 * hj) / 6.0;
    }

    public static int locateBin(double xval, double[] knots) {
        if (xval <= knots[0]) {
            return 0;
        }
        int highIndex = knots.length - 1;
        if (xval >= knots[highIndex]) {
            return highIndex - 1;
        }
        int tryBin = -1;
        int numBins = knots.length;
        int lowIndex = 0;
        for (int count2 = 0; count2 < numBins; ++count2) {
            tryBin = (int)Math.floor((double)(highIndex + lowIndex) * 0.5);
            if (xval >= knots[tryBin] && xval < knots[tryBin + 1]) {
                return tryBin;
            }
            if (xval > knots[tryBin]) {
                lowIndex = tryBin;
                continue;
            }
            if (!(xval < knots[tryBin])) continue;
            highIndex = tryBin;
        }
        return tryBin;
    }

    public static void updateAFunc(double[] basisVals, double xval, int binIndex, double[] knots, double[] hj) {
        int jp1 = binIndex + 1;
        int n2 = binIndex;
        basisVals[n2] = basisVals[n2] + GamUtilsCubicRegression.gen_a_m_j(knots[jp1], xval, hj[binIndex]);
        int n3 = jp1;
        basisVals[n3] = basisVals[n3] + GamUtilsCubicRegression.gen_a_p_j(knots[binIndex], xval, hj[binIndex]);
    }

    public static void updateFMatrixCFunc(double[] basisVals, double xval, int binIndex, double[] knots, double[] hj, double[][] binvD) {
        int numKnots = basisVals.length;
        int matSize = binvD.length;
        int jp1 = binIndex + 1;
        double cmj = GamUtilsCubicRegression.gen_c_m_j(knots[jp1], xval, hj[binIndex]);
        double cpj = GamUtilsCubicRegression.gen_c_p_j(knots[binIndex], xval, hj[binIndex]);
        int binIndexM1 = binIndex - 1;
        for (int index = 0; index < numKnots; ++index) {
            basisVals[index] = binIndex == 0 ? binvD[binIndex][index] * cpj : (binIndex >= matSize ? binvD[binIndexM1][index] * cmj : binvD[binIndexM1][index] * cmj + binvD[binIndex][index] * cpj);
        }
    }

    public static void expandOneGamCol(double xval, double[][] binvD, double[] basisVals, double[] hj, double[] knots) {
        if (!Double.isNaN(xval)) {
            int binIndex = GamUtilsCubicRegression.locateBin(xval, knots);
            GamUtilsCubicRegression.updateFMatrixCFunc(basisVals, xval, binIndex, knots, hj, binvD);
            GamUtilsCubicRegression.updateAFunc(basisVals, xval, binIndex, knots, hj);
        } else {
            Arrays.fill(basisVals, Double.NaN);
        }
    }
}

