/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.GenModel;
import hex.genmodel.easy.BinaryColumnMapper;
import hex.genmodel.easy.BinaryDomainMapConstructor;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EigenEncoderColumnMapper;
import hex.genmodel.easy.EigenEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumEncoderColumnMapper;
import hex.genmodel.easy.EnumEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumLimitedEncoderColumnMapper;
import hex.genmodel.easy.EnumLimitedEncoderDomainMapConstructor;
import hex.genmodel.easy.LabelEncoderDomainMapConstructor;
import hex.genmodel.easy.OneHotEncoderColumnMapper;
import hex.genmodel.easy.OneHotEncoderDomainMapConstructor;
import java.util.Map;

public enum CategoricalEncoding {
    AUTO(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new EnumEncoderColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new EnumEncoderDomainMapConstructor(m4, columnMapping).create();
        }
    }
    ,
    OneHotExplicit(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new OneHotEncoderColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new OneHotEncoderDomainMapConstructor(m4, columnMapping).create();
        }
    }
    ,
    Binary(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new BinaryColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new BinaryDomainMapConstructor(m4, columnMapping).create();
        }
    }
    ,
    EnumLimited(true){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new EnumLimitedEncoderColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new EnumLimitedEncoderDomainMapConstructor(m4, columnMapping).create();
        }
    }
    ,
    Eigen(true){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new EigenEncoderColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new EigenEncoderDomainMapConstructor(m4, columnMapping).create();
        }
    }
    ,
    LabelEncoder(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m4) {
            return new EnumEncoderColumnMapper(m4).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m4, Map<String, Integer> columnMapping) {
            return new LabelEncoderDomainMapConstructor(m4, columnMapping).create();
        }
    };

    private final boolean _parametrized;

    private CategoricalEncoding(boolean parametrized) {
        this._parametrized = parametrized;
    }

    public abstract Map<String, Integer> createColumnMapping(GenModel var1);

    public abstract Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel var1, Map<String, Integer> var2);

    public boolean isParametrized() {
        return this._parametrized;
    }
}

