/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.gam.GAMModel;
import hex.gam.GamSplines.ThinPlateDistanceWithKnots;
import hex.gam.GamSplines.ThinPlatePolynomialWithKnots;
import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.gam.MatrixFrameUtils.GamUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class AddTPKnotsGamColumns {
    final double[][][] _zCS;
    final double[][][] _z;
    final int[][][] _polyBasisList;
    final int[] _numKnots;
    final int[] _d;
    final int[] _M;
    final int[] _m;
    final GAMModel.GAMParameters _parms;
    public final int _gamCols2Add;
    final double[][][] _knots;
    final int _numTPCols;
    final int _numCSCols;
    final double[] _constantTerms;
    final boolean[] _dEven;
    final Frame _adapted;
    public Key<Frame>[] _gamFrameKeysCenter;

    public AddTPKnotsGamColumns(GAMModel.GAMParameters parms, double[][][] zcs, double[][][] z2, int[][][] polyBasis, double[][][] knots, Frame fr) {
        this._zCS = zcs;
        this._z = z2;
        this._polyBasisList = polyBasis;
        this._numKnots = parms._num_knots_tp;
        this._d = parms._gamPredSize;
        this._M = parms._M;
        this._m = parms._m;
        this._parms = parms;
        this._gamCols2Add = ArrayUtils.sum(this._numKnots) - this._numKnots.length;
        this._knots = knots;
        this._numTPCols = this._M.length;
        this._numCSCols = parms._gam_columns_sorted.length - this._numTPCols;
        this._dEven = new boolean[this._numTPCols];
        this._constantTerms = new double[this._numTPCols];
        this._gamFrameKeysCenter = new Key[this._numTPCols];
        for (int index = 0; index < this._numTPCols; ++index) {
            this._dEven[index] = this._parms._gamPredSize[index] % 2 == 0;
            this._constantTerms[index] = this._dEven[index] ? Math.pow(-1.0, (double)(this._m[index] + 1) + (double)this._d[index] / 2.0) / (Math.pow(2.0, this._m[index] - 1) * Math.pow(Math.PI, (double)this._d[index] / 2.0) * (double)CombinatoricsUtils.factorial((int)(this._m[index] - this._d[index] / 2))) : Math.pow(-1.0, this._m[index]) * (double)this._m[index] / ((double)CombinatoricsUtils.factorial((int)(2 * this._m[index])) * Math.pow(Math.PI, (double)(this._d[index] - 1) / 2.0));
        }
        this._adapted = fr;
    }

    public void addTPGamCols(double[][] gamColMeansRaw, double[][] oneOColStd) {
        for (int index = 0; index < this._numTPCols; ++index) {
            int offsetIndex = index + this._numCSCols;
            Frame predictVec = GamUtils.prepareGamVec(offsetIndex, this._parms, this._adapted);
            ApplyTPRegressionSmootherWithKnots addSmoother = new ApplyTPRegressionSmootherWithKnots(predictVec, this._parms, offsetIndex, this._knots[offsetIndex], index, this._zCS[index], this._z[offsetIndex], this._polyBasisList[index], gamColMeansRaw[index], oneOColStd[index]);
            addSmoother.applySmoothers();
        }
    }

    public class ApplyTPRegressionSmootherWithKnots {
        final Frame _predictVec;
        final int _numKnots;
        final int _numKnotsM1;
        final int _numKnotsMM;
        final double[][] _knots;
        final GAMModel.GAMParameters _parms;
        final int _gamColIndex;
        final int _thinPlateGamColIndex;
        final int _numPred;
        final int _M;
        final double[][] _zCST;
        final double[][] _zT;
        final int[][] _polyBasisList;
        final double[] _gamColMeanRaw;
        final double[] _oneOColStd;

        public ApplyTPRegressionSmootherWithKnots(Frame predV, GAMModel.GAMParameters parms, int gamColIndex, double[][] knots, int thinPlateInd, double[][] zCST, double[][] zT, int[][] polyBasis, double[] gamColMeanRaw, double[] oneOColStd) {
            this._predictVec = predV;
            this._knots = knots;
            this._numKnots = knots[0].length;
            this._numKnotsM1 = this._numKnots - 1;
            this._parms = parms;
            this._gamColIndex = gamColIndex;
            this._thinPlateGamColIndex = thinPlateInd;
            this._numPred = parms._gam_columns_sorted[gamColIndex].length;
            this._M = this._parms._M[this._thinPlateGamColIndex];
            this._numKnotsMM = this._numKnots - this._M;
            this._zCST = zCST;
            this._zT = zT;
            this._polyBasisList = polyBasis;
            this._gamColMeanRaw = gamColMeanRaw;
            this._oneOColStd = oneOColStd;
        }

        void applySmoothers() {
            ThinPlateDistanceWithKnots distanceMeasure = (ThinPlateDistanceWithKnots)new ThinPlateDistanceWithKnots(this._knots, this._numPred, this._oneOColStd, this._parms._standardize).doAll(this._numKnots, (byte)3, this._predictVec);
            String colNameStub = ThinPlateRegressionUtils.genThinPlateNameStart(this._parms, this._gamColIndex);
            String[] gamColNames = GamUtils.generateGamColNamesThinPlateKnots(this._gamColIndex, this._parms, this._polyBasisList, colNameStub);
            String[] distanceColNames = ThinPlateRegressionUtils.extractColNames(gamColNames, 0, 0, this._numKnots);
            String[] polyNames = ThinPlateRegressionUtils.extractColNames(gamColNames, this._numKnots, 0, this._M);
            Frame thinPlateFrame = distanceMeasure.outputFrame(Key.make(), distanceColNames, null);
            thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "CS_", this._parms, this._zCST, this._numKnotsMM);
            ThinPlatePolynomialWithKnots thinPlatePoly = (ThinPlatePolynomialWithKnots)new ThinPlatePolynomialWithKnots(this._numPred, this._polyBasisList, this._gamColMeanRaw, this._oneOColStd, this._parms._standardize).doAll(this._M, (byte)3, this._predictVec);
            Frame thinPlatePolyBasis = thinPlatePoly.outputFrame(null, polyNames, null);
            thinPlateFrame.add(thinPlatePolyBasis.names(), thinPlatePolyBasis.removeAll());
            thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "center", this._parms, this._zT, this._numKnotsM1);
            AddTPKnotsGamColumns.this._gamFrameKeysCenter[this._thinPlateGamColIndex] = thinPlateFrame._key;
            DKV.put(thinPlateFrame);
        }
    }
}

