/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.GamSplines.NBSplinesTypeI;
import hex.gam.GamSplines.NBSplinesUtils;
import hex.genmodel.algos.gam.GamUtilsISplines;
import water.util.ArrayUtils;

public class NBSplinesTypeIDerivative {
    private final int _order;
    private final int _basisIndex;
    private final double[] _knots;
    private final double _commonConst;
    public double[][] _coeffs;
    private NBSplinesTypeI _left;
    private NBSplinesTypeI _right;

    public NBSplinesTypeIDerivative(int basisIndex, int order, double[] fullKnots) {
        this._order = order;
        this._basisIndex = basisIndex;
        this._knots = GamUtilsISplines.extractKnots(this._basisIndex, order, fullKnots);
        this._commonConst = (double)this._order * (this._knots[this._order] == this._knots[0] ? 0.0 : 1.0 / (this._knots[this._order] - this._knots[0]));
        this._left = NBSplinesTypeI.formBasis(this._knots, this._order - 1, basisIndex, 0, fullKnots.length - 1);
        this._right = NBSplinesTypeI.formBasis(this._knots, this._order - 1, basisIndex, 1, fullKnots.length - 1);
        this._coeffs = NBSplinesTypeIDerivative.extractDerivativeCoeff(this._left, this._right, fullKnots, basisIndex, this._commonConst);
    }

    public static double[][] extractDerivativeCoeff(NBSplinesTypeI left, NBSplinesTypeI rite, double[] knots, int basisIndex, double parentConst) {
        double[][] coeffsLeft = NBSplinesTypeI.extractCoeffs(left, basisIndex, parentConst);
        double[][] coeffsRite = NBSplinesTypeI.extractCoeffs(rite, basisIndex + 1, parentConst);
        ArrayUtils.mult(coeffsRite, -1.0);
        double[][] combinedCoeffs = new double[knots.length - 1][];
        NBSplinesUtils.sumCoeffs(coeffsLeft, coeffsRite, combinedCoeffs);
        return combinedCoeffs;
    }

    public static double[][] genPenaltyMatrix(double[] knots, int order) {
        int numBasis = knots.length + order - 2;
        if (order <= 1) {
            return new double[numBasis][numBasis];
        }
        double[] knotsWithDuplicates = GamUtilsISplines.fillKnots(knots, order);
        NBSplinesTypeIDerivative[] allDerivatives = NBSplinesTypeIDerivative.formDerivatives(numBasis, order, knotsWithDuplicates);
        double[][] penaltyMat = new double[numBasis][numBasis];
        for (int i2 = 0; i2 < numBasis; ++i2) {
            for (int j2 = i2; j2 < numBasis; ++j2) {
                double[][] coeffProduct = NBSplinesTypeIDerivative.formDerivateProduct(i2, j2, allDerivatives);
                penaltyMat[i2][j2] = NBSplinesUtils.integratePolynomial(knotsWithDuplicates, coeffProduct);
                penaltyMat[j2][i2] = penaltyMat[i2][j2];
            }
        }
        return penaltyMat;
    }

    public static NBSplinesTypeIDerivative[] formDerivatives(int numBasis, int order, double[] fullKnots) {
        NBSplinesTypeIDerivative[] allDerivs = new NBSplinesTypeIDerivative[numBasis];
        for (int index = 0; index < numBasis; ++index) {
            allDerivs[index] = new NBSplinesTypeIDerivative(index, order, fullKnots);
        }
        return allDerivs;
    }

    public static double[][] formDerivateProduct(int firstIndex, int secondIndex, NBSplinesTypeIDerivative[] allDeriv) {
        double[][] firstCoeff = allDeriv[firstIndex]._coeffs;
        double[][] secondCoeff = allDeriv[secondIndex]._coeffs;
        int numBasis = firstCoeff.length;
        double[][] polyProduct = new double[numBasis][];
        for (int index = 0; index < numBasis; ++index) {
            if (firstCoeff[index] == null || secondCoeff[index] == null) continue;
            polyProduct[index] = NBSplinesUtils.polynomialProduct(firstCoeff[index], secondCoeff[index]);
        }
        return polyProduct;
    }
}

