/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.ModelMojoWriter;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningModelInfo;
import java.io.IOException;
import water.H2O;

public class DeepLearningMojoWriter
extends ModelMojoWriter<DeepLearningModel, DeepLearningModel.DeepLearningParameters, DeepLearningModel.DeepLearningModelOutput> {
    private DeepLearningModel.DeepLearningParameters _parms;
    private DeepLearningModelInfo _model_info;
    private DeepLearningModel.DeepLearningModelOutput _output;

    public DeepLearningMojoWriter() {
    }

    public DeepLearningMojoWriter(DeepLearningModel model) {
        super(model);
        this._parms = model.get_params();
        this._model_info = model.model_info();
        this._output = (DeepLearningModel.DeepLearningModelOutput)model._output;
        if (this._model_info.isUnstable()) {
            throw new UnsupportedOperationException(H2O.technote(4, "Refusing to create a MOJO for an unstable model."));
        }
    }

    @Override
    public String mojoVersion() {
        return "1.10";
    }

    @Override
    protected void writeModelData() throws IOException {
        this.writekv("mini_batch_size", this._parms._mini_batch_size);
        this.writekv("nums", this._model_info.data_info._nums);
        this.writekv("cats", this._model_info.data_info._cats);
        this.writekv("cat_offsets", this._model_info.data_info._catOffsets);
        this.writekv("norm_mul", this._model_info.data_info()._normMul);
        this.writekv("norm_sub", this._model_info.data_info()._normSub);
        this.writekv("norm_resp_mul", this._model_info.data_info._normRespMul);
        this.writekv("norm_resp_sub", this._model_info.data_info._normRespSub);
        this.writekv("use_all_factor_levels", this._parms._use_all_factor_levels);
        this.writekv("activation", (Object)this._parms._activation);
        this.writekv("distribution", (Object)this._parms._distribution);
        boolean imputeMeans = this._parms._missing_values_handling.equals((Object)DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation);
        this.writekv("mean_imputation", imputeMeans);
        if (imputeMeans && this._model_info.data_info._cats > 0) {
            this.writekv("cat_modes", this._model_info.data_info.catNAFill());
        }
        this.writekv("neural_network_sizes", this._model_info.units);
        int numberOfWeights = 1 + this._parms._hidden.length;
        double[] all_drop_out_ratios = new double[numberOfWeights];
        for (int index = 0; index < numberOfWeights; ++index) {
            all_drop_out_ratios[index] = index == this._parms._hidden.length ? 0.0 : (this._parms._hidden_dropout_ratios != null ? this._parms._hidden_dropout_ratios[index] : 0.0);
            this.writekv("weight_layer" + index, this._model_info.get_weights(index).raw());
            this.writekv("bias_layer" + index, this._model_info.get_biases(index).raw());
        }
        this.writekv("hidden_dropout_ratios", all_drop_out_ratios);
        this.writekv("_genmodel_encoding", (Object)((DeepLearningModel)this.model).getGenModelEncoding());
        String[] origNames = ((DeepLearningModel.DeepLearningModelOutput)((DeepLearningModel)this.model)._output)._origNames;
        if (origNames != null) {
            int nOrigNames = origNames.length;
            this.writekv("_n_orig_names", nOrigNames);
            this.writeStringArray(origNames, "_orig_names");
        }
        if (((DeepLearningModel.DeepLearningModelOutput)((DeepLearningModel)this.model)._output)._origDomains != null) {
            int nOrigDomainValues = ((DeepLearningModel.DeepLearningModelOutput)((DeepLearningModel)this.model)._output)._origDomains.length;
            this.writekv("_n_orig_domain_values", nOrigDomainValues);
            for (int i2 = 0; i2 < nOrigDomainValues; ++i2) {
                String[] currOrigDomain = ((DeepLearningModel.DeepLearningModelOutput)((DeepLearningModel)this.model)._output)._origDomains[i2];
                this.writekv("_m_orig_domain_values_" + i2, currOrigDomain == null ? 0 : currOrigDomain.length);
                if (currOrigDomain == null) continue;
                this.writeStringArray(currOrigDomain, "_orig_domain_values_" + i2);
            }
        }
        this.writekv("_orig_projection_array", ((DeepLearningModel.DeepLearningModelOutput)((DeepLearningModel)this.model)._output)._orig_projection_array);
    }
}

