/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.recipes;

import hex.createframe.CreateFrameExecutor;
import hex.createframe.CreateFrameRecipe;
import hex.createframe.columns.BinaryColumnCfcm;
import hex.createframe.columns.CategoricalColumnCfcm;
import hex.createframe.columns.IntegerColumnCfcm;
import hex.createframe.columns.RealColumnCfcm;
import hex.createframe.columns.StringColumnCfcm;
import hex.createframe.columns.TimeColumnCfcm;
import hex.createframe.postprocess.MissingInserterCfps;
import hex.createframe.postprocess.ShuffleColumnsCfps;

public class SimpleCreateFrameRecipe
extends CreateFrameRecipe<SimpleCreateFrameRecipe> {
    public int nrows = 100;
    public int ncols_real = 0;
    public int ncols_int = 0;
    public int ncols_enum = 0;
    public int ncols_bool = 0;
    public int ncols_str = 0;
    public int ncols_time = 0;
    public double real_lb = -100.0;
    public double real_ub = 100.0;
    public int int_lb = -100;
    public int int_ub = 100;
    public int enum_nlevels = 10;
    public double bool_p = 0.3;
    public long time_lb = 946080000000L;
    public long time_ub = 1576800000000L;
    public int str_length = 8;
    public double missing_fraction = 0.0;
    public ResponseType response_type = ResponseType.NONE;
    public double response_lb = 0.0;
    public double response_ub = 10.0;
    public double response_p = 0.6;
    public int response_nlevels = 25;

    @Override
    protected void checkParametersValidity() {
        this.check(this.nrows > 0, "Number of rows must be greater than 0");
        this.check(this.ncols_real >= 0, "Number of real columns cannot be negative");
        this.check(this.ncols_int >= 0, "Number of integer columns cannot be negative");
        this.check(this.ncols_bool >= 0, "Number of bool (binary) columns cannot be negative");
        this.check(this.ncols_enum >= 0, "Number of enum (categorical) columns cannot be negative");
        this.check(this.ncols_str >= 0, "Number of string columns cannot be negative");
        this.check(this.ncols_time >= 0, "Number of time columns cannot be negative");
        this.check(!Double.isNaN(this.real_lb), "Real range's lower bound cannot be NaN");
        this.check(!Double.isNaN(this.real_ub), "Real range's upper bound cannot be NaN");
        this.check(!Double.isInfinite(this.real_lb), "Real range's lower bound cannot be infinite");
        this.check(!Double.isInfinite(this.real_ub), "Real range's upper bound cannot be infinite");
        this.check(this.real_lb <= this.real_ub, "Invalid real range interval: lower bound exceeds the upper bound");
        this.check(this.int_lb <= this.int_ub, "Invalid integer range interval: lower bound exceeds the upper bound");
        this.check(!Double.isNaN(this.bool_p), "Boolean frequency parameter cannot be NaN");
        this.check(this.bool_p >= 0.0 && this.bool_p <= 1.0, "Boolean frequency parameter must be in the range 0..1");
        this.check(this.time_lb <= this.time_ub, "Invalid time range interval: lower bound exceeds the upper bound");
        this.check(this.enum_nlevels > 0, "Number of levels for enum (categorical) columns must be positive");
        this.check(this.str_length > 0, "Length of string values should be positive");
        this.check(!Double.isNaN(this.missing_fraction), "Missing fraction cannot be NaN");
        this.check(this.missing_fraction >= 0.0 && this.missing_fraction <= 1.0, "Missing fraction must be in the range 0..1");
        this.check(!Double.isNaN(this.response_lb), "Response column's lower bound cannot be NaN");
        this.check(!Double.isNaN(this.response_ub), "Response column's upper bound cannot be NaN");
        this.check(!Double.isInfinite(this.response_lb), "Response column's lower bound cannot be infinite");
        this.check(!Double.isInfinite(this.response_ub), "Response column's upper bound cannot be infinite");
        this.check(this.response_lb <= this.response_ub, "Invalid interval for response column: lower bound exceeds the upper bound");
        this.check(!Double.isNaN(this.response_p), "Response binary frequency parameter (response_p) cannot be NaN");
        this.check(this.response_p >= 0.0 && this.response_p <= 1.0, "Response binary frequency (response_p) should be in the range 0..1");
        this.check(this.response_nlevels >= 2, "Number of categorical levels for the response column must be 2 or more");
    }

    @Override
    protected void buildRecipe(CreateFrameExecutor cfe) {
        int i2;
        cfe.setSeed(this.seed);
        cfe.setNumRows(this.nrows);
        switch (this.response_type) {
            case REAL: {
                cfe.addColumnMaker(new RealColumnCfcm("response", this.response_lb, this.response_ub));
                break;
            }
            case INT: {
                cfe.addColumnMaker(new IntegerColumnCfcm("response", (int)this.response_lb, (int)this.response_ub));
                break;
            }
            case ENUM: {
                cfe.addColumnMaker(new CategoricalColumnCfcm("response", this.response_nlevels));
                break;
            }
            case BOOL: {
                cfe.addColumnMaker(new BinaryColumnCfcm("response", this.response_p));
                break;
            }
            case TIME: {
                cfe.addColumnMaker(new TimeColumnCfcm("response", (long)this.response_lb, (long)this.response_ub));
            }
        }
        for (i2 = 1; i2 <= this.ncols_real; ++i2) {
            cfe.addColumnMaker(new RealColumnCfcm("R" + i2, this.real_lb, this.real_ub));
        }
        for (i2 = 1; i2 <= this.ncols_int; ++i2) {
            cfe.addColumnMaker(new IntegerColumnCfcm("I" + i2, this.int_lb, this.int_ub));
        }
        for (i2 = 0; i2 < this.ncols_enum; ++i2) {
            cfe.addColumnMaker(new CategoricalColumnCfcm("E" + i2, this.enum_nlevels));
        }
        for (i2 = 1; i2 <= this.ncols_bool; ++i2) {
            cfe.addColumnMaker(new BinaryColumnCfcm("B" + i2, this.bool_p));
        }
        for (i2 = 0; i2 < this.ncols_time; ++i2) {
            cfe.addColumnMaker(new TimeColumnCfcm("T" + i2, this.time_lb, this.time_ub));
        }
        for (i2 = 0; i2 < this.ncols_str; ++i2) {
            cfe.addColumnMaker(new StringColumnCfcm("S" + i2, this.str_length));
        }
        cfe.addPostprocessStep(new MissingInserterCfps(this.missing_fraction));
        cfe.addPostprocessStep(new ShuffleColumnsCfps(true, true));
    }

    public static enum ResponseType {
        NONE,
        REAL,
        INT,
        ENUM,
        BOOL,
        TIME;

    }
}

