/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.postprocess;

import hex.createframe.CreateFramePostprocessStep;
import java.util.Random;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.RandomBase;
import water.util.RandomUtils;

public class MissingInserterCfps
extends CreateFramePostprocessStep {
    private double p;

    public MissingInserterCfps() {
    }

    public MissingInserterCfps(double p2) {
        assert (p2 >= 0.0 && p2 < 1.0) : "p should be in the range [0, 1), got " + p2;
        this.p = p2;
    }

    @Override
    public void exec(Frame fr, Random rng) {
        if (this.p > 0.0) {
            new InsertNAs(this.p, rng).doAll(fr);
        }
    }

    private static class InsertNAs
    extends MRTask<InsertNAs> {
        private long seed;
        private double p;

        public InsertNAs(double prob, Random random) {
            this.p = prob;
            this.seed = random.nextLong();
        }

        @Override
        public void map(Chunk[] cs) {
            int numRows = cs[0]._len;
            long chunkStart = cs[0].start();
            double denom = Math.log(1.0 - this.p);
            RandomBase rng = RandomUtils.getRNG(0L);
            for (int i2 = 0; i2 < cs.length; ++i2) {
                rng.setSeed(this.seed + (long)(i2 * 35602489) + chunkStart * 47582L);
                int l2 = 0;
                while ((l2 += (int)Math.floor(Math.log(rng.nextDouble()) / denom)) < numRows) {
                    cs[i2].set(l2++, Double.NaN);
                }
            }
        }
    }
}

