/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.coxph.CoxPH;
import water.MrFun;

class EfronUpdateFun
extends MrFun<EfronUpdateFun> {
    transient CoxPH.CoxPHTask _coxMR;
    int _n_coef;
    double _logLik;
    double[] _gradient;
    double[][] _hessian;

    EfronUpdateFun(CoxPH.ComputationState cs, CoxPH.CoxPHTask coxMR) {
        this._coxMR = coxMR;
        this._n_coef = cs._n_coef;
        this._logLik = cs._logLik;
        this._gradient = cs._gradient;
        this._hessian = cs._hessian;
    }

    @Override
    protected void map(int t2) {
        double sizeEvents_t = this._coxMR.sizeEvents[t2];
        if (sizeEvents_t > 0.0) {
            long countEvents_t = this._coxMR.countEvents[t2];
            double sumLogRiskEvents_t = this._coxMR.sumLogRiskEvents[t2];
            double sumRiskEvents_t = this._coxMR.sumRiskEvents[t2];
            double rcumsumRisk_t = this._coxMR.rcumsumRisk[t2];
            double avgSize = sizeEvents_t / (double)countEvents_t;
            this._logLik += sumLogRiskEvents_t;
            for (long e2 = 0L; e2 < countEvents_t; ++e2) {
                double frac = (double)e2 / (double)countEvents_t;
                double term = rcumsumRisk_t - frac * sumRiskEvents_t;
                this._logLik -= avgSize * Math.log(term);
                for (int j2 = 0; j2 < this._n_coef; ++j2) {
                    double djTerm = this._coxMR.rcumsumXRisk[t2][j2] - frac * this._coxMR.sumXRiskEvents[t2][j2];
                    double djLogTerm = djTerm / term;
                    int n2 = j2;
                    this._gradient[n2] = this._gradient[n2] - avgSize * djLogTerm;
                    int k2 = 0;
                    while (k2 < this._n_coef) {
                        double dkTerm = this._coxMR.rcumsumXRisk[t2][k2] - frac * this._coxMR.sumXRiskEvents[t2][k2];
                        double[] dArray = this._hessian[j2];
                        int n3 = k2++;
                        dArray[n3] = dArray[n3] + avgSize * (djLogTerm * (dkTerm / term));
                    }
                }
            }
        }
    }

    @Override
    protected void reduce(EfronUpdateFun o2) {
        int i2;
        this._logLik += o2._logLik;
        for (i2 = 0; i2 < this._n_coef; ++i2) {
            int n2 = i2;
            this._gradient[n2] = this._gradient[n2] + o2._gradient[i2];
        }
        for (i2 = 0; i2 < this._n_coef; ++i2) {
            for (int j2 = 0; j2 < this._n_coef; ++j2) {
                double[] dArray = this._hessian[i2];
                int n3 = j2;
                dArray[n3] = dArray[n3] + o2._hessian[i2][j2];
            }
        }
    }

    @Override
    protected MrFun<EfronUpdateFun> makeCopy() {
        return new EfronUpdateFun(new CoxPH.ComputationState(this._n_coef), this._coxMR);
    }

    CoxPH.ComputationState toComputationState(CoxPH.ComputationState cs) {
        cs._logLik = this._logLik;
        cs._gradient = this._gradient;
        cs._hessian = this._hessian;
        return cs;
    }
}

