/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import Jama.Matrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsRegressionCoxPH;
import hex.StringPair;
import hex.coxph.CPHBaseTask;
import hex.coxph.CoxPHModel;
import hex.coxph.EfronMethod;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Key;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ast.prims.mungers.AstGroup;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedHashSet;
import water.util.IcedInt;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.Timer;
import water.util.TwoDimTable;
import water.util.VecUtils;

public class CoxPH
extends ModelBuilder<CoxPHModel, CoxPHModel.CoxPHParameters, CoxPHModel.CoxPHOutput> {
    private static final int MAX_TIME_BINS = 100000;

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.CoxPH};
    }

    @Override
    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    public CoxPH(boolean startup_once) {
        super(new CoxPHModel.CoxPHParameters(), startup_once);
    }

    public CoxPH(CoxPHModel.CoxPHParameters parms) {
        super(parms);
        this.init(false);
    }

    @Override
    protected CoxPHDriver trainModelImpl() {
        return new CoxPHDriver();
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (((CoxPHModel.CoxPHParameters)this._parms)._train != null && ((CoxPHModel.CoxPHParameters)this._parms).train() == null) {
            this.error("train", "Invalid training frame (Frame key = " + ((CoxPHModel.CoxPHParameters)this._parms)._train + " not found)");
        }
        if (((CoxPHModel.CoxPHParameters)this._parms)._train != null && ((CoxPHModel.CoxPHParameters)this._parms).train() != null) {
            int n2;
            Object[] stopVec;
            if (((CoxPHModel.CoxPHParameters)this._parms)._start_column != null) {
                Vec startVec = ((CoxPHModel.CoxPHParameters)this._parms).startVec();
                if (startVec == null) {
                    this.error("start_column", "start_column " + ((CoxPHModel.CoxPHParameters)this._parms)._start_column + " not found in the training frame");
                } else if (!startVec.isNumeric()) {
                    this.error("start_column", "start time must be undefined or of type numeric");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._stop_column != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms).stopVec();
                if (stopVec == null) {
                    this.error("stop_column", "stop_column " + ((CoxPHModel.CoxPHParameters)this._parms)._stop_column + " not found in the training frame");
                } else if (!stopVec.isNumeric()) {
                    this.error("stop_column", "stop time must be of type numeric");
                } else if (expensive) {
                    try {
                        CollectTimes.collect(((CoxPHModel.CoxPHParameters)this._parms).stopVec(), ((CoxPHModel.CoxPHParameters)this._parms)._single_node_mode);
                    }
                    catch (CollectTimesException e2) {
                        this.error("stop_column", e2.getMessage());
                    }
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._response_column != null && !this._response.isInt() && !this._response.isCategorical()) {
                this.error("response_column", "response/event column must be of type integer or factor");
            }
            if (((CoxPHModel.CoxPHParameters)this._parms).startVec() != null && ((CoxPHModel.CoxPHParameters)this._parms).stopVec() != null && ((CoxPHModel.CoxPHParameters)this._parms).startVec().min() >= ((CoxPHModel.CoxPHParameters)this._parms).stopVec().max()) {
                this.error("start_column", "start times must be strictly less than stop times");
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interactions != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interactions;
                int e2 = stopVec.length;
                for (n2 = 0; n2 < e2; ++n2) {
                    String string = stopVec[n2];
                    if (string == null || string.isEmpty() || this._train.vec(string) != null) continue;
                    this.error("interactions", string + " not found in the training frame");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interactions_only != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interactions_only;
                int e2 = stopVec.length;
                for (n2 = 0; n2 < e2; ++n2) {
                    Object object = stopVec[n2];
                    if (object == null || ((String)object).isEmpty() || this._train.vec((String)object) != null) continue;
                    this.error("interactions_only", (String)object + " not found in the training frame");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interaction_pairs != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interaction_pairs;
                int e2 = stopVec.length;
                for (n2 = 0; n2 < e2; ++n2) {
                    Object object = stopVec[n2];
                    if (((StringPair)object)._a != null && !((StringPair)object)._a.isEmpty() && this._train.vec(((StringPair)object)._a) == null) {
                        this.error("interaction_pairs", ((StringPair)object)._a + " not found in the training frame with columns" + Arrays.toString(this._train.names()));
                    }
                    if (((StringPair)object)._b == null || ((StringPair)object)._b.isEmpty() || this._train.vec(((StringPair)object)._b) != null) continue;
                    this.error("interaction_pairs", ((StringPair)object)._b + " not found in the training frame with columns" + Arrays.toString(this._train.names()));
                }
            }
            if (this._train != null) {
                int nonFeatureColCount = (((CoxPHModel.CoxPHParameters)this._parms)._start_column != null ? 1 : 0) + (((CoxPHModel.CoxPHParameters)this._parms)._stop_column != null ? 1 : 0);
                if (this._train.numCols() < 2 + nonFeatureColCount) {
                    this.error("_train", "Training data must have at least 2 features (incl. response).");
                }
                if (null != ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by) {
                    int stratifyColCount = ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by.length;
                    if (this._train.numCols() < 2 + nonFeatureColCount + stratifyColCount) {
                        this.error("_train", "Training data must have at least 1 feature that is not a response and is not used for stratification.");
                    }
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms).isStratified()) {
                block5: for (String string : ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by) {
                    Vec v2 = ((CoxPHModel.CoxPHParameters)this._parms).train().vec(string);
                    if (v2 == null) {
                        this.error("stratify_by", "column '" + string + "' not found");
                    } else if (v2.get_type() != 4) {
                        this.error("stratify_by", "non-categorical column '" + string + "' cannot be used for stratification");
                    }
                    if (((CoxPHModel.CoxPHParameters)this._parms)._interactions == null) continue;
                    for (String inter : ((CoxPHModel.CoxPHParameters)this._parms)._interactions) {
                        if (!string.equals(inter)) continue;
                        this.error("stratify_by", "stratification column '" + string + "' cannot be used in an implicit interaction. Use explicit (pair-wise) interactions instead");
                        continue block5;
                    }
                }
            }
        }
        if (Double.isNaN(((CoxPHModel.CoxPHParameters)this._parms)._lre_min) || ((CoxPHModel.CoxPHParameters)this._parms)._lre_min <= 0.0) {
            this.error("lre_min", "lre_min must be a positive number");
        }
        if (((CoxPHModel.CoxPHParameters)this._parms)._max_iterations < 1) {
            this.error("max_iterations", "max_iterations must be a positive integer");
        }
    }

    @Override
    protected int init_getNClass() {
        return 1;
    }

    private TwoDimTable generateSummary(CoxPHModel.CoxPHOutput output) {
        String[] names = new String[]{"Formula", "Likelihood ratio test", "Concordance", "Number of Observations", "Number of Events"};
        String[] types = new String[]{"string", "double", "double", "long", "long"};
        String[] formats = new String[]{"%s", "%.5f", "%.5f", "%d", "%d"};
        TwoDimTable summary = new TwoDimTable("CoxPH Model", "summary", new String[]{""}, names, types, formats, "");
        summary.set(0, 0, output._formula);
        summary.set(0, 1, output._loglik_test);
        summary.set(0, 2, output._concordance);
        summary.set(0, 3, output._n);
        summary.set(0, 4, output._total_event);
        return summary;
    }

    private static class ScoringHistory {
        private long[] _scoringTimes;
        private double[] _logLiks;

        public ScoringHistory(int iterCnt) {
            this._scoringTimes = new long[iterCnt];
            this._logLiks = new double[iterCnt];
        }

        public ScoringHistory addIterationScore(int iter2, double logLik) {
            this._scoringTimes[iter2] = System.currentTimeMillis();
            this._logLiks[iter2] = logLik;
            return this;
        }

        public TwoDimTable to2dTable(int iterCnt) {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "logLik"};
            String[] ctypes = new String[]{"string", "string", "int", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[iterCnt], cnames, ctypes, cformats, "");
            DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
            for (int i2 = 0; i2 < iterCnt; ++i2) {
                int col = 0;
                res.set(i2, col++, fmt.print(this._scoringTimes[i2]));
                res.set(i2, col++, PrettyPrint.msecs(this._scoringTimes[i2] - this._scoringTimes[0], true));
                res.set(i2, col++, i2);
                res.set(i2, col++, this._logLiks[i2]);
            }
            return res;
        }
    }

    static class ComputationState {
        final int _n_coef;
        double _logLik;
        double[] _gradient;
        double[][] _hessian;

        ComputationState(int n_coef) {
            this._n_coef = n_coef;
            this._logLik = 0.0;
            this._gradient = MemoryManager.malloc8d(n_coef);
            this._hessian = MemoryManager.malloc8d(n_coef, n_coef);
        }

        void reset() {
            int j2;
            this._logLik = 0.0;
            for (j2 = 0; j2 < this._n_coef; ++j2) {
                this._gradient[j2] = 0.0;
            }
            for (j2 = 0; j2 < this._n_coef; ++j2) {
                for (int k2 = 0; k2 < this._n_coef; ++k2) {
                    this._hessian[j2][k2] = 0.0;
                }
            }
        }
    }

    private static class CollectTimesException
    extends RuntimeException {
        private CollectTimesException(String message) {
            super(message);
        }
    }

    private static class CollectTimes
    extends VecUtils.CollectDoubleDomain {
        private CollectTimes() {
            super(new double[0], 100000);
        }

        static double[] collect(Vec timeVec, boolean runLocal) {
            return ((VecUtils.CollectDoubleDomain)new CollectTimes().doAll(timeVec, runLocal)).domain();
        }

        @Override
        protected void onMaxDomainExceeded(int maxDomainSize, int currentSize) {
            throw new CollectTimesException("number of distinct stop times is at least " + currentSize + "; maximum number allowed is " + maxDomainSize);
        }
    }

    protected static class CoxPHTask
    extends CPHBaseTask<CoxPHTask> {
        final double[] _beta;
        final double[] _time;
        final int _n_offsets;
        final boolean _has_start_column;
        final boolean _has_strata_column;
        final boolean _has_weights_column;
        final long _min_event;
        final int _num_strata;
        final boolean _isBreslow;
        long n;
        double[] sumWeights;
        double[][] sumWeightedCatX;
        double[][] sumWeightedNumX;
        double[] sizeRiskSet;
        double[] sizeCensored;
        double[] sizeEvents;
        long[] countEvents;
        double[] sumXEvents;
        double[] sumRiskEvents;
        double[] sumRiskAllEvents;
        double[][] sumXRiskEvents;
        double[] sumLogRiskEvents;
        double[] rcumsumRisk;
        double[][] rcumsumXRisk;
        double[] totalRisk;
        double[][][] rcumsumXXRisk;

        CoxPHTask(DataInfo dinfo, double[] beta, double[] time, long min_event, int n_offsets, boolean has_start_column, Vec strata_column, boolean has_weights_column, CoxPHModel.CoxPHParameters.CoxPHTies ties) {
            super(dinfo);
            this._beta = beta;
            this._time = time;
            this._min_event = min_event;
            this._n_offsets = n_offsets;
            this._has_start_column = has_start_column;
            this._has_strata_column = strata_column != null;
            this._has_weights_column = has_weights_column;
            this._num_strata = this._has_strata_column ? 1 + (int)strata_column.max() : 1;
            this._isBreslow = CoxPHModel.CoxPHParameters.CoxPHTies.breslow.equals((Object)ties);
        }

        @Override
        protected void chunkInit() {
            int n_time = this._time.length * this._num_strata;
            int n_coef = this._beta.length;
            this.sumWeights = MemoryManager.malloc8d(this._num_strata);
            this.sumWeightedCatX = MemoryManager.malloc8d(this._num_strata, this._dinfo.numCats());
            this.sumWeightedNumX = MemoryManager.malloc8d(this._num_strata, this._dinfo.numNums());
            this.sizeRiskSet = MemoryManager.malloc8d(n_time);
            this.sizeCensored = MemoryManager.malloc8d(n_time);
            this.sizeEvents = MemoryManager.malloc8d(n_time);
            this.countEvents = MemoryManager.malloc8(n_time);
            this.sumRiskEvents = MemoryManager.malloc8d(n_time);
            this.sumRiskAllEvents = MemoryManager.malloc8d(n_time);
            this.sumLogRiskEvents = MemoryManager.malloc8d(n_time);
            this.rcumsumRisk = MemoryManager.malloc8d(n_time);
            this.sumXEvents = MemoryManager.malloc8d(n_coef);
            this.sumXRiskEvents = MemoryManager.malloc8d(n_time, n_coef);
            this.rcumsumXRisk = MemoryManager.malloc8d(n_time, n_coef);
            this.totalRisk = MemoryManager.malloc8d(this._num_strata);
            if (this._isBreslow) {
                this.rcumsumXXRisk = MemoryManager.malloc8d(n_time, n_coef, n_coef);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            int j2;
            int j3;
            double strata;
            double weight;
            ++this.n;
            double[] response = row.response;
            int ncats = row.nBins;
            int[] cats = row.binIds;
            double[] nums = row.numVals;
            double d2 = weight = this._has_weights_column ? row.weight : 1.0;
            if (weight <= 0.0) {
                throw new IllegalArgumentException("weights must be positive values");
            }
            int respIdx = response.length - 1;
            long event = (long)(response[respIdx--] - (double)this._min_event);
            int t2 = (int)response[respIdx--];
            int t1 = this._has_start_column ? (int)response[respIdx--] : -1;
            double d3 = strata = this._has_strata_column ? response[respIdx--] : 0.0;
            assert (respIdx == -1) : "expected to use all response data";
            if (Double.isNaN(strata)) {
                return;
            }
            int strataId = (int)strata;
            int numStart = this._dinfo.numStart();
            int n2 = strataId;
            this.sumWeights[n2] = this.sumWeights[n2] + weight;
            for (j3 = 0; j3 < ncats; ++j3) {
                double[] dArray = this.sumWeightedCatX[strataId];
                int n3 = cats[j3];
                dArray[n3] = dArray[n3] + weight;
            }
            for (j3 = 0; j3 < nums.length; ++j3) {
                double[] dArray = this.sumWeightedNumX[strataId];
                int n4 = j3;
                dArray[n4] = dArray[n4] + weight * nums[j3];
            }
            double logRisk = 0.0;
            for (j2 = 0; j2 < ncats; ++j2) {
                logRisk += this._beta[cats[j2]];
            }
            for (j2 = 0; j2 < nums.length - this._n_offsets; ++j2) {
                logRisk += nums[j2] * this._beta[numStart + j2];
            }
            for (j2 = nums.length - this._n_offsets; j2 < nums.length; ++j2) {
                logRisk += nums[j2];
            }
            double risk = weight * Math.exp(logRisk);
            logRisk *= weight;
            int n5 = strataId;
            this.totalRisk[n5] = this.totalRisk[n5] + risk;
            int n6 = t2;
            this.sumRiskAllEvents[n6] = this.sumRiskAllEvents[n6] + risk;
            if (event > 0L) {
                int n7 = t2;
                this.countEvents[n7] = this.countEvents[n7] + 1L;
                int n8 = t2;
                this.sizeEvents[n8] = this.sizeEvents[n8] + weight;
                int n9 = t2;
                this.sumLogRiskEvents[n9] = this.sumLogRiskEvents[n9] + logRisk;
                int n10 = t2;
                this.sumRiskEvents[n10] = this.sumRiskEvents[n10] + risk;
            } else {
                int n11 = t2;
                this.sizeCensored[n11] = this.sizeCensored[n11] + weight;
            }
            if (this._has_start_column) {
                int t3 = t1;
                while (t3 <= t2) {
                    int n12 = t3++;
                    this.sizeRiskSet[n12] = this.sizeRiskSet[n12] + weight;
                }
                t3 = t1;
                while (t3 <= t2) {
                    int n13 = t3++;
                    this.rcumsumRisk[n13] = this.rcumsumRisk[n13] + risk;
                }
            } else {
                int n14 = t2;
                this.sizeRiskSet[n14] = this.sizeRiskSet[n14] + weight;
                int n15 = t2;
                this.rcumsumRisk[n15] = this.rcumsumRisk[n15] + risk;
            }
            int ntotal = ncats + (nums.length - this._n_offsets);
            int numStartIter = numStart - ncats;
            for (int jit = 0; jit < ntotal; ++jit) {
                boolean jIsCat = jit < ncats;
                int j4 = jIsCat ? cats[jit] : numStartIter + jit;
                double x1 = jIsCat ? 1.0 : nums[jit - ncats];
                double xRisk = x1 * risk;
                if (event > 0L) {
                    int n16 = j4;
                    this.sumXEvents[n16] = this.sumXEvents[n16] + weight * x1;
                    double[] dArray = this.sumXRiskEvents[t2];
                    int n17 = j4;
                    dArray[n17] = dArray[n17] + xRisk;
                }
                double[] dArray = this.rcumsumXRisk[t2];
                int n18 = j4;
                dArray[n18] = dArray[n18] + xRisk;
                if (this._has_start_column && t1 % this._time.length > 0) {
                    double[] dArray2 = this.rcumsumXRisk[t1 - 1];
                    int n19 = j4;
                    dArray2[n19] = dArray2[n19] - xRisk;
                }
                if (!this._isBreslow) continue;
                for (int kit = 0; kit < ntotal; ++kit) {
                    boolean kIsCat = kit < ncats;
                    int k2 = kIsCat ? cats[kit] : numStartIter + kit;
                    double x2 = kIsCat ? 1.0 : nums[kit - ncats];
                    double xxRisk = x2 * xRisk;
                    if (this._has_start_column) {
                        for (int t4 = t1; t4 <= t2; ++t4) {
                            double[] dArray3 = this.rcumsumXXRisk[t4][j4];
                            int n20 = k2;
                            dArray3[n20] = dArray3[n20] + xxRisk;
                        }
                        continue;
                    }
                    double[] dArray4 = this.rcumsumXXRisk[t2][j4];
                    int n21 = k2;
                    dArray4[n21] = dArray4[n21] + xxRisk;
                }
            }
        }

        @Override
        public void reduce(CoxPHTask that) {
            this.n += that.n;
            ArrayUtils.add(this.sumWeights, that.sumWeights);
            ArrayUtils.add(this.sumWeightedCatX, that.sumWeightedCatX);
            ArrayUtils.add(this.sumWeightedNumX, that.sumWeightedNumX);
            ArrayUtils.add(this.sizeRiskSet, that.sizeRiskSet);
            ArrayUtils.add(this.sizeCensored, that.sizeCensored);
            ArrayUtils.add(this.sizeEvents, that.sizeEvents);
            ArrayUtils.add(this.countEvents, that.countEvents);
            ArrayUtils.add(this.sumXEvents, that.sumXEvents);
            ArrayUtils.add(this.sumRiskEvents, that.sumRiskEvents);
            ArrayUtils.add(this.sumRiskAllEvents, that.sumRiskAllEvents);
            ArrayUtils.add(this.sumXRiskEvents, that.sumXRiskEvents);
            ArrayUtils.add(this.sumLogRiskEvents, that.sumLogRiskEvents);
            ArrayUtils.add(this.rcumsumRisk, that.rcumsumRisk);
            ArrayUtils.add(this.rcumsumXRisk, that.rcumsumXRisk);
            ArrayUtils.add(this.totalRisk, that.totalRisk);
            if (this._isBreslow) {
                ArrayUtils.add(this.rcumsumXXRisk, that.rcumsumXXRisk);
            }
        }

        @Override
        protected void postGlobal() {
            int j2;
            int t2;
            for (t2 = this.rcumsumXRisk.length - 2; t2 >= 0; --t2) {
                for (j2 = 0; j2 < this.rcumsumXRisk[t2].length; ++j2) {
                    double[] dArray = this.rcumsumXRisk[t2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + ((t2 + 1) % this._time.length == 0 ? 0.0 : this.rcumsumXRisk[t2 + 1][j2]);
                }
            }
            if (!this._has_start_column) {
                for (t2 = this.rcumsumRisk.length - 2; t2 >= 0; --t2) {
                    int n3 = t2;
                    this.rcumsumRisk[n3] = this.rcumsumRisk[n3] + ((t2 + 1) % this._time.length == 0 ? 0.0 : this.rcumsumRisk[t2 + 1]);
                }
                if (this._isBreslow) {
                    for (t2 = this.rcumsumXXRisk.length - 2; t2 >= 0; --t2) {
                        for (j2 = 0; j2 < this.rcumsumXXRisk[t2].length; ++j2) {
                            for (int k2 = 0; k2 < this.rcumsumXXRisk[t2][j2].length; ++k2) {
                                double[] dArray = this.rcumsumXXRisk[t2][j2];
                                int n4 = k2;
                                dArray[n4] = dArray[n4] + ((t2 + 1) % this._time.length == 0 ? 0.0 : this.rcumsumXXRisk[t2 + 1][j2][k2]);
                            }
                        }
                    }
                }
            }
        }
    }

    public class CoxPHDriver
    extends ModelBuilder.Driver {
        public CoxPHDriver() {
            super(CoxPH.this);
        }

        private Frame reorderTrainFrameColumns(IcedHashMap<AstGroup.G, IcedInt> outStrataMap, double[] time) {
            Frame discretizedFr;
            Frame f2 = new Frame(new Vec[0]);
            Vec weightVec = null;
            Vec startVec = null;
            Vec stopVec = null;
            Vec eventVec = null;
            Vec[] vecs = CoxPH.this.train().vecs();
            String[] names = CoxPH.this.train().names();
            for (int i2 = 0; i2 < names.length; ++i2) {
                if (names[i2].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._weights_column)) {
                    weightVec = vecs[i2];
                    continue;
                }
                if (names[i2].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._start_column)) {
                    startVec = vecs[i2];
                    continue;
                }
                if (names[i2].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stop_column)) {
                    stopVec = vecs[i2];
                    continue;
                }
                if (names[i2].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._response_column)) {
                    eventVec = vecs[i2];
                    continue;
                }
                f2.add(names[i2], vecs[i2]);
            }
            Vec strataVec = null;
            if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).isStratified()) {
                StrataTask.setupStrataMapping(f2, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by, outStrataMap);
                discretizedFr = Scope.track(StrataTask.stratifyTime(f2, time, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by, outStrataMap, startVec, stopVec, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode));
                strataVec = discretizedFr.remove(0);
                if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).interactionSpec() == null) {
                    f2.remove(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by);
                }
            } else {
                discretizedFr = Scope.track(DiscretizeTimeTask.discretizeTime(time, startVec, stopVec, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode));
            }
            if (startVec != null) {
                startVec = discretizedFr.vec(0);
                stopVec = discretizedFr.vec(1);
            } else {
                stopVec = discretizedFr.vec(0);
            }
            if (weightVec != null) {
                f2.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._weights_column, weightVec);
            }
            if (strataVec != null) {
                f2.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._strata_column, strataVec);
            }
            if (startVec != null) {
                f2.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._start_column, startVec);
            }
            if (stopVec != null) {
                f2.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stop_column, stopVec);
            }
            if (eventVec != null) {
                f2.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._response_column, eventVec);
            }
            return f2;
        }

        protected void initStats(CoxPHModel model, DataInfo dinfo, double[] time) {
            CoxPHModel.CoxPHParameters p2 = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o2 = (CoxPHModel.CoxPHOutput)model._output;
            o2._n = p2.stopVec().length();
            o2.data_info = dinfo;
            int n_offsets = CoxPH.this._offset == null ? 0 : 1;
            int n_coef = o2.data_info.fullN() - n_offsets;
            String[] coefNames = o2.data_info.coefNames();
            o2._coef_names = new String[n_coef];
            System.arraycopy(coefNames, 0, o2._coef_names, 0, n_coef);
            o2._coef = MemoryManager.malloc8d(n_coef);
            o2._exp_coef = MemoryManager.malloc8d(n_coef);
            o2._exp_neg_coef = MemoryManager.malloc8d(n_coef);
            o2._se_coef = MemoryManager.malloc8d(n_coef);
            o2._z_coef = MemoryManager.malloc8d(n_coef);
            o2._var_coef = MemoryManager.malloc8d(n_coef, n_coef);
            o2._mean_offset = MemoryManager.malloc8d(n_offsets);
            o2._offset_names = new String[n_offsets];
            System.arraycopy(coefNames, n_coef, o2._offset_names, 0, n_offsets);
            int n_time = (int)dinfo._adaptedFrame.vec(p2._stop_column).max() + 1;
            o2._time = time;
            o2._n_risk = MemoryManager.malloc8d(n_time);
            o2._n_event = MemoryManager.malloc8d(n_time);
            o2._n_censor = MemoryManager.malloc8d(n_time);
        }

        protected void calcCounts(CoxPHModel model, CoxPHTask coxMR) {
            int t2;
            CoxPHModel.CoxPHParameters p2 = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o2 = (CoxPHModel.CoxPHOutput)model._output;
            o2._n_missing = o2._n - coxMR.n;
            o2._n = coxMR.n;
            o2._x_mean_cat = MemoryManager.malloc8d(coxMR.sumWeights.length, o2.data_info.numCats());
            o2._x_mean_num = MemoryManager.malloc8d(coxMR.sumWeights.length, o2.data_info.numNums() - o2._mean_offset.length);
            for (int s2 = 0; s2 < coxMR.sumWeights.length; ++s2) {
                System.arraycopy(coxMR.sumWeightedCatX[s2], 0, o2._x_mean_cat[s2], 0, o2._x_mean_cat[s2].length);
                int j2 = 0;
                while (j2 < o2._x_mean_cat[s2].length) {
                    double[] dArray = o2._x_mean_cat[s2];
                    int n2 = j2++;
                    dArray[n2] = dArray[n2] / coxMR.sumWeights[s2];
                }
                System.arraycopy(coxMR.sumWeightedNumX[s2], 0, o2._x_mean_num[s2], 0, o2._x_mean_num[s2].length);
                for (j2 = 0; j2 < o2._x_mean_num[s2].length; ++j2) {
                    o2._x_mean_num[s2][j2] = o2.data_info._normSub[j2] + o2._x_mean_num[s2][j2] / coxMR.sumWeights[s2];
                }
            }
            System.arraycopy(o2.data_info._normSub, o2.data_info.numNums() - o2._mean_offset.length, o2._mean_offset, 0, o2._mean_offset.length);
            for (t2 = 0; t2 < coxMR.countEvents.length; ++t2) {
                o2._total_event += coxMR.countEvents[t2];
                if (!(coxMR.sizeEvents[t2] > 0.0) && !(coxMR.sizeCensored[t2] > 0.0)) continue;
                o2._n_risk[t2] = coxMR.sizeRiskSet[t2];
                o2._n_event[t2] = coxMR.sizeEvents[t2];
                o2._n_censor[t2] = coxMR.sizeCensored[t2];
            }
            if (p2._start_column == null) {
                for (t2 = o2._n_risk.length - 2; t2 >= 0; --t2) {
                    int n3 = t2;
                    o2._n_risk[n3] = o2._n_risk[n3] + o2._n_risk[t2 + 1];
                }
            }
        }

        protected ComputationState calcLoglik(DataInfo dinfo, ComputationState cs, CoxPHModel.CoxPHParameters p2, CoxPHTask coxMR) {
            cs.reset();
            switch (p2._ties) {
                case efron: {
                    return EfronMethod.calcLoglik(dinfo, coxMR, cs, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                }
                case breslow: {
                    int n_coef = cs._n_coef;
                    int n_time = coxMR.sizeEvents.length;
                    double newLoglik = 0.0;
                    for (int i2 = 0; i2 < n_coef; ++i2) {
                        cs._gradient[i2] = coxMR.sumXEvents[i2];
                    }
                    for (int t2 = n_time - 1; t2 >= 0; --t2) {
                        double sizeEvents_t = coxMR.sizeEvents[t2];
                        if (!(sizeEvents_t > 0.0)) continue;
                        double sumLogRiskEvents_t = coxMR.sumLogRiskEvents[t2];
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t2];
                        newLoglik += sumLogRiskEvents_t;
                        newLoglik -= sizeEvents_t * Math.log(rcumsumRisk_t);
                        for (int j2 = 0; j2 < n_coef; ++j2) {
                            double dlogTerm = coxMR.rcumsumXRisk[t2][j2] / rcumsumRisk_t;
                            int n2 = j2;
                            cs._gradient[n2] = cs._gradient[n2] - sizeEvents_t * dlogTerm;
                            for (int k2 = 0; k2 < n_coef; ++k2) {
                                double[] dArray = cs._hessian[j2];
                                int n3 = k2;
                                dArray[n3] = dArray[n3] - sizeEvents_t * (coxMR.rcumsumXXRisk[t2][j2][k2] / rcumsumRisk_t - dlogTerm * (coxMR.rcumsumXRisk[t2][k2] / rcumsumRisk_t));
                            }
                        }
                    }
                    cs._logLik = newLoglik;
                    return cs;
                }
            }
            throw new IllegalArgumentException("_ties method must be either efron or breslow");
        }

        protected void calcModelStats(CoxPHModel model, double[] newCoef, ComputationState cs) {
            int k2;
            int j2;
            CoxPHModel.CoxPHParameters p2 = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o2 = (CoxPHModel.CoxPHOutput)model._output;
            int n_coef = o2._coef.length;
            Matrix inv_hessian = new Matrix(cs._hessian).inverse();
            for (j2 = 0; j2 < n_coef; ++j2) {
                for (int k3 = 0; k3 <= j2; ++k3) {
                    double elem;
                    o2._var_coef[j2][k3] = elem = -inv_hessian.get(j2, k3);
                    o2._var_coef[k3][j2] = elem;
                }
            }
            for (j2 = 0; j2 < n_coef; ++j2) {
                o2._coef[j2] = newCoef[j2];
                o2._exp_coef[j2] = Math.exp(o2._coef[j2]);
                o2._exp_neg_coef[j2] = Math.exp(-o2._coef[j2]);
                o2._se_coef[j2] = Math.sqrt(o2._var_coef[j2][j2]);
                o2._z_coef[j2] = o2._coef[j2] / o2._se_coef[j2];
            }
            if (o2._iter == 0) {
                o2._null_loglik = cs._logLik;
                o2._maxrsq = 1.0 - Math.exp(2.0 * o2._null_loglik / (double)o2._n);
                o2._score_test = 0.0;
                for (j2 = 0; j2 < n_coef; ++j2) {
                    double sum = 0.0;
                    for (k2 = 0; k2 < n_coef; ++k2) {
                        sum += o2._var_coef[j2][k2] * cs._gradient[k2];
                    }
                    o2._score_test += cs._gradient[j2] * sum;
                }
            }
            o2._loglik = cs._logLik;
            o2._loglik_test = -2.0 * (o2._null_loglik - o2._loglik);
            o2._rsq = 1.0 - Math.exp(-o2._loglik_test / (double)o2._n);
            o2._wald_test = 0.0;
            for (j2 = 0; j2 < n_coef; ++j2) {
                double sum = 0.0;
                for (k2 = 0; k2 < n_coef; ++k2) {
                    sum -= cs._hessian[j2][k2] * (o2._coef[k2] - p2._init);
                }
                o2._wald_test += (o2._coef[j2] - p2._init) * sum;
            }
        }

        protected void calcCumhaz_0(CoxPHModel model, CoxPHTask coxMR) {
            int t2;
            CoxPHModel.CoxPHParameters p2 = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o2 = (CoxPHModel.CoxPHOutput)model._output;
            int n_time = coxMR.sizeEvents.length;
            o2._cumhaz_0 = MemoryManager.malloc8d(n_time);
            o2._var_cumhaz_1 = MemoryManager.malloc8d(n_time);
            o2._var_cumhaz_2 = Key.make(model._key + "_var_cumhaz_2");
            o2._var_cumhaz_2_matrix = new CoxPHModel.FrameMatrix(o2._var_cumhaz_2, n_time, o2._coef.length);
            int num_strata = coxMR._num_strata;
            o2._baseline_hazard = Key.make(model._key + "_baseline_hazard");
            o2._baseline_hazard_matrix = new CoxPHModel.FrameMatrix(o2._baseline_hazard, n_time / num_strata, num_strata + 1);
            o2._baseline_survival = Key.make(model._key + "_baseline_survival");
            o2._baseline_survival_matrix = new CoxPHModel.FrameMatrix(o2._baseline_survival, coxMR.sizeEvents.length / num_strata, num_strata + 1);
            int n_coef = o2._coef.length;
            int nz = 0;
            switch (p2._ties) {
                case efron: {
                    double sizeCensored_t;
                    double sizeEvents_t;
                    int t3;
                    for (t3 = 0; t3 < coxMR.sizeEvents.length; ++t3) {
                        sizeEvents_t = coxMR.sizeEvents[t3];
                        sizeCensored_t = coxMR.sizeCensored[t3];
                        if (!(sizeEvents_t > 0.0) && !(sizeCensored_t > 0.0)) continue;
                        long countEvents_t = coxMR.countEvents[t3];
                        double sumRiskEvents_t = coxMR.sumRiskEvents[t3];
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t3];
                        double avgSize = sizeEvents_t / (double)countEvents_t;
                        o2._cumhaz_0[nz] = 0.0;
                        o2._var_cumhaz_1[nz] = 0.0;
                        for (int j2 = 0; j2 < n_coef; ++j2) {
                            o2._var_cumhaz_2_matrix.set(nz, j2, 0.0);
                        }
                        for (long e3 = 0L; e3 < countEvents_t; ++e3) {
                            double frac = (double)e3 / (double)countEvents_t;
                            double haz = 1.0 / (rcumsumRisk_t - frac * sumRiskEvents_t);
                            double haz_sq = haz * haz;
                            int n2 = nz;
                            o2._cumhaz_0[n2] = o2._cumhaz_0[n2] + avgSize * haz;
                            int n3 = nz;
                            o2._var_cumhaz_1[n3] = o2._var_cumhaz_1[n3] + avgSize * haz_sq;
                            for (int j3 = 0; j3 < n_coef; ++j3) {
                                o2._var_cumhaz_2_matrix.add(nz, j3, avgSize * ((coxMR.rcumsumXRisk[t3][j3] - frac * coxMR.sumXRiskEvents[t3][j3]) * haz_sq));
                            }
                        }
                        ++nz;
                    }
                    break;
                }
                case breslow: {
                    double sizeCensored_t;
                    double sizeEvents_t;
                    int t3;
                    for (t3 = 0; t3 < coxMR.sizeEvents.length; ++t3) {
                        double cumhaz_0_nz;
                        sizeEvents_t = coxMR.sizeEvents[t3];
                        sizeCensored_t = coxMR.sizeCensored[t3];
                        if (!(sizeEvents_t > 0.0) && !(sizeCensored_t > 0.0)) continue;
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t3];
                        o2._cumhaz_0[nz] = cumhaz_0_nz = sizeEvents_t / rcumsumRisk_t;
                        o2._var_cumhaz_1[nz] = sizeEvents_t / (rcumsumRisk_t * rcumsumRisk_t);
                        for (int j4 = 0; j4 < n_coef; ++j4) {
                            o2._var_cumhaz_2_matrix.set(nz, j4, coxMR.rcumsumXRisk[t3][j4] / rcumsumRisk_t * cumhaz_0_nz);
                        }
                        ++nz;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("_ties method must be either efron or breslow");
                }
            }
            double[] totalRisks = (double[])coxMR.totalRisk.clone();
            double[] sumHaz = new double[totalRisks.length];
            for (int i3 = sumHaz.length - 1; i3 >= 0; --i3) {
                sumHaz[i3] = 0.0;
            }
            for (t2 = 0; t2 < coxMR._time.length; ++t2) {
                o2._baseline_hazard_matrix.set(t2, 0, coxMR._time[t2]);
                o2._baseline_survival_matrix.set(t2, 0, coxMR._time[t2]);
                for (int strata = 0; strata < num_strata; ++strata) {
                    double weightEvent = coxMR.sizeEvents[t2 + coxMR._time.length * strata];
                    double sumRiskEvent = coxMR.sumRiskAllEvents[t2 + coxMR._time.length * strata];
                    double eventRisk = weightEvent / totalRisks[strata];
                    int n4 = strata;
                    totalRisks[n4] = totalRisks[n4] - sumRiskEvent;
                    int n5 = strata;
                    sumHaz[n5] = sumHaz[n5] + eventRisk;
                    o2._baseline_hazard_matrix.set(t2, strata + 1, eventRisk);
                    o2._baseline_survival_matrix.set(t2, strata + 1, Math.exp(-sumHaz[strata]));
                }
            }
            for (t2 = 1; t2 < o2._cumhaz_0.length; ++t2) {
                o2._cumhaz_0[t2] = o2._cumhaz_0[t2 - 1] + o2._cumhaz_0[t2];
                o2._var_cumhaz_1[t2] = o2._var_cumhaz_1[t2 - 1] + o2._var_cumhaz_1[t2];
                for (int j5 = 0; j5 < n_coef; ++j5) {
                    o2._var_cumhaz_2_matrix.set(t2, j5, o2._var_cumhaz_2_matrix.get(t2 - 1, j5) + o2._var_cumhaz_2_matrix.get(t2, j5));
                }
            }
            o2._var_cumhaz_2_matrix.toFrame(o2._var_cumhaz_2);
            Frame baselineHazardAsFrame = o2._baseline_hazard_matrix.toFrame(o2._baseline_hazard);
            Frame baselineSurvivalAsFrame = o2._baseline_survival_matrix.toFrame(o2._baseline_survival);
            if (null == o2._strataMap || 0 == o2._strataMap.size()) {
                baselineHazardAsFrame.setNames(new String[]{"t", "baseline hazard"});
                baselineSurvivalAsFrame.setNames(new String[]{"t", "baseline survival"});
            } else {
                Vec[] strataCols = CoxPH.this.train().vecs(((CoxPHModel.CoxPHParameters)CoxPH.this._input_parms)._stratify_by);
                List<String> names = o2._strataMap.entrySet().stream().sorted(Comparator.comparingInt(e2 -> ((IcedInt)e2.getValue())._val)).map(Map.Entry::getKey).map(i2 -> i2._gs).map(a2 -> IntStream.range(0, strataCols.length).mapToObj(i2 -> strataCols[i2].factor((int)a2[i2]))).map(s2 -> s2.collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.toList());
                names.add(0, "t");
                baselineHazardAsFrame.setNames(names.toArray(new String[0]));
                baselineSurvivalAsFrame.setNames(names.toArray(new String[0]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeImpl() {
            Lockable model = null;
            try {
                boolean _skip_scoring;
                CoxPH.this.init(true);
                double[] time = CollectTimes.collect(((CoxPHModel.CoxPHParameters)CoxPH.this._parms).stopVec(), ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                CoxPH.this._job.update(0L, "Initializing model training");
                IcedHashMap<AstGroup.G, IcedInt> strataMap = new IcedHashMap<AstGroup.G, IcedInt>();
                Frame f2 = this.reorderTrainFrameColumns(strataMap, time);
                int nResponses = (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).startVec() == null ? 2 : 3) + (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).isStratified() ? 1 : 0);
                DataInfo dinfo = new DataInfo(f2, null, nResponses, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._use_all_factor_levels, DataInfo.TransformType.DEMEAN, DataInfo.TransformType.NONE, true, false, false, CoxPH.this.hasWeightCol(), false, false, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms).interactionSpec()).disableIntercept();
                Scope.track_generic(dinfo);
                DKV.put(dinfo);
                CoxPHModel.CoxPHOutput output = new CoxPHModel.CoxPHOutput(CoxPH.this, dinfo._adaptedFrame, CoxPH.this.train(), strataMap);
                model = new CoxPHModel(CoxPH.this._result, (CoxPHModel.CoxPHParameters)CoxPH.this._parms, output);
                model.delete_and_lock(CoxPH.this._job);
                this.initStats((CoxPHModel)model, dinfo, time);
                ScoringHistory sc = new ScoringHistory(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._max_iterations + 1);
                int n_offsets = CoxPH.this._offset == null ? 0 : 1;
                int n_coef = dinfo.fullN() - n_offsets;
                double[] step = MemoryManager.malloc8d(n_coef);
                double[] oldCoef = MemoryManager.malloc8d(n_coef);
                double[] newCoef = MemoryManager.malloc8d(n_coef);
                Arrays.fill(step, Double.NaN);
                Arrays.fill(oldCoef, Double.NaN);
                for (int j2 = 0; j2 < n_coef; ++j2) {
                    newCoef[j2] = ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms)._init;
                }
                double logLik = -1.7976931348623157E308;
                boolean has_start_column = ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms).startVec() != null;
                boolean has_weights_column = CoxPH.this._weights != null;
                ComputationState cs = new ComputationState(n_coef);
                Timer iterTimer = null;
                CoxPHTask coxMR = null;
                CoxPH.this._job.update(1L, "Running iteration 0");
                for (int i2 = 0; i2 <= ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms)._max_iterations; ++i2) {
                    int j3;
                    iterTimer = new Timer();
                    ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._iter = i2;
                    Timer aggregTimer = new Timer();
                    coxMR = (CoxPHTask)new CoxPHTask(dinfo, newCoef, time, (long)CoxPH.this.response().min(), n_offsets, has_start_column, dinfo._adaptedFrame.vec(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._strata_column), has_weights_column, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._ties).doAll(dinfo._adaptedFrame, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                    Log.info("CoxPHTask: iter=" + i2 + ", time=" + aggregTimer.toString());
                    CoxPH.this._job.update(1L);
                    Timer loglikTimer = new Timer();
                    double newLoglik = this.calcLoglik((DataInfo)dinfo, (ComputationState)cs, (CoxPHModel.CoxPHParameters)((CoxPHModel.CoxPHParameters)CoxPH.this._parms), (CoxPHTask)coxMR)._logLik;
                    Log.info("LogLik: iter=" + i2 + ", time=" + loglikTimer.toString() + ", logLik=" + newLoglik);
                    ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._scoring_history = sc.addIterationScore(i2, newLoglik).to2dTable(i2 + 1);
                    if (newLoglik > logLik) {
                        if (i2 == 0) {
                            this.calcCounts((CoxPHModel)model, coxMR);
                        }
                        this.calcModelStats((CoxPHModel)model, newCoef, cs);
                        ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._lre = newLoglik == 0.0 ? -Math.log10(Math.abs(logLik - newLoglik)) : -Math.log10(Math.abs((logLik - newLoglik) / newLoglik));
                        if (((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._lre >= ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms)._lre_min) break;
                        Arrays.fill(step, 0.0);
                        for (j3 = 0; j3 < n_coef; ++j3) {
                            for (int k2 = 0; k2 < n_coef; ++k2) {
                                int n2 = j3;
                                step[n2] = step[n2] - ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._var_coef[j3][k2] * cs._gradient[k2];
                            }
                        }
                        for (j3 = 0; j3 < n_coef && !Double.isNaN(step[j3]) && !Double.isInfinite(step[j3]); ++j3) {
                        }
                        logLik = newLoglik;
                        System.arraycopy(newCoef, 0, oldCoef, 0, oldCoef.length);
                    } else {
                        j3 = 0;
                        while (j3 < n_coef) {
                            int n3 = j3++;
                            step[n3] = step[n3] / 2.0;
                        }
                    }
                    for (j3 = 0; j3 < n_coef; ++j3) {
                        newCoef[j3] = oldCoef[j3] - step[j3];
                    }
                    model.update(CoxPH.this._job);
                    CoxPH.this._job.update(1L, "Iteration = " + i2 + "/" + ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms)._max_iterations + ", logLik = " + logLik);
                    if (i2 == ((CoxPHModel.CoxPHParameters)((CoxPHModel)model)._parms)._max_iterations) continue;
                    Log.info("CoxPH Iteration: iter=" + i2 + ", " + iterTimer.toString());
                }
                if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._calc_cumhaz && coxMR != null) {
                    this.calcCumhaz_0((CoxPHModel)model, coxMR);
                }
                if (iterTimer != null) {
                    Log.info("CoxPH Last Iteration: " + iterTimer.toString());
                }
                if (!(_skip_scoring = H2O.getSysBoolProperty("debug.skipScoring", false))) {
                    model.update(CoxPH.this._job);
                    ((Model)model).score(((CoxPHModel.CoxPHParameters)CoxPH.this._parms).train()).delete();
                    ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._training_metrics = ModelMetrics.getFromDKV((Model)model, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms).train());
                    ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._concordance = ((ModelMetricsRegressionCoxPH)((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._training_metrics).concordance();
                }
                ((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._model_summary = CoxPH.this.generateSummary((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output);
                Log.info(((CoxPHModel.CoxPHOutput)((CoxPHModel)model)._output)._model_summary);
                model.update(CoxPH.this._job);
            }
            finally {
                if (model != null) {
                    model.unlock(CoxPH.this._job);
                }
            }
        }
    }

    static class StrataTask
    extends DiscretizeTimeTask {
        private final IcedHashMap<AstGroup.G, IcedInt> _strataMap;

        private StrataTask(IcedHashMap<AstGroup.G, IcedInt> strata) {
            this(strata, new double[0], false);
        }

        private StrataTask(IcedHashMap<AstGroup.G, IcedInt> strata, double[] time, boolean has_start_column) {
            super(time, has_start_column);
            this._strataMap = strata;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            NewChunk[] tncs;
            Chunk[] tcs;
            Chunk[] scs;
            if (ncs.length > 1) {
                scs = new Chunk[cs.length - ncs.length + 1];
                System.arraycopy(cs, 0, scs, 0, scs.length);
                tcs = new Chunk[ncs.length - 1];
                System.arraycopy(cs, scs.length, tcs, 0, tcs.length);
                tncs = new NewChunk[ncs.length - 1];
                System.arraycopy(ncs, 1, tncs, 0, tncs.length);
            } else {
                scs = cs;
                tcs = null;
                tncs = null;
            }
            AstGroup.G g2 = new AstGroup.G(scs.length, null);
            for (int i2 = 0; i2 < cs[0].len(); ++i2) {
                g2.fill(i2, scs);
                IcedInt strataId = (IcedInt)this._strataMap.get(g2);
                if (strataId == null) {
                    for (NewChunk nc : ncs) {
                        nc.addNA();
                    }
                    continue;
                }
                ncs[0].addNum(strataId._val);
                if (tcs == null) continue;
                int strataOffset = this._time.length * strataId._val;
                this.discretizeTime(i2, tcs, tncs, strataOffset);
            }
        }

        static Vec makeStrataVec(Frame f2, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> mapping, boolean runLocal) {
            Frame sf = f2.subframe(stratifyBy);
            return ((DiscretizeTimeTask)new StrataTask(mapping).doAll(new byte[]{3}, sf, runLocal)).outputFrame().anyVec();
        }

        static Frame stratifyTime(Frame f2, double[] time, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> mapping, Vec startVec, Vec stopVec, boolean runLocal) {
            boolean hasStartColumn;
            Frame sf = f2.subframe(stratifyBy);
            boolean bl = hasStartColumn = startVec != null;
            if (hasStartColumn) {
                sf.add("__startVec", startVec);
            }
            sf.add("__stopVec", stopVec);
            return ((DiscretizeTimeTask)new StrataTask(mapping, time, hasStartColumn).doAll(ArrayUtils.constAry(hasStartColumn ? 3 : 2, (byte)3), sf, runLocal)).outputFrame();
        }

        static void setupStrataMapping(Frame f2, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> outMapping) {
            Frame sf = f2.subframe(stratifyBy);
            int[] idxs = MemoryManager.malloc4(stratifyBy.length);
            for (int i2 = 0; i2 < idxs.length; ++i2) {
                idxs[i2] = i2;
            }
            IcedHashSet<AstGroup.G> groups = AstGroup.doGroups(sf, idxs, AstGroup.aggNRows());
            block1: for (AstGroup.G g2 : groups) {
                for (double val : g2._gs) {
                    if (Double.isNaN(val)) continue block1;
                }
                outMapping.put(g2, new IcedInt(outMapping.size()));
            }
        }
    }

    static class DiscretizeTimeTask
    extends MRTask<DiscretizeTimeTask> {
        final double[] _time;
        final boolean _has_start_column;

        private DiscretizeTimeTask(double[] time, boolean has_start_column) {
            this._time = time;
            this._has_start_column = has_start_column;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            assert (cs.length == (this._has_start_column ? 2 : 1));
            for (int i2 = 0; i2 < cs[0].len(); ++i2) {
                this.discretizeTime(i2, cs, ncs, 0);
            }
        }

        void discretizeTime(int i2, Chunk[] cs, NewChunk[] ncs, int offset) {
            double stopTime = cs[cs.length - 1].atd(i2);
            int t2 = Arrays.binarySearch(this._time, stopTime);
            if (t2 < 0) {
                throw new IllegalStateException("Encountered unexpected stop time");
            }
            ncs[ncs.length - 1].addNum(t2 + offset);
            if (this._has_start_column) {
                double startTime = cs[0].atd(i2);
                if (startTime >= stopTime) {
                    throw new IllegalArgumentException("start times must be strictly less than stop times");
                }
                int t1c = Arrays.binarySearch(this._time, startTime);
                int t1 = t1c >= 0 ? t1c + 1 : -t1c - 1;
                ncs[0].addNum(t1 + offset);
            }
        }

        static Frame discretizeTime(double[] time, Vec startVec, Vec stopVec, boolean runLocal) {
            byte[] byArray;
            boolean hasStartColumn = startVec != null;
            Frame f2 = new Frame(new Vec[0]);
            if (hasStartColumn) {
                f2.add("__startCol", startVec);
            }
            f2.add("__stopCol", stopVec);
            if (hasStartColumn) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 3;
                byArray = byArray2;
                byArray2[1] = 3;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 3;
            }
            byte[] outputTypes = byArray;
            return ((DiscretizeTimeTask)new DiscretizeTimeTask(time, startVec != null).doAll(outputTypes, f2, runLocal)).outputFrame();
        }
    }
}

