/*
 * Decompiled with CFR 0.152.
 */
package hex.anovaglm;

import hex.DataInfo;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.anovaglm.ANOVAGLM;
import hex.anovaglm.ANOVAGLMUtils;
import hex.deeplearning.DeepLearningModel;
import hex.gam.MatrixFrameUtils.GAMModelUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.util.DistributionUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.distribution.FDistribution;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.TwoDimTable;

public class ANOVAGLMModel
extends Model<ANOVAGLMModel, ANOVAGLMParameters, ANOVAGLMModelOutput> {
    public ANOVAGLMModel(Key<ANOVAGLMModel> selfKey, ANOVAGLMParameters parms, ANOVAGLMModelOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        assert (domain == null);
        switch (((ANOVAGLMModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((ANOVAGLMModelOutput)this._output).nclasses(), domain, ((ANOVAGLMParameters)this._parms)._auc_type);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
        throw H2O.unimpl("Invalid ModelCategory " + (Object)((Object)((ANOVAGLMModelOutput)this._output).getModelCategory()));
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("ANOVAGLM does not support scoring on data.  It only provide information on predictor relevance");
    }

    @Override
    public Frame score(Frame fr, String destination_key, Job j2, boolean computeMetrics, CFuncRef customMetricFunc) {
        throw new UnsupportedOperationException("ANOVAGLM does not support scoring on data.  It only provide information on predictor relevance");
    }

    @Override
    public Frame result() {
        return ((ANOVAGLMModelOutput)this._output).generateResultFrame();
    }

    public void fillOutput(String[] modelNames, int[] degreeOfFreedom) {
        ((ANOVAGLMModelOutput)this._output)._modelNames = modelNames;
        ((ANOVAGLMModelOutput)this._output)._degreeOfFreedom = degreeOfFreedom;
        ((ANOVAGLMModelOutput)this._output)._model_summary = this.generateSummary();
    }

    public TwoDimTable generateSummary() {
        Frame result = this.result();
        int ncols = result.numCols();
        int nrows = (int)result.numRows();
        String[] names = result.names();
        String[] types = new String[]{"string", "string", "string", "double", "int", "double", "double", "double"};
        String[] formats = new String[]{"%s", "%s", "%s", "%f", "%d", "%f", "%f", "%f"};
        String[] rowHeaders = new String[nrows];
        TwoDimTable table = new TwoDimTable("GLM ANOVA Type III SS", "summary", rowHeaders, names, types, formats, "");
        for (int rIdx = 0; rIdx < nrows; ++rIdx) {
            for (int cIdx = 0; cIdx < ncols; ++cIdx) {
                Vec v2 = result.vec(cIdx);
                table.set(rIdx, cIdx, v2.isNumeric() ? Double.valueOf(v2.at(rIdx)) : v2.stringAt(rIdx));
                if (cIdx != 0) continue;
                rowHeaders[rIdx] = v2.stringAt(rIdx);
            }
        }
        result.delete();
        return table;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        super.remove_impl(fs, cascade);
        Keyed.remove(((ANOVAGLMModelOutput)this._output)._transformed_columns_key, fs, cascade);
        return fs;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((ANOVAGLMModelOutput)this._output)._transformed_columns_key != null) {
            ab.putKey(((ANOVAGLMModelOutput)this._output)._transformed_columns_key);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((ANOVAGLMModelOutput)this._output)._transformed_columns_key != null) {
            ab.getKey(((ANOVAGLMModelOutput)this._output)._transformed_columns_key, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public static class ANOVAGLMModelOutput
    extends Model.Output {
        DataInfo _dinfo;
        public long _training_time_ms;
        public String[][] _coefficient_names;
        GLMModel.GLMParameters.Family _family;
        GLMModel.GLMParameters.Link _link;
        public Key<Frame> _transformed_columns_key;
        public TwoDimTable[] _coefficients_table;
        GLMModel[] _glmModels;
        String[] _modelNames;
        int[] _degreeOfFreedom;

        @Override
        public ModelCategory getModelCategory() {
            switch (this._family) {
                case quasibinomial: 
                case fractionalbinomial: 
                case binomial: {
                    return ModelCategory.Binomial;
                }
                case multinomial: {
                    return ModelCategory.Multinomial;
                }
                case ordinal: {
                    return ModelCategory.Ordinal;
                }
            }
            return ModelCategory.Regression;
        }

        public String[][] coefficientNames() {
            return this._coefficient_names;
        }

        public ANOVAGLMModelOutput(ANOVAGLM b2, DataInfo dinfo) {
            super(b2, dinfo._adaptedFrame);
            this._dinfo = dinfo;
            this._domains = dinfo._adaptedFrame.domains();
            this._family = ((ANOVAGLMParameters)b2._parms)._family;
            this._link = ((ANOVAGLMParameters)b2._parms)._link;
        }

        void copyGLMCoeffs(String[] modelNames) {
            int numModels = this._glmModels.length;
            this._coefficients_table = new TwoDimTable[numModels];
            this._coefficient_names = new String[numModels][];
            for (int index = 0; index < numModels; ++index) {
                this._coefficients_table[index] = GAMModelUtils.genCoefficientTable(new String[]{"coefficients", "standardized coefficients"}, ((GLMModel.GLMOutput)this._glmModels[index]._output).beta(), ((GLMModel.GLMOutput)this._glmModels[index]._output).getNormBeta(), ((GLMModel.GLMOutput)this._glmModels[index]._output)._coefficient_names, "Coefficients for " + modelNames[index]);
                this._coefficient_names[index] = (String[])((GLMModel.GLMOutput)this._glmModels[index]._output)._coefficient_names.clone();
            }
        }

        private Frame generateResultFrame() {
            int lastModelIndex = this._glmModels.length - 1;
            String[] colNames = new String[]{"predictors_interactions", "family", "link", "ss", "df", "ms", "f", "p_value"};
            String[] rowNames = new String[lastModelIndex];
            String[] familyNames = new String[lastModelIndex];
            String[] linkNames = new String[lastModelIndex];
            double[] ss = ANOVAGLMUtils.generateGLMSS(this._glmModels, this._family);
            double[] dof = Arrays.stream(this._degreeOfFreedom).asDoubleStream().toArray();
            double[] msA = new double[lastModelIndex];
            double[] fA = new double[lastModelIndex];
            double[] pValues = new double[lastModelIndex];
            System.arraycopy(this._modelNames, 0, rowNames, 0, lastModelIndex);
            long dofFullModel = ((GLMModel.GLMOutput)this._glmModels[lastModelIndex]._output)._training_metrics.residual_degrees_of_freedom();
            double mse = ss[lastModelIndex] / (double)dofFullModel;
            double oneOverMse = 1.0 / mse;
            for (int rIndex = 0; rIndex < lastModelIndex; ++rIndex) {
                double p_value;
                double f2;
                double ms;
                familyNames[rIndex] = this._family.toString();
                linkNames[rIndex] = this._link.toString();
                msA[rIndex] = ms = ss[rIndex] / (double)this._degreeOfFreedom[rIndex];
                fA[rIndex] = f2 = oneOverMse * ss[rIndex] / (double)this._degreeOfFreedom[rIndex];
                FDistribution fdist = new FDistribution((double)this._degreeOfFreedom[rIndex], (double)dofFullModel);
                pValues[rIndex] = p_value = 1.0 - fdist.cumulativeProbability(f2);
            }
            Vec.VectorGroup vg = Vec.VectorGroup.VG_LEN1;
            Vec rNames = Vec.makeVec(rowNames, vg.addVec());
            Vec fNames = Vec.makeVec(familyNames, vg.addVec());
            Vec lNames = Vec.makeVec(linkNames, vg.addVec());
            Vec sumSquares = Vec.makeVec(ss, vg.addVec());
            Vec degOfFreedom = Vec.makeVec(dof, vg.addVec());
            Vec msV = Vec.makeVec(msA, vg.addVec());
            Vec fV = Vec.makeVec(fA, vg.addVec());
            Vec pValuesV = Vec.makeVec(pValues, vg.addVec());
            return new Frame(Key.make(), colNames, new Vec[]{rNames, fNames, lNames, sumSquares, degOfFreedom, msV, fV, pValuesV});
        }
    }

    public static class ANOVAGLMParameters
    extends Model.Parameters {
        public int _highest_interaction_term;
        public double[] _alpha;
        public double[] _lambda = new double[]{0.0};
        public boolean _standardize = true;
        public GLMModel.GLMParameters.Family _family = GLMModel.GLMParameters.Family.AUTO;
        public boolean _lambda_search;
        public GLMModel.GLMParameters.Link _link = GLMModel.GLMParameters.Link.family_default;
        public GLMModel.GLMParameters.Solver _solver = GLMModel.GLMParameters.Solver.IRLSM;
        public String[] _interactions = null;
        public double _tweedie_variance_power;
        public double _tweedie_link_power = 1.0;
        public double _theta;
        public double _invTheta;
        public Serializable _missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
        public boolean _compute_p_values = true;
        public boolean _remove_collinear_columns = true;
        public int _nfolds = 0;
        public Key<Frame> _plug_values = null;
        public boolean _save_transformed_framekeys = false;
        public int _nparallelism = 4;

        @Override
        public String algoName() {
            return "ANOVAGLM";
        }

        @Override
        public String fullName() {
            return "ANOVA for Generalized Linear Model";
        }

        @Override
        public String javaName() {
            return ANOVAGLMModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 1L;
        }

        public GLMModel.GLMParameters.MissingValuesHandling missingValuesHandling() {
            if (this._missing_values_handling instanceof GLMModel.GLMParameters.MissingValuesHandling) {
                return (GLMModel.GLMParameters.MissingValuesHandling)((Object)this._missing_values_handling);
            }
            assert (this._missing_values_handling instanceof DeepLearningModel.DeepLearningParameters.MissingValuesHandling);
            switch ((DeepLearningModel.DeepLearningParameters.MissingValuesHandling)((Object)this._missing_values_handling)) {
                case MeanImputation: {
                    return GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
                }
                case Skip: {
                    return GLMModel.GLMParameters.MissingValuesHandling.Skip;
                }
            }
            throw new IllegalStateException("Unsupported missing values handling value: " + this._missing_values_handling);
        }

        public boolean imputeMissing() {
            return this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues;
        }

        public DataInfo.Imputer makeImputer() {
            if (this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
                if (this._plug_values == null || this._plug_values.get() == null) {
                    throw new IllegalStateException("Plug values frame needs to be specified when Missing Value Handling = PlugValues.");
                }
                return new GLM.PlugValuesImputer(this._plug_values.get());
            }
            return new DataInfo.MeanImputer();
        }

        @Override
        public void setDistributionFamily(DistributionFamily distributionFamily) {
            this._family = DistributionUtils.distributionToFamily(distributionFamily);
            this._link = GLMModel.GLMParameters.Link.family_default;
        }

        @Override
        public DistributionFamily getDistributionFamily() {
            return DistributionUtils.familyToDistribution(this._family);
        }
    }
}

