/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.ModelMojoWriter;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;

public abstract class MultiModelMojoWriter<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends ModelMojoWriter<M, P, O> {
    public MultiModelMojoWriter() {
    }

    public MultiModelMojoWriter(M model) {
        super(model);
    }

    protected abstract List<Model> getSubModels();

    protected abstract void writeParentModelData() throws IOException;

    @Override
    protected final void writeModelData() throws IOException {
        List<Model> subModels = this.getSubModels();
        this.writekv("submodel_count", subModels.size());
        int modelNum = 0;
        for (Model model : subModels) {
            this.writekv("submodel_key_" + modelNum, model._key.toString());
            this.writekv("submodel_dir_" + modelNum, MultiModelMojoWriter.getZipDirectory(model));
            ++modelNum;
        }
        this.writeParentModelData();
    }

    @Override
    protected void writeTo(ZipOutputStream zos) throws IOException {
        super.writeTo(zos);
        for (Model model : this.getSubModels()) {
            String zipDir = MultiModelMojoWriter.getZipDirectory(model);
            ModelMojoWriter writer = model.getMojo();
            writer.writeTo(zos, zipDir);
        }
    }

    private static String getZipDirectory(Model m4) {
        String algo = ((Model.Parameters)m4._parms).algoName();
        String key = m4._key.toString();
        return "models/" + algo + "/" + key + "/";
    }
}

