/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.Model;

class HuberDistribution
extends Distribution {
    public HuberDistribution(Model.Parameters params) {
        super(params);
    }

    @Override
    public double deviance(double w2, double y2, double f2) {
        if (Math.abs(y2 - f2) <= this._huberDelta) {
            return w2 * (y2 - f2) * (y2 - f2);
        }
        return w2 * (2.0 * Math.abs(y2 - f2) - this._huberDelta) * this._huberDelta;
    }

    @Override
    public double negHalfGradient(double y2, double f2) {
        if (Math.abs(y2 - f2) <= this._huberDelta) {
            return y2 - f2;
        }
        return f2 >= y2 ? -this._huberDelta : this._huberDelta;
    }
}

