/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto.utils;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECChecks {
    public static boolean isPointOnCurve(ECPublicKey publicKey, ECPrivateKey privateKey) {
        return ECChecks.isPointOnCurve(publicKey, privateKey.getParams());
    }

    public static boolean isPointOnCurve(ECPublicKey publicKey, ECParameterSpec ecParameterSpec) {
        ECPoint point = publicKey.getW();
        return ECChecks.isPointOnCurve(point.getAffineX(), point.getAffineY(), ecParameterSpec);
    }

    public static boolean isPointOnCurve(BigInteger x2, BigInteger y2, ECParameterSpec ecParameterSpec) {
        EllipticCurve curve = ecParameterSpec.getCurve();
        BigInteger a2 = curve.getA();
        BigInteger b2 = curve.getB();
        BigInteger p2 = ((ECFieldFp)curve.getField()).getP();
        BigInteger leftSide = y2.pow(2).mod(p2);
        BigInteger rightSide = x2.pow(3).add(a2.multiply(x2)).add(b2).mod(p2);
        return leftSide.equals(rightSide);
    }

    private ECChecks() {
    }
}

