/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.constantine.platform;

import com.kenai.constantine.Constant;
import com.kenai.constantine.ConstantSet;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private final AtomicInteger nextUnknown;
    private final int lastUnknown;
    private final boolean bitmask;
    private Constant[] cache = null;
    private volatile E[] valueCache = null;
    private volatile int cacheGuard = 0;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> enumType) {
        this(enumType, Integer.MIN_VALUE, -2147482648, false);
    }

    private ConstantResolver(Class<E> enumType, int firstUnknown, int lastUnknown, boolean bitmask) {
        this.enumType = enumType;
        this.nextUnknown = new AtomicInteger(firstUnknown);
        this.lastUnknown = lastUnknown;
        this.bitmask = bitmask;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType, int first, int last) {
        return new ConstantResolver<T>(enumType, first, last, false);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getBitmaskResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType, 0, Integer.MIN_VALUE, true);
    }

    private Constant getConstant(E e2) {
        Constant c2;
        if (this.cacheGuard != 0 && (c2 = this.cache[((Enum)e2).ordinal()]) != null) {
            return c2;
        }
        return this.lookupAndCacheConstant(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constant lookupAndCacheConstant(E e2) {
        Object object = this.modLock;
        synchronized (object) {
            Constant c2;
            if (this.cacheGuard != 0 && (c2 = this.cache[((Enum)e2).ordinal()]) != null) {
                return c2;
            }
            EnumSet<Enum> enums = EnumSet.allOf(this.enumType);
            ConstantSet cset = this.getConstants();
            if (this.cache == null) {
                this.cache = new Constant[enums.size()];
            }
            long known = 0L;
            long unknown = 0L;
            for (Enum v2 : enums) {
                Constant c3 = cset.getConstant(v2.name());
                if (c3 == null) {
                    if (this.bitmask) {
                        unknown |= 1L << v2.ordinal();
                        c3 = new UnknownConstant(0, v2.name());
                    } else {
                        c3 = new UnknownConstant(this.nextUnknown.getAndAdd(1), v2.name());
                    }
                } else if (this.bitmask) {
                    known |= (long)c3.value();
                }
                this.cache[v2.ordinal()] = c3;
            }
            if (this.bitmask) {
                long mask = 0L;
                while ((mask = Long.lowestOneBit(unknown)) != 0L) {
                    int index = Long.numberOfTrailingZeros(mask);
                    int sparebit = Long.numberOfTrailingZeros(Long.lowestOneBit(known ^ 0xFFFFFFFFFFFFFFFFL));
                    int value = 1 << sparebit;
                    this.cache[index] = new UnknownConstant(value, this.cache[index].name());
                    known |= (long)value;
                    unknown &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            this.cacheGuard = 1;
            return this.cache[((Enum)e2).ordinal()];
        }
    }

    final int intValue(E e2) {
        return this.getConstant(e2).value();
    }

    final long longValue(E e2) {
        return this.getConstant(e2).longValue();
    }

    final String description(E e2) {
        return this.getConstant(e2).toString();
    }

    final E valueOf(int value) {
        Enum e2;
        if (value >= 0 && value < 256 && this.valueCache != null && (e2 = this.valueCache[value]) != null) {
            return (E)e2;
        }
        e2 = (Enum)this.reverseLookupMap.get(value);
        if (e2 != null) {
            return (E)e2;
        }
        Constant c2 = this.getConstants().getConstant(value);
        if (c2 != null) {
            try {
                e2 = Enum.valueOf(this.enumType, c2.name());
                this.reverseLookupMap.put(value, e2);
                if (c2.value() >= 0 && c2.value() < 256) {
                    Object[] values = this.valueCache;
                    if (values == null) {
                        values = (Enum[])Array.newInstance(this.enumType, 256);
                    }
                    values[c2.value()] = e2;
                    this.valueCache = values;
                }
                return (E)e2;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        System.out.println("failed to reverse lookup value " + value);
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }

    private static final class UnknownConstant
    implements Constant {
        private final int value;
        private final String name;

        UnknownConstant(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public int intValue() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public boolean defined() {
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

