/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import ai.h2o.com.google.common.collect.ImmutableList;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import javax.annotation.Nullable;

final class AutoValue_Binding
extends Binding {
    private final String role;
    private final ImmutableList<String> members;
    private final Condition condition;

    private AutoValue_Binding(String role, ImmutableList<String> members, @Nullable Condition condition) {
        this.role = role;
        this.members = members;
        this.condition = condition;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public ImmutableList<String> getMembers() {
        return this.members;
    }

    @Override
    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    public String toString() {
        return "Binding{role=" + this.role + ", members=" + this.members + ", condition=" + this.condition + "}";
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof Binding) {
            Binding that = (Binding)o2;
            return this.role.equals(that.getRole()) && this.members.equals(that.getMembers()) && (this.condition == null ? that.getCondition() == null : this.condition.equals(that.getCondition()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.role.hashCode();
        h$ *= 1000003;
        h$ ^= this.members.hashCode();
        h$ *= 1000003;
        return h$ ^= this.condition == null ? 0 : this.condition.hashCode();
    }

    @Override
    public Binding.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Binding.Builder {
        private String role;
        private ImmutableList<String> members;
        private Condition condition;

        Builder() {
        }

        private Builder(Binding source) {
            this.role = source.getRole();
            this.members = source.getMembers();
            this.condition = source.getCondition();
        }

        @Override
        public Binding.Builder setRole(String role) {
            if (role == null) {
                throw new NullPointerException("Null role");
            }
            this.role = role;
            return this;
        }

        @Override
        public Binding.Builder setMembers(Iterable<String> members) {
            this.members = ImmutableList.copyOf(members);
            return this;
        }

        @Override
        ImmutableList<String> getMembers() {
            if (this.members == null) {
                throw new IllegalStateException("Property \"members\" has not been set");
            }
            return this.members;
        }

        @Override
        public Binding.Builder setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Binding build() {
            if (this.role == null || this.members == null) {
                StringBuilder missing = new StringBuilder();
                if (this.role == null) {
                    missing.append(" role");
                }
                if (this.members == null) {
                    missing.append(" members");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Binding(this.role, this.members, this.condition);
        }
    }
}

