/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson.longrunning.stub;

import ai.h2o.com.google.common.collect.ImmutableList;
import ai.h2o.com.google.common.collect.ImmutableMap;
import ai.h2o.com.google.common.collect.ImmutableSet;
import ai.h2o.com.google.common.collect.Lists;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class OperationsStubSettings
extends StubSettings<OperationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final PagedCallSettings<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings;
    private final UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings;
    private final UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private static final PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation> LIST_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListOperationsRequest injectToken(ListOperationsRequest payload, String token) {
            return ListOperationsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListOperationsRequest injectPageSize(ListOperationsRequest payload, int pageSize) {
            return ListOperationsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListOperationsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Operation> extractResources(ListOperationsResponse payload) {
            return payload.getOperationsList() == null ? ImmutableList.of() : payload.getOperationsList();
        }
    };
    private static final PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> LIST_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse>(){

        @Override
        public ApiFuture<OperationsClient.ListOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperationsRequest, ListOperationsResponse> callable, ListOperationsRequest request, ApiCallContext context, ApiFuture<ListOperationsResponse> futureResponse) {
            PageContext<ListOperationsRequest, ListOperationsResponse, Operation> pageContext = PageContext.create(callable, LIST_OPERATIONS_PAGE_STR_DESC, request, context);
            return OperationsClient.ListOperationsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OperationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOperationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "longrunning.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "longrunning.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OperationsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OperationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OperationsStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OperationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings;
        private final UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings;
        private final UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listOperationsSettings = PagedCallSettings.newBuilder(LIST_OPERATIONS_PAGE_STR_FACT);
            this.getOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listOperationsSettings, this.getOperationSettings, this.deleteOperationSettings, this.cancelOperationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OperationsStubSettings settings) {
            super(settings);
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listOperationsSettings, this.getOperationSettings, this.deleteOperationSettings, this.cancelOperationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OperationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(OperationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(OperationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(OperationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(OperationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            ((PagedCallSettings.Builder)builder.listOperationsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.deleteOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.cancelOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public OperationsStubSettings build() throws IOException {
            return new OperationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(500L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis(10000L)).setInitialRpcTimeout(Duration.ofMillis(10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(10000L)).setTotalTimeout(Duration.ofMillis(10000L)).build();
            definitions.put("retry_policy_0_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

