/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import ai.h2o.com.google.common.base.MoreObjects;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class BatcherStats {
    private final Map<Class, Integer> requestExceptionCounts = new HashMap<Class, Integer>();
    private final Map<StatusCode.Code, Integer> requestStatusCounts = new HashMap<StatusCode.Code, Integer>();
    private int requestPartialFailureCount;
    private final Map<Class, Integer> entryExceptionCounts = new HashMap<Class, Integer>();
    private final Map<StatusCode.Code, Integer> entryStatusCounts = new HashMap<StatusCode.Code, Integer>();

    BatcherStats() {
    }

    synchronized void recordBatchFailure(Throwable throwable) {
        Class<Object> exceptionClass = throwable.getClass();
        if (throwable instanceof ApiException) {
            StatusCode.Code code = ((ApiException)throwable).getStatusCode().getCode();
            exceptionClass = ApiException.class;
            int oldStatusCount = MoreObjects.firstNonNull(this.requestStatusCounts.get((Object)code), 0);
            this.requestStatusCounts.put(code, oldStatusCount + 1);
        }
        int oldExceptionCount = MoreObjects.firstNonNull(this.requestExceptionCounts.get(exceptionClass), 0);
        this.requestExceptionCounts.put(exceptionClass, oldExceptionCount + 1);
    }

    synchronized <T extends BatchEntry> void recordBatchElementsCompletion(List<T> batchElementResultFutures) {
        boolean isRequestPartiallyFailed = false;
        for (BatchEntry elementResult : batchElementResultFutures) {
            try {
                elementResult.getResultFuture().get();
            }
            catch (Throwable throwable) {
                if (!isRequestPartiallyFailed) {
                    isRequestPartiallyFailed = true;
                    ++this.requestPartialFailureCount;
                }
                Throwable actualCause = throwable.getCause();
                Class<Object> exceptionClass = actualCause.getClass();
                if (actualCause instanceof ApiException) {
                    StatusCode.Code code = ((ApiException)actualCause).getStatusCode().getCode();
                    exceptionClass = ApiException.class;
                    int oldStatusCount = MoreObjects.firstNonNull(this.entryStatusCounts.get((Object)code), 0);
                    this.entryStatusCounts.put(code, oldStatusCount + 1);
                }
                int oldExceptionCount = MoreObjects.firstNonNull(this.entryExceptionCounts.get(exceptionClass), 0);
                this.entryExceptionCounts.put(exceptionClass, oldExceptionCount + 1);
            }
        }
    }

    @Nullable
    synchronized BatchingException asException() {
        if (this.requestExceptionCounts.isEmpty() && this.requestPartialFailureCount == 0) {
            return null;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Batching finished with ");
        if (!this.requestExceptionCounts.isEmpty()) {
            messageBuilder.append(String.format("%d batches failed to apply due to: ", this.requestExceptionCounts.size())).append(this.buildExceptionList(this.requestExceptionCounts, this.requestStatusCounts)).append(" and ");
        }
        messageBuilder.append(String.format("%d partial failures.", this.requestPartialFailureCount));
        if (this.requestPartialFailureCount > 0) {
            int totalEntriesCount = 0;
            for (Integer count2 : this.entryExceptionCounts.values()) {
                totalEntriesCount += count2.intValue();
            }
            messageBuilder.append(String.format(" The %d partial failures contained %d entries that failed with: ", this.requestPartialFailureCount, totalEntriesCount)).append(this.buildExceptionList(this.entryExceptionCounts, this.entryStatusCounts)).append(".");
        }
        return new BatchingException(messageBuilder.toString());
    }

    private String buildExceptionList(Map<Class, Integer> exceptionCounts, Map<StatusCode.Code, Integer> statusCounts) {
        StringBuilder messageBuilder = new StringBuilder();
        Iterator<Map.Entry<Class, Integer>> exceptionIterator = exceptionCounts.entrySet().iterator();
        while (exceptionIterator.hasNext()) {
            Map.Entry<Class, Integer> request = exceptionIterator.next();
            messageBuilder.append(String.format("%d %s", request.getValue(), request.getKey().getSimpleName()));
            if (ApiException.class.equals((Object)request.getKey())) {
                messageBuilder.append("(");
                Iterator<Map.Entry<StatusCode.Code, Integer>> statusIterator = statusCounts.entrySet().iterator();
                while (statusIterator.hasNext()) {
                    Map.Entry<StatusCode.Code, Integer> statusCode = statusIterator.next();
                    messageBuilder.append(String.format("%d %s", new Object[]{statusCode.getValue(), statusCode.getKey()}));
                    if (!statusIterator.hasNext()) continue;
                    messageBuilder.append(", ");
                }
                messageBuilder.append(")");
            }
            if (!exceptionIterator.hasNext()) continue;
            messageBuilder.append(", ");
        }
        return messageBuilder.toString();
    }
}

