/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.xgboost4j.java.util;

import ai.h2o.xgboost4j.java.util.UtilUnsafe;

public final class BigDenseMatrix {
    private static final int FLOAT_BYTE_SIZE = 4;
    public static final long MAX_MATRIX_SIZE = 0x1FFFFFFFFFFFFFFFL;
    public final int nrow;
    public final int ncol;
    public final long address;

    public static void setDirect(long valAddress, float val) {
        UtilUnsafe.UNSAFE.putFloat(valAddress, val);
    }

    public static float getDirect(long valAddress) {
        return UtilUnsafe.UNSAFE.getFloat(valAddress);
    }

    public BigDenseMatrix(int nrow, int ncol) {
        long size = (long)nrow * (long)ncol;
        if (size > 0x1FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Matrix too large; matrix size cannot exceed 2305843009213693951");
        }
        this.nrow = nrow;
        this.ncol = ncol;
        this.address = UtilUnsafe.UNSAFE.allocateMemory(size * 4L);
    }

    public final void set(long idx, float val) {
        BigDenseMatrix.setDirect(this.address + idx * 4L, val);
    }

    public final void set(int i2, int j2, float val) {
        this.set(this.index(i2, j2), val);
    }

    public final float get(long idx) {
        return BigDenseMatrix.getDirect(this.address + idx * 4L);
    }

    public final float get(int i2, int j2) {
        return this.get(this.index(i2, j2));
    }

    public final void dispose() {
        UtilUnsafe.UNSAFE.freeMemory(this.address);
    }

    private long index(int i2, int j2) {
        return (long)i2 * (long)this.ncol + (long)j2;
    }
}

