/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.xgboost4j.java;

import ai.h2o.xgboost4j.java.Booster;
import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import ai.h2o.xgboost4j.java.XGBoostJNI;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KryoBooster
extends Booster
implements KryoSerializable {
    private static final Log logger = LogFactory.getLog(KryoBooster.class);

    KryoBooster(Map<String, Object> params, DMatrix[] cacheMats) throws XGBoostError {
        super(params, cacheMats, true);
    }

    KryoBooster() {
        super(true);
    }

    public void write(Kryo kryo, Output output) {
        try {
            byte[] serObj = this.toByteArray();
            int serObjSize = serObj.length;
            output.writeInt(serObjSize);
            output.writeInt(this.version);
            output.write(serObj);
        }
        catch (XGBoostError ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Booster serialization failed", ex);
        }
    }

    public void read(Kryo kryo, Input input) {
        try {
            this.init(null);
            int serObjSize = input.readInt();
            this.version = input.readInt();
            byte[] bytes = new byte[serObjSize];
            input.readBytes(bytes);
            XGBoostJNI.checkCall(XGBoostJNI.XGBoosterLoadModelFromBuffer(this.handle, bytes));
        }
        catch (XGBoostError ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Booster deserialization failed", ex);
        }
    }
}

