/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.interaction;

import ai.h2o.targetencoding.interaction.InteractionsEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;

class CreateInteractionTask
extends MRTask<CreateInteractionTask> {
    final InteractionsEncoder _encoder;
    final long[] _interactionDomain;
    private transient Map<Long, Integer> _interactionValueToCategoricalValue;

    public CreateInteractionTask(InteractionsEncoder encoder, String[] interactionDomain) {
        this._encoder = encoder;
        this._interactionDomain = interactionDomain == null ? null : Arrays.stream(interactionDomain).mapToLong(Long::parseLong).toArray();
    }

    @Override
    protected void setupLocal() {
        if (this._interactionDomain != null) {
            this._interactionValueToCategoricalValue = new HashMap<Long, Integer>();
            for (int i2 = 0; i2 < this._interactionDomain.length; ++i2) {
                this._interactionValueToCategoricalValue.put(this._interactionDomain[i2], i2);
            }
        }
    }

    @Override
    public void map(Chunk[] cs, NewChunk nc) {
        for (int row = 0; row < cs[0].len(); ++row) {
            int[] interactingValues = new int[cs.length];
            for (int i2 = 0; i2 < cs.length; ++i2) {
                interactingValues[i2] = cs[i2].isNA(row) ? -1 : (int)cs[i2].at8(row);
            }
            long val = this._encoder.encode(interactingValues);
            if (val < 0L) {
                nc.addNA();
                continue;
            }
            if (this._interactionDomain == null) {
                nc.addNum(val);
                continue;
            }
            int catVal = this._interactionValueToCategoricalValue.getOrDefault(val, -1);
            if (catVal < 0) {
                nc.addNA();
                continue;
            }
            nc.addCategorical(catVal);
        }
    }
}

