/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.ColumnsMapping;
import ai.h2o.targetencoding.ColumnsToSingleMapping;
import ai.h2o.targetencoding.TargetEncoderHelper;
import ai.h2o.targetencoding.TargetEncoderModel;
import hex.ModelMojoWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.IcedHashMap;

public class TargetEncoderMojoWriter
extends ModelMojoWriter<TargetEncoderModel, TargetEncoderModel.TargetEncoderParameters, TargetEncoderModel.TargetEncoderOutput> {
    public TargetEncoderMojoWriter() {
    }

    public TargetEncoderMojoWriter(TargetEncoderModel model) {
        super(model);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected void writeModelData() throws IOException {
        this.writeTargetEncodingInfo();
        this.writeTargetEncodingMap();
    }

    private void writeTargetEncodingInfo() throws IOException {
        TargetEncoderModel.TargetEncoderOutput output = (TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output;
        TargetEncoderModel.TargetEncoderParameters teParams = output._parms;
        this.writekv("keep_original_categorical_columns", teParams._keep_original_categorical_columns);
        this.writekv("with_blending", teParams._blending);
        if (teParams._blending) {
            this.writekv("inflection_point", teParams._inflection_point);
            this.writekv("smoothing", teParams._smoothing);
        }
        List nonPredictors = Arrays.stream(new String[]{((TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output).weightsName(), ((TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output).offsetName(), ((TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output).foldName(), ((TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output).responseName()}).filter(Objects::nonNull).collect(Collectors.toList());
        this.writekv("non_predictors", String.join((CharSequence)";", nonPredictors));
        this.writeColumnsHasNAs(output._te_column_to_hasNAs, "feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini");
        this.writeColumnsMapping(output._input_to_encoding_column, "feature_engineering/target_encoding/input_encoding_columns_map.ini");
        this.writeColumnsMapping(output._input_to_output_columns, "feature_engineering/target_encoding/input_output_columns_map.ini");
    }

    private void writeTargetEncodingMap() throws IOException {
        TargetEncoderModel.TargetEncoderOutput targetEncoderOutput = (TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output;
        int nclasses = ((TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output)._nclasses;
        IcedHashMap<String, Frame> targetEncodingMap = targetEncoderOutput._target_encoding_map;
        this.groupEncodingsByFoldColumnIfNeeded(targetEncoderOutput, targetEncodingMap);
        this.startWritingTextFile("feature_engineering/target_encoding/encoding_map.ini");
        for (Map.Entry encodingsEntry : targetEncodingMap.entrySet()) {
            String column = (String)encodingsEntry.getKey();
            Frame encodings = (Frame)encodingsEntry.getValue();
            Vec.Reader catRead = new Vec.Reader(encodings.vec(0));
            Vec.Reader numRead = new Vec.Reader(encodings.vec("numerator"));
            Vec.Reader denRead = new Vec.Reader(encodings.vec("denominator"));
            Vec.Reader tcRead = nclasses > 2 ? new Vec.Reader(encodings.vec("targetclass")) : null;
            this.writeln("[" + column + "]");
            int i2 = 0;
            while ((long)i2 < catRead.length()) {
                CharSequence[] charSequenceArray;
                String category = Long.toString(catRead.at8(i2));
                if (tcRead == null) {
                    CharSequence[] charSequenceArray2 = new String[2];
                    charSequenceArray2[0] = Double.toString(numRead.at(i2));
                    charSequenceArray = charSequenceArray2;
                    charSequenceArray2[1] = Double.toString(denRead.at(i2));
                } else {
                    String[] stringArray = new String[3];
                    stringArray[0] = Double.toString(numRead.at(i2));
                    stringArray[1] = Double.toString(denRead.at(i2));
                    charSequenceArray = stringArray;
                    stringArray[2] = Long.toString(tcRead.at8(i2));
                }
                CharSequence[] components = charSequenceArray;
                this.writelnkv(category, String.join((CharSequence)" ", components));
                ++i2;
            }
        }
        this.finishWritingTextFile();
    }

    private void groupEncodingsByFoldColumnIfNeeded(TargetEncoderModel.TargetEncoderOutput targetEncoderOutput, Map<String, Frame> targetEncodingMap) {
        String foldColumn = targetEncoderOutput._parms._fold_column;
        if (foldColumn != null) {
            try {
                for (Map.Entry<String, Frame> encodingMapEntry : targetEncodingMap.entrySet()) {
                    String teColumn = encodingMapEntry.getKey();
                    Frame encodingsWithFolds = encodingMapEntry.getValue();
                    Frame encodingsWithoutFolds = TargetEncoderHelper.groupEncodingsByCategory(encodingsWithFolds, encodingsWithFolds.find(teColumn), true);
                    targetEncodingMap.put(teColumn, encodingsWithoutFolds);
                    encodingsWithFolds.delete();
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to group encoding maps by fold column", ex);
            }
        }
    }

    private void writeColumnsHasNAs(IcedHashMap<String, Boolean> col2HasNAs, String fileName) throws IOException {
        this.startWritingTextFile(fileName);
        for (Map.Entry entry : col2HasNAs.entrySet()) {
            this.writelnkv((String)entry.getKey(), (Boolean)entry.getValue() != false ? "1" : "0");
        }
        this.finishWritingTextFile();
    }

    private void writeColumnsMapping(ColumnsMapping[] mapping, String fileName) throws IOException {
        this.startWritingTextFile(fileName);
        for (ColumnsMapping entry : mapping) {
            this.writeln("[from]");
            for (String s2 : entry.from()) {
                this.writeln(s2);
            }
            this.writeln("[to]");
            for (String s2 : entry.to()) {
                this.writeln(s2);
            }
            if (!(entry instanceof ColumnsToSingleMapping) || entry.from().length <= 1) continue;
            this.writeln("[to_domain]");
            for (String s2 : ((ColumnsToSingleMapping)entry).toDomain()) {
                this.writeln(s2);
            }
        }
        this.finishWritingTextFile();
    }
}

