/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting binomial classification.")
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0013'\u0001EB\u0001B\u000e\u0001\u0003\u0006\u0004%\te\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005q!)a\t\u0001C\u0001\u000f\")a\t\u0001C\u0001\u0015\"91\n\u0001b\u0001\n#a\u0005B\u0002.\u0001A\u0003%Q\nC\u0004\\\u0001\t\u0007I\u0011\u0003'\t\rq\u0003\u0001\u0015!\u0003N\u0011\u001di\u0006A1A\u0005\u00121CaA\u0018\u0001!\u0002\u0013i\u0005bB0\u0001\u0005\u0004%\t\u0002\u0014\u0005\u0007A\u0002\u0001\u000b\u0011B'\t\u000f\u0005\u0004!\u0019!C\t\u0019\"1!\r\u0001Q\u0001\n5Cqa\u0019\u0001C\u0002\u0013EA\n\u0003\u0004e\u0001\u0001\u0006I!\u0014\u0005\bK\u0002\u0011\r\u0011\"\u0005g\u0011\u0019i\u0007\u0001)A\u0005O\"9a\u000e\u0001b\u0001\n#1\u0007BB8\u0001A\u0003%q\rC\u0004q\u0001\t\u0007I\u0011\u00034\t\rE\u0004\u0001\u0015!\u0003h\u0011\u001d\u0011\bA1A\u0005\u0012\u0019Daa\u001d\u0001!\u0002\u00139\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002>\u0001\t\u0003)\b\"B>\u0001\t\u0003)\b\"\u0002?\u0001\t\u0003)\b\"B?\u0001\t\u0003)\b\"\u0002@\u0001\t\u0003)\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002&\u0001!\t!!\u0001\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002\u0002!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005\u0005\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003#\u0002A\u0011IA*\u0005IA%g\u0014\"j]>l\u0017.\u00197NKR\u0014\u0018nY:\u000b\u0005\u001dB\u0013aB7fiJL7m\u001d\u0006\u0003S)\n!!\u001c7\u000b\u0005-b\u0013!C:qCJ\\G.\u001b8h\u0015\tic&A\u0002ie=T\u0011aL\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002M%\u0011QG\n\u0002\u0011\u0011Jz5i\\7n_:lU\r\u001e:jGN\f1!^5e+\u0005A\u0004CA\u001dC\u001d\tQ\u0004\t\u0005\u0002<}5\tAH\u0003\u0002>a\u00051AH]8pizR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011IP\u0001\u0005k&$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0011&\u0003\"a\r\u0001\t\u000bY\u001a\u0001\u0019\u0001\u001d\u0015\u0003!\u000b!A\u001d\u001a\u0016\u00035\u0003\"A\u0014-\u000e\u0003=S!\u0001U)\u0002\u000bA\f'/Y7\u000b\u0005%\u0012&BA*U\u0003\u0015\u0019\b/\u0019:l\u0015\t)f+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0006\u0019qN]4\n\u0005e{%a\u0003#pk\ndW\rU1sC6\f1A\u001d\u001a!\u0003\u001dawn\u001a7pgN\f\u0001\u0002\\8hY>\u001c8\u000fI\u0001\u0004CV\u001c\u0017\u0001B1vG\u0002\nQ\u0001\u001d:bk\u000e\fa\u0001\u001d:bk\u000e\u0004\u0013\u0001B4j]&\fQaZ5oS\u0002\n\u0011#\\3b]B+'o\u00117bgN,%O]8s\u0003IiW-\u00198QKJ\u001cE.Y:t\u000bJ\u0014xN\u001d\u0011\u0002\u001f\r|gNZ;tS>tW*\u0019;sSb,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\"\na\u0001]1sC6\u001c\u0018B\u00017j\u0005YqU\u000f\u001c7bE2,G)\u0019;b\rJ\fW.\u001a)be\u0006l\u0017\u0001E2p]\u001a,8/[8o\u001b\u0006$(/\u001b=!\u0003e!\bN]3tQ>dGm]!oI6+GO]5d'\u000e|'/Z:\u00025QD'/Z:i_2$7/\u00118e\u001b\u0016$(/[2TG>\u0014Xm\u001d\u0011\u000255\f\u0007p\u0011:ji\u0016\u0014\u0018.Y!oI6+GO]5d'\u000e|'/Z:\u000275\f\u0007p\u0011:ji\u0016\u0014\u0018.Y!oI6+GO]5d'\u000e|'/Z:!\u000399\u0017-\u001b8t\u0019&4G\u000fV1cY\u0016\fqbZ1j]Nd\u0015N\u001a;UC\ndW\rI\u0001\u0006O\u0016$(K\r\u000b\u0002mB\u0011q\u000f_\u0007\u0002}%\u0011\u0011P\u0010\u0002\u0007\t>,(\r\\3\u0002\u0015\u001d,G\u000fT8hY>\u001c8/\u0001\u0004hKR\fUkQ\u0001\tO\u0016$\bKU!V\u0007\u00069q-\u001a;HS:L\u0017\u0001F4fi6+\u0017M\u001c)fe\u000ec\u0017m]:FeJ|'/\u0001\nhKR\u001cuN\u001c4vg&|g.T1ue&DHCAA\u0002!\u0011\t)!a\b\u000f\t\u0005\u001d\u0011\u0011\u0004\b\u0005\u0003\u0013\t)B\u0004\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003#q1aOA\b\u0013\u00059\u0016BA+W\u0013\t\u0019F+C\u0002\u0002\u0018I\u000b1a]9m\u0013\u0011\tY\"!\b\u0002\u000fA\f7m[1hK*\u0019\u0011q\u0003*\n\t\u0005\u0005\u00121\u0005\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a\u0007\u0002\u001e\u0005ar-\u001a;UQJ,7\u000f[8mIN\fe\u000eZ'fiJL7mU2pe\u0016\u001c\u0018!H4fi6\u000b\u0007p\u0011:ji\u0016\u0014\u0018.Y!oI6+GO]5d'\u000e|'/Z:\u0002#\u001d,GoR1j]Nd\u0015N\u001a;UC\ndW-\u0001\u0006tKRlU\r\u001e:jGN$b!a\f\u00026\u00055\u0003cA<\u00022%\u0019\u00111\u0007 \u0003\tUs\u0017\u000e\u001e\u0005\b\u0003o\u0019\u0003\u0019AA\u001d\u0003\u0011Q7o\u001c8\u0011\t\u0005m\u0012\u0011J\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!qm]8o\u0015\u0011\t\u0019%!\u0012\u0002\r\u001d|wn\u001a7f\u0015\t\t9%A\u0002d_6LA!a\u0013\u0002>\tQ!j]8o\u001f\nTWm\u0019;\t\r\u0005=3\u00051\u00019\u0003\u001d\u0019wN\u001c;fqR\fAaY8qsR!\u0011QKA,\u001b\u0005\u0001\u0001bBA-I\u0001\u0007\u00111L\u0001\u0006Kb$(/\u0019\t\u0004\u001d\u0006u\u0013bAA0\u001f\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0004\u0001\u0003G\nI'a\u001b\u0011\u0007M\n)'C\u0002\u0002h\u0019\u0012!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\t\ti'A6UQ\u0016\u00043\r\\1tg\u0002j\u0017m[3tA\u00054\u0018-\u001b7bE2,\u0007%\u00197mA5,GO]5dg\u0002\"\b.\u0019;!g\"\f'/\u001a3!C\u000e\u0014xn]:!C2d\u0007%\u00197h_JLG\u000f[7tAM,\b\u000f]8si&tw\r\t2j]>l\u0017.\u00197!G2\f7o]5gS\u000e\fG/[8o]\u0001")
public class H2OBinomialMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final DoubleParam logloss;
    private final DoubleParam auc;
    private final DoubleParam prauc;
    private final DoubleParam gini;
    private final DoubleParam meanPerClassError;
    private final NullableDataFrameParam confusionMatrix;
    private final NullableDataFrameParam thresholdsAndMetricScores;
    private final NullableDataFrameParam maxCriteriaAndMetricScores;
    private final NullableDataFrameParam gainsLiftTable;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam auc() {
        return this.auc;
    }

    public DoubleParam prauc() {
        return this.prauc;
    }

    public DoubleParam gini() {
        return this.gini;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public NullableDataFrameParam thresholdsAndMetricScores() {
        return this.thresholdsAndMetricScores;
    }

    public NullableDataFrameParam maxCriteriaAndMetricScores() {
        return this.maxCriteriaAndMetricScores;
    }

    public NullableDataFrameParam gainsLiftTable() {
        return this.gainsLiftTable;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.auc()));
    }

    public double getPRAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.prauc()));
    }

    public double getGini() {
        return BoxesRunTime.unboxToDouble(this.$(this.gini()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    public Dataset<Row> getConfusionMatrix() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.confusionMatrix()));
    }

    public Dataset<Row> getThresholdsAndMetricScores() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.thresholdsAndMetricScores()));
    }

    public Dataset<Row> getMaxCriteriaAndMetricScores() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.maxCriteriaAndMetricScores()));
    }

    public Dataset<Row> getGainsLiftTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.gainsLiftTable()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block97: {
            Params params;
            block94: {
                block93: {
                    Params params2;
                    block90: {
                        block89: {
                            Params params3;
                            block86: {
                                block85: {
                                    Params params4;
                                    block82: {
                                        block81: {
                                            Params params5;
                                            block78: {
                                                block77: {
                                                    Params params6;
                                                    block74: {
                                                        block73: {
                                                            Params params7;
                                                            block70: {
                                                                block69: {
                                                                    Params params8;
                                                                    block66: {
                                                                        block65: {
                                                                            Params params9;
                                                                            block62: {
                                                                                super.setMetrics(json, context);
                                                                                if (!json.has("r2")) break block62;
                                                                                try {
                                                                                    params9 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    Throwable throwable2;
                                                                                    block64: {
                                                                                        block63: {
                                                                                            Throwable throwable3 = throwable;
                                                                                            if (throwable3 == null) break block63;
                                                                                            throwable2 = throwable3;
                                                                                            String string = System.getProperty("spark.testing", "false");
                                                                                            String string2 = "true";
                                                                                            if (string == null ? string2 != null : !string.equals(string2)) break block64;
                                                                                        }
                                                                                        throw throwable;
                                                                                    }
                                                                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'r2' from ").append(context).toString(), throwable2);
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    params9 = boxedUnit;
                                                                                }
                                                                                break block65;
                                                                            }
                                                                            String message = new StringBuilder(35).append("The metric 'r2' in ").append(context).append(" does not exist.").toString();
                                                                            String string = System.getProperty("spark.testing", "false");
                                                                            String string3 = "true";
                                                                            if (!(string == null ? string3 != null : !string.equals(string3))) {
                                                                                throw new AssertionError((Object)message);
                                                                            }
                                                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                                            params9 = BoxedUnit.UNIT;
                                                                        }
                                                                        if (!json.has("logloss")) break block66;
                                                                        try {
                                                                            params8 = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Throwable throwable4;
                                                                            block68: {
                                                                                block67: {
                                                                                    Throwable throwable5 = throwable;
                                                                                    if (throwable5 == null) break block67;
                                                                                    throwable4 = throwable5;
                                                                                    String string = System.getProperty("spark.testing", "false");
                                                                                    String string4 = "true";
                                                                                    if (string == null ? string4 != null : !string.equals(string4)) break block68;
                                                                                }
                                                                                throw throwable;
                                                                            }
                                                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unsuccessful try to extract 'logloss' from ").append(context).toString(), throwable4);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            params8 = boxedUnit;
                                                                        }
                                                                        break block69;
                                                                    }
                                                                    String message = new StringBuilder(40).append("The metric 'logloss' in ").append(context).append(" does not exist.").toString();
                                                                    String string = System.getProperty("spark.testing", "false");
                                                                    String string5 = "true";
                                                                    if (!(string == null ? string5 != null : !string.equals(string5))) {
                                                                        throw new AssertionError((Object)message);
                                                                    }
                                                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                                    params8 = BoxedUnit.UNIT;
                                                                }
                                                                if (!json.has("AUC")) break block70;
                                                                try {
                                                                    params7 = this.set("auc", BoxesRunTime.boxToDouble((double)json.get("AUC").getAsDouble()));
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Throwable throwable6;
                                                                    block72: {
                                                                        block71: {
                                                                            Throwable throwable7 = throwable;
                                                                            if (throwable7 == null) break block71;
                                                                            throwable6 = throwable7;
                                                                            String string = System.getProperty("spark.testing", "false");
                                                                            String string6 = "true";
                                                                            if (string == null ? string6 != null : !string.equals(string6)) break block72;
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Unsuccessful try to extract 'AUC' from ").append(context).toString(), throwable6);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    params7 = boxedUnit;
                                                                }
                                                                break block73;
                                                            }
                                                            String message = new StringBuilder(36).append("The metric 'AUC' in ").append(context).append(" does not exist.").toString();
                                                            String string = System.getProperty("spark.testing", "false");
                                                            String string7 = "true";
                                                            if (!(string == null ? string7 != null : !string.equals(string7))) {
                                                                throw new AssertionError((Object)message);
                                                            }
                                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                            params7 = BoxedUnit.UNIT;
                                                        }
                                                        if (!json.has("pr_auc")) break block74;
                                                        try {
                                                            params6 = this.set("prauc", BoxesRunTime.boxToDouble((double)json.get("pr_auc").getAsDouble()));
                                                        }
                                                        catch (Throwable throwable) {
                                                            Throwable throwable8;
                                                            block76: {
                                                                block75: {
                                                                    Throwable throwable9 = throwable;
                                                                    if (throwable9 == null) break block75;
                                                                    throwable8 = throwable9;
                                                                    String string = System.getProperty("spark.testing", "false");
                                                                    String string8 = "true";
                                                                    if (string == null ? string8 != null : !string.equals(string8)) break block76;
                                                                }
                                                                throw throwable;
                                                            }
                                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Unsuccessful try to extract 'pr_auc' from ").append(context).toString(), throwable8);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            params6 = boxedUnit;
                                                        }
                                                        break block77;
                                                    }
                                                    String message = new StringBuilder(39).append("The metric 'pr_auc' in ").append(context).append(" does not exist.").toString();
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string9 = "true";
                                                    if (!(string == null ? string9 != null : !string.equals(string9))) {
                                                        throw new AssertionError((Object)message);
                                                    }
                                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                    params6 = BoxedUnit.UNIT;
                                                }
                                                if (!json.has("Gini")) break block78;
                                                try {
                                                    params5 = this.set("gini", BoxesRunTime.boxToDouble((double)json.get("Gini").getAsDouble()));
                                                }
                                                catch (Throwable throwable) {
                                                    Throwable throwable10;
                                                    block80: {
                                                        block79: {
                                                            Throwable throwable11 = throwable;
                                                            if (throwable11 == null) break block79;
                                                            throwable10 = throwable11;
                                                            String string = System.getProperty("spark.testing", "false");
                                                            String string10 = "true";
                                                            if (string == null ? string10 != null : !string.equals(string10)) break block80;
                                                        }
                                                        throw throwable;
                                                    }
                                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Unsuccessful try to extract 'Gini' from ").append(context).toString(), throwable10);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    params5 = boxedUnit;
                                                }
                                                break block81;
                                            }
                                            String message = new StringBuilder(37).append("The metric 'Gini' in ").append(context).append(" does not exist.").toString();
                                            String string = System.getProperty("spark.testing", "false");
                                            String string11 = "true";
                                            if (!(string == null ? string11 != null : !string.equals(string11))) {
                                                throw new AssertionError((Object)message);
                                            }
                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                            params5 = BoxedUnit.UNIT;
                                        }
                                        if (!json.has("mean_per_class_error")) break block82;
                                        try {
                                            params4 = this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable12;
                                            block84: {
                                                block83: {
                                                    Throwable throwable13 = throwable;
                                                    if (throwable13 == null) break block83;
                                                    throwable12 = throwable13;
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string12 = "true";
                                                    if (string == null ? string12 != null : !string.equals(string12)) break block84;
                                                }
                                                throw throwable;
                                            }
                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Unsuccessful try to extract 'mean_per_class_error' from ").append(context).toString(), throwable12);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            params4 = boxedUnit;
                                        }
                                        break block85;
                                    }
                                    String message = new StringBuilder(53).append("The metric 'mean_per_class_error' in ").append(context).append(" does not exist.").toString();
                                    String string = System.getProperty("spark.testing", "false");
                                    String string13 = "true";
                                    if (!(string == null ? string13 != null : !string.equals(string13))) {
                                        throw new AssertionError((Object)message);
                                    }
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                    params4 = BoxedUnit.UNIT;
                                }
                                if (!json.has("cm")) break block86;
                                try {
                                    params3 = this.set("confusionMatrix", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.nestedJsonFieldToDataFrame(json, "cm", "table")));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable14;
                                    block88: {
                                        block87: {
                                            Throwable throwable15 = throwable;
                                            if (throwable15 == null) break block87;
                                            throwable14 = throwable15;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string14 = "true";
                                            if (string == null ? string14 != null : !string.equals(string14)) break block88;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'cm' from ").append(context).toString(), throwable14);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block89;
                            }
                            String message = new StringBuilder(35).append("The metric 'cm' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string15 = "true";
                            if (!(string == null ? string15 != null : !string.equals(string15))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("thresholds_and_metric_scores")) break block90;
                        try {
                            params2 = this.set("thresholdsAndMetricScores", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "thresholds_and_metric_scores")));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable16;
                            block92: {
                                block91: {
                                    Throwable throwable17 = throwable;
                                    if (throwable17 == null) break block91;
                                    throwable16 = throwable17;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string16 = "true";
                                    if (string == null ? string16 != null : !string.equals(string16)) break block92;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Unsuccessful try to extract 'thresholds_and_metric_scores' from ").append(context).toString(), throwable16);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block93;
                    }
                    String message = new StringBuilder(61).append("The metric 'thresholds_and_metric_scores' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string17 = "true";
                    if (!(string == null ? string17 != null : !string.equals(string17))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("max_criteria_and_metric_scores")) break block94;
                try {
                    params = this.set("maxCriteriaAndMetricScores", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "max_criteria_and_metric_scores")));
                }
                catch (Throwable throwable) {
                    Throwable throwable18;
                    block96: {
                        block95: {
                            Throwable throwable19 = throwable;
                            if (throwable19 == null) break block95;
                            throwable18 = throwable19;
                            String string = System.getProperty("spark.testing", "false");
                            String string18 = "true";
                            if (string == null ? string18 != null : !string.equals(string18)) break block96;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Unsuccessful try to extract 'max_criteria_and_metric_scores' from ").append(context).toString(), throwable18);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block97;
            }
            String message = new StringBuilder(63).append("The metric 'max_criteria_and_metric_scores' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string19 = "true";
            if (!(string == null ? string19 != null : !string.equals(string19))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("gains_lift_table")) {
            try {
                this.set("gainsLiftTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "gains_lift_table")));
            }
            catch (Throwable throwable) {
                Throwable throwable20 = throwable;
                if (throwable20 != null) {
                    Throwable throwable21 = throwable20;
                    String string = System.getProperty("spark.testing", "false");
                    String string20 = "true";
                    if (string == null ? string20 != null : !string.equals(string20)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Unsuccessful try to extract 'gains_lift_table' from ").append(context).toString(), throwable21);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(49).append("The metric 'gains_lift_table' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string21 = "true";
            if (string == null ? string21 != null : !string.equals(string21)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OBinomialMetrics copy(ParamMap extra) {
        return (H2OBinomialMetrics)this.defaultCopy(extra);
    }

    public H2OBinomialMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.auc = this.doubleParam("auc", "The AUC for this scoring run.");
        this.prauc = this.doubleParam("prauc", "The precision-recall AUC for this scoring run.");
        this.gini = this.doubleParam("gini", "The Gini score for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix at the threshold for maximum F1.");
        this.thresholdsAndMetricScores = this.nullableDataFrameParam("thresholdsAndMetricScores", "The Metrics for various thresholds.");
        this.maxCriteriaAndMetricScores = this.nullableDataFrameParam("maxCriteriaAndMetricScores", "The Metrics for various criteria.");
        this.gainsLiftTable = this.nullableDataFrameParam("gainsLiftTable", "Gains and Lift table.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.auc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.prauc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.gini().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.thresholdsAndMetricScores().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxCriteriaAndMetricScores().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.gainsLiftTable().$minus$greater(null)}));
    }

    public H2OBinomialMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OBinomialMetrics"));
    }
}

