/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.rest.api;

import ai.h2o.sparkling.extensions.internals.CollectCategoricalDomainsTask;
import ai.h2o.sparkling.extensions.internals.ConvertCategoricalToStringColumnsTask;
import ai.h2o.sparkling.extensions.internals.UpdateCategoricalIndicesTask;
import ai.h2o.sparkling.extensions.rest.api.schema.FinalizeFrameV3;
import ai.h2o.sparkling.extensions.rest.api.schema.InitializeFrameV3;
import ai.h2o.sparkling.extensions.rest.api.schema.UploadPlanV3;
import ai.h2o.sparkling.utils.Base64Encoding$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import water.DKV;
import water.H2ONode;
import water.Key;
import water.api.Handler;
import water.fvec.AppendableVec;
import water.fvec.ChunkUtils;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.CategoricalPreviewParseWriter;
import water.parser.ParseDataset;
import water.util.Log;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0003\u0006\u0001/!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)Q\u0007\u0001C\u0001m!)A\b\u0001C\u0005{!)\u0001\r\u0001C\u0005C\")a\r\u0001C\u0005O\")!\u000e\u0001C\u0005W\")a\u000e\u0001C\u0001_\n\u0011\u0012*\u001c9peR4%/Y7f\u0011\u0006tG\r\\3s\u0015\tYA\"A\u0002ba&T!!\u0004\b\u0002\tI,7\u000f\u001e\u0006\u0003\u001fA\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\t\t\"#A\u0005ta\u0006\u00148\u000e\\5oO*\u00111\u0003F\u0001\u0004QJz'\"A\u000b\u0002\u0005\u0005L7\u0001A\n\u0003\u0001a\u0001\"!G\u000f\u000e\u0003iQ!aC\u000e\u000b\u0003q\tQa^1uKJL!A\b\u000e\u0003\u000f!\u000bg\u000e\u001a7fe\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011AC\u0001\u000bS:LG/[1mSj,GcA\u0013,gA\u0011a%K\u0007\u0002O)\u0011\u0001FC\u0001\u0007g\u000eDW-\\1\n\u0005):#!E%oSRL\u0017\r\\5{K\u001a\u0013\u0018-\\3Wg!)AF\u0001a\u0001[\u00059a/\u001a:tS>t\u0007C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#aA%oi\")AG\u0001a\u0001K\u00059!/Z9vKN$\u0018\u0001\u00034j]\u0006d\u0017N_3\u0015\u0007]R4\b\u0005\u0002'q%\u0011\u0011h\n\u0002\u0010\r&t\u0017\r\\5{K\u001a\u0013\u0018-\\3Wg!)Af\u0001a\u0001[!)Ag\u0001a\u0001o\u0005I4m\u001c8wKJ$8i\u001c7v[:\u001cx+\u001b;i)>|W*\u00198z\u0007\u0006$XmZ8sS\u000e\fG\u000eT3wK2\u001cHk\\*ue&twmQ8mk6t7\u000f\u0006\u0003?\u0003&\u000b\u0006C\u0001\u0018@\u0013\t\u0001uF\u0001\u0003V]&$\b\"\u0002\"\u0005\u0001\u0004\u0019\u0015!\u00024sC6,\u0007C\u0001#H\u001b\u0005)%B\u0001$\u001c\u0003\u00111g/Z2\n\u0005!+%!\u0002$sC6,\u0007\"\u0002&\u0005\u0001\u0004Y\u0015aC2pYVlg\u000eV=qKN\u00042A\f'O\u0013\tiuFA\u0003BeJ\f\u0017\u0010\u0005\u0002/\u001f&\u0011\u0001k\f\u0002\u0005\u0005f$X\rC\u0003S\t\u0001\u00071+A\u0007tiJLgn\u001a#p[\u0006Lgn\u001d\t\u0004]1#\u0006c\u0001\u0018M+B\u0011a+\u0018\b\u0003/n\u0003\"\u0001W\u0018\u000e\u0003eS!A\u0017\f\u0002\rq\u0012xn\u001c;?\u0013\tav&\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/0\u00035\u001awN\u001c<feR\u001c\u0015\r^3h_JL7-\u00197D_2,XN\\:U_>#\b.\u001a:UsB,7/\u00134OK\u0016$W\r\u001a\u000b\u0004}\t\u001c\u0007\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"\u00023\u0006\u0001\u0004)\u0017\u0001G2bi\u0016<wN]5dC2\u001cu\u000e\\;n]&sG-[2fgB\u0019a\u0006T\u0017\u0002]%tG-[2fg>37\t[1oO\u0016$7i\u001c7v[:\u001chI]8n\u0007\u0006$XmZ8sS\u000e\fG\u000eV8TiJLgn\u001a\u000b\u0004K\"L\u0007\"\u0002&\u0007\u0001\u0004Y\u0005\"\u0002*\u0007\u0001\u0004\u0019\u0016!D3ya\u0006tG\rR8nC&t7\u000fF\u0002TY6DQAU\u0004A\u0002MCQAS\u0004A\u0002-\u000bQbZ3u+Bdw.\u00193QY\u0006tGc\u00019tiB\u0011a%]\u0005\u0003e\u001e\u0012A\"\u00169m_\u0006$\u0007\u000b\\1o-NBQ\u0001\f\u0005A\u00025BQ\u0001\u000e\u0005A\u0002A\u0004")
public class ImportFrameHandler
extends Handler {
    public InitializeFrameV3 initialize(int version, InitializeFrameV3 request) {
        ChunkUtils.initFrame(request.key, request.columns);
        return request;
    }

    public FinalizeFrameV3 finalize(int version, FinalizeFrameV3 request) {
        long[] rowsPerChunk = Base64Encoding$.MODULE$.decodeToLongArray(request.rows_per_chunk);
        byte[] columnTypes = Base64Encoding$.MODULE$.decode(request.column_types);
        Key frameKey = Key.make(request.key);
        CollectCategoricalDomainsTask collectDomainsTask = new CollectCategoricalDomainsTask(frameKey);
        collectDomainsTask.doAllNodes();
        String[][] stringDomains = collectDomainsTask.getDomains();
        boolean isEmpty = stringDomains == null;
        byte[] columnTypesAwareOfEmptyFrames = isEmpty ? (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(columnTypes)).map((Function1 & Serializable & scala.Serializable)columnType -> BoxesRunTime.boxToByte((byte)ImportFrameHandler.$anonfun$finalize$1(BoxesRunTime.unboxToByte((Object)columnType))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())) : columnTypes;
        String[][] domains = this.expandDomains(stringDomains, columnTypesAwareOfEmptyFrames);
        ChunkUtils.finalizeFrame(request.key, rowsPerChunk, columnTypesAwareOfEmptyFrames, domains, false);
        Frame frame = (Frame)DKV.getGet(frameKey);
        this.convertColumnsWithTooManyCategoricalLevelsToStringColumns(frame, columnTypesAwareOfEmptyFrames, stringDomains);
        int[] categoricalColumnIndices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.vecs())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ImportFrameHandler.$anonfun$finalize$2(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ImportFrameHandler.$anonfun$finalize$3(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ImportFrameHandler.$anonfun$finalize$4(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        UpdateCategoricalIndicesTask updateCategoricalIndicesTask = new UpdateCategoricalIndicesTask(frameKey, categoricalColumnIndices);
        updateCategoricalIndicesTask.doAll(frame);
        this.convertCategoricalColumnsToOtherTypesIfNeeded(frame, categoricalColumnIndices);
        if (frame.numCols() > 0) {
            ParseDataset.logParseResults(frame);
        }
        frame.update();
        frame.unlock();
        return request;
    }

    private void convertColumnsWithTooManyCategoricalLevelsToStringColumns(Frame frame, byte[] columnTypes, String[][] stringDomains) {
        block0: {
            int[] indicesOfChanges = this.indicesOfChangedColumnsFromCategoricalToString(columnTypes, stringDomains);
            if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indicesOfChanges)).nonEmpty()) break block0;
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indicesOfChanges)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Log.info(new StringBuilder(103).append("A categorical column '").append(frame.names()[idx]).append("' exceeded maximum number of categories. ").append("Converting it to a column of strings ...").toString()));
            Vec[] vectorsToBeConvertedToString = (Vec[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indicesOfChanges)).map((Function1 & Serializable & scala.Serializable)x$3 -> frame.vec(BoxesRunTime.unboxToInt((Object)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vec.class)));
            int[] domainIndices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringDomains)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$3(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$4(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$5(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            ConvertCategoricalToStringColumnsTask convertCategoricalToStringColumnsTask = new ConvertCategoricalToStringColumnsTask(frame._key, domainIndices);
            byte[] outputTypes = (byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])vectorsToBeConvertedToString)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToByte((byte)ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$6(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            convertCategoricalToStringColumnsTask.doAll(outputTypes, vectorsToBeConvertedToString);
            Vec[] newVectors = AppendableVec.closeAll(convertCategoricalToStringColumnsTask.appendables());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newVectors)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(indicesOfChanges), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$7(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                ImportFrameHandler.$anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$8(frame, x$7);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void convertCategoricalColumnsToOtherTypesIfNeeded(Frame frame, int[] categoricalColumnIndices) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(categoricalColumnIndices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            byte correctType;
            Vec vector = frame.vec(idx);
            byte by = correctType = CategoricalPreviewParseWriter.guessType(vector.domain(), (int)vector.length(), (int)vector.naCnt());
            switch (by) {
                case 4: {
                    break;
                }
                case 2: {
                    Log.info(new StringBuilder(55).append("The categorical column '").append(frame.names()[idx]).append("' has been converted to string.").toString());
                    Vec oldVector = frame.replace(idx, vector.toStringVec());
                    oldVector.remove();
                    break;
                }
                case 3: {
                    Log.info(new StringBuilder(56).append("The categorical column '").append(frame.names()[idx]).append("' has been converted to numeric.").toString());
                    Vec oldVector = frame.replace(idx, vector.toNumericVec());
                    oldVector.remove();
                    break;
                }
                default: {
                    Log.err(new StringBuilder(101).append("The categorical column '").append(frame.names()[idx]).append("' has been identified to be ").append("type of '").append(by).append("', but the conversion is not supported. ").toString());
                    break;
                }
            }
        });
    }

    private int[] indicesOfChangedColumnsFromCategoricalToString(byte[] columnTypes, String[][] stringDomains) {
        int strIdx = 0;
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int idx = 0; idx < columnTypes.length; ++idx) {
            if (columnTypes[idx] != 4) continue;
            if (stringDomains[strIdx] == null) {
                result.append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{idx}));
            }
            ++strIdx;
        }
        return (int[])result.toArray(ClassTag$.MODULE$.Int());
    }

    private String[][] expandDomains(String[][] stringDomains, byte[] columnTypes) {
        int strIdx = 0;
        String[][] result = (String[][])Array$.MODULE$.fill(columnTypes.length, (Function0 & Serializable & scala.Serializable)() -> null, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        for (int idx = 0; idx < columnTypes.length; ++idx) {
            if (columnTypes[idx] != 4) continue;
            result[idx] = stringDomains[strIdx];
            ++strIdx;
        }
        return result;
    }

    public UploadPlanV3 getUploadPlan(int version, UploadPlanV3 request) {
        Key<Vec> key = new Vec.VectorGroup().addVec();
        UploadPlanV3.ChunkAssigmentV3[] layout = (UploadPlanV3.ChunkAssigmentV3[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), request.number_of_chunks).map((Function1 & Serializable & scala.Serializable)chunkId -> ImportFrameHandler.$anonfun$getUploadPlan$1(key, BoxesRunTime.unboxToInt((Object)chunkId)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UploadPlanV3.ChunkAssigmentV3.class));
        request.layout = layout;
        return request;
    }

    public static final /* synthetic */ byte $anonfun$finalize$1(byte columnType) {
        return columnType == 4 ? (byte)2 : (byte)columnType;
    }

    public static final /* synthetic */ boolean $anonfun$finalize$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$finalize$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vec vec = (Vec)tuple2._1();
        boolean bl = vec.isCategorical();
        return bl;
    }

    public static final /* synthetic */ int $anonfun$finalize$4(Tuple2 x$2) {
        int idx;
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n2 = idx = tuple2._2$mcI$sp();
        return n2;
    }

    public static final /* synthetic */ boolean $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$4(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] domain = (String[])tuple2._1();
        boolean bl = domain == null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$5(Tuple2 x$5) {
        int idx;
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n2 = idx = tuple2._2$mcI$sp();
        return n2;
    }

    public static final /* synthetic */ byte $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$6(Vec x$6) {
        return 2;
    }

    public static final /* synthetic */ boolean $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$7(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$convertColumnsWithTooManyCategoricalLevelsToStringColumns$8(Frame frame$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vec newVector = (Vec)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Vec oldVector = frame$1.replace(index, newVector);
        oldVector.remove();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ UploadPlanV3.ChunkAssigmentV3 $anonfun$getUploadPlan$1(Key key$1, int chunkId) {
        H2ONode h2oNode = Vec.chunkKey(key$1, chunkId).home_node();
        return new UploadPlanV3.ChunkAssigmentV3(chunkId, h2oNode);
    }
}

