/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.internals;

import ai.h2o.sparkling.extensions.internals.LocalNodeDomains;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.parser.BufferedString;
import water.util.IcedHashMap;

public class UpdateCategoricalIndicesTask
extends MRTask<UpdateCategoricalIndicesTask> {
    private final Key frameKey;
    private final int[] categoricalColumns;

    public UpdateCategoricalIndicesTask(Key frameKey, int[] categoricalColumns) {
        this.frameKey = frameKey;
        this.categoricalColumns = categoricalColumns;
    }

    private static IcedHashMap<BufferedString, Integer> domainToCategoricalMap(String[] domain) {
        IcedHashMap<BufferedString, Integer> categoricalMap = new IcedHashMap<BufferedString, Integer>();
        for (int j2 = 0; j2 < domain.length; ++j2) {
            categoricalMap.put(new BufferedString(domain[j2]), j2);
        }
        return categoricalMap;
    }

    @Override
    public void map(Chunk[] chunks) {
        Frame frame = (Frame)DKV.getGet(this.frameKey);
        int chunkId = chunks[0].cidx();
        if (!LocalNodeDomains.containsDomains(this.frameKey, chunkId)) {
            throw new H2OIllegalArgumentException(String.format("No local domain found for the chunk '%d' on the node '%s'.", chunkId, H2O.SELF.getIpPortString()));
        }
        String[][] localDomains = LocalNodeDomains.getDomains(this.frameKey, chunkId);
        for (int catColIdx = 0; catColIdx < this.categoricalColumns.length; ++catColIdx) {
            int colId = this.categoricalColumns[catColIdx];
            Chunk chunk = chunks[colId];
            String[] localDomain = localDomains[catColIdx];
            IcedHashMap<BufferedString, Integer> categoricalMap = UpdateCategoricalIndicesTask.domainToCategoricalMap(frame.vec(colId).domain());
            if (chunk instanceof CStrChunk) continue;
            for (int valIdx = 0; valIdx < chunk._len; ++valIdx) {
                if (chunk.isNA(valIdx)) continue;
                int oldValue = (int)chunk.at8(valIdx);
                BufferedString category = new BufferedString(localDomain[oldValue]);
                int newValue = (Integer)categoricalMap.get(category);
                chunk.set(valIdx, newValue);
            }
            chunk.close(chunkId, this._fs);
        }
    }

    @Override
    public void closeLocal() {
        super.closeLocal();
        LocalNodeDomains.remove(this.frameKey);
    }
}

