/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.utils.ArgumentBuilder;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import water.H2O;
import water.H2OStarter;
import water.Paxos;
import water.fvec.Frame;
import water.init.HostnameGuesser;

public final class H2OClientUtils$
implements SharedBackendUtils {
    public static H2OClientUtils$ MODULE$;
    private final Tuple2<String, Object> PROP_REST_API_BASED_CLIENT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new H2OClientUtils$();
    }

    @Override
    public String getHostname(SparkEnv env) {
        return SharedBackendUtils.getHostname$(this, env);
    }

    @Override
    public H2OConf checkAndUpdateConf(H2OConf conf) {
        return SharedBackendUtils.checkAndUpdateConf$(this, conf);
    }

    @Override
    public void distributeFiles(H2OConf conf, SparkContext sc) {
        SharedBackendUtils.distributeFiles$(this, conf, sc);
    }

    @Override
    public Seq<String> getH2OSecurityArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OSecurityArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OCommonArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OCommonArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OWorkerAsClientArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OWorkerAsClientArgs$(this, conf);
    }

    @Override
    public Seq<String> parseStringToHttpHeaderArgs(String headers) {
        return SharedBackendUtils.parseStringToHttpHeaderArgs$(this, headers);
    }

    @Override
    public Seq<String> getExtraHttpHeaderArgs(H2OConf conf) {
        return SharedBackendUtils.getExtraHttpHeaderArgs$(this, conf);
    }

    @Override
    public String[] toH2OArgs(Seq<String> h2oArgs, NodeDesc[] executors) {
        return SharedBackendUtils.toH2OArgs$(this, h2oArgs, executors);
    }

    @Override
    public NodeDesc[] toH2OArgs$default$2() {
        return SharedBackendUtils.toH2OArgs$default$2$(this);
    }

    @Override
    public File createTempDir() {
        return SharedBackendUtils.createTempDir$(this);
    }

    @Override
    public File saveFlatFileAsFile(String content) {
        return SharedBackendUtils.saveFlatFileAsFile$(this, content);
    }

    @Override
    public String translateHostnameToIp(String hostname) {
        return SharedBackendUtils.translateHostnameToIp$(this, hostname);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Tuple2<String, Object> PROP_REST_API_BASED_CLIENT() {
        return this.PROP_REST_API_BASED_CLIENT;
    }

    public boolean isH2OClientBased(H2OConf conf) {
        return !conf.getBoolean((String)this.PROP_REST_API_BASED_CLIENT()._1(), this.PROP_REST_API_BASED_CLIENT()._2$mcZ$sp());
    }

    private Seq<String> getH2OClientArgs(H2OConf conf) {
        return new ArgumentBuilder().add(this.getH2OWorkerAsClientArgs(conf)).add("-network", conf.clientNetworkMask()).addIf("-ip", conf.clientIp(), conf.clientNetworkMask().isEmpty()).add("-client").buildArgs();
    }

    public Seq<String> getH2OCommonArgsWhenClientBased(H2OConf conf) {
        return new ArgumentBuilder().add("-allow_clients").add("-client_disconnect_timeout", conf.clientCheckRetryTimeout()).buildArgs();
    }

    public Seq<String> getExtraExternalBackendArgsWhenClientBased(H2OConf conf) {
        return new ArgumentBuilder().add("-sw_ext_backend").add((Seq<String>)((Seq)new .colon.colon((Object)"-J", (List)new .colon.colon((Object)"-client_disconnect_timeout", (List)new .colon.colon((Object)"-J", (List)new .colon.colon((Object)Integer.toString(conf.clientCheckRetryTimeout()), (List)Nil$.MODULE$)))))).buildArgs();
    }

    public NodeDesc startH2OClient(H2OContext hc, H2OConf conf, NodeDesc[] nodes) {
        Object object;
        if (conf.runsInExternalClusterMode()) {
            this.setClientIp(conf);
            object = BoxedUnit.UNIT;
        } else {
            object = conf.clientIp().isEmpty() ? conf.setClientIp(this.getHostname(SparkEnv$.MODULE$.get())) : BoxedUnit.UNIT;
        }
        if (!conf.runsInInternalClusterMode() || !hc.sparkContext().isLocal()) {
            int expectedSize;
            int discoveredSize;
            String[] args = (String[])this.getH2OClientArgs(conf).toArray(ClassTag$.MODULE$.apply(String.class));
            String[] launcherArgs = this.toH2OArgs((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), nodes);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Arguments used for launching the H2O client node: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])launcherArgs)).mkString(" ")).toString());
            H2OStarter.start(launcherArgs, true);
            if ((conf.runsInInternalClusterMode() || conf.isAutoClusterStartUsed()) && (discoveredSize = this.waitForCloudSize(expectedSize = nodes.length, conf.cloudTimeout())) < expectedSize) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Exiting! H2O cluster was of size ").append(discoveredSize).append(" but expected was ").append(expectedSize).append("!!").toString());
                hc.stop(true);
                throw new RuntimeException(new StringBuilder(18).append("Cloud size ").append(discoveredSize).append(" under ").append(expectedSize).toString());
            }
        }
        return new NodeDesc(SparkEnv$.MODULE$.get().executorId(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT);
    }

    private int waitForCloudSize(int expectedSize, long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutInMilliseconds) {
            if (H2O.CLOUD.size() >= expectedSize && Paxos._commonKnowledge) {
                return H2O.CLOUD.size();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return H2O.CLOUD.size();
    }

    private void setClientIp(H2OConf conf) {
        block0: {
            Option<String> clientIp = this.identifyClientIp((String)conf.h2oClusterHost().get());
            Object object = clientIp.isDefined() && conf.clientNetworkMask().isEmpty() ? conf.setClientIp((String)clientIp.get()) : BoxedUnit.UNIT;
            if (!conf.clientIp().isEmpty()) break block0;
            conf.setClientIp(this.getHostname(SparkEnv$.MODULE$.get()));
        }
    }

    private Option<String> identifyClientIp(String remoteAddress) {
        None$ none$;
        Object object = new Object();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(networkInterface.getInterfaceAddresses()).asScala()).foreach((Function1 & Serializable & scala.Serializable)address -> {
                    H2OClientUtils$.$anonfun$identifyClientIp$1(remoteAddress, object, address);
                    return BoxedUnit.UNIT;
                });
            }
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public <T extends Frame> T withLockAndUpdate(T fr, Function1<T, Object> f2) {
        fr.write_lock();
        f2.apply(fr);
        fr.update();
        fr.unlock();
        return fr;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$identifyClientIp$1(String remoteAddress$1, Object nonLocalReturnKey1$1, InterfaceAddress address) {
        String ip = new StringBuilder(1).append(address.getAddress().getHostAddress()).append("/").append(address.getNetworkPrefixLength()).toString();
        HostnameGuesser.CIDRBlock cidr = HostnameGuesser.CIDRBlock.parse(ip);
        if (cidr != null && cidr.isInetAddressOnNetwork(InetAddress.getByName(remoteAddress$1))) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)address.getAddress().getHostAddress()));
        }
    }

    private H2OClientUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        SharedBackendUtils.$init$(this);
        this.PROP_REST_API_BASED_CLIENT = new Tuple2((Object)"spark.ext.h2o.rest.api.based.client", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

