/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.external;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.external.K8sUtils;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4qAC\u0006\u0011\u0002\u0007\u0005a\u0003C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011Eq\u0005C\u0003I\u0001\u0011E\u0011\nC\u0003M\u0001\u0011%Q\nC\u0003Q\u0001\u0011%\u0011\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003l\u0001\u0011%A\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003v\u0001\u0011%aOA\tLqMD%gT*uCR,g-\u001e7TKRT!\u0001D\u0007\u0002\u0011\u0015DH/\u001a:oC2T!AD\b\u0002\u000f\t\f7m[3oI*\u0011\u0001#E\u0001\ngB\f'o\u001b7j]\u001eT!AE\n\u0002\u0007!\u0014tNC\u0001\u0015\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011aC\u0005\u0003A-\u0011\u0001b\u0013\u001dt+RLGn]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\r\u0002\"\u0001\u0007\u0013\n\u0005\u0015J\"\u0001B+oSR\fQ#\u001b8ti\u0006dG\u000e\u0013\u001aP'R\fG/\u001a4vYN+G\u000f\u0006\u0003)g\u00013\u0005CA\u00151\u001d\tQc\u0006\u0005\u0002,35\tAF\u0003\u0002.+\u00051AH]8pizJ!aL\r\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_eAQ\u0001\u000e\u0002A\u0002U\naa\u00197jK:$\bC\u0001\u001c?\u001b\u00059$B\u0001\u001b9\u0015\tI$(\u0001\u0006lk\n,'O\\3uKNT!a\u000f\u001f\u0002\u000f\u0019\f'M]5dq)\tQ(\u0001\u0002j_&\u0011qh\u000e\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]RDQ!\u0011\u0002A\u0002\t\u000bAaY8oMB\u00111\tR\u0007\u0002\u001f%\u0011Qi\u0004\u0002\b\u0011Jz5i\u001c8g\u0011\u00159%\u00011\u0001)\u0003IAW-\u00193mKN\u001c8+\u001a:wS\u000e,WK\u0015'\u0002)\u0011,G.\u001a;f\u0011Jz5\u000b^1uK\u001a,HnU3u)\r\u0019#j\u0013\u0005\u0006i\r\u0001\r!\u000e\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\u0018o\u0006LGOR8s\u00072,8\u000f^3s)>\u0014UMU3bIf$2\u0001\u000b(P\u0011\u0015!D\u00011\u00016\u0011\u0015\tE\u00011\u0001C\u0003U9W\r\u001e)pIN4uN]*uCR,g-\u001e7TKR$2AU/_!\rA2+V\u0005\u0003)f\u0011Q!\u0011:sCf\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\u000b5|G-\u001a7\u000b\u0005iC\u0014aA1qS&\u0011Al\u0016\u0002\u0004!>$\u0007\"\u0002\u001b\u0006\u0001\u0004)\u0004\"B!\u0006\u0001\u0004\u0011\u0015!E2p]Z,'\u000f\u001e'bE\u0016dGk\\'baR\u0011\u0011-\u001b\t\u0005E\u001eD\u0003&D\u0001d\u0015\t!W-\u0001\u0003vi&d'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u000e\u00141!T1q\u0011\u0015Qg\u00011\u0001)\u0003\u0015a\u0017MY3m\u00035a\u0017n\u001d;SK\u0006$\u0017\u0010U8egR\u0019!+\u001c8\t\u000bQ:\u0001\u0019A\u001b\t\u000b\u0005;\u0001\u0019\u0001\"\u0002\u0019\u001d,GO\u0014;ie\u0016\fG-Z:\u0015\u0005E$\bC\u0001\rs\u0013\t\u0019\u0018DA\u0002J]RDQ!\u0011\u0005A\u0002\t\u000bAa\u001d9fGR\u0019q\u000f`?\u0011\u0005aTX\"A=\u000b\u0005u*\u0017BA>z\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b\u0005K\u0001\u0019\u0001\"\t\u000b\u001dK\u0001\u0019\u0001\u0015")
public interface K8sH2OStatefulSet
extends K8sUtils {
    public static /* synthetic */ String installH2OStatefulSet$(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf, String headlessServiceURL) {
        return $this.installH2OStatefulSet(client, conf, headlessServiceURL);
    }

    default public String installH2OStatefulSet(KubernetesClient client, H2OConf conf, String headlessServiceURL) {
        List resource = (List)client.load(this.spec(conf, headlessServiceURL)).get();
        client.resourceList((Collection)resource).createOrReplace();
        return this.waitForClusterToBeReady(client, conf);
    }

    public static /* synthetic */ void deleteH2OStatefulSet$(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf) {
        $this.deleteH2OStatefulSet(client, conf);
    }

    default public void deleteH2OStatefulSet(KubernetesClient client, H2OConf conf) {
        ((Deletable)((Nameable)client.apps().statefulSets().inNamespace(conf.externalK8sNamespace())).withName(conf.externalK8sH2OStatefulsetName())).delete();
    }

    private String waitForClusterToBeReady(KubernetesClient client, H2OConf conf) {
        ((Nameable)client.apps().statefulSets().inNamespace(conf.externalK8sNamespace())).withName(conf.externalK8sH2OStatefulsetName());
        long start = System.currentTimeMillis();
        int timeout = conf.cloudTimeout();
        while (System.currentTimeMillis() - start < (long)timeout) {
            if (this.getPodsForStatefulSet(client, conf).length < new StringOps(Predef$.MODULE$.augmentString((String)conf.clusterSize().get())).toInt() || this.listReadyPods(client, conf).length != 1) {
                Thread.sleep(100L);
                continue;
            }
            return ((Pod)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listReadyPods(client, conf))).head()).getMetadata().getName();
        }
        if (this.getPodsForStatefulSet(client, conf).length < new StringOps(Predef$.MODULE$.augmentString((String)conf.clusterSize().get())).toInt() && this.listReadyPods(client, conf).length != 1) {
            throw new RuntimeException("Timeout during clouding of external H2O backend on K8s.");
        }
        return ((Pod)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listReadyPods(client, conf))).head()).getMetadata().getName();
    }

    private Pod[] getPodsForStatefulSet(KubernetesClient client, H2OConf conf) {
        return (Pod[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)client.pods().inNamespace(conf.externalK8sNamespace())).withLabels(this.convertLabelToMap(conf.externalK8sH2OLabel()))).list()).getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)K8sH2OStatefulSet.$anonfun$getPodsForStatefulSet$1(x$1)))).toArray(ClassTag$.MODULE$.apply(Pod.class));
    }

    private java.util.Map<String, String> convertLabelToMap(String label) {
        String[] split = label.split("=");
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)split[0]), (Object)split[1])}))).asJava();
    }

    private Pod[] listReadyPods(KubernetesClient client, H2OConf conf) {
        return (Pod[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getPodsForStatefulSet(client, conf))).filter((Function1 & Serializable & scala.Serializable)pod -> BoxesRunTime.boxToBoolean((boolean)K8sH2OStatefulSet.$anonfun$listReadyPods$1(client, conf, pod)));
    }

    private int getNthreades(H2OConf conf) {
        return conf.nthreads() > 0 ? conf.nthreads() : 1;
    }

    private InputStream spec(H2OConf conf, String headlessServiceURL) {
        String spec = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1940).append("\n                  |apiVersion: apps/v1\n                  |kind: StatefulSet\n                  |metadata:\n                  |  name: ").append(conf.externalK8sH2OStatefulsetName()).append("\n                  |  namespace: ").append(conf.externalK8sNamespace()).append("\n                  |spec:\n                  |  serviceName: ").append(conf.externalK8sH2OServiceName()).append("\n                  |  podManagementPolicy: \"Parallel\"\n                  |  replicas: ").append(conf.clusterSize().get()).append("\n                  |  selector:\n                  |    matchLabels:\n                  |      ").append(this.convertLabel(conf.externalK8sH2OLabel())).append("\n                  |  template:\n                  |    metadata:\n                  |      labels:\n                  |        ").append(this.convertLabel(conf.externalK8sH2OLabel())).append("\n                  |    spec:\n                  |      terminationGracePeriodSeconds: 10\n                  |      containers:\n                  |        - name: ").append(conf.externalK8sH2OServiceName()).append("\n                  |          image: '").append(conf.externalK8sDockerImage()).append("'\n                  |          resources:\n                  |            requests:\n                  |              cpu: ").append(this.getNthreades(conf)).append("\n                  |              memory: \"").append(conf.externalMemory()).append("\"\n                  |            limits:\n                  |              cpu: ").append(this.getNthreades(conf)).append("\n                  |              memory: \"").append(conf.externalMemory()).append("\"\n                  |          ports:\n                  |            - containerPort: 54321\n                  |              protocol: TCP\n                  |          readinessProbe:\n                  |            httpGet:\n                  |              path: /kubernetes/isLeaderNode\n                  |              port: ").append(conf.externalK8sH2OApiPort()).append("\n                  |            initialDelaySeconds: 5\n                  |            periodSeconds: 5\n                  |            failureThreshold: 1\n                  |          env:\n                  |          - name: H2O_KUBERNETES_SERVICE_DNS\n                  |            value: ").append(headlessServiceURL).append("\n                  |          - name: H2O_NODE_LOOKUP_TIMEOUT\n                  |            value: '180'\n                  |          - name: H2O_NODE_EXPECTED_COUNT\n                  |            value: '").append(conf.clusterSize().get()).append("'\n                  |          - name: H2O_KUBERNETES_API_PORT\n                  |            value: '").append(conf.externalK8sH2OApiPort()).append("'").toString())).stripMargin();
        return new ByteArrayInputStream(spec.getBytes());
    }

    public static /* synthetic */ boolean $anonfun$getPodsForStatefulSet$1(Pod x$1) {
        String string = x$1.getStatus().getPhase();
        String string2 = "Running";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ boolean $anonfun$listReadyPods$1(KubernetesClient client$1, H2OConf conf$1, Pod pod) {
        PodResource newPod = (PodResource)((Nameable)client$1.pods().inNamespace(conf$1.externalK8sNamespace())).withName(pod.getMetadata().getName());
        return Predef$.MODULE$.Boolean2boolean(newPod.isReady()) && newPod.getLog().contains(new StringBuilder(24).append("Created cluster of size ").append(conf$1.clusterSize().get()).toString());
    }

    public static void $init$(K8sH2OStatefulSet $this) {
    }
}

