/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.external;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.SharedBackendConf$;
import ai.h2o.sparkling.backend.external.ExternalBackendConf$;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.sys.package$;

public final class ExternalH2OBackend$
implements SharedBackendUtils {
    public static ExternalH2OBackend$ MODULE$;
    private final String TAG_EXTERNAL_H2O;
    private final String TAG_SPARK_APP;
    private final String H2O_JOB_NAME;
    private final String ENV_H2O_DRIVER_JAR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExternalH2OBackend$();
    }

    @Override
    public String getHostname(SparkEnv env) {
        return SharedBackendUtils.getHostname$(this, env);
    }

    @Override
    public void distributeFiles(H2OConf conf, SparkContext sc) {
        SharedBackendUtils.distributeFiles$(this, conf, sc);
    }

    @Override
    public Seq<String> getH2OSecurityArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OSecurityArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OCommonArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OCommonArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OWorkerAsClientArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OWorkerAsClientArgs$(this, conf);
    }

    @Override
    public Seq<String> parseStringToHttpHeaderArgs(String headers) {
        return SharedBackendUtils.parseStringToHttpHeaderArgs$(this, headers);
    }

    @Override
    public Seq<String> getExtraHttpHeaderArgs(H2OConf conf) {
        return SharedBackendUtils.getExtraHttpHeaderArgs$(this, conf);
    }

    @Override
    public String[] toH2OArgs(Seq<String> h2oArgs, NodeDesc[] executors) {
        return SharedBackendUtils.toH2OArgs$(this, h2oArgs, executors);
    }

    @Override
    public NodeDesc[] toH2OArgs$default$2() {
        return SharedBackendUtils.toH2OArgs$default$2$(this);
    }

    @Override
    public File createTempDir() {
        return SharedBackendUtils.createTempDir$(this);
    }

    @Override
    public File saveFlatFileAsFile(String content) {
        return SharedBackendUtils.saveFlatFileAsFile$(this, content);
    }

    @Override
    public String translateHostnameToIp(String hostname) {
        return SharedBackendUtils.translateHostnameToIp$(this, hostname);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public H2OConf checkAndUpdateConf(H2OConf conf) {
        Object object;
        SharedBackendUtils.checkAndUpdateConf$(this, conf);
        if (conf.getInt("spark.locality.wait", 3000) <= 3000) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Increasing 'spark.locality.wait' to value 30000");
            object = conf.set("spark.locality.wait", "30000");
        } else {
            object = BoxedUnit.UNIT;
        }
        String string = conf.clusterStartMode();
        String string2 = ExternalBackendConf$.MODULE$.EXTERNAL_BACKEND_MANUAL_MODE();
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = conf.clusterStartMode();
            String string4 = ExternalBackendConf$.MODULE$.EXTERNAL_BACKEND_AUTO_MODE();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException(new StringBuilder(68).append("'").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_CLUSTER_START_MODE()._1()).append("' property is set to ").append(conf.clusterStartMode()).append(".\n          Valid options are \"").append(ExternalBackendConf$.MODULE$.EXTERNAL_BACKEND_MANUAL_MODE()).append("\" or \"").append(ExternalBackendConf$.MODULE$.EXTERNAL_BACKEND_AUTO_MODE()).append("\".\n      ").toString());
            }
        }
        if (conf.isAutoClusterStartUsed()) {
            Object object2;
            String string5 = conf.externalAutoStartBackend();
            String string6 = ExternalBackendConf$.MODULE$.YARN_BACKEND();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                String string7 = conf.externalAutoStartBackend();
                String string8 = ExternalBackendConf$.MODULE$.KUBERNETES_BACKEND();
                if (string7 == null ? string8 != null : !string7.equals(string8)) {
                    throw new IllegalArgumentException(new StringBuilder(68).append("'").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_AUTO_START_BACKEND()._1()).append("' property is set to ").append(conf.externalAutoStartBackend()).append(".\n          Valid options are \"").append(ExternalBackendConf$.MODULE$.YARN_BACKEND()).append("\" or \"").append(ExternalBackendConf$.MODULE$.KUBERNETES_BACKEND()).append("\".\n      ").toString());
                }
            }
            String string9 = conf.externalAutoStartBackend();
            String string10 = ExternalBackendConf$.MODULE$.YARN_BACKEND();
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                LazyRef driverPath$lzy = new LazyRef();
                String envDriverJar = this.ENV_H2O_DRIVER_JAR();
                if (conf.h2oDriverPath().isEmpty() && ExternalH2OBackend$.driverPath$1(driverPath$lzy, envDriverJar).isEmpty()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(240).append("Path to the H2O driver has to be specified when using automatic cluster start.\n               |It can be specified either via method available on the configuration object or\n               |by using the '").append(envDriverJar).append("' environmental property.\n          ").toString())).stripMargin());
                }
                if (conf.h2oDriverPath().isEmpty() && ExternalH2OBackend$.driverPath$1(driverPath$lzy, envDriverJar).isDefined()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(100).append("Obtaining path to the H2O driver from the environment variable ").append(envDriverJar).append(".\n               |Specified path is: ").append(ExternalH2OBackend$.driverPath$1(driverPath$lzy, envDriverJar).get()).toString())).stripMargin());
                    object6 = conf.setH2ODriverPath((String)ExternalH2OBackend$.driverPath$1(driverPath$lzy, envDriverJar).get());
                } else {
                    object6 = BoxedUnit.UNIT;
                }
                if (conf.clientCheckRetryTimeout() < conf.backendHeartbeatInterval()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s needs to be larger than %s, increasing the value to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_EXTERNAL_CLIENT_RETRY_TIMEOUT()._1(), SharedBackendConf$.MODULE$.PROP_BACKEND_HEARTBEAT_INTERVAL()._1(), BoxesRunTime.boxToInteger((int)(conf.backendHeartbeatInterval() * 6))})));
                    object5 = conf.setClientCheckRetryTimeout(conf.backendHeartbeatInterval() * 6);
                } else {
                    object5 = BoxedUnit.UNIT;
                }
                Object object7 = conf.cloudName().isEmpty() ? conf.setCloudName(new StringOps(Predef$.MODULE$.augmentString(this.H2O_JOB_NAME())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkSessionUtils$.MODULE$.active().sparkContext().applicationId()}))) : BoxedUnit.UNIT;
                Object object8 = conf.clusterInfoFile().isEmpty() ? conf.setClusterInfoFile(new StringBuilder(7).append("notify_").append(conf.cloudName().get()).toString()) : BoxedUnit.UNIT;
                if (conf.getOption("spark.yarn.principal").isDefined() && conf.kerberosPrincipal().isEmpty()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("spark.yarn.principal provided and ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_PRINCIPAL()._1()).append(" is").append(" not set. Passing the configuration to H2O.").toString());
                    object4 = conf.setKerberosPrincipal(conf.get("spark.yarn.principal"));
                } else {
                    object4 = BoxedUnit.UNIT;
                }
                if (conf.getOption("spark.yarn.keytab").isDefined() && conf.kerberosKeytab().isEmpty()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("spark.yarn.keytab provided and ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_KEYTAB()._1()).append(" is").append(" not set. Passing the configuration to H2O.").toString());
                    object3 = conf.setKerberosKeytab(conf.get("spark.yarn.keytab"));
                } else {
                    object3 = BoxedUnit.UNIT;
                }
                if (conf.kerberosKeytab().isDefined() && conf.kerberosPrincipal().isEmpty()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n                                                |  Both options ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_KEYTAB()._1()).append(" and\n                                                |  ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_PRINCIPAL()._1()).append(" need to be provided, specified has\n                                                |  been just ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_KEYTAB()._1()).append("\n          ").toString())).stripMargin());
                }
                if (conf.kerberosPrincipal().isDefined() && conf.kerberosKeytab().isEmpty()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n                                                |  Both options ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_KEYTAB()._1()).append(" and\n                                                |  ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_PRINCIPAL()._1()).append(" need to be provided, specified has\n                                                |  been just ").append(ExternalBackendConf$.MODULE$.PROP_EXTERNAL_KERBEROS_PRINCIPAL()._1()).append("\n          ").toString())).stripMargin());
                }
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = conf.cloudName().isEmpty() ? conf.setCloudName("root") : BoxedUnit.UNIT;
            }
            if (conf.clusterSize().isEmpty()) {
                throw new IllegalArgumentException("Cluster size of external H2O cluster has to be specified in automatic mode of external H2O backend!");
            }
        } else {
            if (conf.cloudName().isEmpty()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("Cluster name has to be specified when using the external H2O cluster mode in the manual start mode.\n             |It can be set either on the configuration object or via '").append(SharedBackendConf$.MODULE$.PROP_CLOUD_NAME()._1()).append("'\n             |spark configuration property").toString())).stripMargin());
            }
            if (conf.h2oCluster().isEmpty()) {
                throw new IllegalArgumentException("H2O Cluster endpoint has to be specified!");
            }
        }
        this.distributeFiles(conf, SparkSessionUtils$.MODULE$.active().sparkContext());
        return conf;
    }

    public String TAG_EXTERNAL_H2O() {
        return this.TAG_EXTERNAL_H2O;
    }

    public String TAG_SPARK_APP() {
        return this.TAG_SPARK_APP;
    }

    public String H2O_JOB_NAME() {
        return this.H2O_JOB_NAME;
    }

    public String ENV_H2O_DRIVER_JAR() {
        return this.ENV_H2O_DRIVER_JAR;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ Option driverPath$lzycompute$1(LazyRef driverPath$lzy$1, String envDriverJar$1) {
        Option option;
        LazyRef lazyRef = driverPath$lzy$1;
        synchronized (lazyRef) {
            option = driverPath$lzy$1.initialized() ? (Option)driverPath$lzy$1.value() : (Option)driverPath$lzy$1.initialize((Object)package$.MODULE$.env().get((Object)envDriverJar$1));
        }
        return option;
    }

    private static final Option driverPath$1(LazyRef driverPath$lzy$1, String envDriverJar$1) {
        return driverPath$lzy$1.initialized() ? (Option)driverPath$lzy$1.value() : ExternalH2OBackend$.driverPath$lzycompute$1(driverPath$lzy$1, envDriverJar$1);
    }

    private ExternalH2OBackend$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        SharedBackendUtils.$init$(this);
        this.TAG_EXTERNAL_H2O = "H2O/Sparkling-Water";
        this.TAG_SPARK_APP = "Sparkling-Water/Spark/%s";
        this.H2O_JOB_NAME = "H2O_via_SparklingWater_%s";
        this.ENV_H2O_DRIVER_JAR = "H2O_DRIVER_JAR";
    }
}

