/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.api.rdds;

import ai.h2o.org.eclipse.jetty.servlet.ServletContextHandler;
import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.backend.api.ServletBase;
import ai.h2o.sparkling.backend.api.rdds.RDDInfo;
import ai.h2o.sparkling.backend.api.rdds.RDDInfo$;
import ai.h2o.sparkling.backend.api.rdds.RDDInfo$RDDInfoParameters$;
import ai.h2o.sparkling.backend.api.rdds.RDDToH2OFrame;
import ai.h2o.sparkling.backend.api.rdds.RDDToH2OFrame$RDDToH2OFrameParameters$;
import ai.h2o.sparkling.backend.api.rdds.RDDs;
import ai.h2o.sparkling.backend.api.rdds.RDDsServlet$;
import ai.h2o.sparkling.backend.converters.SupportedRDD$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Types;
import scala.runtime.BoxesRunTime;
import water.exceptions.H2ONotFoundArgumentException;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!B\t\u0013\u0001Qq\u0002\"B\u0017\u0001\t\u0003y\u0003\u0002\u0003\u001a\u0001\u0011\u000b\u0007I\u0011B\u001a\t\u0011a\u0002\u0001R1A\u0005\neBQ\u0001\u0012\u0001\u0005B\u0015CQA\u0016\u0001\u0005B]CQA\u0017\u0001\u0005\u0002mCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001b\u0001\u0005\u0002)Daa \u0001\u0005\n\u0005\u0005\u0001bBA\u0005\u0001\u0011%\u00111B\u0004\b\u0003{\u0011\u0002\u0012AA \r\u0019\t\"\u0003#\u0001\u0002B!1Q\u0006\u0004C\u0001\u0003+Bq!a\u0016\r\t#\nI\u0006C\u0004\u0002^1!\t&a\u0018\t\u0013\u0005UD\"!A\u0005\n\u0005]$a\u0003*E\tN\u001cVM\u001d<mKRT!a\u0005\u000b\u0002\tI$Gm\u001d\u0006\u0003+Y\t1!\u00199j\u0015\t9\u0002$A\u0004cC\u000e\\WM\u001c3\u000b\u0005eQ\u0012!C:qCJ\\G.\u001b8h\u0015\tYB$A\u0002ie=T\u0011!H\u0001\u0003C&\u001c2\u0001A\u0010*!\t\u0001s%D\u0001\"\u0015\t\u00113%\u0001\u0003iiR\u0004(B\u0001\u0013&\u0003\u001d\u0019XM\u001d<mKRT\u0011AJ\u0001\u0006U\u00064\u0018\r_\u0005\u0003Q\u0005\u00121\u0002\u0013;uaN+'O\u001e7fiB\u0011!fK\u0007\u0002)%\u0011A\u0006\u0006\u0002\f'\u0016\u0014h\u000f\\3u\u0005\u0006\u001cX-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005\u0011\u0012A\u00015d+\u0005!\u0004CA\u001b7\u001b\u0005A\u0012BA\u001c\u0019\u0005)A%gT\"p]R,\u0007\u0010^\u0001\u0003g\u000e,\u0012A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\nQa\u001d9be.T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO&\u00111\t\u0010\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0006I><U\r\u001e\u000b\u0004\r2\u000b\u0006CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001B+oSRDQ!\u0014\u0003A\u00029\u000b1A]3r!\t\u0001s*\u0003\u0002QC\t\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0011\u0015\u0011F\u00011\u0001T\u0003\u0011\u0011Xm\u001d9\u0011\u0005\u0001\"\u0016BA+\"\u0005MAE\u000f\u001e9TKJ4H.\u001a;SKN\u0004xN\\:f\u0003\u0019!w\u000eU8tiR\u0019a\tW-\t\u000b5+\u0001\u0019\u0001(\t\u000bI+\u0001\u0019A*\u0002\t1L7\u000f\u001e\u000b\u00029B\u0011\u0011'X\u0005\u0003=J\u0011AA\u0015#Eg\u00061q-\u001a;S\t\u0012#\"!\u00193\u0011\u0005E\u0012\u0017BA2\u0013\u0005\u001d\u0011F\tR%oM>DQ!Z\u0004A\u0002\u0019\fQA\u001d3e\u0013\u0012\u0004\"aR4\n\u0005!D%aA%oi\u0006QAo\u001c%3\u001f\u001a\u0013\u0018-\\3\u0015\u0007-tw\u000e\u0005\u00022Y&\u0011QN\u0005\u0002\u000e%\u0012#Ek\u001c%3\u001f\u001a\u0013\u0018-\\3\t\u000b\u0015D\u0001\u0019\u00014\t\u000bAD\u0001\u0019A9\u0002\u0015!\u0014tN\u0012:b[\u0016LE\rE\u0002HeRL!a\u001d%\u0003\r=\u0003H/[8o!\t)HP\u0004\u0002wuB\u0011q\u000fS\u0007\u0002q*\u0011\u0011PL\u0001\u0007yI|w\u000e\u001e \n\u0005mD\u0015A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f%\u0002\u0011\u0019,Go\u00195BY2$\"!a\u0001\u0011\t\u001d\u000b)!Y\u0005\u0004\u0003\u000fA%!B!se\u0006L\u0018!E2p]Z,'\u000f\u001e+p\u0011JzeI]1nKR1\u0011QBA\n\u0003s\u00012!NA\b\u0013\r\t\t\u0002\u0007\u0002\t\u0011JzeI]1nK\"9\u0011Q\u0003\u0006A\u0002\u0005]\u0011a\u0001:eIB\"\u0011\u0011DA\u0014!\u0019\tY\"a\b\u0002$5\u0011\u0011Q\u0004\u0006\u0004\u0003+a\u0014\u0002BA\u0011\u0003;\u00111A\u0015#E!\u0011\t)#a\n\r\u0001\u0011a\u0011\u0011FA\n\u0003\u0003\u0005\tQ!\u0001\u0002,\t\u0019q\fJ\u0019\u0012\t\u00055\u00121\u0007\t\u0004\u000f\u0006=\u0012bAA\u0019\u0011\n9aj\u001c;iS:<\u0007cA$\u00026%\u0019\u0011q\u0007%\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002<)\u0001\r!]\u0001\u0005]\u0006lW-A\u0006S\t\u0012\u001b8+\u001a:wY\u0016$\bCA\u0019\r'\u001da\u00111IA%\u0003\u001f\u00022aRA#\u0013\r\t9\u0005\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0007)\nY%C\u0002\u0002NQ\u0011qbU3sm2,GOU3hSN$XM\u001d\t\u0004\u000f\u0006E\u0013bAA*\u0011\na1+\u001a:jC2L'0\u00192mKR\u0011\u0011qH\u0001\u0010O\u0016$(+Z9vKN$\b+\u0019;igR\u0011\u00111\f\t\u0005\u000f\u0006\u0015A/\u0001\u0006hKR\u001cVM\u001d<mKR$b!!\u0019\u0002j\u0005M\u0004\u0003BA2\u0003Kj\u0011aI\u0005\u0004\u0003O\u001a#aB*feZdW\r\u001e\u0005\b\u0003Wz\u0001\u0019AA7\u0003\u0011\u0019wN\u001c4\u0011\u0007U\ny'C\u0002\u0002ra\u0011q\u0001\u0013\u001aP\u0007>tg\rC\u00033\u001f\u0001\u0007A'A\u0006sK\u0006$'+Z:pYZ,GCAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bA\u0001\\1oO*\u0011\u00111Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\b\u0006u$AB(cU\u0016\u001cG\u000f")
public class RDDsServlet
extends HttpServlet
implements ServletBase {
    private H2OContext hc;
    private SparkContext sc;
    private volatile byte bitmap$0;

    public static void register(ServletContextHandler servletContextHandler, H2OConf h2OConf, H2OContext h2OContext) {
        RDDsServlet$.MODULE$.register(servletContextHandler, h2OConf, h2OContext);
    }

    @Override
    public void sendResult(Object obj, HttpServletResponse resp) {
        ServletBase.sendResult$(this, obj, resp);
    }

    private H2OContext hc$lzycompute() {
        RDDsServlet rDDsServlet = this;
        synchronized (rDDsServlet) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.hc = H2OContext$.MODULE$.ensure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> H2OContext$.MODULE$.ensure$default$1());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.hc;
    }

    private H2OContext hc() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.hc$lzycompute() : this.hc;
    }

    private SparkContext sc$lzycompute() {
        RDDsServlet rDDsServlet = this;
        synchronized (rDDsServlet) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = this.hc().sparkContext();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    private SparkContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        String string = req.getPathInfo();
        if (string != null) {
            throw new H2ONotFoundArgumentException(new StringBuilder(17).append("Invalid endpoint ").append(string).toString());
        }
        RDDs rDDs = this.list();
        RDDs obj = rDDs;
        this.sendResult(obj, resp);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        Object object;
        String string = req.getPathInfo();
        if (string.matches("/.*/h2oframe")) {
            RDDToH2OFrame.RDDToH2OFrameParameters parameters = RDDToH2OFrame$RDDToH2OFrameParameters$.MODULE$.parse(req);
            parameters.validate();
            object = this.toH2OFrame(parameters.rddId(), parameters.h2oFrameId());
        } else if (string.matches("/.*")) {
            RDDInfo.RDDInfoParameters parameters = RDDInfo$RDDInfoParameters$.MODULE$.parse(req);
            parameters.validate();
            object = this.getRDD(parameters.rddId());
        } else {
            throw new H2ONotFoundArgumentException(new StringBuilder(17).append("Invalid endpoint ").append(string).toString());
        }
        RDDToH2OFrame obj = object;
        this.sendResult(obj, resp);
    }

    public RDDs list() {
        return new RDDs(this.fetchAll());
    }

    public RDDInfo getRDD(int rddId) {
        return RDDInfo$.MODULE$.fromRDD((RDD)this.sc().getPersistentRDDs().apply((Object)BoxesRunTime.boxToInteger((int)rddId)));
    }

    public RDDToH2OFrame toH2OFrame(int rddId, Option<String> h2oFrameId) {
        RDD rdd = (RDD)this.sc().getPersistentRDDs().apply((Object)BoxesRunTime.boxToInteger((int)rddId));
        H2OFrame h2oFrame = this.convertToH2OFrame(rdd, h2oFrameId);
        return new RDDToH2OFrame(rddId, h2oFrame.frameId());
    }

    private RDDInfo[] fetchAll() {
        return (RDDInfo[])((TraversableOnce)SparkSessionUtils$.MODULE$.active().sparkContext().getPersistentRDDs().values().map((Function1 & Serializable & scala.Serializable)rdd -> RDDInfo$.MODULE$.fromRDD((RDD<?>)rdd), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RDDInfo.class));
    }

    private H2OFrame convertToH2OFrame(RDD<?> rdd, Option<String> name) {
        H2OFrame h2OFrame;
        if (rdd.isEmpty()) {
            h2OFrame = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDInt((RDD<Object>)this.sc().parallelize((Seq)Nil$.MODULE$, this.sc().parallelize$default$2(), ClassTag$.MODULE$.Int())), name);
        } else {
            H2OFrame h2OFrame2;
            Object object = rdd.first();
            if (object instanceof Double) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromDouble(rdd), name);
            } else if (object instanceof LabeledPoint) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDLabeledPoint(rdd), name);
            } else if (object instanceof Boolean) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDBool(rdd), name);
            } else if (object instanceof String) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDString(rdd), name);
            } else if (object instanceof Integer) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDInt(rdd), name);
            } else if (object instanceof Float) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDFloat(rdd), name);
            } else if (object instanceof Long) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDLong(rdd), name);
            } else if (object instanceof Timestamp) {
                h2OFrame2 = this.hc().asH2OFrame(SupportedRDD$.MODULE$.toH2OFrameFromRDDTimeStamp(rdd), name);
            } else if (object instanceof Product) {
                Product first = (Product)rdd.first();
                Seq fields = (Seq)ScalaReflection$.MODULE$.getConstructorParameters(first.getClass()).map((Function1 & Serializable & scala.Serializable)v2 -> {
                    ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor((Types.TypeApi)v2._2());
                    return new StructField((String)v2._1(), schema.dataType(), schema.nullable(), StructField$.MODULE$.apply$default$4());
                }, Seq$.MODULE$.canBuildFrom());
                Dataset df = SparkSessionUtils$.MODULE$.active().createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)tuple -> Row$.MODULE$.fromTuple(tuple), ClassTag$.MODULE$.apply(Row.class)), StructType$.MODULE$.apply(fields));
                h2OFrame2 = this.hc().asH2OFrame((Dataset<Row>)df, name, this.hc().asH2OFrame$default$3());
            } else {
                throw new IllegalArgumentException(new StringBuilder(23).append("Do not understand type ").append(object).toString());
            }
            h2OFrame = h2OFrame2;
        }
        return h2OFrame;
    }

    public RDDsServlet() {
        ServletBase.$init$(this);
    }
}

