/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.H2OFrame$;
import ai.h2o.sparkling.backend.H2OAwareRDD;
import ai.h2o.sparkling.backend.H2OChunk$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.PartitionStats;
import ai.h2o.sparkling.backend.PartitionStatsGenerator$;
import ai.h2o.sparkling.backend.Writer;
import ai.h2o.sparkling.backend.WriterMetadata;
import ai.h2o.sparkling.backend.converters.CategoricalDomainBuilder;
import ai.h2o.sparkling.backend.converters.TimeZoneConverter;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.extensions.rest.api.Paths$;
import ai.h2o.sparkling.extensions.rest.api.schema.UploadPlanV3;
import ai.h2o.sparkling.extensions.serde.SerdeUtils$;
import ai.h2o.sparkling.utils.ScalaUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.ExposeUtils$;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Writer$ {
    public static Writer$ MODULE$;

    static {
        new Writer$();
    }

    public H2OFrame convert(H2OAwareRDD<Row> rdd, String[] colNames, WriterMetadata metadata) {
        H2OFrame$.MODULE$.initializeFrame(metadata.conf(), metadata.frameId(), colNames);
        PartitionStats partitionStats = PartitionStatsGenerator$.MODULE$.getPartitionStats(rdd, metadata.featureColsForConstCheck());
        if (BoxesRunTime.unboxToBoolean((Object)partitionStats.areFeatureColumnsConstant().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            throw new IllegalArgumentException(new StringBuilder(135).append("H2O could not use any of the specified input").append(" columns: '").append(((TraversableOnce)metadata.featureColsForConstCheck().get()).mkString(", ")).append("' because they are all constants. H2O requires at least one non-constant column.").toString());
        }
        Map<Object, Object> partitionSizes = partitionStats.partitionSizes();
        Seq nonEmptyPartitions = (Seq)((MapLike)partitionSizes.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Writer$.$anonfun$convert$2(x$1)))).keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
        Map<Object, NodeDesc> uploadPlan = this.getUploadPlan(metadata.conf(), nonEmptyPartitions.length());
        Function2 & Serializable & scala.Serializable operation = (Function2 & Serializable & scala.Serializable)(context, it) -> MODULE$.perDataFramePartition(metadata, uploadPlan, (Seq<Object>)nonEmptyPartitions, partitionSizes, (TaskContext)context, (Iterator<Row>)it);
        Tuple2[] rows = (Tuple2[])SparkSessionUtils$.MODULE$.active().sparkContext().runJob(rdd, (Function2)operation, nonEmptyPartitions, ClassTag$.MODULE$.apply(Tuple2.class));
        long[] rowsPerChunk = new long[nonEmptyPartitions.size()];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Writer$.$anonfun$convert$4(rowsPerChunk, x0$1);
            return BoxedUnit.UNIT;
        });
        byte[] types = SerdeUtils$.MODULE$.expectedTypesToVecTypes(metadata.expectedTypes(), metadata.maxVectorSizes());
        H2OFrame$.MODULE$.finalizeFrame(metadata.conf(), metadata.frameId(), rowsPerChunk, types);
        return H2OFrame$.MODULE$.apply(metadata.frameId());
    }

    private Tuple2<Object, Object> perDataFramePartition(WriterMetadata metadata, Map<Object, NodeDesc> uploadPlan, Seq<Object> partitions, Map<Object, Object> partitionSizes, TaskContext context, Iterator<Row> it) {
        int chunkIdx = partitions.indexOf((Object)BoxesRunTime.boxToInteger((int)context.partitionId()));
        int numRows = BoxesRunTime.unboxToInt((Object)partitionSizes.apply((Object)BoxesRunTime.boxToInteger((int)context.partitionId())));
        CategoricalDomainBuilder domainBuilder = new CategoricalDomainBuilder(metadata.expectedTypes());
        NodeDesc h2oNode = (NodeDesc)uploadPlan.apply((Object)BoxesRunTime.boxToInteger((int)chunkIdx));
        ScalaUtils$.MODULE$.withResource(new Writer(h2oNode, metadata, numRows, chunkIdx), (Function1 & Serializable & scala.Serializable)writer -> {
            it.foreach((Function1 & Serializable & scala.Serializable)row -> {
                Writer$.MODULE$.sparkRowToH2ORow(row, writer, metadata$2, domainBuilder$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        H2OChunk$.MODULE$.putChunkCategoricalDomains(h2oNode, metadata.conf(), metadata.frameId(), chunkIdx, domainBuilder.getDomains());
        return new Tuple2.mcIJ.sp(chunkIdx, (long)numRows);
    }

    private void sparkRowToH2ORow(Row row, Writer con, WriterMetadata metadata, CategoricalDomainBuilder domainBuilder) {
        TimeZoneConverter timeZoneConverter = new TimeZoneConverter(metadata.timezone());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Writer$.$anonfun$sparkRowToH2ORow$1(row, con, domainBuilder, timeZoneConverter, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Map<Object, NodeDesc> getUploadPlan(H2OConf conf, int numberOfPartitions) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number_of_chunks"), (Object)BoxesRunTime.boxToInteger((int)numberOfPartitions))}));
        UploadPlanV3 rawPlan = (UploadPlanV3)H2OFrame$.MODULE$.query(endpoint, Paths$.MODULE$.UPLOAD_PLAN(), conf, (Map<String, Object>)parameters, H2OFrame$.MODULE$.query$default$5(), H2OFrame$.MODULE$.query$default$6(), ClassTag$.MODULE$.apply(UploadPlanV3.class));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawPlan.layout)).map((Function1 & Serializable & scala.Serializable)chunkAssignment -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)chunkAssignment.chunk_id)), (Object)new NodeDesc(Integer.toString(chunkAssignment.node_idx), chunkAssignment.ip, chunkAssignment.port)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$convert$2(Tuple2 x$1) {
        return x$1._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ void $anonfun$convert$4(long[] rowsPerChunk$1, Tuple2 x0$1) {
        long numRows;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int chunkIdx = tuple2._1$mcI$sp();
        rowsPerChunk$1[chunkIdx] = numRows = tuple2._2$mcJ$sp();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sparkRowToH2ORow$1(Row row$1, Writer con$1, CategoricalDomainBuilder domainBuilder$2, TimeZoneConverter timeZoneConverter$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField entry = (StructField)tuple2._1();
            int idxField = tuple2._2$mcI$sp();
            if (row$1.isNullAt(idxField)) {
                con$1.putNA(idxField);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                DataType dataType = entry.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    int valueIndex = domainBuilder$2.addStringToDomain(row$1.getBoolean(idxField) ? "True" : "False", idxField);
                    con$1.put(valueIndex);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getByte(idxField));
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getShort(idxField));
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getInt(idxField));
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                } else if (LongType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getLong(idxField));
                    BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getFloat(idxField));
                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                } else if (dataType instanceof DecimalType) {
                    con$1.put(row$1.getDecimal(idxField).doubleValue());
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    con$1.put(row$1.getDouble(idxField));
                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                } else if (StringType$.MODULE$.equals(dataType)) {
                    int valueIndex = domainBuilder$2.addStringToDomain(row$1.getString(idxField), idxField);
                    con$1.put(valueIndex);
                    BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    con$1.put(timeZoneConverter$1.fromSparkTimeZoneToUTC((Timestamp)row$1.getAs(idxField)));
                    BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                } else if (DateType$.MODULE$.equals(dataType)) {
                    con$1.put(timeZoneConverter$1.fromSparkTimeZoneToUTC((Date)row$1.getAs(idxField)));
                    BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
                } else if (ExposeUtils$.MODULE$.isMLVectorUDT(dataType)) {
                    con$1.putVector((org.apache.spark.ml.linalg.Vector)row$1.getAs(idxField));
                    BoxedUnit boxedUnit13 = BoxedUnit.UNIT;
                } else if (dataType instanceof VectorUDT) {
                    con$1.putVector((Vector)row$1.getAs(idxField));
                    BoxedUnit boxedUnit14 = BoxedUnit.UNIT;
                } else {
                    if (ExposeUtils$.MODULE$.isUDT(dataType)) {
                        throw new UnsupportedOperationException(new StringBuilder(36).append("User defined type is not supported: ").append(dataType.getClass()).toString());
                    }
                    throw new UnsupportedOperationException(new StringBuilder(63).append("Data of type ").append(dataType.getClass()).append(" are not supported for the conversion").append(" to H2OFrame.").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit15 = boxedUnit;
    }

    private Writer$() {
        MODULE$ = this;
    }
}

