/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.exceptions.WrongSparkVersion;
import ai.h2o.sparkling.backend.external.ExternalH2OBackend$;
import ai.h2o.sparkling.backend.utils.H2OClientUtils$;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkContext;
import org.apache.spark.h2o.backends.internal.InternalH2OBackend$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import water.H2O;
import water.api.schemas3.CloudV3;

public final class H2OContext$
implements org.apache.spark.expose.Logging {
    public static H2OContext$ MODULE$;
    private final AtomicReference<H2OContext> ai$h2o$sparkling$H2OContext$$instantiatedContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new H2OContext$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public synchronized void setInstantiatedContext(H2OContext h2oContext) {
        block0: {
            H2OContext ctx = this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            if (ctx != null) break block0;
            this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(h2oContext);
        }
    }

    public AtomicReference<H2OContext> ai$h2o$sparkling$H2OContext$$instantiatedContext() {
        return this.ai$h2o$sparkling$H2OContext$$instantiatedContext;
    }

    public Option<H2OContext> get() {
        return Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get());
    }

    public H2OContext ensure(Function0<String> onError) {
        return (H2OContext)Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException((String)onError.apply());
        });
    }

    public String ensure$default$1() {
        return "H2OContext has to be running.";
    }

    private boolean connectingToNewCluster(H2OContext hc, H2OConf newConf) {
        CloudV3 newCloudV3 = RestApiUtils$.MODULE$.getClusterInfo(newConf);
        boolean sameNodes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hc.getH2ONodes())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.ipPort(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCloudV3.nodes)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.ip_port, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        return !sameNodes;
    }

    private H2OConf checkAndUpdateConf(H2OConf conf) {
        return conf.runsInExternalClusterMode() ? ExternalH2OBackend$.MODULE$.checkAndUpdateConf(conf) : InternalH2OBackend$.MODULE$.checkAndUpdateConf(conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized H2OContext getOrCreate(H2OConf conf) {
        if (H2OClientUtils$.MODULE$.isH2OClientBased(conf)) {
            if (this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get() != null) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            if (H2O.API_PORT != 0) throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("\n              |H2O context hasn't been started successfully in the previous attempt and H2O client with previous configuration is already running.\n              |Because of the current H2O limitation that it can't be restarted within a running JVM,\n              |please restart your job or spark session and create new H2O context with new configuration.\")\n          ")).stripMargin());
            H2OConf checkedConf = this.checkAndUpdateConf(conf);
            this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
            return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
        } else {
            H2OContext existingContext = this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            if (existingContext != null) {
                boolean isExternalBackend = conf.runsInExternalClusterMode();
                boolean startedManually = existingContext.getConf().isManualClusterStartUsed();
                if (!isExternalBackend || !startedManually) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
                if (conf.h2oCluster().isEmpty()) {
                    throw new IllegalArgumentException("H2O cluster endpoint has to be specified!");
                }
                if (!this.connectingToNewCluster(existingContext, conf)) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
                H2OConf checkedConf = this.checkAndUpdateConf(conf);
                this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Connecting to a new external H2O cluster : ").append(checkedConf.h2oCluster().get()).toString());
                return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            } else {
                H2OConf checkedConf = this.checkAndUpdateConf(conf);
                this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
            }
        }
        return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
    }

    public H2OContext getOrCreate() {
        return this.getOrCreate((H2OConf)Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new H2OConf()));
    }

    private boolean isSparkVersionUnsupported() {
        return SparkSessionUtils$.MODULE$.active().version().startsWith("2.1.");
    }

    private boolean isSparkVersionDeprecated() {
        return SparkSessionUtils$.MODULE$.active().version().startsWith("2.2.");
    }

    public void ai$h2o$sparkling$H2OContext$$logStartingInfo(H2OConf conf) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Sparkling Water version: ").append(BuildInfo$.MODULE$.SWVersion()).toString());
        String deprecationSuffix = this.isSparkVersionDeprecated() ? " (deprecated)" : "";
        String unsupportedSuffix = this.isSparkVersionUnsupported() ? " (unsupported)" : "";
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Spark version: ").append(SparkSessionUtils$.MODULE$.active().version()).append(deprecationSuffix).append(unsupportedSuffix).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Integrated H2O version: ").append(BuildInfo$.MODULE$.H2OVersion()).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("The following Spark configuration is used: \n    ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).mkString("\n    ")).toString());
    }

    public void ai$h2o$sparkling$H2OContext$$verifySparkVersion() {
        block2: {
            SparkContext sc = SparkSessionUtils$.MODULE$.active().sparkContext();
            boolean runningOnCorrectSpark = sc.version().startsWith(BuildInfo$.MODULE$.buildSparkMajorVersion());
            if (!runningOnCorrectSpark) {
                throw new WrongSparkVersion(new StringBuilder(177).append("You are trying to use Sparkling Water built for Spark ").append(BuildInfo$.MODULE$.buildSparkMajorVersion()).append(",").append(" but your Spark is of version ").append(sc.version()).append(". Please make sure to use correct Sparkling Water for your").append(" Spark and re-run the application.").toString());
            }
            if (this.isSparkVersionUnsupported()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Apache Spark ").append(SparkSessionUtils$.MODULE$.active().version()).append(" is unsupported since the Sparkling Water version 3.34.0.1-1.").toString());
            }
            if (!this.isSparkVersionDeprecated()) break block2;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Apache Spark ").append(SparkSessionUtils$.MODULE$.active().version()).append(" is deprecated and ").append("the support will be removed in the Sparkling Water version 3.38.").toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private H2OContext$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.ai$h2o$sparkling$H2OContext$$instantiatedContext = new AtomicReference();
    }
}

