/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.servlet;

import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import ai.h2o.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface WebSocketServletFactory {
    public boolean acceptWebSocket(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public boolean acceptWebSocket(WebSocketCreator var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    public void start() throws Exception;

    public void stop() throws Exception;

    public WebSocketCreator getCreator();

    public ExtensionFactory getExtensionFactory();

    public WebSocketPolicy getPolicy();

    public boolean isUpgradeRequest(HttpServletRequest var1, HttpServletResponse var2);

    public void register(Class<?> var1);

    public void setCreator(WebSocketCreator var1);

    public static class Loader {
        static final String DEFAULT_IMPL = "ai.h2o.org.eclipse.jetty.websocket.server.WebSocketServerFactory";

        public static WebSocketServletFactory load(ServletContext ctx, WebSocketPolicy policy) {
            try {
                Class<?> wsClazz = Class.forName(DEFAULT_IMPL, true, Thread.currentThread().getContextClassLoader());
                Constructor<?> ctor = wsClazz.getDeclaredConstructor(ServletContext.class, WebSocketPolicy.class);
                return (WebSocketServletFactory)ctor.newInstance(ctx, policy);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Unable to load org.eclipse.jetty.websocket.server.WebSocketServerFactory", e2);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e3) {
                throw new RuntimeException("Unable to instantiate org.eclipse.jetty.websocket.server.WebSocketServerFactory", e3);
            }
        }
    }
}

