/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.common.scopes;

import ai.h2o.org.eclipse.jetty.io.ByteBufferPool;
import ai.h2o.org.eclipse.jetty.io.MappedByteBufferPool;
import ai.h2o.org.eclipse.jetty.util.DecoratedObjectFactory;
import ai.h2o.org.eclipse.jetty.util.component.ContainerLifeCycle;
import ai.h2o.org.eclipse.jetty.util.ssl.SslContextFactory;
import ai.h2o.org.eclipse.jetty.util.thread.QueuedThreadPool;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketSession;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.concurrent.Executor;

public class SimpleContainerScope
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private final ByteBufferPool bufferPool;
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketPolicy policy;
    private final Executor executor;
    private SslContextFactory sslContextFactory;

    public SimpleContainerScope(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool(), new DecoratedObjectFactory());
        this.sslContextFactory = new SslContextFactory();
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, new DecoratedObjectFactory());
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this(policy, bufferPool, null, objectFactory);
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, Executor executor, DecoratedObjectFactory objectFactory) {
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.objectFactory = objectFactory == null ? new DecoratedObjectFactory() : objectFactory;
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketContainer@" + this.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            this.executor = threadPool;
            this.addBean(this.executor);
        } else {
            this.executor = executor;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
    }
}

