/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.common.message;

import ai.h2o.org.eclipse.jetty.io.ByteBufferPool;
import ai.h2o.org.eclipse.jetty.util.BufferUtil;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.websocket.api.BatchMode;
import ai.h2o.org.eclipse.jetty.websocket.api.WriteCallback;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import ai.h2o.org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketSession;
import ai.h2o.org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class MessageOutputStream
extends OutputStream {
    private static final Logger LOG = Log.getLogger(MessageOutputStream.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount;
    private BinaryFrame frame;
    private ByteBuffer buffer;
    private WriteCallback callback;
    private boolean closed;

    public MessageOutputStream(WebSocketSession session) {
        this(session.getOutgoingHandler(), session.getPolicy().getMaxBinaryMessageBufferSize(), session.getBufferPool());
    }

    public MessageOutputStream(OutgoingFrames outgoing, int bufferSize, ByteBufferPool bufferPool) {
        this.outgoing = outgoing;
        this.bufferPool = bufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = bufferPool.acquire(bufferSize, true);
        BufferUtil.flipToFill(this.buffer);
        this.frame = new BinaryFrame();
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        try {
            this.send(bytes, off, len);
        }
        catch (Throwable x2) {
            this.notifyFailure(x2);
            throw x2;
        }
    }

    @Override
    public void write(int b2) throws IOException {
        try {
            this.send(new byte[]{(byte)b2}, 0, 1);
        }
        catch (Throwable x2) {
            this.notifyFailure(x2);
            throw x2;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable x2) {
            this.notifyFailure(x2);
            throw x2;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            this.bufferPool.release(this.buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames sent", this.frameCount);
            }
            this.notifySuccess();
        }
        catch (Throwable x2) {
            this.notifyFailure(x2);
            throw x2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean fin) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = fin;
            BufferUtil.flipToFlush(this.buffer, 0);
            this.frame.setPayload(this.buffer);
            this.frame.setFin(fin);
            try (BlockingWriteCallback.WriteBlocker b2 = this.blocker.acquireWriteBlocker();){
                this.outgoing.outgoingFrame(this.frame, b2, BatchMode.OFF);
                b2.block();
            }
            ++this.frameCount;
            this.frame.setIsContinuation();
            BufferUtil.flipToFill(this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(byte[] bytes, int offset, int length) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            while (length > 0) {
                int space = this.buffer.remaining();
                int size = Math.min(space, length);
                this.buffer.put(bytes, offset, size);
                offset += size;
                if ((length -= size) <= 0) continue;
                this.flush(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(WriteCallback callback) {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        WriteCallback callback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.writeSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable failure) {
        WriteCallback callback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.writeFailed(failure);
        }
    }
}

