/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util.security;

import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.util.security.Credential;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class Password
extends Credential {
    private static final Logger LOG = Log.getLogger(Password.class);
    private static final long serialVersionUID = 5062906681431569445L;
    public static final String __OBFUSCATE = "OBF:";
    private String _pw;

    public Password(String password) {
        this._pw = password;
        while (this._pw != null && this._pw.startsWith(__OBFUSCATE)) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    @Override
    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof String) {
            return Password.stringEquals(this._pw, (String)credentials);
        }
        if (credentials instanceof char[]) {
            return Password.stringEquals(this._pw, new String((char[])credentials));
        }
        if (credentials instanceof Credential) {
            return ((Credential)credentials).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (null == o2) {
            return false;
        }
        if (o2 instanceof Password) {
            return Password.stringEquals(this._pw, ((Password)o2)._pw);
        }
        if (o2 instanceof String) {
            return Password.stringEquals(this._pw, (String)o2);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    public static String obfuscate(String s2) {
        StringBuilder buf = new StringBuilder();
        byte[] b2 = s2.getBytes(StandardCharsets.UTF_8);
        buf.append(__OBFUSCATE);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            byte b1 = b2[i2];
            byte b22 = b2[b2.length - (i2 + 1)];
            if (b1 < 0 || b22 < 0) {
                int i0 = (0xFF & b1) * 256 + (0xFF & b22);
                String x2 = Integer.toString(i0, 36).toLowerCase(Locale.ENGLISH);
                buf.append("U0000", 0, 5 - x2.length());
                buf.append(x2);
                continue;
            }
            int i1 = 127 + b1 + b22;
            int i22 = 127 + b1 - b22;
            int i0 = i1 * 256 + i22;
            String x3 = Integer.toString(i0, 36).toLowerCase(Locale.ENGLISH);
            int j0 = Integer.parseInt(x3, 36);
            int j1 = i0 / 256;
            int j2 = i0 % 256;
            byte bx = (byte)((j1 + j2 - 254) / 2);
            buf.append("000", 0, 4 - x3.length());
            buf.append(x3);
        }
        return buf.toString();
    }

    public static String deobfuscate(String s2) {
        if (s2.startsWith(__OBFUSCATE)) {
            s2 = s2.substring(4);
        }
        byte[] b2 = new byte[s2.length() / 2];
        int l2 = 0;
        for (int i2 = 0; i2 < s2.length(); i2 += 4) {
            int i0;
            String x2;
            if (s2.charAt(i2) == 'U') {
                x2 = s2.substring(++i2, i2 + 4);
                i0 = Integer.parseInt(x2, 36);
                byte bx = (byte)(i0 >> 8);
                b2[l2++] = bx;
                continue;
            }
            x2 = s2.substring(i2, i2 + 4);
            i0 = Integer.parseInt(x2, 36);
            int i1 = i0 / 256;
            int i22 = i0 % 256;
            byte bx = (byte)((i1 + i22 - 254) / 2);
            b2[l2++] = bx;
        }
        return new String(b2, 0, l2, StandardCharsets.UTF_8);
    }

    public static Password getPassword(String realm, String dft, String promptDft) {
        String passwd2 = System.getProperty(realm, dft);
        if (passwd2 == null || passwd2.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] buf = new byte[512];
                int len = System.in.read(buf);
                if (len > 0) {
                    passwd2 = new String(buf, 0, len).trim();
                }
            }
            catch (IOException e2) {
                LOG.warn("EXCEPTION ", e2);
            }
            if (passwd2 == null || passwd2.length() == 0) {
                passwd2 = promptDft;
            }
        }
        return new Password(passwd2);
    }

    public static void main(String[] arg) {
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java " + Password.class.getName() + " [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p2 = arg[arg.length == 1 ? 0 : 1];
        Password pw = new Password(p2);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Credential.MD5.digest(p2));
        if (arg.length == 2) {
            System.err.println(Credential.Crypt.crypt(arg[0], pw.toString()));
        }
    }
}

