/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util;

import ai.h2o.org.eclipse.jetty.util.ArrayUtil;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.URIUtil;
import ai.h2o.org.eclipse.jetty.util.annotation.Name;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeUtil {
    private static final Logger LOG = Log.getLogger(TypeUtil.class);
    public static final Class<?>[] NO_ARGS = new Class[0];
    public static final int CR = 13;
    public static final int LF = 10;
    private static final HashMap<String, Class<?>> name2Class = new HashMap();
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;

    public static <T> List<T> asList(T[] a2) {
        if (a2 == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(a2);
    }

    public static Class<?> fromName(String name) {
        return name2Class.get(name);
    }

    public static String toName(Class<?> type) {
        return class2Name.get(type);
    }

    public static Object valueOf(Class<?> type, String value) {
        try {
            if (type.equals(String.class)) {
                return value;
            }
            Method m4 = class2Value.get(type);
            if (m4 != null) {
                return m4.invoke(null, value);
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return Character.valueOf(value.charAt(0));
            }
            Constructor<?> c2 = type.getConstructor(String.class);
            return c2.newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException x2) {
            LOG.ignore(x2);
        }
        catch (InvocationTargetException x3) {
            if (x3.getTargetException() instanceof Error) {
                throw (Error)x3.getTargetException();
            }
            LOG.ignore(x3);
        }
        return null;
    }

    public static Object valueOf(String type, String value) {
        return TypeUtil.valueOf(TypeUtil.fromName(type), value);
    }

    public static int parseInt(String s2, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s2.length() - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(offset + i2);
            int digit = TypeUtil.convertHexDigit((int)c2);
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s2.substring(offset, offset + length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static int parseInt(byte[] b2, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = b2.length - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = (char)(0xFF & b2[offset + i2]);
            int digit = c2 - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c2 - 65) >= 10 && digit < base)) {
                digit = 10 + c2 - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(new String(b2, offset, length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static byte[] parseBytes(String s2, int base) {
        byte[] bytes = new byte[s2.length() / 2];
        for (int i2 = 0; i2 < s2.length(); i2 += 2) {
            bytes[i2 / 2] = (byte)TypeUtil.parseInt(s2, i2, 2, base);
        }
        return bytes;
    }

    public static String toString(byte[] bytes, int base) {
        StringBuilder buf = new StringBuilder();
        for (byte b2 : bytes) {
            int bi = 0xFF & b2;
            int c2 = 48 + bi / base % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte convertHexDigit(byte c2) {
        byte b2 = (byte)((c2 & 0x1F) + (c2 >> 6) * 25 - 16);
        if (b2 < 0 || b2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return b2;
    }

    public static int convertHexDigit(char c2) {
        int d2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (d2 < 0 || d2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return d2;
    }

    public static int convertHexDigit(int c2) {
        int d2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (d2 < 0 || d2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return d2;
    }

    public static void toHex(byte b2, Appendable buf) {
        try {
            int d2 = 0xF & (0xF0 & b2) >> 4;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
            d2 = 0xF & b2;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void toHex(int value, Appendable buf) throws IOException {
        int d2 = 0xF & (0xF0000000 & value) >> 28;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF000000 & value) >> 24;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF00000 & value) >> 20;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF0000 & value) >> 16;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF000 & value) >> 12;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF00 & value) >> 8;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF0 & value) >> 4;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & value;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        Integer.toString(0, 36);
    }

    public static void toHex(long value, Appendable buf) throws IOException {
        TypeUtil.toHex((int)(value >> 32), buf);
        TypeUtil.toHex((int)value, buf);
    }

    public static String toHexString(byte b2) {
        return TypeUtil.toHexString(new byte[]{b2}, 0, 1);
    }

    public static String toHexString(byte[] b2) {
        return TypeUtil.toHexString(b2, 0, b2.length);
    }

    public static String toHexString(byte[] b2, int offset, int length) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int bi = 0xFF & b2[i2];
            int c2 = 48 + bi / 16 % 16;
            if (c2 > 57) {
                c2 = 65 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi % 16;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String s2) {
        if (s2.length() % 2 != 0) {
            throw new IllegalArgumentException(s2);
        }
        byte[] array = new byte[s2.length() / 2];
        for (int i2 = 0; i2 < array.length; ++i2) {
            int b2 = Integer.parseInt(s2.substring(i2 * 2, i2 * 2 + 2), 16);
            array[i2] = (byte)(0xFF & b2);
        }
        return array;
    }

    public static void dump(Class<?> c2) {
        System.err.println("Dump: " + c2);
        TypeUtil.dump(c2.getClassLoader());
    }

    public static void dump(ClassLoader cl) {
        System.err.println("Dump Loaders:");
        while (cl != null) {
            System.err.println("  loader " + cl);
            cl = cl.getParent();
        }
    }

    public static Object call(Class<?> oClass, String methodName, Object obj, Object[] arg) throws InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(oClass, "Class cannot be null");
        Objects.requireNonNull(methodName, "Method name cannot be null");
        if (StringUtil.isBlank(methodName)) {
            throw new IllegalArgumentException("Method name cannot be blank");
        }
        for (Method method : oClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != arg.length || Modifier.isStatic(method.getModifiers()) != (obj == null) || obj == null && method.getDeclaringClass() != oClass) continue;
            try {
                return method.invoke(obj, arg);
            }
            catch (IllegalAccessException | IllegalArgumentException e2) {
                LOG.ignore(e2);
            }
        }
        Object[][] args_with_opts = null;
        for (Method method : oClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != arg.length + 1 || !method.getParameterTypes()[arg.length].isArray() || Modifier.isStatic(method.getModifiers()) != (obj == null) || obj == null && method.getDeclaringClass() != oClass) continue;
            if (args_with_opts == null) {
                args_with_opts = ArrayUtil.addToArray(arg, new Object[0], Object.class);
            }
            try {
                return method.invoke(obj, (Object[])args_with_opts);
            }
            catch (IllegalAccessException | IllegalArgumentException e3) {
                LOG.ignore(e3);
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Object construct(Class<?> klass, Object[] arguments2) throws InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(klass, "Class cannot be null");
        for (Constructor<?> constructor : klass.getConstructors()) {
            if (arguments2 == null ? constructor.getParameterCount() != 0 : constructor.getParameterCount() != arguments2.length) continue;
            try {
                return constructor.newInstance(arguments2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e2) {
                LOG.ignore(e2);
            }
        }
        throw new NoSuchMethodException("<init>");
    }

    public static Object construct(Class<?> klass, Object[] arguments2, Map<String, Object> namedArgMap) throws InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(klass, "Class cannot be null");
        Objects.requireNonNull(namedArgMap, "Named Argument Map cannot be null");
        for (Constructor<?> constructor : klass.getConstructors()) {
            if (arguments2 == null ? constructor.getParameterCount() != 0 : constructor.getParameterCount() != arguments2.length) continue;
            try {
                Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
                if (arguments2 == null || arguments2.length == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Constructor has no arguments", new Object[0]);
                    }
                    return constructor.newInstance(arguments2);
                }
                if (parameterAnnotations == null || parameterAnnotations.length == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Constructor has no parameter annotations", new Object[0]);
                    }
                    return constructor.newInstance(arguments2);
                }
                Object[] swizzled = new Object[arguments2.length];
                int count2 = 0;
                Annotation[][] annotationArray = parameterAnnotations;
                int n2 = annotationArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = annotationArray[i2]) {
                        if (annotation instanceof Name) {
                            Name param = (Name)annotation;
                            if (namedArgMap.containsKey(param.value())) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("placing named {} in position {}", param.value(), count2);
                                }
                                swizzled[count2] = namedArgMap.get(param.value());
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("placing {} in position {}", arguments2[count2], count2);
                                }
                                swizzled[count2] = arguments2[count2];
                            }
                            ++count2;
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("passing on annotation {}", annotation);
                    }
                }
                return constructor.newInstance(swizzled);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e2) {
                LOG.ignore(e2);
            }
        }
        throw new NoSuchMethodException("<init>");
    }

    public static boolean isTrue(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2;
        }
        return Boolean.parseBoolean(o2.toString());
    }

    public static boolean isFalse(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2 == false;
        }
        return "false".equalsIgnoreCase(o2.toString());
    }

    public static URI getLocationOfClass(Class<?> clazz) {
        try {
            URL location;
            CodeSource source;
            ProtectionDomain domain = clazz.getProtectionDomain();
            if (domain != null && (source = domain.getCodeSource()) != null && (location = source.getLocation()) != null) {
                return location.toURI();
            }
            String resourceName = clazz.getName().replace('.', '/') + ".class";
            ClassLoader loader = clazz.getClassLoader();
            URL url = (loader == null ? ClassLoader.getSystemClassLoader() : loader).getResource(resourceName);
            if (url != null) {
                return URIUtil.getJarSource(url.toURI());
            }
        }
        catch (URISyntaxException e2) {
            LOG.debug(e2);
        }
        return null;
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] s2 = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", s2));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", s2));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }
}

