/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util;

import ai.h2o.org.eclipse.jetty.util.AbstractTrie;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    private final char[] _tree;
    private final String[] _key;
    private final V[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(boolean insensitive) {
        this(insensitive, 128);
    }

    public ArrayTernaryTrie(int capacity) {
        this(true, capacity);
    }

    public ArrayTernaryTrie(boolean insensitive, int capacity) {
        super(insensitive);
        this._value = new Object[capacity];
        this._tree = new char[capacity * 4];
        this._key = new String[capacity];
    }

    public ArrayTernaryTrie(ArrayTernaryTrie<V> trie, double factor) {
        super(trie.isCaseInsensitive());
        int capacity = (int)((double)trie._value.length * factor);
        this._rows = trie._rows;
        this._value = Arrays.copyOf(trie._value, capacity);
        this._tree = Arrays.copyOf(trie._tree, capacity * 4);
        this._key = Arrays.copyOf(trie._key, capacity);
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._tree, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s2, V v2) {
        char t2 = '\u0000';
        int limit = s2.length();
        int last = 0;
        for (int k2 = 0; k2 < limit; ++k2) {
            int diff;
            char c2 = s2.charAt(k2);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char n2;
                int row = 4 * t2;
                if (t2 == this._rows) {
                    this._rows = (char)(this._rows + '\u0001');
                    if (this._rows >= this._key.length) {
                        this._rows = (char)(this._rows - '\u0001');
                        return false;
                    }
                    this._tree[row] = c2;
                }
                if ((diff = (n2 = this._tree[row]) - c2) == 0) {
                    last = row + EQ;
                    t2 = this._tree[last];
                } else if (diff < 0) {
                    last = row + LO;
                    t2 = this._tree[last];
                } else {
                    last = row + HI;
                    t2 = this._tree[last];
                }
                if (t2 != '\u0000') continue;
                t2 = this._rows;
                this._tree[last] = t2;
            } while (diff != 0);
        }
        if (t2 == this._rows) {
            this._rows = (char)(this._rows + '\u0001');
            if (this._rows >= this._key.length) {
                this._rows = (char)(this._rows - '\u0001');
                return false;
            }
        }
        this._key[t2] = v2 == null ? null : s2;
        this._value[t2] = v2;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        int t2 = 0;
        int i2 = 0;
        block0: while (i2 < len) {
            int diff;
            int row;
            char c2 = s2.charAt(offset + i2++);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t2]) - c2) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 != 0) continue block0;
                return null;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V get(ByteBuffer b2, int offset, int len) {
        int t2 = 0;
        offset += b2.position();
        int i2 = 0;
        block0: while (i2 < len) {
            int diff;
            int row;
            byte c2 = (byte)(b2.get(offset + i2++) & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t2]) - c2) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 != 0) continue block0;
                return null;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V getBest(String s2) {
        return this.getBest(0, s2, 0, s2.length());
    }

    @Override
    public V getBest(String s2, int offset, int length) {
        return this.getBest(0, s2, offset, length);
    }

    private V getBest(int t2, String s2, int offset, int len) {
        int node = t2;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            int row;
            char c2 = s2.charAt(offset++);
            --len;
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t2]) - c2) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V better = this.getBest(t2, s2, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    @Override
    public V getBest(ByteBuffer b2, int offset, int len) {
        if (b2.hasArray()) {
            return this.getBest(0, b2.array(), b2.arrayOffset() + b2.position() + offset, len);
        }
        return this.getBest(0, b2, offset, len);
    }

    private V getBest(int t2, byte[] b2, int offset, int len) {
        int node = t2;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            int row;
            byte c2 = (byte)(b2[offset++] & 0x7F);
            --len;
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t2]) - c2) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V better = this.getBest(t2, b2, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    private V getBest(int t2, ByteBuffer b2, int offset, int len) {
        int node = t2;
        int o2 = offset + b2.position();
        block0: for (int i2 = 0; i2 < len; ++i2) {
            int diff;
            int row;
            byte c2 = (byte)(b2.get(o2 + i2) & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t2]) - c2) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V best = this.getBest(t2, b2, offset + i2 + 1, len - i2 - 1);
                if (best == null) continue block0;
                return best;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int r2 = 0; r2 <= this._rows; ++r2) {
            if (this._key[r2] == null || this._value[r2] == null) continue;
            buf.append(',');
            buf.append(this._key[r2]);
            buf.append('=');
            buf.append(this._value[r2].toString());
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (int r2 = 0; r2 <= this._rows; ++r2) {
            if (this._key[r2] == null || this._value[r2] == null) continue;
            keys.add(this._key[r2]);
        }
        return keys;
    }

    public int size() {
        int s2 = 0;
        for (int r2 = 0; r2 <= this._rows; ++r2) {
            if (this._key[r2] == null || this._value[r2] == null) continue;
            ++s2;
        }
        return s2;
    }

    public boolean isEmpty() {
        for (int r2 = 0; r2 <= this._rows; ++r2) {
            if (this._key[r2] == null || this._value[r2] == null) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entries = new HashSet<Map.Entry<String, V>>();
        for (int r2 = 0; r2 <= this._rows; ++r2) {
            if (this._key[r2] == null || this._value[r2] == null) continue;
            entries.add(new AbstractMap.SimpleEntry<String, V>(this._key[r2], this._value[r2]));
        }
        return entries;
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }

    public static int hilo(int diff) {
        return 1 + (diff | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }

    public void dump() {
        for (int r2 = 0; r2 < this._rows; ++r2) {
            char c2 = this._tree[r2 * 4 + 0];
            System.err.printf("%4d [%s,%d,%d,%d] '%s':%s%n", r2, c2 < ' ' || c2 > '\u007f' ? "" + c2 : "'" + c2 + "'", (int)this._tree[r2 * 4 + LO], (int)this._tree[r2 * 4 + EQ], (int)this._tree[r2 * 4 + HI], this._key[r2], this._value[r2]);
        }
    }

    public static class Growing<V>
    implements Trie<V> {
        private final int _growby;
        private ArrayTernaryTrie<V> _trie;

        public Growing() {
            this(1024, 1024);
        }

        public Growing(int capacity, int growby) {
            this._growby = growby;
            this._trie = new ArrayTernaryTrie(capacity);
        }

        public Growing(boolean insensitive, int capacity, int growby) {
            this._growby = growby;
            this._trie = new ArrayTernaryTrie(insensitive, capacity);
        }

        @Override
        public boolean put(V v2) {
            return this.put(v2.toString(), v2);
        }

        public int hashCode() {
            return this._trie.hashCode();
        }

        @Override
        public V remove(String s2) {
            return this._trie.remove(s2);
        }

        @Override
        public V get(String s2) {
            return this._trie.get(s2);
        }

        @Override
        public V get(ByteBuffer b2) {
            return this._trie.get(b2);
        }

        @Override
        public V getBest(byte[] b2, int offset, int len) {
            return this._trie.getBest(b2, offset, len);
        }

        @Override
        public boolean isCaseInsensitive() {
            return this._trie.isCaseInsensitive();
        }

        public boolean equals(Object obj) {
            return this._trie.equals(obj);
        }

        @Override
        public void clear() {
            this._trie.clear();
        }

        @Override
        public boolean put(String s2, V v2) {
            boolean added = this._trie.put(s2, v2);
            while (!added && this._growby > 0) {
                ArrayTernaryTrie<V> bigger = new ArrayTernaryTrie<V>(((ArrayTernaryTrie)this._trie)._key.length + this._growby);
                for (Map.Entry<String, V> entry : this._trie.entrySet()) {
                    bigger.put(entry.getKey(), entry.getValue());
                }
                this._trie = bigger;
                added = this._trie.put(s2, v2);
            }
            return added;
        }

        @Override
        public V get(String s2, int offset, int len) {
            return this._trie.get(s2, offset, len);
        }

        @Override
        public V get(ByteBuffer b2, int offset, int len) {
            return this._trie.get(b2, offset, len);
        }

        @Override
        public V getBest(String s2) {
            return this._trie.getBest(s2);
        }

        @Override
        public V getBest(String s2, int offset, int length) {
            return this._trie.getBest(s2, offset, length);
        }

        @Override
        public V getBest(ByteBuffer b2, int offset, int len) {
            return this._trie.getBest(b2, offset, len);
        }

        public String toString() {
            return this._trie.toString();
        }

        @Override
        public Set<String> keySet() {
            return this._trie.keySet();
        }

        @Override
        public boolean isFull() {
            return false;
        }

        public void dump() {
            this._trie.dump();
        }

        public boolean isEmpty() {
            return this._trie.isEmpty();
        }

        public int size() {
            return this._trie.size();
        }
    }
}

