/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client.util;

import ai.h2o.org.eclipse.jetty.client.util.StringContentProvider;
import ai.h2o.org.eclipse.jetty.util.Fields;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class FormContentProvider
extends StringContentProvider {
    public FormContentProvider(Fields fields) {
        this(fields, StandardCharsets.UTF_8);
    }

    public FormContentProvider(Fields fields, Charset charset) {
        super("application/x-www-form-urlencoded", FormContentProvider.convert(fields, charset), charset);
    }

    public static String convert(Fields fields) {
        return FormContentProvider.convert(fields, StandardCharsets.UTF_8);
    }

    public static String convert(Fields fields, Charset charset) {
        StringBuilder builder = new StringBuilder(fields.getSize() * 32);
        for (Fields.Field field : fields) {
            for (String value : field.getValues()) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(FormContentProvider.encode(field.getName(), charset)).append("=").append(FormContentProvider.encode(value, charset));
            }
        }
        return builder.toString();
    }

    private static String encode(String value, Charset charset) {
        try {
            return URLEncoder.encode(value, charset.name());
        }
        catch (UnsupportedEncodingException x2) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }
}

