/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.ConnectionPool;
import ai.h2o.org.eclipse.jetty.client.api.Connection;
import ai.h2o.org.eclipse.jetty.client.api.Destination;
import ai.h2o.org.eclipse.jetty.util.AtomicBiInteger;
import ai.h2o.org.eclipse.jetty.util.Callback;
import ai.h2o.org.eclipse.jetty.util.Promise;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedAttribute;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedObject;
import ai.h2o.org.eclipse.jetty.util.component.ContainerLifeCycle;
import ai.h2o.org.eclipse.jetty.util.component.Dumpable;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

@ManagedObject
public abstract class AbstractConnectionPool
implements ConnectionPool,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBiInteger connections = new AtomicBiInteger();
    private final Destination destination;
    private final int maxConnections;
    private final Callback requester;

    protected AbstractConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this.destination = destination;
        this.maxConnections = maxConnections;
        this.requester = requester;
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.maxConnections;
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.connections.getLo();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    public int getPendingCount() {
        return this.connections.getHi();
    }

    @Override
    public boolean isEmpty() {
        return this.connections.getLo() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Connection acquire() {
        Connection connection = this.activate();
        if (connection == null) {
            this.tryCreate(-1);
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(int maxPending) {
        int total;
        int pending;
        long encoded;
        do {
            encoded = this.connections.get();
            pending = AtomicBiInteger.getHi(encoded);
            total = AtomicBiInteger.getLo(encoded);
            if (LOG.isDebugEnabled()) {
                LOG.debug("tryCreate {}/{} connections {}/{} pending", total, this.maxConnections, pending, maxPending);
            }
            if (total >= this.maxConnections) {
                return;
            }
            if (maxPending < 0 || pending < maxPending) continue;
            return;
        } while (!this.connections.compareAndSet(encoded, pending + 1, total + 1));
        if (LOG.isDebugEnabled()) {
            LOG.debug("newConnection {}/{} connections {}/{} pending", total + 1, this.maxConnections, pending + 1, maxPending);
        }
        this.destination.newConnection(new Promise<Connection>(){

            @Override
            public void succeeded(Connection connection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation succeeded {}", total + 1, AbstractConnectionPool.this.maxConnections, connection);
                }
                AbstractConnectionPool.this.connections.add(-1, 0);
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.proceed();
            }

            @Override
            public void failed(Throwable x2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection " + (total + 1) + "/" + AbstractConnectionPool.this.maxConnections + " creation failed", x2);
                }
                AbstractConnectionPool.this.connections.add(-1, -1);
                AbstractConnectionPool.this.requester.failed(x2);
            }
        });
    }

    protected abstract void onCreated(Connection var1);

    protected void proceed() {
        this.requester.succeeded();
    }

    protected abstract Connection activate();

    protected Connection active(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection active {}", connection);
        }
        this.acquired(connection);
        return connection;
    }

    protected void acquired(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close) {
        if (close) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection idle close {}", connection);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection idle {}", connection);
        }
        return true;
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
        int pooled = this.connections.addAndGetLo(-1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection removed {} - pooled: {}", connection, pooled);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connections.set(0, 0);
        }
    }

    protected void close(Collection<Connection> connections) {
        connections.forEach(Connection::close);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }
}

